/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.codegen;

import com.sap.sapdb.testframe.codegen.CodeMaker;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Tag;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.StringTokenizer;

public class RecipientsCodeMaker
extends CodeMaker {
    private String RECIPIENT = "recipient";
    private String AUTHOR = "author";
    private static MessageFormat FIELD_DECLARATION = new MessageFormat(RecipientsCodeMaker.indent(1) + "public static final {0} m{1} = \"{2}\";");
    private static MessageFormat GET_DECLARATION = new MessageFormat(RecipientsCodeMaker.indent(1) + "public static {0} get{1}()");
    private static MessageFormat GET_BODY = new MessageFormat(RecipientsCodeMaker.indent(2) + "return m{0};");

    private static String convertFirstCharToUpperCase(String pString) {
        char[] array = pString.toCharArray();
        array[0] = Character.toUpperCase(array[0]);
        return new String(array);
    }

    private ArrayList getList(Tag[] pTags) {
        if (pTags.length == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < pTags.length; ++i) {
            list.add(pTags[i].text());
        }
        return list;
    }

    public void make(ClassDoc pClassDoc) {
        if (!pClassDoc.isClass()) {
            return;
        }
        boolean skip = true;
        for (ClassDoc superClass = pClassDoc.superclass(); superClass != null; superClass = superClass.superclass()) {
            if (!superClass.toString().equals("com.sap.sapdb.testframe.testcase.TestCase")) continue;
            skip = false;
            break;
        }
        if (skip) {
            return;
        }
        Tag[] author = pClassDoc.tags(this.AUTHOR);
        Tag[] recipients = pClassDoc.tags(this.RECIPIENT);
        if (author.length == 0 && recipients.length == 0) {
            return;
        }
        String outdir = System.getProperty("user.outdir");
        String packageName = pClassDoc.containingPackage().name();
        String dirName = null;
        if (packageName.equals("")) {
            dirName = outdir + System.getProperty("file.separator") + packageName;
        } else {
            StringTokenizer st = new StringTokenizer(packageName, ".");
            while (st.hasMoreTokens()) {
                int pos = outdir.indexOf(st.nextToken());
                if (pos == -1) {
                    dirName = outdir + System.getProperty("file.separator") + packageName.replace('.', System.getProperty("file.separator").charAt(0));
                    continue;
                }
                dirName = outdir.substring(0, pos) + packageName.replace('.', System.getProperty("file.separator").charAt(0));
            }
        }
        File file = new File(dirName);
        if (!file.isDirectory()) {
            file.mkdir();
        }
        String fileName = dirName + System.getProperty("file.separator") + pClassDoc.name() + "_MessageRecipients" + ".java";
        this.setFile(fileName);
        this.makeDeclaration(pClassDoc);
        this.makeGetMethod(this.RECIPIENT, recipients);
        this.makeEnd();
        this.endFile();
    }

    private void makeDeclaration(ClassDoc pClassDoc) {
        this.out("package " + pClassDoc.containingPackage().name() + ";\n");
        this.out("\n");
        this.out("/* \n");
        this.out(" This code is generated by com.sap.sapdb.testframe.codegen.RecipientsCodeMaker. \n");
        this.out("*/ \n");
        this.out("public class " + pClassDoc.name() + "_MessageRecipients" + " {\n");
    }

    private void makeEnd() {
        this.out("}");
    }

    private void makeGetMethod(String pTagName, Tag[] pTags) {
        if (pTags.length == 0) {
            return;
        }
        ArrayList list = this.getList(pTags);
        String tagName = RecipientsCodeMaker.convertFirstCharToUpperCase(pTagName);
        ListIterator it = list.listIterator();
        int counter = 0;
        while (it.hasNext()) {
            Object[] farg = new Object[]{"String", tagName + "_" + Integer.toString(counter), (String)it.next()};
            this.out(FIELD_DECLARATION.format(farg));
            this.out("\n");
            Object[] gdarg = new Object[]{"String", tagName + "_" + Integer.toString(counter)};
            this.out(GET_DECLARATION.format(gdarg));
            this.out(RecipientsCodeMaker.indent(0) + " {");
            this.out("\n");
            Object[] gbarg = new Object[]{tagName + "_" + Integer.toString(counter)};
            this.out(GET_BODY.format(gbarg));
            this.out("\n");
            this.out(RecipientsCodeMaker.indent(1) + "}");
            this.out("\n");
            ++counter;
        }
    }
}

