/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.util.testdriver;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.trace.Connection;
import com.sap.dbtechtest.util.options.BoolOption;
import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.options.SapDBOptions;
import com.sap.dbtechtest.util.options.StringOption;
import com.sap.dbtechtest.util.testdriver.TestCase;
import com.sap.dbtechtest.util.testdriver.TestEnvironment;
import com.sap.dbtechtest.xlog.ExceptionOccurred;
import com.sap.dbtechtest.xlog.Info;
import com.sap.dbtechtest.xlog.LogWriter;
import com.sap.dbtechtest.xlog.LogWriterJTestProtocol;
import com.sap.dbtechtest.xlog.LogWriterXML;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Dictionary;
import java.util.Random;

public abstract class Test {
    public static final OptionDesc[] testOptionsC = new OptionDesc[]{new StringOption("logfile", "name of log file", "-", new String[]{"-L"}), new StringOption("odbc", "ODBC connection <datasource>", "", new String[]{"-o"}), new BoolOption("verbose", "verbose output", new String[]{"-v"}), new BoolOption("failuredump", "dump failure tree", new String[]{"-F"}), new BoolOption("picky", "check for missing test cases", null)};
    protected SapDBOptions options;
    protected java.sql.Connection connection;
    protected Statement stmt;
    protected long timerStart;
    protected String testName = null;
    protected LogWriter log;
    protected boolean isMainTest;
    protected TestEnvironment environment;
    private Dictionary excludeList;
    static long seed = 0L;

    public Test(OptionDesc[] optionDescArray, String string, String[] stringArray, Object object) throws SQLException {
        this.options = new SapDBOptions(optionDescArray, testOptionsC, string);
        this.options.parse(stringArray);
        this.log = object != null ? new LogWriterJTestProtocol(this.options.getString("logfile"), object) : new LogWriterXML(this.options.getString("logfile"));
        this.log.setVerboseTo(this.options.getBoolean("verbose"));
        this.connection = this.connect();
        this.stmt = this.connection.createStatement(1005, 1007);
        this.isMainTest = true;
        this.environment = new TestEnvironment(this.connection, this.log);
        if (this.options.getBoolean("picky")) {
            this.environment.addFeature("picky");
        }
        if (this.checkUnicodeDB()) {
            this.environment.addFeature("UnicodeDB");
        }
        if (null != this.options.getVariables("property").get("unicode") && this.options.getVariables("property").get("unicode").toString().equalsIgnoreCase("yes")) {
            this.environment.addFeature("UnicodeConnection");
        }
        this.excludeList = this.options.getVariables("exclude");
    }

    public Test(OptionDesc[] optionDescArray, String string, String[] stringArray) throws SQLException {
        this(optionDescArray, string, stringArray, null);
    }

    public Test(Test test) throws SQLException {
        this.connection = test.connection;
        this.stmt = this.connection.createStatement(1005, 1007);
        this.isMainTest = false;
        this.log = test.log;
        this.options = test.options;
        this.environment = test.environment;
    }

    public boolean isSQLModeOracle() {
        if (this.connection instanceof ConnectionSapDB) {
            return ((ConnectionSapDB)this.connection).isSQLModeOracle();
        }
        if (this.connection instanceof Connection) {
            return ((ConnectionSapDB)((Connection)this.connection).getInner()).isSQLModeOracle();
        }
        return false;
    }

    public String getName() {
        if (this.testName != null) {
            return this.testName;
        }
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        String string2 = n > -1 ? string.substring(n + 1) : string;
        return string2;
    }

    protected boolean supportsTestCase(String string, TestCase testCase) {
        boolean bl;
        String string2 = this.environment.getMissingFeature(testCase.getRequirements());
        if (string2 == null) {
            bl = true;
        } else {
            bl = false;
            this.log.addInfo(string, "TestCase '" + testCase + "' not running" + " because of '" + string2 + "'");
        }
        return bl;
    }

    public java.sql.Connection connect() throws SQLException {
        java.sql.Connection connection = this.options.connect();
        connection.setAutoCommit(false);
        return connection;
    }

    public void release() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = null;
            this.stmt = null;
        }
    }

    public void finalize() {
        try {
            this.stmt.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.stmt = null;
    }

    protected abstract void testRun() throws SQLException;

    protected boolean isExcluded() {
        if (this.excludeList == null) {
            return false;
        }
        String string = (String)this.excludeList.get(this.getClass().getName());
        if (string == null || !string.startsWith("exclude")) {
            return false;
        }
        this.log.addInfo(new Info(this.getName(), "is excluded"));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean runInner() throws SQLException {
        block21: {
            String string;
            block19: {
                string = this.getName();
                this.log.push(string);
                if (this.isExcluded()) break block19;
                if (this.connection.isClosed()) {
                    this.connect();
                }
                this.connection.setAutoCommit(false);
                this.testRun();
            }
            Object var4_2 = null;
            try {
                if (this.isMainTest) {
                    this.stmt.close();
                    this.connection.close();
                } else {
                    this.connection.rollback();
                }
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.log.pop();
            {
                break block21;
                catch (Throwable throwable) {
                    this.vtraceFlush();
                    this.log.addFailure(new ExceptionOccurred(string, throwable));
                    Object var4_3 = null;
                    try {
                        if (this.isMainTest) {
                            this.stmt.close();
                            this.connection.close();
                        } else {
                            this.connection.rollback();
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    this.log.pop();
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    if (this.isMainTest) {
                        this.stmt.close();
                        this.connection.close();
                    } else {
                        this.connection.rollback();
                    }
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.log.pop();
                throw throwable;
            }
        }
        if (this.isMainTest && this.options != null && this.options.getBoolean("failuredump")) {
            this.log.dumpFailureTree();
        }
        return this.log.hasErrors();
    }

    public void startTiming() throws SQLException {
        this.timerStart = System.currentTimeMillis();
    }

    public long endTiming() {
        long l = System.currentTimeMillis();
        return l - this.timerStart;
    }

    public void dropTable(String string) {
        try {
            this.stmt.executeUpdate("drop table " + string);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected int sql(String string) throws SQLException {
        int n = this.stmt.executeUpdate(string);
        return n;
    }

    public PreparedStatement prepare(String string) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement(string);
        return preparedStatement;
    }

    protected ResultSet select(String string) throws SQLException {
        ResultSet resultSet = this.stmt.executeQuery(string);
        return resultSet;
    }

    public static String[] addOptions(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    protected void sleep(int n) {
        try {
            if (this.log.isVerbose()) {
                for (int i = 0; i < n; i += 10) {
                    int n2 = n - i;
                    this.log.addInfo("sleep", "" + n2 + " seconds");
                    this.log.flush();
                    Thread.sleep(Math.min(10, n2) * 1000);
                }
            } else {
                Thread.sleep(n * 1000);
            }
        }
        catch (InterruptedException interruptedException) {
            this.log.addFailure(new ExceptionOccurred("sleep", interruptedException));
        }
    }

    protected String getUsername() {
        return this.options.getUser();
    }

    protected String getPasswd() {
        return this.options.getPassword();
    }

    protected String getDBName() {
        return this.options.getDBName();
    }

    private boolean checkUnicodeDB() {
        try {
            if (!this.environment.testRunsWithMaxDB) {
                return false;
            }
            return this.getDBParameterAsString("_UNICODE").equalsIgnoreCase("YES") && this.getDBParameterAsString("DEFAULT_CODE").equalsIgnoreCase("UNICODE");
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    protected int getDBParameterAsInt(String string) throws SQLException {
        ResultSet resultSet = this.stmt.executeQuery("select value from dbparameters where description = '" + string + "'");
        resultSet.next();
        int n = resultSet.getInt(1);
        resultSet.close();
        return n;
    }

    protected String getDBParameterAsString(String string) throws SQLException {
        ResultSet resultSet = this.stmt.executeQuery("select value from dbparameters where description = '" + string + "'");
        resultSet.next();
        String string2 = resultSet.getString(1);
        resultSet.close();
        return string2;
    }

    public void checkForOpenResultsets(java.sql.Connection connection) throws SQLException {
        if (!this.environment.testRunsWithMaxDB) {
            return;
        }
        System.gc();
        System.gc();
        this.connection.isClosed();
        Statement statement = this.connection.createStatement(1005, 1007);
        statement.setCursorName("CheckForOpenResults");
        ResultSet resultSet = statement.executeQuery("SELECT tablename FROM domain.tables WHERE tabletype = 'RESULT' AND tablename <> 'CheckForOpenResults'");
        while (resultSet.next()) {
            this.log.addWarning("WARNING RESULTSET NOT CLOSED", resultSet.getString(1));
        }
        resultSet.close();
        statement.close();
    }

    public boolean checkVersion(String string) {
        if (!this.environment.testRunsWithMaxDB) {
            return true;
        }
        try {
            String string2 = this.connection.getMetaData().getDatabaseProductVersion();
            string2 = string2.substring(10);
            if (string2.compareTo(string) >= 0) {
                return true;
            }
            this.log.addInfo("Version check unsuccessful, required " + string + ", found " + string2);
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isVersion(String string) {
        if (!this.environment.testRunsWithMaxDB) {
            return true;
        }
        try {
            String string2 = this.connection.getMetaData().getDatabaseProductVersion();
            string2 = string2.substring("Kernel   ".length() + 1, "Kernel   ".length() + Math.min(string2.length(), string.length()) + 1);
            if (string2.equals(string)) {
                return true;
            }
            this.log.addInfo("Version check unsuccessful, required " + string + ", found " + string2);
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void vtraceFlush() throws SQLException {
        try {
            if (!this.environment.testRunsWithMaxDB) {
                return;
            }
            this.stmt.execute("diagnose vtrace flush");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String getUnicodeIdentifier(String string) throws SQLException {
        if (this.environment.hasFeature("UnicodeDB") && this.environment.hasFeature("UnicodeConnection")) {
            if (string.length() > 23) {
                string = string.substring(0, 23);
            }
            return string + "_\u8f6f\u4ef6\u5f00\u53d1\u5546\u662f\u82f1\u96c4";
        }
        return string;
    }

    public String makeRandomString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        Random random = new Random(System.currentTimeMillis() + ++seed);
        for (int i = 0; i < n; ++i) {
            char c = (char)(random.nextInt(26) + 65);
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

