/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.util.options;

import com.sap.dbtechtest.util.ConnectionWrapper;
import com.sap.dbtechtest.util.SQLMapper;
import com.sap.dbtechtest.util.options.BoolOption;
import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.options.Options;
import com.sap.dbtechtest.util.options.StringOption;
import com.sap.dbtechtest.util.options.VariableOption;
import java.io.FileInputStream;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class SapDBOptions
extends Options {
    public static final String sapdbDriverClassC = "com.sap.dbtech.jdbc.DriverSapDB";
    private static final String odbcDriverClassC = "sun.jdbc.odbc.JdbcOdbcDriver";
    public static final String connectURL = "url";
    public static final String driverClass = "driverClass";
    public static final String urlPrefix = "urlPrefix";
    public static final String userInfo = "userInfo";
    public static final String databaseName = "databaseName";
    public static final String serverName = "serverName";
    public static final String port = "port";
    public static final String property = "property";
    public static final String mapFile = "sqlmapfile";
    public static final String testProps = "testproperties";
    public static final String dumpsql = "dumpsql";
    public static final String exclude = "exclude";
    private static OptionDesc[] baseOptions = new OptionDesc[]{new BoolOption("dumpsql", "dumps all sql commands to the log file", new String[]{"-s"}), new StringOption("testproperties", "a file that contains the test properties", "test.properties", new String[]{"-p"}), new StringOption("sqlmapfile", "a xml-file that contains the mapping of vender specific SQL", "sqlmapping.xml", new String[]{"-m"}), new StringOption("url", "vender specific connect URL", "unknown URL", new String[]{"-U"}), new StringOption("driverClass", "vender specific driver class name", "com.sap.dbtech.jdbc.DriverSapDB", new String[]{"-c"}), new StringOption("urlPrefix", "vender specific url prefix", "jdbc:sapdb", new String[]{"-x"}), new StringOption("userInfo", "user info <name,pwd>", "unknown,user", new String[]{"-u"}), new StringOption("databaseName", "database name <[serverName:]dbname>", "", new String[]{"-d"}), new StringOption("serverName", "server node", "", new String[]{"-n"}), new VariableOption("property", "connect property <name=value>", new String[]{"-P"}), new VariableOption("property", "exclude <class name>", new String[]{"-e"})};
    private static boolean nativeDriverLoaded = false;
    private static boolean odbcDriverLoaded = false;
    private SQLMapper sqlMapper = null;

    public SapDBOptions(OptionDesc[] optionDescArray, String string) {
        super(SapDBOptions.concatArray(optionDescArray, baseOptions), string);
    }

    public SapDBOptions(OptionDesc[] optionDescArray, OptionDesc[] optionDescArray2, String string) {
        super(SapDBOptions.concatArrays(new OptionDesc[][]{optionDescArray, optionDescArray2, baseOptions}), string);
    }

    public void loadTestOptionsFromFile() {
        try {
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            String string6 = this.getString(testProps);
            Properties properties = new Properties();
            FileInputStream fileInputStream = new FileInputStream(string6);
            properties.load(fileInputStream);
            String string7 = (String)properties.remove(serverName);
            String string8 = (String)properties.remove(port);
            if (string7 != null && !string7.equals("")) {
                if (string8 != null && !string8.equals("")) {
                    this.values.put(serverName, string7 + ":" + string8);
                } else {
                    this.values.put(serverName, string7);
                }
            }
            if ((string5 = (String)properties.remove(databaseName)) != null && !string5.equals("")) {
                this.values.put(databaseName, string5);
            }
            String string9 = (String)properties.remove("user");
            String string10 = (String)properties.remove("password");
            if (string9 != null && !string9.equals("") && string10 != null && !string10.equals("")) {
                this.values.put(userInfo, string9 + "," + string10);
            }
            if ((string4 = (String)properties.remove(connectURL)) != null && !string4.equals("")) {
                this.values.put(connectURL, string4);
            }
            if ((string3 = (String)properties.remove(driverClass)) != null && !string3.equals("")) {
                this.values.put(driverClass, string3);
            }
            if ((string2 = (String)properties.remove(urlPrefix)) != null && !string2.equals("")) {
                this.values.put(urlPrefix, string2);
            }
            if ((string = (String)properties.remove(dumpsql)) != null && string.equalsIgnoreCase("true")) {
                this.values.put(dumpsql, Boolean.TRUE);
            }
            Dictionary dictionary = this.getVariables(property);
            Dictionary dictionary2 = this.getVariables(exclude);
            if (dictionary2 == null) {
                this.values.put(exclude, new Hashtable());
                dictionary2 = this.getVariables(exclude);
            }
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                Object object2 = properties.get(object);
                if (object2 == null || object2.equals("")) continue;
                if (((String)object2).startsWith(exclude)) {
                    dictionary2.put(object, object2);
                    continue;
                }
                dictionary.put(object, object2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadSQLMapFile() {
        String string = this.getString(mapFile);
        boolean bl = this.getBoolean(dumpsql);
        this.sqlMapper = new SQLMapper(string, bl);
    }

    public int parse(String[] stringArray) {
        int n = super.parse(stringArray);
        if (n == 2 && this.sqlMapper == null) {
            this.loadTestOptionsFromFile();
            this.loadSQLMapFile();
            return 2;
        }
        return n;
    }

    public Connection connect() throws SQLException {
        String string = this.getString("odbc");
        Connection connection = string.length() > 0 ? this.connectODBC(string) : this.connectNative();
        if (this.sqlMapper == null) {
            this.loadSQLMapFile();
        }
        return new ConnectionWrapper(connection, this.sqlMapper);
    }

    public String getConnectURL() {
        String string = this.getString(connectURL);
        if (string.equals("unknown URL")) {
            int n;
            String string2 = this.getString(urlPrefix);
            String string3 = this.getString(serverName);
            String string4 = this.getString(databaseName);
            Dictionary dictionary = this.getVariables(property);
            StringBuffer stringBuffer = new StringBuffer();
            String string5 = "";
            String string6 = "&";
            if (string3.length() == 0 && (n = string4.indexOf(58)) > 0) {
                string3 = string4.substring(0, n);
                string4 = string4.substring(n + 1);
            }
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                String string7 = (String)enumeration.nextElement();
                Object v = dictionary.get(string7);
                stringBuffer.append(string5);
                stringBuffer.append(string7);
                stringBuffer.append('=');
                stringBuffer.append(v.toString());
                string5 = string6;
            }
            string = string2 + "://" + string3 + "/" + string4 + "?" + stringBuffer.toString();
        }
        return string;
    }

    public Connection connectNative() throws SQLException {
        String string;
        Object object;
        if (!nativeDriverLoaded) {
            object = this.getString(driverClass);
            try {
                Class.forName((String)object).newInstance();
                nativeDriverLoaded = true;
            }
            catch (Exception exception) {
                try {
                    Class.forName((String)object);
                    nativeDriverLoaded = true;
                }
                catch (Exception exception2) {
                    System.out.println(exception.toString());
                    throw new SQLException("Can't load driver class " + (String)object);
                }
            }
        }
        String string2 = this.getConnectURL();
        String string3 = this.getString(userInfo);
        String string4 = "";
        int n = string3.indexOf(44);
        if (n > 0) {
            string = string3.substring(0, n);
            string4 = string3.substring(n + 1);
        } else {
            string = string3;
        }
        object = string.equals("unknown") && string4.equals(string3) ? DriverManager.getConnection(string2) : DriverManager.getConnection(string2, string, string4);
        return object;
    }

    public String getUser() {
        String string = this.getString(userInfo);
        int n = string.indexOf(44);
        String string2 = n > 0 ? string.substring(0, n) : string;
        return string2;
    }

    public String getProperty(String string) {
        String string2 = this.getString(string);
        if (string2 == null) {
            string2 = (String)((Hashtable)this.values.get(property)).get(string);
        }
        if (userInfo != null) {
            return string2;
        }
        return null;
    }

    public String getPassword() {
        String string = this.getString(userInfo);
        int n = string.indexOf(44);
        String string2 = n > 0 ? string.substring(n + 1) : "";
        return string2;
    }

    public String getDBName() {
        int n;
        String string = this.getString(serverName);
        String string2 = this.getString(databaseName);
        if (string.length() == 0 && (n = string2.indexOf(58)) > 0) {
            string = string2.substring(0, n);
            string2 = string2.substring(n + 1);
        }
        return string2;
    }

    public String getHostname() {
        int n;
        String string = this.getString(serverName);
        String string2 = this.getString(databaseName);
        if (string.length() == 0 && (n = string2.indexOf(58)) > 0) {
            string = string2.substring(0, n);
            string2 = string2.substring(n + 1);
        }
        return string;
    }

    public Connection connectODBC(String string) throws SQLException {
        String string2;
        if (!odbcDriverLoaded) {
            try {
                Class.forName(odbcDriverClassC);
                odbcDriverLoaded = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SQLException("Can't load driver class sun.jdbc.odbc.JdbcOdbcDriver");
            }
        }
        String string3 = this.getString(userInfo);
        String string4 = "";
        Dictionary dictionary = this.getVariables(property);
        Properties properties = new Properties();
        int n = string3.indexOf(44);
        if (n > 0) {
            string2 = string3.substring(0, n);
            string4 = string3.substring(n + 1);
        } else {
            string2 = string3;
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string5 = (String)enumeration.nextElement();
            Object object = properties.get(string5);
            properties.setProperty(string5, object.toString());
        }
        Connection connection = DriverManager.getConnection("jdbc:odbc:" + string, string2, string4);
        return connection;
    }

    public static OptionDesc[] concatArrays(OptionDesc[][] optionDescArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        OptionDesc[] optionDescArray2 = null;
        for (n = 0; n < optionDescArray.length; ++n) {
            if (optionDescArray[n] == null) continue;
            n2 += Array.getLength(optionDescArray[n]);
            optionDescArray2 = optionDescArray[n];
        }
        if (optionDescArray2 == null) {
            return null;
        }
        Object object = SapDBOptions.arrayFromSample(optionDescArray2, n2);
        for (n = 0; n < optionDescArray.length; ++n) {
            if (optionDescArray[n] == null) continue;
            int n4 = Array.getLength(optionDescArray[n]);
            System.arraycopy(optionDescArray[n], 0, object, n3, n4);
            n3 += n4;
        }
        return (OptionDesc[])object;
    }

    public static OptionDesc[] concatArray(OptionDesc[] optionDescArray, OptionDesc[] optionDescArray2) {
        return SapDBOptions.concatArrays(new OptionDesc[][]{optionDescArray, optionDescArray2});
    }

    protected static Object arrayFromSample(Object object, int n) {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz == null) {
            return null;
        }
        Object object2 = Array.newInstance(clazz, n);
        return object2;
    }

    public static SapDBOptions dummyOptions() {
        return new SapDBOptions(null, null);
    }
}

