/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.generators.AsciiStream;
import com.sap.dbtechtest.jdbc.types.ConversionTest;
import com.sap.dbtechtest.jdbc.types.ConversionTestCase;
import com.sap.dbtechtest.jdbc.types.EqualityTestCase;
import com.sap.dbtechtest.util.ObjectServices;
import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.options.StringOption;
import com.sap.dbtechtest.util.testdriver.Test;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class VarcharTest
extends ConversionTest {
    public static final int varcharColSizeC = 20;
    public static final String piStringC = new Double(Math.PI).toString();
    private static final String help = "help for VarcharTest";
    private static final OptionDesc[] optdesc = new OptionDesc[]{new StringOption("sqlcol", "SQL column definition", "VARCHAR (20)", null)};
    private static String testString = "hello";
    private static byte[] testStringUCS2 = null;
    private static byte[] testStringByte = null;
    private final ConversionTestCase[] insertTests;
    private final ConversionTestCase[] fetchTests;

    public VarcharTest(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
        try {
            testStringUCS2 = testString.getBytes("UTF-16BE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        testStringByte = testString.getBytes();
        this.insertTests = new ConversionTestCase[]{new EqualityTestCase("Array", null).setInsertException(JDBCDriverExceptionClass), (ConversionTestCase)new EqualityTestCase("AsciiStream", new AsciiStream(10L)).knownBug("PTS1111434 PTS1111435"), (ConversionTestCase)new EqualityTestCase("AsciiStream", new AsciiStream(20L)).knownBug("PTS1111434 PTS1111435"), new EqualityTestCase("AsciiStream", new AsciiStream(40L)).setInsertException(this.ValueOverflowClass), new EqualityTestCase("BigDecimal", new BigDecimal(0.0), "0"), new EqualityTestCase("BigDecimal", new BigDecimal("1234567890123456789012345")).setInsertException(this.ValueOverflowClass), (ConversionTestCase)new EqualityTestCase("Boolean", Boolean.TRUE, Boolean.TRUE.toString()).knownBug("PTS1111434 PTS1111435"), (ConversionTestCase)new EqualityTestCase("Boolean", Boolean.FALSE, Boolean.FALSE.toString()).knownBug("PTS1111434 PTS1111435"), VarcharTest.byteInsertTestCase(-128L), VarcharTest.byteInsertTestCase(-1L), VarcharTest.byteInsertTestCase(0L), VarcharTest.byteInsertTestCase(1L), VarcharTest.byteInsertTestCase(127L), (ConversionTestCase)new EqualityTestCase("Bytes", testStringUCS2, testString).require("UnicodeDB"), (ConversionTestCase)new EqualityTestCase("Bytes", testStringByte, testString).require("AsciiDB"), new EqualityTestCase("Date", new Date(100, 0, 1), "2000-01-01"), (ConversionTestCase)VarcharTest.doubleInsertTestCase(Double.NEGATIVE_INFINITY).knownBug("PTS1111434 PTS1111435"), (ConversionTestCase)VarcharTest.doubleInsertTestCase(Double.MIN_VALUE).knownBug("PTS1111434 PTS1111435"), (ConversionTestCase)VarcharTest.doubleInsertTestCase(-Math.PI).knownBug("PTS1111434 PTS1111435"), VarcharTest.doubleInsertTestCase(-0.5), (ConversionTestCase)VarcharTest.doubleInsertTestCase(-0.1).knownBug("PTS1111434 PTS1111435"), new EqualityTestCase("Double", new Double(0.0), "0"), (ConversionTestCase)VarcharTest.doubleInsertTestCase(0.1).knownBug("PTS1111434 PTS1111435"), VarcharTest.doubleInsertTestCase(0.5), (ConversionTestCase)VarcharTest.doubleInsertTestCase(Math.PI).knownBug("PTS1111434 PTS1111435"), (ConversionTestCase)VarcharTest.doubleInsertTestCase(Double.MAX_VALUE).knownBug("PTS1111434 PTS1111435"), (ConversionTestCase)VarcharTest.doubleInsertTestCase(Double.POSITIVE_INFINITY).knownBug("PTS1111434 PTS1111435"), (ConversionTestCase)VarcharTest.floatInsertTestCase(Double.NEGATIVE_INFINITY).knownBug("PTS1111434 PTS1111435"), (ConversionTestCase)VarcharTest.floatInsertTestCase(1.4E-45f).knownBug("PTS1111434 PTS1111435"), (ConversionTestCase)VarcharTest.floatInsertTestCase(-Math.PI).knownBug("PTS1111434 PTS1111435"), VarcharTest.floatInsertTestCase(-0.5), (ConversionTestCase)VarcharTest.floatInsertTestCase(-0.1).knownBug("PTS1111434 PTS1111435"), new EqualityTestCase("Float", new Float(0.0), "0"), (ConversionTestCase)VarcharTest.floatInsertTestCase(0.1).knownBug("PTS1111434 PTS1111435"), VarcharTest.floatInsertTestCase(0.5), (ConversionTestCase)VarcharTest.floatInsertTestCase(Math.PI).knownBug("PTS1111434 PTS1111435"), (ConversionTestCase)VarcharTest.floatInsertTestCase(3.4028234663852886E38).knownBug("PTS1111434 PTS1111435"), (ConversionTestCase)VarcharTest.floatInsertTestCase(Double.POSITIVE_INFINITY).knownBug("PTS1111434 PTS1111435"), VarcharTest.intInsertTestCase(Integer.MIN_VALUE), VarcharTest.intInsertTestCase(-1L), VarcharTest.intInsertTestCase(0L), VarcharTest.intInsertTestCase(1L), VarcharTest.intInsertTestCase(Integer.MAX_VALUE), VarcharTest.longInsertTestCase(Long.MIN_VALUE), VarcharTest.longInsertTestCase(-1L), VarcharTest.longInsertTestCase(0L), VarcharTest.longInsertTestCase(1L), (ConversionTestCase)VarcharTest.longInsertTestCase(Long.MAX_VALUE).knownBug("PTS1111434 PTS1111435"), new EqualityTestCase("String", "hello"), new EqualityTestCase("String", ""), new EqualityTestCase("String", "abcdefghijklmnopqrstuvwxyz").setInsertException(this.ValueOverflowClass), new EqualityTestCase("Ref", null).setInsertException(JDBCDriverExceptionClass), VarcharTest.shortInsertTestCase(-32768L), VarcharTest.shortInsertTestCase(-1L), VarcharTest.shortInsertTestCase(0L), VarcharTest.shortInsertTestCase(1L), VarcharTest.shortInsertTestCase(32767L), new EqualityTestCase("Object", "hello"), new EqualityTestCase("Object", ""), new EqualityTestCase("Object", "abcdefghijklmnopqrstuvwxyz").setInsertException(this.ValueOverflowClass), new EqualityTestCase("Time", new Time(12, 0, 0), "12:00:00"), new EqualityTestCase("Timestamp", new Timestamp(100, 0, 1, 12, 0, 0, 5), "2001-01-01 12:00:00.000000005").setInsertException(this.ValueOverflowClass)};
        this.fetchTests = new ConversionTestCase[]{new EqualityTestCase("Array", null).setFetchException(JDBCDriverExceptionClass), VarcharTest.bigDecimalFetchTestCase("0"), VarcharTest.bigDecimalFetchTestCase("12345678901234567890"), VarcharTest.bigDecimalFetchTestCase("garbage"), new EqualityTestCase("Boolean", Boolean.TRUE.toString(), Boolean.TRUE), new EqualityTestCase("Boolean", Boolean.FALSE.toString(), Boolean.FALSE), VarcharTest.byteFetchTestCase(-128L), VarcharTest.byteFetchTestCase(-1L), VarcharTest.byteFetchTestCase(0L), VarcharTest.byteFetchTestCase(1L), VarcharTest.byteFetchTestCase(127L), VarcharTest.byteFetchTestCase("garbage"), (ConversionTestCase)VarcharTest.byteFetchTestCase("1.1").knownBug("PTS1111434 PTS1111435"), (ConversionTestCase)VarcharTest.byteFetchTestCase(128L).knownBug("PTS1111434 PTS1111435"), (ConversionTestCase)new EqualityTestCase("Bytes", "hello", "hello".getBytes()).require("AsciiDB"), new EqualityTestCase("Date", "2000-01-01", new Date(100, 0, 1)), new EqualityTestCase("Date", "2000.01.01", new Date(100, 0, 1)).setFetchException(ConversionExceptionClass), (ConversionTestCase)new EqualityTestCase("Date", "2000-02-30", new Date(100, 0, 1)).setFetchException(ConversionExceptionClass).knownBug("PTS1111434 PTS1111435"), VarcharTest.doubleFetchTestCase(ObjectServices.substring("-" + piStringC, 0, 20)), VarcharTest.doubleFetchTestCase(-0.5), VarcharTest.doubleFetchTestCase("-0.1"), VarcharTest.doubleFetchTestCase(0.0), VarcharTest.doubleFetchTestCase(0.1), VarcharTest.doubleFetchTestCase(0.5), VarcharTest.doubleFetchTestCase(ObjectServices.substring(piStringC, 0, 20)), VarcharTest.doubleFetchTestCase("garbage"), VarcharTest.floatFetchTestCase(ObjectServices.substring("-" + piStringC, 0, 20)), VarcharTest.floatFetchTestCase(-0.5), VarcharTest.floatFetchTestCase(-0.1), VarcharTest.floatFetchTestCase(0.0), VarcharTest.floatFetchTestCase(0.1), VarcharTest.floatFetchTestCase(0.5), VarcharTest.floatFetchTestCase(ObjectServices.substring(piStringC, 0, 20)), VarcharTest.floatFetchTestCase("garbage"), VarcharTest.intFetchTestCase(Integer.MIN_VALUE), VarcharTest.intFetchTestCase(-1L), VarcharTest.intFetchTestCase(0L), VarcharTest.intFetchTestCase(1L), VarcharTest.intFetchTestCase(Integer.MAX_VALUE), VarcharTest.intFetchTestCase("garbage"), (ConversionTestCase)VarcharTest.intFetchTestCase(0x80000000L).knownBug("PTS1111434 PTS1111435"), VarcharTest.longFetchTestCase(Long.MIN_VALUE), VarcharTest.longFetchTestCase(-1L), VarcharTest.longFetchTestCase(0L), VarcharTest.longFetchTestCase(1L), (ConversionTestCase)VarcharTest.longFetchTestCase(Long.MAX_VALUE).knownBug("PTS1111434 PTS1111435"), VarcharTest.longFetchTestCase("garbage"), new EqualityTestCase("String", "hello"), new EqualityTestCase("String", ""), new EqualityTestCase("String", "abcdefghijklmnopqrstuvwxyz").setInsertException(this.ValueOverflowClass), new EqualityTestCase("Ref", null).setFetchException(JDBCDriverExceptionClass), VarcharTest.shortFetchTestCase(-32768L), VarcharTest.shortFetchTestCase(-1L), VarcharTest.shortFetchTestCase(0L), VarcharTest.shortFetchTestCase(1L), VarcharTest.shortFetchTestCase(32767L), VarcharTest.shortFetchTestCase("garbage"), (ConversionTestCase)VarcharTest.shortFetchTestCase(32768L).knownBug("PTS1111434 PTS1111435"), new EqualityTestCase("Object", "hello"), new EqualityTestCase("Object", ""), new EqualityTestCase("Object", "abcdefghijklmnopqrstuvwxyz").setInsertException(this.ValueOverflowClass), new EqualityTestCase("Time", "12:00:00", new Time(12, 0, 0)), new EqualityTestCase("Time", "12-00-00", new Time(12, 0, 0)).setFetchException(ConversionExceptionClass), (ConversionTestCase)new EqualityTestCase("Time", "12:70:00", new Time(12, 0, 0)).knownBug("PTS1111434 PTS1111435"), new EqualityTestCase("Timestamp", "2000-01-01 12:00:00", new Timestamp(100, 0, 1, 12, 0, 0, 0)), new EqualityTestCase("Timestamp", "2000.01.01 12:00:00", new Timestamp(100, 0, 1, 12, 0, 0, 0)).setFetchException(ConversionExceptionClass), (ConversionTestCase)new EqualityTestCase("Timestamp", "2000-02-30 12:00:00", new Timestamp(100, 0, 1, 12, 0, 0, 0)).knownBug("PTS1111434 PTS1111435")};
    }

    public VarcharTest(Test test) throws SQLException {
        super(test);
        try {
            testStringUCS2 = testString.getBytes("UTF-16BE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        testStringByte = testString.getBytes();
        this.insertTests = new ConversionTestCase[]{new EqualityTestCase("Array", null).setInsertException(JDBCDriverExceptionClass), (ConversionTestCase)new EqualityTestCase("AsciiStream", new AsciiStream(10L)).knownBug("PTS1111434 PTS1111435"), (ConversionTestCase)new EqualityTestCase("AsciiStream", new AsciiStream(20L)).knownBug("PTS1111434 PTS1111435"), new EqualityTestCase("AsciiStream", new AsciiStream(40L)).setInsertException(this.ValueOverflowClass), new EqualityTestCase("BigDecimal", new BigDecimal(0.0), "0"), new EqualityTestCase("BigDecimal", new BigDecimal("1234567890123456789012345")).setInsertException(this.ValueOverflowClass), (ConversionTestCase)new EqualityTestCase("Boolean", Boolean.TRUE, Boolean.TRUE.toString()).knownBug("PTS1111434 PTS1111435"), (ConversionTestCase)new EqualityTestCase("Boolean", Boolean.FALSE, Boolean.FALSE.toString()).knownBug("PTS1111434 PTS1111435"), VarcharTest.byteInsertTestCase(-128L), VarcharTest.byteInsertTestCase(-1L), VarcharTest.byteInsertTestCase(0L), VarcharTest.byteInsertTestCase(1L), VarcharTest.byteInsertTestCase(127L), (ConversionTestCase)new EqualityTestCase("Bytes", testStringUCS2, testString).require("UnicodeDB"), (ConversionTestCase)new EqualityTestCase("Bytes", testStringByte, testString).require("AsciiDB"), new EqualityTestCase("Date", new Date(100, 0, 1), "2000-01-01"), (ConversionTestCase)VarcharTest.doubleInsertTestCase(Double.NEGATIVE_INFINITY).knownBug("PTS1111434 PTS1111435"), (ConversionTestCase)VarcharTest.doubleInsertTestCase(Double.MIN_VALUE).knownBug("PTS1111434 PTS1111435"), (ConversionTestCase)VarcharTest.doubleInsertTestCase(-Math.PI).knownBug("PTS1111434 PTS1111435"), VarcharTest.doubleInsertTestCase(-0.5), (ConversionTestCase)VarcharTest.doubleInsertTestCase(-0.1).knownBug("PTS1111434 PTS1111435"), new EqualityTestCase("Double", new Double(0.0), "0"), (ConversionTestCase)VarcharTest.doubleInsertTestCase(0.1).knownBug("PTS1111434 PTS1111435"), VarcharTest.doubleInsertTestCase(0.5), (ConversionTestCase)VarcharTest.doubleInsertTestCase(Math.PI).knownBug("PTS1111434 PTS1111435"), (ConversionTestCase)VarcharTest.doubleInsertTestCase(Double.MAX_VALUE).knownBug("PTS1111434 PTS1111435"), (ConversionTestCase)VarcharTest.doubleInsertTestCase(Double.POSITIVE_INFINITY).knownBug("PTS1111434 PTS1111435"), (ConversionTestCase)VarcharTest.floatInsertTestCase(Double.NEGATIVE_INFINITY).knownBug("PTS1111434 PTS1111435"), (ConversionTestCase)VarcharTest.floatInsertTestCase(1.4E-45f).knownBug("PTS1111434 PTS1111435"), (ConversionTestCase)VarcharTest.floatInsertTestCase(-Math.PI).knownBug("PTS1111434 PTS1111435"), VarcharTest.floatInsertTestCase(-0.5), (ConversionTestCase)VarcharTest.floatInsertTestCase(-0.1).knownBug("PTS1111434 PTS1111435"), new EqualityTestCase("Float", new Float(0.0), "0"), (ConversionTestCase)VarcharTest.floatInsertTestCase(0.1).knownBug("PTS1111434 PTS1111435"), VarcharTest.floatInsertTestCase(0.5), (ConversionTestCase)VarcharTest.floatInsertTestCase(Math.PI).knownBug("PTS1111434 PTS1111435"), (ConversionTestCase)VarcharTest.floatInsertTestCase(3.4028234663852886E38).knownBug("PTS1111434 PTS1111435"), (ConversionTestCase)VarcharTest.floatInsertTestCase(Double.POSITIVE_INFINITY).knownBug("PTS1111434 PTS1111435"), VarcharTest.intInsertTestCase(Integer.MIN_VALUE), VarcharTest.intInsertTestCase(-1L), VarcharTest.intInsertTestCase(0L), VarcharTest.intInsertTestCase(1L), VarcharTest.intInsertTestCase(Integer.MAX_VALUE), VarcharTest.longInsertTestCase(Long.MIN_VALUE), VarcharTest.longInsertTestCase(-1L), VarcharTest.longInsertTestCase(0L), VarcharTest.longInsertTestCase(1L), (ConversionTestCase)VarcharTest.longInsertTestCase(Long.MAX_VALUE).knownBug("PTS1111434 PTS1111435"), new EqualityTestCase("String", "hello"), new EqualityTestCase("String", ""), new EqualityTestCase("String", "abcdefghijklmnopqrstuvwxyz").setInsertException(this.ValueOverflowClass), new EqualityTestCase("Ref", null).setInsertException(JDBCDriverExceptionClass), VarcharTest.shortInsertTestCase(-32768L), VarcharTest.shortInsertTestCase(-1L), VarcharTest.shortInsertTestCase(0L), VarcharTest.shortInsertTestCase(1L), VarcharTest.shortInsertTestCase(32767L), new EqualityTestCase("Object", "hello"), new EqualityTestCase("Object", ""), new EqualityTestCase("Object", "abcdefghijklmnopqrstuvwxyz").setInsertException(this.ValueOverflowClass), new EqualityTestCase("Time", new Time(12, 0, 0), "12:00:00"), new EqualityTestCase("Timestamp", new Timestamp(100, 0, 1, 12, 0, 0, 5), "2001-01-01 12:00:00.000000005").setInsertException(this.ValueOverflowClass)};
        this.fetchTests = new ConversionTestCase[]{new EqualityTestCase("Array", null).setFetchException(JDBCDriverExceptionClass), VarcharTest.bigDecimalFetchTestCase("0"), VarcharTest.bigDecimalFetchTestCase("12345678901234567890"), VarcharTest.bigDecimalFetchTestCase("garbage"), new EqualityTestCase("Boolean", Boolean.TRUE.toString(), Boolean.TRUE), new EqualityTestCase("Boolean", Boolean.FALSE.toString(), Boolean.FALSE), VarcharTest.byteFetchTestCase(-128L), VarcharTest.byteFetchTestCase(-1L), VarcharTest.byteFetchTestCase(0L), VarcharTest.byteFetchTestCase(1L), VarcharTest.byteFetchTestCase(127L), VarcharTest.byteFetchTestCase("garbage"), (ConversionTestCase)VarcharTest.byteFetchTestCase("1.1").knownBug("PTS1111434 PTS1111435"), (ConversionTestCase)VarcharTest.byteFetchTestCase(128L).knownBug("PTS1111434 PTS1111435"), (ConversionTestCase)new EqualityTestCase("Bytes", "hello", "hello".getBytes()).require("AsciiDB"), new EqualityTestCase("Date", "2000-01-01", new Date(100, 0, 1)), new EqualityTestCase("Date", "2000.01.01", new Date(100, 0, 1)).setFetchException(ConversionExceptionClass), (ConversionTestCase)new EqualityTestCase("Date", "2000-02-30", new Date(100, 0, 1)).setFetchException(ConversionExceptionClass).knownBug("PTS1111434 PTS1111435"), VarcharTest.doubleFetchTestCase(ObjectServices.substring("-" + piStringC, 0, 20)), VarcharTest.doubleFetchTestCase(-0.5), VarcharTest.doubleFetchTestCase("-0.1"), VarcharTest.doubleFetchTestCase(0.0), VarcharTest.doubleFetchTestCase(0.1), VarcharTest.doubleFetchTestCase(0.5), VarcharTest.doubleFetchTestCase(ObjectServices.substring(piStringC, 0, 20)), VarcharTest.doubleFetchTestCase("garbage"), VarcharTest.floatFetchTestCase(ObjectServices.substring("-" + piStringC, 0, 20)), VarcharTest.floatFetchTestCase(-0.5), VarcharTest.floatFetchTestCase(-0.1), VarcharTest.floatFetchTestCase(0.0), VarcharTest.floatFetchTestCase(0.1), VarcharTest.floatFetchTestCase(0.5), VarcharTest.floatFetchTestCase(ObjectServices.substring(piStringC, 0, 20)), VarcharTest.floatFetchTestCase("garbage"), VarcharTest.intFetchTestCase(Integer.MIN_VALUE), VarcharTest.intFetchTestCase(-1L), VarcharTest.intFetchTestCase(0L), VarcharTest.intFetchTestCase(1L), VarcharTest.intFetchTestCase(Integer.MAX_VALUE), VarcharTest.intFetchTestCase("garbage"), (ConversionTestCase)VarcharTest.intFetchTestCase(0x80000000L).knownBug("PTS1111434 PTS1111435"), VarcharTest.longFetchTestCase(Long.MIN_VALUE), VarcharTest.longFetchTestCase(-1L), VarcharTest.longFetchTestCase(0L), VarcharTest.longFetchTestCase(1L), (ConversionTestCase)VarcharTest.longFetchTestCase(Long.MAX_VALUE).knownBug("PTS1111434 PTS1111435"), VarcharTest.longFetchTestCase("garbage"), new EqualityTestCase("String", "hello"), new EqualityTestCase("String", ""), new EqualityTestCase("String", "abcdefghijklmnopqrstuvwxyz").setInsertException(this.ValueOverflowClass), new EqualityTestCase("Ref", null).setFetchException(JDBCDriverExceptionClass), VarcharTest.shortFetchTestCase(-32768L), VarcharTest.shortFetchTestCase(-1L), VarcharTest.shortFetchTestCase(0L), VarcharTest.shortFetchTestCase(1L), VarcharTest.shortFetchTestCase(32767L), VarcharTest.shortFetchTestCase("garbage"), (ConversionTestCase)VarcharTest.shortFetchTestCase(32768L).knownBug("PTS1111434 PTS1111435"), new EqualityTestCase("Object", "hello"), new EqualityTestCase("Object", ""), new EqualityTestCase("Object", "abcdefghijklmnopqrstuvwxyz").setInsertException(this.ValueOverflowClass), new EqualityTestCase("Time", "12:00:00", new Time(12, 0, 0)), new EqualityTestCase("Time", "12-00-00", new Time(12, 0, 0)).setFetchException(ConversionExceptionClass), (ConversionTestCase)new EqualityTestCase("Time", "12:70:00", new Time(12, 0, 0)).knownBug("PTS1111434 PTS1111435"), new EqualityTestCase("Timestamp", "2000-01-01 12:00:00", new Timestamp(100, 0, 1, 12, 0, 0, 0)), new EqualityTestCase("Timestamp", "2000.01.01 12:00:00", new Timestamp(100, 0, 1, 12, 0, 0, 0)).setFetchException(ConversionExceptionClass), (ConversionTestCase)new EqualityTestCase("Timestamp", "2000-02-30 12:00:00", new Timestamp(100, 0, 1, 12, 0, 0, 0)).knownBug("PTS1111434 PTS1111435")};
        this.options.addExtraOptions(optdesc);
    }

    protected ConversionTestCase[] getInputTestCases() {
        return this.insertTests;
    }

    protected ConversionTestCase[] getFetchTestCases() {
        return this.fetchTests;
    }

    protected static EqualityTestCase byteInsertTestCase(long l) {
        return new EqualityTestCase("Byte", new Byte((byte)l), new Byte((byte)l).toString());
    }

    protected static EqualityTestCase doubleInsertTestCase(double d) {
        return new EqualityTestCase("Double", new Double(d), new Double(d).toString());
    }

    protected static EqualityTestCase floatInsertTestCase(double d) {
        return new EqualityTestCase("Float", new Float(d), new Float(d).toString());
    }

    protected static EqualityTestCase intInsertTestCase(long l) {
        return new EqualityTestCase("Int", new Integer((int)l), new Integer((int)l).toString());
    }

    protected static EqualityTestCase longInsertTestCase(long l) {
        return new EqualityTestCase("Long", new Long(l), new Long(l).toString());
    }

    protected static EqualityTestCase shortInsertTestCase(long l) {
        return new EqualityTestCase("Short", new Short((short)l), new Short((short)l).toString());
    }

    protected static EqualityTestCase bigDecimalFetchTestCase(String string) {
        EqualityTestCase equalityTestCase;
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = new BigDecimal(string);
            equalityTestCase = new EqualityTestCase("BigDecimal", string, bigDecimal);
        }
        catch (NumberFormatException numberFormatException) {
            equalityTestCase = new EqualityTestCase("BigDecimal", string, null);
            equalityTestCase.setFetchException(ConversionExceptionClass);
        }
        return equalityTestCase;
    }

    protected static EqualityTestCase byteFetchTestCase(long l) {
        BigDecimal bigDecimal = new BigDecimal((double)l);
        return new EqualityTestCase("Byte", bigDecimal.toString(), bigDecimal);
    }

    protected static EqualityTestCase byteFetchTestCase(String string) {
        EqualityTestCase equalityTestCase;
        Byte by = null;
        try {
            by = new Byte(string);
            equalityTestCase = new EqualityTestCase("Byte", string, by);
        }
        catch (NumberFormatException numberFormatException) {
            equalityTestCase = new EqualityTestCase("Byte", string, null);
            equalityTestCase.setFetchException(ConversionExceptionClass);
        }
        return equalityTestCase;
    }

    protected static EqualityTestCase doubleFetchTestCase(double d) {
        BigDecimal bigDecimal = new BigDecimal(d);
        return new EqualityTestCase("Double", VarcharTest.roundString(bigDecimal.toString(), 20), bigDecimal);
    }

    protected static EqualityTestCase doubleFetchTestCase(String string) {
        EqualityTestCase equalityTestCase;
        Double d = null;
        try {
            d = new Double(string);
            equalityTestCase = new EqualityTestCase("Double", string, d);
        }
        catch (NumberFormatException numberFormatException) {
            equalityTestCase = new EqualityTestCase("Double", string, null);
            equalityTestCase.setFetchException(ConversionExceptionClass);
        }
        return equalityTestCase;
    }

    protected static EqualityTestCase floatFetchTestCase(double d) {
        BigDecimal bigDecimal = new BigDecimal(d);
        return new EqualityTestCase("Float", VarcharTest.roundString(bigDecimal.toString(), 20), bigDecimal);
    }

    protected static EqualityTestCase floatFetchTestCase(String string) {
        EqualityTestCase equalityTestCase;
        Float f = null;
        try {
            f = new Float(string);
            equalityTestCase = new EqualityTestCase("Float", string, f);
        }
        catch (NumberFormatException numberFormatException) {
            equalityTestCase = new EqualityTestCase("Float", string, null);
            equalityTestCase.setFetchException(ConversionExceptionClass);
        }
        return equalityTestCase;
    }

    protected static EqualityTestCase intFetchTestCase(long l) {
        BigDecimal bigDecimal = new BigDecimal((double)l);
        return new EqualityTestCase("Int", bigDecimal.toString(), bigDecimal);
    }

    protected static EqualityTestCase intFetchTestCase(String string) {
        EqualityTestCase equalityTestCase;
        Integer n = null;
        try {
            n = new Integer(string);
            equalityTestCase = new EqualityTestCase("Int", string, n);
        }
        catch (NumberFormatException numberFormatException) {
            equalityTestCase = new EqualityTestCase("Int", string, null);
            equalityTestCase.setFetchException(ConversionExceptionClass);
        }
        return equalityTestCase;
    }

    protected static EqualityTestCase longFetchTestCase(long l) {
        BigDecimal bigDecimal = new BigDecimal((double)l);
        return new EqualityTestCase("Long", bigDecimal.toString(), bigDecimal);
    }

    protected static EqualityTestCase longFetchTestCase(String string) {
        EqualityTestCase equalityTestCase;
        Long l = null;
        try {
            l = new Long(string);
            equalityTestCase = new EqualityTestCase("Long", string, l);
        }
        catch (NumberFormatException numberFormatException) {
            equalityTestCase = new EqualityTestCase("Long", string, null);
            equalityTestCase.setFetchException(ConversionExceptionClass);
        }
        return equalityTestCase;
    }

    protected static EqualityTestCase shortFetchTestCase(long l) {
        BigDecimal bigDecimal = new BigDecimal((double)l);
        return new EqualityTestCase("Short", bigDecimal.toString(), bigDecimal);
    }

    protected static EqualityTestCase shortFetchTestCase(String string) {
        EqualityTestCase equalityTestCase;
        Short s = null;
        try {
            s = new Short(string);
            equalityTestCase = new EqualityTestCase("Short", string, s);
        }
        catch (NumberFormatException numberFormatException) {
            equalityTestCase = new EqualityTestCase("Short", string, null);
            equalityTestCase.setFetchException(ConversionExceptionClass);
        }
        return equalityTestCase;
    }

    protected static String roundString(String string, int n) {
        return ObjectServices.substring(string, 0, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        VarcharTest varcharTest = new VarcharTest(stringArray);
        try {
            varcharTest.runInner();
        }
        finally {
            varcharTest.connection.close();
        }
        if (varcharTest.log.hasErrors()) {
            System.exit(5);
        }
    }
}

