/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ProcedureLongTest
extends Test {
    private static final String help = "Test for LONG parameters of DB Procedures";
    private static final OptionDesc[] optdesc = new OptionDesc[0];
    private String tableName = "";

    public ProcedureLongTest(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public ProcedureLongTest(Test test) throws SQLException {
        super(test);
    }

    void execSQL(String string) {
        try {
            this.stmt.execute(string);
        }
        catch (SQLException sQLException) {
            this.log.addInfo("Ignored: " + sQLException.getMessage());
        }
    }

    protected void testRun() throws SQLException {
        if (!this.checkVersion("7.6.0")) {
            return;
        }
        this.tableName = this.getUnicodeIdentifier("LTEST1_INSERT");
        String string = this.getUsername();
        this.testRunInsert(string);
        this.testRunSelect(string);
    }

    protected void testRunInsert(String string) throws SQLException {
        this.execSQL("DROP DBPROC " + this.tableName);
        this.dropTable("LTEST1");
        this.execSQL("CREATE TABLE " + this.tableName + " (A INTEGER, B LONG ASCII)");
        this.execSQL("CREATE DBPROC " + this.tableName + " (IN A INT, IN B LONG ASCII) " + "AS INSERT INTO " + string + "." + this.tableName + "  VALUES(:A, :B);");
        CallableStatement callableStatement = this.connection.prepareCall("CALL " + this.tableName + " (?,?)");
        callableStatement.setInt(1, 1);
        callableStatement.setString(2, "A short LONG value");
        callableStatement.execute();
        callableStatement.setInt(1, 2);
        String string2 = this.makeLongString("Test ", 20000);
        callableStatement.setString(2, string2);
        callableStatement.execute();
        Statement statement = this.connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT B FROM " + this.tableName + "  ORDER BY A");
        if (resultSet == null || !resultSet.next()) {
            this.log.addFailure(new Failure("ProcedureLong", "Nothing was inserted in LTEST1_INSERT"));
        } else if (!resultSet.getString(1).equals("A short LONG value")) {
            this.log.addFailure(new Failure("ProcedureLong", "Found wrong value:" + resultSet.getString(1)));
        } else if (!resultSet.next()) {
            this.log.addFailure(new Failure("ProcedureLong", "No 2nd value"));
        } else if (!resultSet.getString(1).equals(string2)) {
            this.log.addFailure(new Failure("ProcedureLong", "2nd value did not match."));
        }
    }

    protected void testRunSelect(String string) throws SQLException {
        this.dropTable(this.tableName);
        this.execSQL("CREATE TABLE " + this.tableName + " (A INTEGER, B LONG ASCII, PRIMARY KEY(A))");
        PreparedStatement preparedStatement = this.prepare("INSERT INTO " + this.tableName + "  VALUES(?, ?)");
        preparedStatement.setInt(1, 1);
        preparedStatement.setString(2, "MaxDB is great.");
        preparedStatement.execute();
        preparedStatement.setInt(1, 2);
        preparedStatement.setString(2, this.makeLongString("TEST ", 20000));
        preparedStatement.execute();
        preparedStatement.setInt(1, 3);
        preparedStatement.setNull(2, 1);
        preparedStatement.execute();
        this.execSQL("DROP DBPROC " + this.tableName + " ");
        this.execSQL("CREATE DBPROC " + this.tableName + " (IN K INTEGER, OUT V LONG ASCII) " + "AS SELECT B INTO :V FROM " + string + "." + this.tableName + "  WHERE A = :K;");
        CallableStatement callableStatement = this.connection.prepareCall("CALL " + this.tableName + " (?, ?)");
        callableStatement.setInt(1, 1);
        callableStatement.execute();
        if (!callableStatement.getString(2).equals("MaxDB is great.")) {
            this.log.addFailure(new Failure("Did not found inserted short LONG value."));
        }
        callableStatement.setInt(1, 3);
        callableStatement.execute();
        String string2 = callableStatement.getString(2);
        if (!callableStatement.wasNull()) {
            this.log.addFailure(new Failure("Did not found NULL value."));
        }
        if (string2 != null) {
            this.log.addFailure(new Failure("Retrieved value is not NULL"));
        }
        callableStatement.setInt(1, 2);
        callableStatement.execute();
        string2 = callableStatement.getString(2);
        if (!this.makeLongString("TEST ", 20000).equals(string2)) {
            this.log.addFailure(new Failure("LONG text not found."));
        }
    }

    private String makeLongString(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        ProcedureLongTest procedureLongTest = new ProcedureLongTest(stringArray);
        try {
            procedureLongTest.runInner();
        }
        finally {
            procedureLongTest.connection.close();
        }
        if (procedureLongTest.log.hasErrors()) {
            System.exit(5);
        }
    }
}

