/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import com.sap.dbtechtest.xlog.LogWriter;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class LongsShouldNotLoop
extends Test {
    private static final String help = "help for LongsShouldNotLoop";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public LongsShouldNotLoop(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public LongsShouldNotLoop(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        int n;
        String string = "LongsShouldNotLoop";
        String string2 = this.getUnicodeIdentifier(string);
        if (!this.checkVersion("7.5.0")) {
            return;
        }
        Connection connection = this.connect();
        Connection connection2 = this.connect();
        int n2 = 0;
        try {
            n2 = this.getDBParameterAsInt("PACKET_SIZE") + 1;
        }
        catch (SQLException sQLException) {
            n2 = this.getDBParameterAsInt("_PACKET_SIZE") + 1;
        }
        int n3 = 2 * n2;
        int n4 = n2 - 8000;
        connection.setAutoCommit(false);
        connection2.setAutoCommit(false);
        Statement statement = connection.createStatement();
        try {
            statement.execute("drop table " + string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        statement.execute("create table " + string2 + " ( i int key , l1 long ascii)");
        connection.commit();
        PreparedStatement preparedStatement = connection.prepareStatement("Insert into  " + string2 + " values (?,?)");
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < n3; ++n) {
            stringBuffer.append('x');
        }
        preparedStatement.setInt(1, 1);
        preparedStatement.setString(2, stringBuffer.toString());
        preparedStatement.executeUpdate();
        stringBuffer = new StringBuffer();
        for (n = 0; n < n4; ++n) {
            stringBuffer.append('y');
        }
        preparedStatement.setInt(1, 2);
        preparedStatement.setString(2, stringBuffer.toString());
        preparedStatement.executeUpdate();
        connection.commit();
        ResultSet resultSet = statement.executeQuery("select l1 from  " + string2 + " where i = 1");
        resultSet.next();
        Clob clob = resultSet.getClob(1);
        try {
            int n5;
            int n6;
            InputStream inputStream = clob.getAsciiStream();
            byte[] byArray = new byte[32768];
            int n7 = inputStream.read(byArray);
            Statement statement2 = connection2.createStatement();
            DeleteThread deleteThread = new DeleteThread(statement2, this.log, string2);
            deleteThread.start();
            try {
                Thread.sleep(1500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            connection.commit();
            int n8 = 0;
            do {
                for (int i = 0; i < byArray.length; ++i) {
                    if (byArray[i] != 120) {
                        this.log.addFailure(new Failure(string, "wrong content in long at position " + i));
                        ++n8;
                    }
                    if (n8 <= 10) continue;
                    this.log.addFailure(new Failure(string, "more than 10 errors detected - break the test "));
                    break;
                }
                if ((n6 = inputStream.read(byArray)) < 0) continue;
                n7 += n6;
            } while (n6 != -1);
            this.log.addDifference(string, "Check size of retrieved long value", new Integer(n3), new Integer(n7));
            resultSet = statement.executeQuery("select l1 from  " + string2 + " where i = 2");
            resultSet.next();
            String string3 = resultSet.getString(1);
            n8 = 0;
            for (n5 = 0; n5 < string3.length(); ++n5) {
                if (string3.charAt(n5) != 'y') {
                    this.log.addFailure(new Failure(string, "wrong content in long at position " + n5));
                    ++n8;
                }
                if (n8 <= 10) continue;
                this.log.addFailure(new Failure(string, "more than 10 errors detected - break the test "));
                break;
            }
            this.log.addDifference(string, "check long size", new Integer(n4), new Integer(n5));
            ResultSet resultSet2 = statement.executeQuery("select TABLENAME  from locks where process = (select Taskid  from sessions where own='YES')");
            this.log.addDifference(string, "Check if locks remain", Boolean.FALSE, new Boolean(resultSet2.next()));
        }
        catch (IOException iOException) {
            this.log.addFailure(new Failure(iOException.toString()));
        }
        connection.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        LongsShouldNotLoop longsShouldNotLoop = new LongsShouldNotLoop(stringArray);
        try {
            longsShouldNotLoop.runInner();
        }
        finally {
            longsShouldNotLoop.connection.close();
        }
        if (longsShouldNotLoop.log.hasErrors()) {
            System.exit(5);
        }
    }

    public class DeleteThread
    extends Thread {
        private Statement stmt = null;
        private LogWriter log = null;
        private String tablename = "";

        public DeleteThread(Statement statement, LogWriter logWriter, String string) {
            this.stmt = statement;
            this.log = logWriter;
            this.tablename = string;
        }

        public void run() {
            try {
                this.log.addInfo("before delete " + this.tablename);
                this.stmt.execute("delete " + this.tablename + " where i = 1");
                this.log.addInfo("after delete " + this.tablename);
                this.stmt.getConnection().commit();
                this.log.addInfo("C2 is commited");
            }
            catch (SQLException sQLException) {
                this.log.addFailure(new Failure(sQLException.toString()));
            }
        }
    }
}

