/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class LongsInDBProceduresStreamTest
extends Test {
    private static final String help = "help for LongsInDBProceduresStreamTest";
    private static final OptionDesc[] optdesc = new OptionDesc[0];
    private String tableName = "";
    private String tableName1 = "";

    public LongsInDBProceduresStreamTest(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public LongsInDBProceduresStreamTest(Test test) throws SQLException {
        super(test);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        LongsInDBProceduresStreamTest longsInDBProceduresStreamTest = new LongsInDBProceduresStreamTest(stringArray);
        try {
            longsInDBProceduresStreamTest.runInner();
        }
        finally {
            longsInDBProceduresStreamTest.connection.close();
        }
        if (longsInDBProceduresStreamTest.log.hasErrors()) {
            System.exit(5);
        }
    }

    public void testRun() throws SQLException {
        if (!this.checkVersion("7.6.0")) {
            return;
        }
        String string = "LongsInDBProcedures";
        this.tableName = this.getUnicodeIdentifier(string);
        this.tableName1 = this.getUnicodeIdentifier("TAB2");
        this.dropTable(this.tableName);
        this.stmt.execute("CREATE TABLE " + this.tableName + " ( i int PRIMARY KEY, l1 long, l2 long )");
        this.dropTable(this.tableName1);
        this.stmt.execute("CREATE TABLE " + this.tableName1 + " ( i int PRIMARY KEY, l1 long, l2 long)");
        try {
            this.stmt.execute("drop DBPROC " + this.tableName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.stmt.execute("drop DBPROC " + this.tableName1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stmt.execute("create DBPROC " + this.tableName + " ( IN i int, IN l1 LONG, IN l2 LONG) AS" + "\tVAR ix2 INTEGER;\t" + "   TRY" + " insert into " + this.getUsername() + "." + this.tableName + " set \ti = :i," + "\t\t\tl1 = :l1," + "\t\t\tl2 = :l2;" + "\tSET ix2 = i * 2;" + "\tinsert into " + this.getUsername() + "." + this.tableName1 + " set\ti = :ix2," + "\t\t\tl1 = :l1," + "\t\t\tl2 = :l2;" + "   CATCH STOP ($rc, $errmsg);");
        this.stmt.execute("create DBPROC " + this.tableName1 + " ( IN i int, IN l1 LONG, IN l2 LONG) AS" + "\tVAR ix2 INTEGER;\t" + "   SET ix2 = 100;" + "   WHILE ix2 > 0 DO BEGIN" + "   SET ix2 = ix2 -1;" + "   TRY" + "   Delete from " + this.getUsername() + "." + this.tableName + "; " + "   CATCH IF $rc <> 100 THEN STOP  ($rc, $errmsg);" + "   TRY" + "   Delete from " + this.getUsername() + "." + this.tableName1 + ";" + "   CATCH IF $rc <> 100 THEN STOP  ($rc, $errmsg);" + "   TRY" + "\tCALL " + this.tableName + " (:i, :l1, :l2);" + "   CATCH STOP ($rc, $errmsg);" + "   END;");
        CallableStatement callableStatement = this.connection.prepareCall("CALL " + this.tableName + " ( ?, ?, ?)");
        String string2 = this.makeRandomString(2);
        String string3 = this.makeRandomString(2);
        int n = 1;
        callableStatement.setInt(1, n);
        callableStatement.setString(2, string2);
        callableStatement.setString(3, string3);
        callableStatement.execute();
        this.checkResult(string, n, string2, string3);
        this.stmt.execute("Delete from " + this.tableName);
        this.stmt.execute("Delete from " + this.tableName1);
        CallableStatement callableStatement2 = this.connection.prepareCall("CALL " + this.tableName1 + " ( ?, ?, ?)");
        callableStatement2.setInt(1, n);
        callableStatement2.setString(2, string2);
        callableStatement2.setString(3, string3);
        callableStatement2.execute();
        this.checkResult(string, n, string2, string3);
        this.stmt.execute("Delete from " + this.tableName);
        this.stmt.execute("Delete from " + this.tableName1);
        this.connection.commit();
        if (this.environment.hasFeature("UnicodeDB") || this.environment.hasFeature("UnicodeDBwithAsciiCode")) {
            return;
        }
        callableStatement.setInt(1, n);
        callableStatement.setAsciiStream(2, (InputStream)new ByteArrayInputStream(string2.getBytes()), -1);
        callableStatement.setAsciiStream(3, (InputStream)new ByteArrayInputStream(string3.getBytes()), -1);
        callableStatement.execute();
        this.checkResult(string, n, string2, string3);
    }

    private void checkResult(String string, int n, String string2, String string3) throws SQLException {
        ResultSet resultSet = this.stmt.executeQuery("SELECT * from " + this.tableName);
        this.log.addDifference(string, "fetch next", Boolean.TRUE, new Boolean(resultSet.next()));
        this.log.addDifference(string, "check column 1", new Integer(n), new Integer(resultSet.getInt(1)));
        this.log.addDifference(string, "check column 2", string2, resultSet.getString(2));
        this.log.addDifference(string, "check column 3", string3, resultSet.getString(3));
        resultSet = this.stmt.executeQuery("SELECT * from " + this.tableName1);
        this.log.addDifference(string, "fetch next", Boolean.TRUE, new Boolean(resultSet.next()));
        this.log.addDifference(string, "check column 1", new Integer(n * 2), new Integer(resultSet.getInt(1)));
        this.log.addDifference(string, "check column 2", string2, resultSet.getString(2));
        this.log.addDifference(string, "check column 3", string3, resultSet.getString(3));
        resultSet.close();
    }
}

