/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class IllegalFloatTest
extends Test {
    private static final String help = "Tests not-a-number values.";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public IllegalFloatTest(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public IllegalFloatTest(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = this.getUnicodeIdentifier("TEST_NANVALUES_D");
        String string2 = this.getUnicodeIdentifier("TEST_NANVALUES_C");
        this.dropTable(string);
        this.dropTable(string2);
        this.stmt.execute("CREATE TABLE " + string + " (A FLOAT(38))");
        this.stmt.execute("CREATE TABLE " + string2 + " (A VARCHAR(200))");
        PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT INTO " + string + " VALUES(?)");
        PreparedStatement preparedStatement2 = this.connection.prepareStatement("INSERT INTO " + string2 + " VALUES(?)");
        try {
            preparedStatement.setDouble(1, Double.NaN);
            this.log.addFailure(new Failure("NaN", "SQLException should be raised."));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            preparedStatement.setDouble(1, Double.NEGATIVE_INFINITY);
            this.log.addFailure(new Failure("-INF", "SQLException should be raised."));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            preparedStatement.setDouble(1, Double.POSITIVE_INFINITY);
            this.log.addFailure(new Failure("+INF", "SQLException should be raised."));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            preparedStatement2.setDouble(1, Double.NaN);
            this.log.addFailure(new Failure("NaN", "SQLException should be raised."));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            preparedStatement2.setDouble(1, Double.NEGATIVE_INFINITY);
            this.log.addFailure(new Failure("-INF", "SQLException should be raised."));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            preparedStatement2.setDouble(1, Double.POSITIVE_INFINITY);
            this.log.addFailure(new Failure("+INF", "SQLException should be raised."));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        IllegalFloatTest illegalFloatTest = new IllegalFloatTest(stringArray);
        try {
            illegalFloatTest.runInner();
        }
        finally {
            illegalFloatTest.connection.close();
        }
        if (illegalFloatTest.log.hasErrors()) {
            System.exit(5);
        }
    }
}

