/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.TestDifference;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class FixedTest
extends Test {
    private static final String help = "Test that the big decimal scale is correctly set.";
    private static final OptionDesc[] optdesc = new OptionDesc[0];
    private String tableName = "";

    public FixedTest(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public FixedTest(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "FixedTest";
        this.tableName = this.getUnicodeIdentifier(string);
        this.dropTable(this.tableName);
        this.stmt.execute("CREATE TABLE " + this.tableName + "(V FIXED(12,2), X FLOAT)");
        this.stmt.execute("INSERT INTO " + this.tableName + " VALUES (12.45, 1E-64)");
        this.stmt.execute("INSERT INTO " + this.tableName + " VALUES (12, 1E-64)");
        this.stmt.execute("INSERT INTO " + this.tableName + " VALUES (12.1, 1E-64)");
        ResultSet resultSet = this.stmt.executeQuery("SELECT * FROM " + this.tableName);
        while (resultSet.next()) {
            BigDecimal bigDecimal = resultSet.getBigDecimal(1);
            int n = bigDecimal.scale();
            if (n != 2) {
                this.log.addFailure(new TestDifference("FIXED", "scale of big decimal", "scale 2", "scale " + n));
            }
            this.log.addDifference(string, "Check BigDecimal", new BigDecimal(1.0E-64), resultSet.getBigDecimal(2));
        }
        this.testValue();
    }

    public void testValue() throws SQLException {
        this.dropTable(this.tableName);
        this.stmt.execute("CREATE TABLE " + this.tableName + "(V FIXED(18,8))");
        PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT INTO " + this.tableName + " VALUES(?)");
        preparedStatement.setBigDecimal(1, new BigDecimal("-25.00"));
        preparedStatement.executeUpdate();
        this.connection.commit();
        PreparedStatement preparedStatement2 = this.connection.prepareStatement("SELECT * FROM " + this.tableName);
        ResultSet resultSet = preparedStatement2.executeQuery();
        while (resultSet.next()) {
            this.log.addDifference("FixedTest", "get BigDecimal", "-25.00000000", resultSet.getBigDecimal(1).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        FixedTest fixedTest = new FixedTest(stringArray);
        try {
            fixedTest.runInner();
        }
        finally {
            fixedTest.connection.close();
        }
        if (fixedTest.log.hasErrors()) {
            System.exit(5);
        }
    }
}

