/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class BinaryFromCharacterColumns
extends Test {
    private static final String help = "help for BinaryTest";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public BinaryFromCharacterColumns(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public BinaryFromCharacterColumns(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        int n;
        String string = "BinaryTest";
        String string2 = this.getUnicodeIdentifier(string);
        this.dropTable(string2);
        this.stmt.execute("CREATE TABLE \"" + string2 + "\" (a varchar(100), b long ascii, c long byte, d long)");
        ResultSet resultSet = this.connection.getMetaData().getColumns(null, null, string2, null);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        this.log.addDifference(string, "check fetch next", Boolean.TRUE, new Boolean(resultSet.next()));
        do {
            if (resultSet.getString("TYPE_NAME").indexOf("UNICODE") != -1 || resultSet.getString("TYPE_NAME").indexOf("ASCII") != -1 && this.environment.hasFeature("UnicodeDB") && this.environment.hasFeature("UnicodeConnection")) {
                arrayList.add(new Integer(1));
                continue;
            }
            arrayList.add(new Integer(0));
        } while (resultSet.next());
        String string3 = this.makeRandomString(10);
        PreparedStatement preparedStatement = this.connection.prepareStatement("Insert into \"" + string2 + "\" values (?,?,?,?)");
        preparedStatement.setString(1, string3);
        preparedStatement.setString(2, string3);
        preparedStatement.setBytes(3, string3.getBytes());
        preparedStatement.setString(4, string3);
        preparedStatement.executeUpdate();
        ResultSet resultSet2 = this.stmt.executeQuery("select * from \"" + string2 + "\"");
        this.log.addDifference(string, "check fetch next", Boolean.TRUE, new Boolean(resultSet2.next()));
        for (n = 1; n <= resultSet2.getMetaData().getColumnCount(); ++n) {
        }
        for (n = 1; n <= resultSet2.getMetaData().getColumnCount(); ++n) {
            Object object;
            Object object2 = string3.getBytes();
            if ((Integer)arrayList.get(n - 1) != 0) {
                object = new byte[string3.length() * 2];
                for (int i = 0; i < string3.length(); ++i) {
                    object[2 * i + 1] = string3.getBytes()[i];
                }
                object2 = object;
            }
            if (resultSet2.getMetaData().getColumnType(n) == 12) {
                this.log.addDifference(string, "column " + n + " (" + resultSet2.getMetaData().getColumnName(n) + ") check content", object2, resultSet2.getBytes(n));
                continue;
            }
            object = resultSet2.getBlob(n);
            try {
                byte[] byArray = new byte[(int)object.length()];
                int n2 = object.getBinaryStream().read(byArray);
                int n3 = (int)object.length();
                this.log.addDifference(string, "column " + n + " (" + resultSet2.getMetaData().getColumnName(n) + ") check row size", new Integer(n3), new Integer(n2));
                this.log.addDifference(string, "column " + n + " (" + resultSet2.getMetaData().getColumnName(n) + ") check content", object2, byArray);
                continue;
            }
            catch (IOException iOException) {
                this.log.addFailure(new Failure(string, iOException.toString()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        BinaryFromCharacterColumns binaryFromCharacterColumns = new BinaryFromCharacterColumns(stringArray);
        try {
            binaryFromCharacterColumns.runInner();
        }
        finally {
            binaryFromCharacterColumns.connection.close();
        }
        if (binaryFromCharacterColumns.log.hasErrors()) {
            System.exit(5);
        }
    }
}

