/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.statement;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import com.sap.dbtechtest.xlog.Info;
import com.sap.dbtechtest.xlog.LogWriter;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class CancelInternal
extends Test {
    private static final String help = "help for CancelInternal";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public CancelInternal(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public CancelInternal(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "CancelInternal";
        String string2 = this.getUnicodeIdentifier(string);
        this.dropTable(string2);
        this.stmt.execute("CREATE TABLE " + string2 + " (a long byte, b long byte)");
        PreparedStatement preparedStatement = this.connection.prepareStatement("Insert into " + string2 + " values (?,?)");
        preparedStatement.setBytes(1, this.makeRandomString(100).getBytes());
        preparedStatement.setBytes(2, null);
        preparedStatement.execute();
        this.connection.commit();
        InternalThread internalThread = new InternalThread(preparedStatement, this.log);
        internalThread.start();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        preparedStatement.cancel();
        internalThread.unlock();
        try {
            Thread.sleep(3000L);
            internalThread.interrupt();
            internalThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.connection.rollback();
        if (!this.checkVersion("7.6.0")) {
            return;
        }
        Statement statement = this.connection.createStatement(1005, 1008);
        ResultSet resultSet = statement.executeQuery("Select * from " + string2);
        resultSet.next();
        InternalThread2 internalThread2 = new InternalThread2(resultSet, this.log);
        internalThread2.start();
        this.log.addInfo(new Info("Thread Main", "InternalThread2 started"));
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.log.addInfo(new Info("Thread Main", "try cancel SelectForUpdate-Statement"));
        statement.cancel();
        this.log.addInfo(new Info("Thread Main", "finish cancel SelectForUpdate-Statement"));
        this.vtraceFlush();
        internalThread2.unlock();
        this.log.addInfo(new Info("Thread Main", "InternalThread2 Stream unlocked"));
        try {
            Thread.sleep(5000L);
            internalThread2.interrupt();
            this.log.addInfo(new Info("Thread Main", "InternalThread2 interrupted"));
            internalThread2.join();
            this.log.addInfo(new Info("Thread Main", "InternalThread2 joined"));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.log.addInfo(new Info("Thread Main", "Connection rollback"));
        this.connection.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        CancelInternal cancelInternal = new CancelInternal(stringArray);
        try {
            cancelInternal.runInner();
        }
        finally {
            cancelInternal.connection.close();
        }
        if (cancelInternal.log.hasErrors()) {
            System.exit(5);
        }
    }

    class InternalThread2
    extends Thread {
        LogWriter log;
        BlockingInputStream stream;
        ResultSet rs;

        InternalThread2(ResultSet resultSet, LogWriter logWriter) {
            this.log = logWriter;
            this.stream = new BlockingInputStream(20000000, this.log);
            this.rs = resultSet;
        }

        public void unlock() {
            this.stream.continueRead();
        }

        public void run() {
            try {
                this.rs.updateBinaryStream(1, (InputStream)this.stream, -1);
                this.log.addInfo(new Info("InternalThread2", "start UpdateRow"));
                this.rs.updateRow();
                this.log.addInfo(new Info("InternalThread2", "finished UpdateRow"));
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == -102) {
                    this.log.addInfo("InternalThread2", "Expected cancel exception occured.");
                }
                this.log.addFailure(new Failure("InternalThread2", sQLException.toString()));
            }
        }
    }

    class InternalThread
    extends Thread {
        BlockingInputStream stream;
        PreparedStatement ps;
        LogWriter log;

        InternalThread(PreparedStatement preparedStatement, LogWriter logWriter) {
            this.log = logWriter;
            this.stream = new BlockingInputStream(20000000, this.log);
            this.ps = preparedStatement;
        }

        public void unlock() {
            this.stream.continueRead();
        }

        public void run() {
            try {
                this.ps.setBinaryStream(1, (InputStream)this.stream, -1);
                this.ps.setBytes(2, "Homer".getBytes());
                this.ps.execute();
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == -102) {
                    this.log.addInfo("InternalThread", "Expected cancel exception occured.");
                }
                this.log.addFailure(new Failure("InternalThread", sQLException.toString()));
            }
        }
    }

    class BlockingInputStream
    extends InputStream {
        byte[] arr = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        int pos = 0;
        int size = 0;
        boolean contRead = false;
        LogWriter log;

        BlockingInputStream(int n, LogWriter logWriter) {
            this.size = n;
            this.log = logWriter;
        }

        void continueRead() {
            this.contRead = true;
        }

        public int read() throws IOException {
            if (this.pos >= this.size) {
                return -1;
            }
            if (this.pos == 150000) {
                this.log.addInfo("BlockingInputStream", "Stream is blockking ...");
                while (!this.contRead) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        this.log.addFailure(new Failure("BlockingInputStream", interruptedException.toString()));
                        System.out.println(interruptedException.toString());
                        return -1;
                    }
                }
            }
            byte by = this.arr[this.pos % 10];
            ++this.pos;
            return by;
        }
    }
}

