/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.resultset;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ResultSetMetaData
extends Test {
    private static final String help = "help for ResultSetMetaData";
    private static final OptionDesc[] optdesc = new OptionDesc[0];
    private String tableName = "";

    public ResultSetMetaData(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public ResultSetMetaData(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string;
        short[] sArray;
        String[] stringArray;
        String string2 = "ResultSetMetaData";
        this.tableName = this.getUnicodeIdentifier(string2);
        this.dropTable(this.tableName);
        this.connection.commit();
        String string3 = "";
        if (this.isSQLModeOracle()) {
            if (this.environment.hasFeature("UnicodeDBwithAsciiCode")) {
                stringArray = new String[]{"CHAR ASCII", "CHAR BYTE", "VARCHAR ASCII", "VARCHAR BYTE", "INTEGER", "SMALLINT", "FLOAT", "FIXED", "BOOLEAN", "DATE", "TIME", "TIMESTAMP", "LONG ASCII", "LONG BYTE"};
                sArray = new short[]{1, -2, 12, -3, 4, 5, 6, 3, -7, 91, 92, 93, -1, -4};
                string = "CREATE TABLE " + this.tableName + " (C_CHARASCII    Char (1) ASCII," + "    C_CHARBYTE     Char (1) BYTE," + "    C_VARCHARASCII Varchar (1) ASCII," + "    C_VARCHARBYTE  Varchar (1) BYTE," + "    C_INT          Integer," + "    C_SMALINT      Smallint," + "    C_FLOAT        Float (5)," + "    C_FIXED        Fixed (5)," + "    C_BOOLEAN      Boolean," + "    C_DATE         Date," + "    C_TIME         Time," + "    C_TIMESTAMP    Timestamp," + "    C_LONGASCII    Long ASCII," + "    C_LONGBYTE     Long BYTE" + ")";
            } else {
                stringArray = new String[]{"CHAR ASCII", "CHAR BYTE", "VARCHAR ASCII", "VARCHAR BYTE", "INTEGER", "SMALLINT", "FLOAT", "FIXED", "BOOLEAN", "DATE", "TIME", "TIMESTAMP", "LONG ASCII", "LONG BYTE"};
                sArray = new short[]{1, -2, 12, -3, 4, 5, 6, 3, -7, 91, 92, 93, -1, -4};
                string = "CREATE TABLE " + this.tableName + " (C_CHARASCII    Char (1) ASCII," + "    C_CHARBYTE     Char (1) BYTE," + "    C_VARCHARASCII Varchar (1) ASCII," + "    C_VARCHARBYTE  Varchar (1) BYTE," + "    C_INT          Integer," + "    C_SMALINT      Smallint," + "    C_FLOAT        Float (5)," + "    C_FIXED        Fixed (5)," + "    C_BOOLEAN      Boolean," + "    C_DATE         Date," + "    C_TIME         Time," + "    C_TIMESTAMP    Timestamp," + "    C_LONGASCII    Long ASCII," + "    C_LONGBYTE     Long BYTE" + ")";
            }
        } else if (this.environment.hasFeature("UnicodeDBwithAsciiCode")) {
            stringArray = new String[]{"CHAR ASCII", "CHAR BYTE", "CHAR UNICODE", "VARCHAR ASCII", "VARCHAR BYTE", "VARCHAR UNICODE", "INTEGER", "SMALLINT", "FLOAT", "FIXED", "BOOLEAN", "DATE", "TIME", "TIMESTAMP", "LONG ASCII", "LONG BYTE", "LONG UNICODE"};
            sArray = new short[]{1, -2, 1, 12, -3, 12, 4, 5, 6, 3, -7, 91, 92, 93, -1, -4, -1};
            string = "CREATE TABLE " + this.tableName + " (C_CHARASCII    Char (1) ASCII," + "    C_CHARBYTE     Char (1) BYTE," + "    C_CHARUNICODE  Char (1) UNICODE," + "    C_VARCHARASCII Varchar (1) ASCII," + "    C_VARCHARBYTE  Varchar (1) BYTE," + "    C_VARCHARUNICODE Varchar (1) UNICODE," + "    C_INT          Integer," + "    C_SMALINT      Smallint," + "    C_FLOAT        Float (5)," + "    C_FIXED        Fixed (5)," + "    C_BOOLEAN      Boolean," + "    C_DATE         Date," + "    C_TIME         Time," + "    C_TIMESTAMP    Timestamp," + "    C_LONGASCII    Long ASCII," + "    C_LONGBYTE     Long BYTE," + "    C_LONGUNICODE  Long UNICODE" + ")";
        } else {
            stringArray = new String[]{"CHAR ASCII", "CHAR BYTE", "VARCHAR ASCII", "VARCHAR BYTE", "INTEGER", "SMALLINT", "FLOAT", "FIXED", "BOOLEAN", "DATE", "TIME", "TIMESTAMP", "LONG ASCII", "LONG BYTE"};
            sArray = new short[]{1, -2, 12, -3, 4, 5, 6, 3, -7, 91, 92, 93, -1, -4};
            string = "CREATE TABLE " + this.tableName + " (C_CHARASCII    Char (1) ASCII," + "    C_CHARBYTE     Char (1) BYTE," + "    C_VARCHARASCII Varchar (1) ASCII," + "    C_VARCHARBYTE  Varchar (1) BYTE," + "    C_INT          Integer," + "    C_SMALINT      Smallint," + "    C_FLOAT        Float (5)," + "    C_FIXED        Fixed (5)," + "    C_BOOLEAN      Boolean," + "    C_DATE         Date," + "    C_TIME         Time," + "    C_TIMESTAMP    Timestamp," + "    C_LONGASCII    Long ASCII," + "    C_LONGBYTE     Long BYTE" + ")";
        }
        this.stmt.execute(string);
        this.connection.commit();
        ResultSet resultSet = this.stmt.executeQuery("Select * from " + this.tableName);
        java.sql.ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            this.log.addDifference(string2, "Check rsmd.getColumnType()" + resultSetMetaData.getColumnName(i), new Integer(sArray[i - 1]), new Integer(resultSetMetaData.getColumnType(i)));
            this.log.addDifference(string2, "Check rsmd.getColumnTypeName(" + i + ") " + resultSetMetaData.getColumnName(i), stringArray[i - 1], resultSetMetaData.getColumnTypeName(i));
        }
    }

    void checkInternalModeUnicode(String string) throws SQLException {
        short[] sArray;
        String string2 = "";
        short[] sArray2 = new short[]{1, -2, 1, 12, -3, 12, 4, 5, 6, 3, -7, 91, 92, 93, -1, -4, -1};
        short[] sArray3 = new short[]{-7, -4, -3, -2, -1, -1, 1, 1, 3, 3, 4, 5, 6, 7, 8, 12, 12, 91, 92, 93};
        if (this.checkVersion("7.6.0")) {
            sArray3 = sArray = new short[]{-4, -3, -2, -1, -1, -1, 1, 1, 1, 3, 3, 3, 4, 5, 6, 7, 8, 12, 12, 12, 16, 91, 92, 93};
        }
        sArray = sArray3;
        short[] sArray4 = sArray2;
        this.stmt.execute("CREATE TABLE " + this.tableName + " (C_CHARASCII    Char (1) ASCII," + "    C_CHARBYTE     Char (1) BYTE," + "    C_CHARUNICODE  Char (1) UNICODE," + "    C_VARCHARASCII Varchar (1) ASCII," + "    C_VARCHARBYTE  Varchar (1) BYTE," + "    C_VARCHARUNICODE Varchar (1) UNICODE," + "    C_INT          Integer," + "    C_SMALINT      Smallint," + "    C_FLOAT        Float (5)," + "    C_FIXED        Fixed (5)," + "    C_BOOLEAN      Boolean," + "    C_DATE         Date," + "    C_TIME         Time," + "    C_TIMESTAMP    Timestamp," + "    C_LONGASCII    Long ASCII," + "    C_LONGBYTE     Long BYTE," + "    C_LONGUNICODE  Long UNICODE" + ")");
        this.connection.commit();
        ResultSet resultSet = this.connection.getMetaData().getColumns("", "", "ResultSetMetaData", "%");
        int n = 0;
        while (resultSet.next()) {
            this.log.addDifference(string, "Check SQLTypes Mapping getColumns" + resultSet.getString("COLUMN_NAME"), new Short(sArray4[n]), new Short(resultSet.getShort("DATA_TYPE")));
            ++n;
        }
        resultSet = this.connection.getMetaData().getTypeInfo();
        n = 0;
        while (resultSet.next()) {
            this.log.addDifference(string, "Check SQLTypes Mapping getTypeInfo" + resultSet.getString("TYPE_NAME"), new Short(sArray[n]), new Short(resultSet.getShort("DATA_TYPE")));
            ++n;
        }
        this.connection.commit();
        ResultSet resultSet2 = this.connection.getMetaData().getCatalogs();
        while (resultSet2.next()) {
            this.log.addDifference(string, "Check Catalog Name", "", resultSet2.getString(1));
        }
    }

    void checkOracleMode(String string) throws SQLException {
        short[] sArray = new short[]{1, -2, 12, -3, 2, 2, 6, 91, -1, -4};
        short[] sArray2 = new short[]{-4, -3, -2, -1, 1, 3, 4, 5, 6, 7, 8, 12, 91};
        this.stmt.execute("CREATE TABLE " + this.tableName + "   (C_CHARASCII    Char (1) ASCII," + "    C_CHARBYTE     Char (1) BYTE," + "    C_VARCHARASCII Varchar (1) ASCII," + "    C_VARCHARBYTE  Varchar (1) BYTE," + "    C_INT          Integer," + "    C_SMALINT      Smallint," + "    C_FLOAT        Float (5)," + "    C_DATE         Date," + "    C_LONGASCII    Long ASCII," + "    C_LONGBYTE     Long BYTE" + ")");
        this.connection.commit();
        ResultSet resultSet = this.connection.getMetaData().getColumns("", "", this.tableName, "%");
        int n = 0;
        while (resultSet.next()) {
            this.log.addDifference(string, "Check SQLTypes Mapping getColumns" + resultSet.getString("COLUMN_NAME"), new Short(sArray[n]), new Short(resultSet.getShort("DATA_TYPE")));
            ++n;
        }
        resultSet = this.connection.getMetaData().getTypeInfo();
        n = 0;
        while (resultSet.next()) {
            this.log.addDifference(string, "Check SQLTypes Mapping getTypeInfo" + resultSet.getString("TYPE_NAME"), new Short(sArray2[n]), new Short(resultSet.getShort("DATA_TYPE")));
            ++n;
        }
        this.connection.commit();
    }

    void checkOracleModeUnicode(String string) throws SQLException {
        short[] sArray = new short[]{1, -2, 1, 12, -3, 12, 2, 2, 6, 91, -1, -4, -1};
        short[] sArray2 = new short[]{-4, -3, -2, -1, -1, 1, 1, 3, 4, 5, 6, 7, 8, 12, 12, 91};
        this.stmt.execute("CREATE TABLE " + this.tableName + "   (C_CHARASCII    Char (1) ASCII," + "    C_CHARBYTE     Char (1) BYTE," + "    C_CHARUNICODE  Char (1) UNICODE," + "    C_VARCHARASCII Varchar (1) ASCII," + "    C_VARCHARBYTE  Varchar (1) BYTE," + "    C_VARCHAUNICODE Varchar (1) UNICODE," + "    C_INT          Integer," + "    C_SMALINT      Smallint," + "    C_FLOAT        Float (5)," + "    C_DATE         Date," + "    C_LONGASCII    Long ASCII," + "    C_LONGBYTE     Long BYTE," + "    C_LONGUNICODE  Long UNICODE" + ")");
        this.connection.commit();
        ResultSet resultSet = this.connection.getMetaData().getColumns("", "", this.tableName, "%");
        int n = 0;
        while (resultSet.next()) {
            this.log.addDifference(string, "Check SQLTypes Mapping getColumns" + resultSet.getString("COLUMN_NAME"), new Short(sArray[n]), new Short(resultSet.getShort("DATA_TYPE")));
            ++n;
        }
        resultSet = this.connection.getMetaData().getTypeInfo();
        n = 0;
        while (resultSet.next()) {
            this.log.addDifference(string, "Check SQLTypes Mapping getTypeInfo" + resultSet.getString("TYPE_NAME"), new Short(sArray2[n]), new Short(resultSet.getShort("DATA_TYPE")));
            ++n;
        }
        this.connection.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        ResultSetMetaData resultSetMetaData = new ResultSetMetaData(stringArray);
        try {
            resultSetMetaData.runInner();
        }
        finally {
            resultSetMetaData.connection.close();
        }
        if (resultSetMetaData.log.hasErrors()) {
            System.exit(5);
        }
    }
}

