/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.resultset;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class CloseCursorsAtCommit
extends Test {
    private static final String help = "help for CloseCursorsAtCommit";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public CloseCursorsAtCommit(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public CloseCursorsAtCommit(Test test) throws SQLException {
        super(test);
    }

    public int getNumberOfOpenResultsets() throws SQLException {
        ResultSet resultSet = this.stmt.executeQuery("SELECT count(*) FROM domain.tables WHERE tabletype = 'RESULT'");
        resultSet.next();
        int n = resultSet.getInt(1);
        resultSet.close();
        return n;
    }

    public void testRun() throws SQLException {
        Statement statement;
        int n;
        String string = "CloseCursorsAtCommit";
        int n2 = 10;
        ResultSet[] resultSetArray = new ResultSet[n2];
        ResultSet[] resultSetArray2 = new ResultSet[n2];
        ResultSet[] resultSetArray3 = new ResultSet[n2];
        ResultSet[] resultSetArray4 = new ResultSet[n2];
        int n3 = this.getNumberOfOpenResultsets();
        this.log.addDifference(string, "check default Holdability", new Integer(this.connection.getMetaData().getResultSetHoldability()), new Integer(this.connection.getHoldability()));
        for (n = 0; n < resultSetArray3.length; ++n) {
            statement = this.connection.prepareStatement("Select * from dual");
            statement.setCursorName("DEF_HOC_" + String.valueOf(n));
            resultSetArray3[n] = statement.executeQuery();
        }
        this.connection.setHoldability(2);
        for (n = 0; n < resultSetArray4.length; ++n) {
            statement = this.connection.prepareStatement("Select * from dual");
            statement.setCursorName("MAN_CAC_" + String.valueOf(n));
            resultSetArray4[n] = statement.executeQuery();
        }
        this.connection.setHoldability(this.connection.getMetaData().getResultSetHoldability());
        for (n = 0; n < resultSetArray2.length; ++n) {
            statement = this.connection.createStatement(1005, 1007, 1);
            statement.setCursorName("RES_HOC_" + String.valueOf(n));
            resultSetArray2[n] = statement.executeQuery("Select * from dual");
        }
        for (n = 0; n < resultSetArray.length; ++n) {
            statement = this.connection.createStatement(1005, 1007, 2);
            statement.setCursorName("RES_CAC_" + String.valueOf(n));
            resultSetArray[n] = statement.executeQuery("Select * from dual");
        }
        this.log.addDifference(string, "check number of created resultsets", new Integer(4 * n2 + n3), new Integer(this.getNumberOfOpenResultsets()));
        this.connection.commit();
        this.log.addDifference(string, "check number of open resultsets after commit", new Integer(2 * n2 + n3), new Integer(this.getNumberOfOpenResultsets()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        CloseCursorsAtCommit closeCursorsAtCommit = new CloseCursorsAtCommit(stringArray);
        try {
            closeCursorsAtCommit.runInner();
        }
        finally {
            closeCursorsAtCommit.connection.close();
        }
        if (closeCursorsAtCommit.log.hasErrors()) {
            System.exit(5);
        }
    }
}

