/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.rest;

import com.sap.dbtechtest.jdbc.types.Reflector;
import com.sap.dbtechtest.util.ObjectServices;
import com.sap.dbtechtest.util.ValueList;
import com.sap.dbtechtest.util.options.ListOption;
import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import com.sap.dbtechtest.xlog.LogWriter;
import com.sap.dbtechtest.xlog.TestDifference;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;

public class DatabaseMetaData
extends Test {
    public static final Class StringClassC = DatabaseMetaData.loadClass("java.lang.String");
    public static final Class IntegerClassC = DatabaseMetaData.loadClass("java.lang.Integer");
    public static final Class ResultSetClassC = DatabaseMetaData.loadClass("java.sql.ResultSet");
    public static final Class ConnectionClassC = DatabaseMetaData.loadClass("java.sql.Connection");
    private static final Vector supportedMethods = new Vector();
    private static final String help = "help for DatabaseMetaData";
    private static final OptionDesc[] optdesc;
    public static TestCase[] testCases;

    protected static Class loadClass(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Class " + string + " not found");
        }
        return clazz;
    }

    public DatabaseMetaData(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public DatabaseMetaData(Test test) throws SQLException {
        super(test);
    }

    private void initTestCases() {
        boolean bl = this.checkVersion("7.6.0");
        TestCase[] testCaseArray = new TestCase[]{new TestCase("getURL", StringClassC), new TestCase("isReadOnly", Boolean.FALSE), new TestCase("getAttributes", new Object[]{null, null, null, null}, null, ResultSetClassC, null), new TestCase("allProceduresAreCallable", Boolean.FALSE), new TestCase("allTablesAreSelectable", Boolean.FALSE), new TestCase("getUserName", StringClassC), new TestCase("nullsAreSortedHigh", Boolean.TRUE), new TestCase("nullsAreSortedLow", Boolean.FALSE), new TestCase("nullsAreSortedAtStart", Boolean.FALSE), new TestCase("nullsAreSortedAtEnd", Boolean.FALSE), new TestCase("getDatabaseProductName", "SAP DB"), new TestCase("getDatabaseProductVersion", StringClassC), new TestCase("getDriverName", "SAP DB"), new TestCase("getDriverVersion", StringClassC), new TestCase("getDriverMajorVersion", new Integer(7)), new TestCase("getDriverMinorVersion", new Integer(3)), new TestCase("usesLocalFiles", Boolean.FALSE), new TestCase("usesLocalFilePerTable", Boolean.FALSE), new TestCase("supportsMixedCaseIdentifiers", Boolean.FALSE), new TestCase("storesUpperCaseIdentifiers", Boolean.TRUE), new TestCase("storesLowerCaseIdentifiers", Boolean.FALSE), new TestCase("storesMixedCaseIdentifiers", Boolean.FALSE), new TestCase("supportsMixedCaseQuotedIdentifiers", Boolean.TRUE), new TestCase("storesUpperCaseQuotedIdentifiers", Boolean.FALSE), new TestCase("storesLowerCaseQuotedIdentifiers", Boolean.FALSE), new TestCase("storesMixedCaseQuotedIdentifiers", Boolean.TRUE), new TestCase("getIdentifierQuoteString", "\""), new TestCase("getSQLKeywords", StringClassC), new TestCase("getNumericFunctions", StringClassC), new TestCase("getStringFunctions", StringClassC), new TestCase("getSystemFunctions", StringClassC), new TestCase("getTimeDateFunctions", StringClassC), new TestCase("getSearchStringEscape", "\\"), new TestCase("getExtraNameCharacters", "#@$"), new TestCase("supportsAlterTableWithAddColumn", Boolean.TRUE), new TestCase("supportsAlterTableWithDropColumn", Boolean.TRUE), new TestCase("supportsColumnAliasing", Boolean.TRUE), new TestCase("nullPlusNonNullIsNull", Boolean.TRUE), new TestCase("supportsConvert", new Object[]{null, null}, Boolean.FALSE, null, null), new TestCase("supportsConvert", Boolean.FALSE), new TestCase("supportsTableCorrelationNames", Boolean.TRUE), new TestCase("supportsDifferentTableCorrelationNames", Boolean.FALSE), new TestCase("supportsExpressionsInOrderBy", Boolean.TRUE), new TestCase("supportsOrderByUnrelated", Boolean.TRUE), new TestCase("supportsGroupBy", Boolean.TRUE), new TestCase("supportsGroupByUnrelated", Boolean.TRUE), new TestCase("supportsGroupByBeyondSelect", Boolean.FALSE), new TestCase("supportsLikeEscapeClause", Boolean.TRUE), new TestCase("supportsMultipleResultSets", Boolean.FALSE), new TestCase("supportsMultipleTransactions", Boolean.TRUE), new TestCase("supportsNonNullableColumns", Boolean.TRUE), new TestCase("supportsMinimumSQLGrammar", Boolean.TRUE), new TestCase("supportsCoreSQLGrammar", Boolean.TRUE), new TestCase("supportsExtendedSQLGrammar", Boolean.TRUE), new TestCase("supportsANSI92EntryLevelSQL", Boolean.TRUE), new TestCase("supportsANSI92IntermediateSQL", Boolean.FALSE), new TestCase("supportsANSI92FullSQL", Boolean.FALSE), new TestCase("supportsIntegrityEnhancementFacility", Boolean.TRUE), new TestCase("supportsOuterJoins", Boolean.TRUE), new TestCase("supportsFullOuterJoins", Boolean.TRUE), new TestCase("supportsLimitedOuterJoins", Boolean.TRUE), new TestCase("getSchemaTerm", "SCHEMA"), new TestCase("getProcedureTerm", "DBPROC"), new TestCase("getCatalogTerm", "DATABASE"), new TestCase("isCatalogAtStart", Boolean.FALSE), new TestCase("getCatalogSeparator", "."), new TestCase("supportsSchemasInDataManipulation", Boolean.TRUE), new TestCase("supportsSchemasInProcedureCalls", Boolean.TRUE), new TestCase("supportsSchemasInTableDefinitions", bl ? Boolean.TRUE : Boolean.FALSE), new TestCase("supportsSchemasInIndexDefinitions", Boolean.TRUE), new TestCase("supportsSchemasInPrivilegeDefinitions", Boolean.TRUE), new TestCase("supportsCatalogsInDataManipulation", Boolean.FALSE), new TestCase("supportsCatalogsInProcedureCalls", Boolean.FALSE), new TestCase("supportsCatalogsInTableDefinitions", Boolean.FALSE), new TestCase("supportsCatalogsInIndexDefinitions", Boolean.FALSE), new TestCase("supportsCatalogsInPrivilegeDefinitions", Boolean.FALSE), new TestCase("supportsPositionedDelete", Boolean.TRUE), new TestCase("supportsPositionedUpdate", Boolean.TRUE), new TestCase("supportsSelectForUpdate", Boolean.TRUE), new TestCase("supportsStoredProcedures", Boolean.TRUE), new TestCase("supportsSubqueriesInComparisons", Boolean.TRUE), new TestCase("supportsSubqueriesInExists", Boolean.TRUE), new TestCase("supportsSubqueriesInIns", Boolean.TRUE), new TestCase("supportsSubqueriesInQuantifieds", Boolean.TRUE), new TestCase("supportsCorrelatedSubqueries", Boolean.TRUE), new TestCase("supportsUnion", Boolean.TRUE), new TestCase("supportsUnionAll", Boolean.TRUE), new TestCase("supportsOpenCursorsAcrossCommit", Boolean.TRUE), new TestCase("supportsOpenCursorsAcrossRollback", Boolean.TRUE), new TestCase("supportsOpenStatementsAcrossCommit", Boolean.TRUE), new TestCase("supportsOpenStatementsAcrossRollback", Boolean.TRUE), new TestCase("getMaxBinaryLiteralLength", new Integer(8000)), new TestCase("getMaxCharLiteralLength", new ValueList().add(new Integer(4000)).add(new Integer(8000))), new TestCase("getMaxColumnNameLength", new Integer(32)), new TestCase("getMaxColumnsInGroupBy", new Integer(128)), new TestCase("getMaxColumnsInIndex", new Integer(16)), new TestCase("getMaxColumnsInOrderBy", new Integer(128)), new TestCase("getMaxColumnsInSelect", new Integer(1023)), new TestCase("getMaxColumnsInTable", new Integer(1023)), new TestCase("getMaxConnections", new Integer(50)), new TestCase("getMaxCursorNameLength", new Integer(32)), new TestCase("getMaxIndexLength", new Integer(1024)), new TestCase("getMaxSchemaNameLength", new Integer(32)), new TestCase("getMaxProcedureNameLength", new Integer(32)), new TestCase("getMaxCatalogNameLength", new Integer(0)), new TestCase("getMaxRowSize", new Integer(8088)), new TestCase("doesMaxRowSizeIncludeBlobs", Boolean.FALSE), new TestCase("getMaxStatementLength", IntegerClassC), new TestCase("getMaxStatements", new Integer(Integer.MAX_VALUE)), new TestCase("getMaxTableNameLength", new Integer(32)), new TestCase("getMaxTablesInSelect", new Integer(0)), new TestCase("getMaxUserNameLength", new Integer(32)), new TestCase("getDefaultTransactionIsolation", new Integer(2)), new TestCase("supportsTransactions", Boolean.TRUE), new TestCase("supportsTransactionIsolationLevel", new Object[]{new Integer(2)}, Boolean.TRUE, null, null), new TestCase("supportsDataDefinitionAndDataManipulationTransactions", Boolean.TRUE), new TestCase("supportsDataManipulationTransactionsOnly", Boolean.FALSE), new TestCase("dataDefinitionCausesTransactionCommit", Boolean.FALSE), new TestCase("dataDefinitionIgnoredInTransactions", Boolean.FALSE), new TestCase("getProcedures", new Object[]{null, null, null}, null, ResultSetClassC, null), new TestCase("getProcedureColumns", new Object[]{null, null, null, null}, null, ResultSetClassC, null), new TestCase("getTables", new Object[]{null, null, null, null}, null, ResultSetClassC, null), new TestCase("getSchemas", ResultSetClassC), new TestCase("getCatalogs", ResultSetClassC), new TestCase("getTableTypes", ResultSetClassC), new TestCase("getColumns", new Object[]{null, null, null, null}, null, ResultSetClassC, null), new TestCase("getColumnPrivileges", new Object[]{null, null, null, null}, null, ResultSetClassC, null), new TestCase("getTablePrivileges", new Object[]{null, null, null}, null, ResultSetClassC, null), new TestCase("getBestRowIdentifier", new Object[]{null, null, null, new Integer(0), Boolean.TRUE}, null, ResultSetClassC, null), new TestCase("getVersionColumns", new Object[]{null, null, null}, null, ResultSetClassC, null), new TestCase("getPrimaryKeys", new Object[]{null, null, null}, null, ResultSetClassC, null), new TestCase("getImportedKeys", new Object[]{null, null, null}, null, ResultSetClassC, null), new TestCase("getExportedKeys", new Object[]{null, null, null}, null, ResultSetClassC, null), new TestCase("getCrossReference", new Object[]{null, null, null, null, null, null}, null, ResultSetClassC, null), new TestCase("getTypeInfo", ResultSetClassC), new TestCase("getIndexInfo", new Object[]{null, null, null, Boolean.TRUE, Boolean.TRUE}, null, ResultSetClassC, null), new TestCase("supportsResultSetType", new Object[]{new Integer(1003)}, Boolean.TRUE, null, null), new TestCase("supportsResultSetType", new Object[]{new Integer(1004)}, Boolean.TRUE, null, null), new TestCase("supportsResultSetType", new Object[]{new Integer(1005)}, Boolean.TRUE, null, null), new TestCase("supportsResultSetConcurrency", new Object[]{new Integer(1003), new Integer(1007)}, Boolean.TRUE, null, null), new TestCase("supportsResultSetConcurrency", new Object[]{new Integer(1003), new Integer(1008)}, Boolean.TRUE, null, null), new TestCase("supportsResultSetConcurrency", new Object[]{new Integer(1004), new Integer(1007)}, Boolean.TRUE, null, null), new TestCase("supportsResultSetConcurrency", new Object[]{new Integer(1004), new Integer(1008)}, Boolean.TRUE, null, null), new TestCase("supportsResultSetConcurrency", new Object[]{new Integer(1005), new Integer(1007)}, Boolean.TRUE, null, null), new TestCase("supportsResultSetConcurrency", new Object[]{new Integer(1005), new Integer(1008)}, Boolean.TRUE, null, null), new TestCase("ownUpdatesAreVisible", new Object[]{new Integer(0)}, Boolean.TRUE, null, null), new TestCase("ownDeletesAreVisible", new Object[]{new Integer(0)}, Boolean.TRUE, null, null), new TestCase("ownInsertsAreVisible", new Object[]{new Integer(0)}, Boolean.TRUE, null, null), new TestCase("othersUpdatesAreVisible", new Object[]{new Integer(0)}, Boolean.TRUE, null, null), new TestCase("othersDeletesAreVisible", new Object[]{new Integer(0)}, Boolean.FALSE, null, null), new TestCase("othersInsertsAreVisible", new Object[]{new Integer(0)}, Boolean.TRUE, null, null), new TestCase("updatesAreDetected", new Object[]{new Integer(0)}, Boolean.FALSE, null, null), new TestCase("deletesAreDetected", new Object[]{new Integer(0)}, Boolean.FALSE, null, null), new TestCase("insertsAreDetected", new Object[]{new Integer(0)}, Boolean.FALSE, null, null), new TestCase("supportsBatchUpdates", Boolean.TRUE), new TestCase("getUDTs", new Object[]{null, null, null, null}, null, ResultSetClassC, null), new TestCase("getConnection", ConnectionClassC), new TestCase("supportsSavepoints", Boolean.TRUE), new TestCase("supportsNamedParameters", Boolean.TRUE), new TestCase("supportsMultipleOpenResults", Boolean.FALSE), new TestCase("supportsGetGeneratedKeys", Boolean.FALSE), new TestCase("getSuperTypes", new Object[]{null, null, null}, null, ResultSetClassC, null), new TestCase("getSuperTables", new Object[]{null, null, null}, null, ResultSetClassC, null), new TestCase("supportsResultSetHoldability", new Object[]{new Integer(1)}, Boolean.TRUE, null, null), new TestCase("supportsResultSetHoldability", new Object[]{new Integer(2)}, Boolean.TRUE, null, null), new TestCase("getResultSetHoldability", new Integer(1)), new TestCase("getDatabaseMajorVersion", new Integer(7)), new TestCase("getDatabaseMinorVersion", new Integer(4)), new TestCase("getJDBCMajorVersion", new Integer(3)), new TestCase("getJDBCMinorVersion", new Integer(0)), new TestCase("getSQLStateType", new Integer(2)), new TestCase("locatorsUpdateCopy", Boolean.FALSE), new TestCase("supportsStatementPooling", Boolean.FALSE)};
        testCases = testCaseArray;
    }

    public void testRun() throws SQLException {
        String string = "DatabaseMetaData";
        java.sql.DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        this.initTestCases();
        TestCase[] testCaseArray = this.filterTestCases();
        for (int i = 0; i < testCaseArray.length; ++i) {
            Exception exception;
            TestCase testCase = testCaseArray[i];
            if (!this.supportsTestCase(string, testCase)) continue;
            try {
                exception = null;
                Object object = Reflector.apply(databaseMetaData, testCase.methodName, testCase.arguments);
                testCase.testForDiff(object, this.log);
                if (object instanceof ResultSet) {
                    ((ResultSet)object).close();
                }
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
                exception = exception2;
            }
            testCase.testForException(exception, this.log);
        }
    }

    protected TestCase[] filterTestCases() {
        Object object;
        Vector vector = this.options.getVector("method");
        if (vector == null || vector.size() == 0) {
            this.checkForCompleteness(testCases);
            vector = supportedMethods;
        }
        TestCase[] testCaseArray = new TestCase[testCases.length];
        int n = 0;
        for (int i = 0; i < testCases.length; ++i) {
            object = testCases[i];
            if (!vector.contains(((TestCase)object).methodName)) continue;
            testCaseArray[n] = object;
            ++n;
        }
        TestCase[] testCaseArray2 = new TestCase[n];
        System.arraycopy(testCaseArray, 0, testCaseArray2, 0, n);
        object = "nullsAreSortedHigh:nullsAreSortedLow:getDriverMajorVersion:getDriverMinorVersion:storesMixedCaseQuotedIdentifiers:getMaxIndexLength:getMaxTablesInSelect:getUDTs:getVersionColumns:getDatabaseMinorVersion:";
        for (int i = 0; i < testCases.length; ++i) {
            TestCase testCase = testCases[i];
            if (((String)object).indexOf(testCase.methodName + ":") == -1) continue;
            testCase.disable("bugfix not approved");
        }
        return testCaseArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForCompleteness(TestCase[] testCaseArray) {
        Enumeration enumeration = supportedMethods.elements();
        this.log.push("completeness");
        try {
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                boolean bl = false;
                for (int i = 0; i < testCaseArray.length; ++i) {
                    if (!string.equals(testCaseArray[i].methodName)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.log.addFailure(new Failure("Method '" + string + "' not in test cases"));
            }
        }
        finally {
            this.log.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        DatabaseMetaData databaseMetaData = new DatabaseMetaData(stringArray);
        try {
            databaseMetaData.runInner();
        }
        finally {
            databaseMetaData.connection.close();
        }
        if (databaseMetaData.log.hasErrors()) {
            System.exit(5);
        }
    }

    static {
        Method[] methodArray = DatabaseMetaData.loadClass("java.sql.DatabaseMetaData").getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            String string = methodArray[i].getName();
            supportedMethods.add(string);
        }
        optdesc = new OptionDesc[]{new ListOption("method", "run only these method tests", null)};
        testCases = null;
    }

    static class TestCase
    extends com.sap.dbtechtest.util.testdriver.TestCase {
        String methodName;
        Object[] arguments;
        Object expectedResult;
        Class expectedClass;
        Class expectedException;

        public TestCase(String string, Object[] objectArray, Object object, Class clazz, Class clazz2) {
            this.methodName = string;
            this.arguments = objectArray;
            this.expectedResult = object;
            this.expectedClass = clazz;
            this.expectedException = clazz2;
        }

        public String toString() {
            return "DatabaseMetaData." + this.methodName + " (" + ObjectServices.toString(this.arguments) + ")";
        }

        public TestCase(String string, Object object) {
            this(string, null, object, null, null);
        }

        public TestCase(String string, Class clazz) {
            this(string, null, null, clazz, null);
        }

        public boolean testForDiff(Object object, LogWriter logWriter) {
            boolean bl;
            String string = this.methodName;
            String string2 = this.arguments == null ? "result" : ObjectServices.toString(this.arguments);
            if (this.expectedClass != null) {
                bl = this.expectedClass.isAssignableFrom(object.getClass());
                if (bl) {
                    logWriter.addInfo(string, "result: " + ObjectServices.toString(object));
                } else {
                    logWriter.addFailure(new TestDifference(string, "expected some " + this.expectedClass.getName() + "; got " + string2));
                }
            } else {
                bl = logWriter.addDifference(string, string2, this.expectedResult, object);
            }
            return bl;
        }

        protected boolean testForException(Exception exception, LogWriter logWriter) {
            String string = this.methodName;
            return this.testForException(string, this.expectedException, exception, logWriter);
        }
    }
}

