/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.prepared;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;

public class OmsDBProc
extends Test {
    private static final String help = "insert help";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public OmsDBProc(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public OmsDBProc(Test test) throws SQLException {
        super(test);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void testRun() throws SQLException {
        try {
            try {
                this.stmt.execute("DROP PACKAGE DBPROCTEST");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.dropTable("DBPROCTEST_RESULT");
            this.stmt.execute("CREATE TABLE DBPROCTEST_RESULT(TEST VARCHAR(40), RESULT VARCHAR(40))");
            this.dropTable("DBPROCTEST_LOG");
            this.stmt.execute("CREATE TABLE DBPROCTEST_LOG (IDX INTEGER DEFAULT SERIAL, LINE VARCHAR(80))");
            this.stmt.execute("CREATE PACKAGE DBPROCTEST FILE 'C:\\SAPDevelop\\V76\\develop\\usr\\sap\\DBPROCTEST.dll'");
            this.connection.commit();
            this.stmt.execute("CREATE DBPROCEDURE TEST_STRUCT_IN IN DBPROCTEST EXECUTE INPROC");
            this.stmt.execute("CREATE DBPROCEDURE TEST_STRUCT_OUT IN DBPROCTEST EXECUTE INPROC");
            this.stmt.execute("CREATE DBPROCEDURE TEST_BIGSTRUCT_IN IN DBPROCTEST EXECUTE INPROC");
            this.stmt.execute("CREATE DBPROCEDURE TEST_BIGSTRUCT_OUT IN DBPROCTEST EXECUTE INPROC");
            this.stmt.execute("CREATE DBPROCEDURE TEST_CHARSTREAM_IN IN DBPROCTEST EXECUTE INPROC");
            this.stmt.execute("CREATE DBPROCEDURE TEST_CHARSTREAM_OUT IN DBPROCTEST EXECUTE INPROC");
            this.stmt.execute("CREATE DBPROCEDURE TEST_CHARSTREAM_ECHO IN DBPROCTEST EXECUTE INPROC");
            this.stmt.execute("CREATE DBPROCEDURE TEST_UCS2STREAM_IN IN DBPROCTEST EXECUTE INPROC");
            this.stmt.execute("CREATE DBPROCEDURE TEST_BYTESTREAM_IN IN DBPROCTEST EXECUTE INPROC");
            this.stmt.execute("CREATE DBPROCEDURE TEST_BYTESTREAM_OUT IN DBPROCTEST EXECUTE INPROC");
            this.stmt.execute("CREATE DBPROCEDURE TEST_UCS2STREAM_OUT IN DBPROCTEST EXECUTE INPROC");
            this.stmt.execute("CREATE DBPROCEDURE TEST_STRUCTSTREAM_IN IN DBPROCTEST EXECUTE INPROC");
            this.stmt.execute("CREATE DBPROCEDURE TEST_STRUCTSTREAM_OUT IN DBPROCTEST EXECUTE INPROC");
            this.stmt.execute("CREATE DBPROCEDURE TEST_INT8STREAM_OUT IN DBPROCTEST EXECUTE INPROC");
            this.stmt.execute("CREATE DBPROCEDURE TEST_INT4STREAM_OUT IN DBPROCTEST EXECUTE INPROC");
            this.connection.commit();
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException.getMessage());
            throw sQLException;
        }
        this.testUCS2CharStreamIn();
        Object var3_3 = null;
        try {
            this.stmt.execute("SELECT 1 FROM DUAL");
        }
        catch (SQLException object) {
            // empty catch block
        }
        try {
            this.stmt.execute("SELECT 1 FROM DUAL");
        }
        catch (SQLException object) {
            // empty catch block
        }
        try {
            this.stmt.execute("SELECT 1 FROM DUAL");
        }
        catch (SQLException object) {
            // empty catch block
        }
        object = this.stmt.executeQuery("SELECT LINE FROM DBPROCTEST_LOG ORDER BY IDX");
        while (object.next()) {
            System.err.println(object.getString(1));
        }
        object.close();
        ResultSet resultSet = this.stmt.executeQuery("SELECT TEST,RESULT FROM DBPROCTEST_RESULT");
        while (resultSet.next()) {
            System.err.println("Test: " + resultSet.getString(1) + " Result: " + resultSet.getString(2));
        }
        {
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            try {
                this.stmt.execute("SELECT 1 FROM DUAL");
            }
            catch (SQLException object) {
                // empty catch block
            }
            try {
                this.stmt.execute("SELECT 1 FROM DUAL");
            }
            catch (SQLException object) {
                // empty catch block
            }
            try {
                this.stmt.execute("SELECT 1 FROM DUAL");
            }
            catch (SQLException object) {
                // empty catch block
            }
            object = this.stmt.executeQuery("SELECT LINE FROM DBPROCTEST_LOG ORDER BY IDX");
            while (object.next()) {
                System.err.println(object.getString(1));
            }
            object.close();
            ResultSet resultSet2 = this.stmt.executeQuery("SELECT TEST,RESULT FROM DBPROCTEST_RESULT");
            while (resultSet2.next()) {
                System.err.println("Test: " + resultSet2.getString(1) + " Result: " + resultSet2.getString(2));
            }
            resultSet2.close();
            throw throwable;
        }
        resultSet.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testStructStreamOut() throws SQLException {
        try {
            CallableStatement callableStatement = this.connection.prepareCall("CALL TEST_INT4STREAM_OUT(?)");
            callableStatement.registerOutParameter(1, 1111);
            callableStatement.execute();
            Object object = callableStatement.getObject(1);
        }
        finally {
            this.connection.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testStructureIn() throws SQLException {
        try {
            CallableStatement callableStatement = this.connection.prepareCall("CALL TEST_STRUCT_IN(?)");
            Object[] objectArray = new Object[]{new Byte(33), new Integer(65323), new Short(12345), new Integer(17), new Double(17.345), new BigDecimal("3.123"), "Oscar".getBytes(), new Character('A'), new Character('Z'), new Boolean(true), new Integer(-234)};
            callableStatement.setObject(1, (Object)objectArray);
            callableStatement.execute();
        }
        finally {
            this.connection.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testStructureOut() throws SQLException {
        try {
            CallableStatement callableStatement = this.connection.prepareCall("CALL TEST_STRUCT_OUT(?)");
            callableStatement.execute();
            Object object = callableStatement.getObject(1);
            System.err.println(object);
            System.err.println(((Struct)object).getSQLTypeName());
        }
        finally {
            this.connection.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testUnicodeStreamOut() throws SQLException {
        try {
            CallableStatement callableStatement = this.connection.prepareCall("CALL TEST_UCS2STREAM_OUT(?)");
            callableStatement.registerOutParameter(1, 1111);
            callableStatement.execute();
            String string = callableStatement.getString(1);
            if (string.length() != 27777) {
                this.log.addFailure(new Failure("String is too short."));
            }
            System.err.println(string);
        }
        finally {
            this.connection.commit();
        }
    }

    void testCharStreamEcho() throws SQLException {
        CallableStatement callableStatement = this.connection.prepareCall("CALL TEST_CHARSTREAM_ECHO(?, ?, ?, ?)");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 10000; ++i) {
            stringBuffer.append("TEST TEST TEST");
        }
        callableStatement.setString(1, stringBuffer.toString());
        callableStatement.registerOutParameter(2, 1111);
        callableStatement.setString(3, "ABCDEABCDEABCDEABCDEABCDEABCDEABCDEABCDE");
        callableStatement.registerOutParameter(4, 1);
        callableStatement.execute();
        String string = callableStatement.getString(2);
        if (!string.equals(stringBuffer.toString())) {
            this.log.addFailure(new Failure("charStreamEcho", "Input String is not equal to output string"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testCharStreamOut() throws SQLException {
        try {
            CallableStatement callableStatement = this.connection.prepareCall("CALL TEST_CHARSTREAM_OUT(?, ?)");
            callableStatement.registerOutParameter(1, 1111);
            callableStatement.execute();
            String string = callableStatement.getString(1).trim();
            String string2 = callableStatement.getString(2).trim();
            if (string.length() != 4000) {
                this.log.addFailure(new Failure("String is not 40000 chars long, found " + string.length() + " chars."));
            }
            if (!string2.equals("Homer Maggie Bart")) {
                this.log.addFailure(new Failure("Parameter string value is wrong."));
            }
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == 'A') continue;
                this.log.addFailure(new Failure("Expected 'A' in stream string at position " + i + "."));
            }
        }
        finally {
            this.connection.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testByteStreamOut() throws SQLException {
        try {
            CallableStatement callableStatement = this.connection.prepareCall("CALL TEST_BYTESTREAM_OUT(?)");
            callableStatement.registerOutParameter(1, 1111);
            callableStatement.execute();
            byte[] byArray = callableStatement.getBytes(1);
            if (byArray.length != 40000) {
                this.log.addFailure(new Failure("Byte array output is not 40000, but " + byArray.length + " bytes long."));
            }
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == 17) continue;
                this.log.addFailure(new Failure("ba[" + i + "] is not 17."));
            }
        }
        finally {
            this.connection.commit();
        }
    }

    void testUCS2CharStreamIn() throws SQLException {
        System.out.println("Testing ASCII for UNICODE.");
        CallableStatement callableStatement = this.connection.prepareCall("CALL TEST_UCS2STREAM_IN(?)");
        callableStatement.setString(1, "AAAAAAAAAAAAAAAAAAAA");
        callableStatement.execute();
        this.connection.commit();
        if (!this.environment.hasFeature("UnicodeConnection")) {
            System.out.println("Skipping test, no Unicode connection.");
            return;
        }
        System.out.println("Testing real unicode chars.");
        String string = "\u043f\u0439\u043e\u0435\u0436\u0434";
        callableStatement.setString(1, string);
        callableStatement.execute();
        this.connection.commit();
    }

    void testCharStreamIn() throws SQLException {
        CallableStatement callableStatement = this.connection.prepareCall("CALL TEST_CHARSTREAM_IN(?)");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 40000; ++i) {
            stringBuffer.append('A');
        }
        callableStatement.setString(1, stringBuffer.toString());
        callableStatement.execute();
        callableStatement.setCharacterStream(1, (Reader)new StringReader(stringBuffer.toString()), stringBuffer.length());
        callableStatement.execute();
        callableStatement.setString(1, "\u00d6\u00d6\u00d6\u00d6\u00d6\u00d6\u00d6\u00d6\u00d6\u00d6\u00d6\u00d6\u00d6\u00d6\u00d6\u00d6\u00d6\u00d6\u00d6\u00d6");
        callableStatement.execute();
        this.connection.commit();
    }

    void testByteStreamIn() throws SQLException {
        CallableStatement callableStatement = this.connection.prepareCall("CALL TEST_BYTESTREAM_IN(?)");
        System.err.println("TEST BYTES");
        byte[] byArray = new byte[17];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = -1;
        }
        callableStatement.setBytes(1, byArray);
        callableStatement.execute();
        System.err.println("TEST BINARY STREAM");
        callableStatement.setBinaryStream(1, (InputStream)new ByteArrayInputStream(byArray), 17);
        callableStatement.execute();
        this.connection.commit();
        callableStatement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        OmsDBProc omsDBProc = new OmsDBProc(stringArray);
        try {
            omsDBProc.runInner();
        }
        finally {
            omsDBProc.connection.close();
        }
        if (omsDBProc.log.hasErrors()) {
            System.exit(5);
        }
    }
}

