/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.prepared;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DBProcGetDate
extends Test {
    private static final String help = "help for DBProcGetDate";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public DBProcGetDate(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public DBProcGetDate(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        if (!this.checkVersion("7.5.0")) {
            return;
        }
        String string = "DBProcGetDate";
        String string2 = this.getUnicodeIdentifier(string);
        this.dropTable(string2);
        int n = 10;
        this.stmt.executeUpdate("CREATE TABLE " + string2 + " (a int, b date)");
        PreparedStatement preparedStatement = this.connection.prepareStatement("insert " + string2 + " values (?,?)");
        Date date = new Date(System.currentTimeMillis());
        for (int i = 0; i < n; ++i) {
            preparedStatement.setInt(1, 1);
            preparedStatement.setDate(2, date);
            preparedStatement.addBatch();
        }
        preparedStatement.executeBatch();
        String string3 = string2;
        try {
            this.stmt.execute("DROP DBPROC " + string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stmt.executeUpdate("CREATE DBPROC " + string3 + " (IN protocole INTEGER, OUT dateinvent VARCHAR(10))" + " AS SELECT MAX(CHAR(b,ISO)) FROM " + this.getUsername() + "." + string2 + " where a=:protocole;" + " FETCH INTO :dateinvent;");
        CallableStatement callableStatement = this.connection.prepareCall("CALL " + string3 + "(?, ?)");
        callableStatement.registerOutParameter(2, 91);
        callableStatement.setInt(1, 1);
        callableStatement.execute();
        this.log.addDifference(string, "Check date value returned from DBProc", date, callableStatement.getDate(2));
        ResultSet resultSet = this.stmt.executeQuery("SELECT * FROM " + string2);
        this.log.addDifference(string, "Check fetch next", Boolean.TRUE, new Boolean(resultSet.next()));
        this.log.addDifference(string, "Check date value returned from SELECT", date, resultSet.getDate(2));
        this.connection.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        DBProcGetDate dBProcGetDate = new DBProcGetDate(stringArray);
        try {
            dBProcGetDate.runInner();
        }
        finally {
            dBProcGetDate.connection.close();
        }
        if (dBProcGetDate.log.hasErrors()) {
            System.exit(5);
        }
    }
}

