/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.prepared;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.sql.BatchUpdateException;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class BatchnotAllParametersSet
extends Test {
    private static final String help = "help for BatchnotAllParametersSet";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public BatchnotAllParametersSet(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public BatchnotAllParametersSet(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "BatchnotAllParametersSet";
        String string2 = this.getUnicodeIdentifier("BatchnotAllParam");
        this.dropTable(string2);
        this.stmt.execute("CREATE TABLE " + string2 + " (a int ,b varchar(2000),CONSTRAINT a <= 1000000)");
        PreparedStatement preparedStatement = this.prepare("insert into " + string2 + " values (?,?)");
        for (int i = 1; i <= 100; ++i) {
            preparedStatement.setInt(1, i);
            if (i <= 90) {
                preparedStatement.setInt(2, i);
            }
            preparedStatement.addBatch();
            preparedStatement.clearParameters();
        }
        try {
            preparedStatement.executeBatch();
            this.log.addFailure(new Failure(string, "Expected BatchUpdateException not occured"));
        }
        catch (BatchUpdateException batchUpdateException) {
            int[] nArray = batchUpdateException.getUpdateCounts();
            this.log.addDifference(string, "Checking update count array size ", Boolean.TRUE, new Boolean(nArray.length <= 90));
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == 1 || nArray[i] == -2) continue;
                this.log.addFailure(new Failure(string, "Unexpected update count: " + nArray[i]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        BatchnotAllParametersSet batchnotAllParametersSet = new BatchnotAllParametersSet(stringArray);
        try {
            batchnotAllParametersSet.runInner();
        }
        finally {
            batchnotAllParametersSet.connection.close();
        }
        if (batchnotAllParametersSet.log.hasErrors()) {
            System.exit(5);
        }
    }
}

