/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.prepared;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.BatchUpdateException;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class BatchException
extends Test {
    private static final String help = "Test that the big decimal scale is correctly set.";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public BatchException(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public BatchException(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "BatchException";
        String string2 = this.getUnicodeIdentifier(string);
        this.dropTable(string2);
        this.stmt.execute("CREATE TABLE " + string2 + " (A INTEGER PRIMARY KEY)");
        this.stmt.execute("INSERT INTO " + string2 + " VALUES (2)");
        this.stmt.execute("INSERT INTO " + string2 + " VALUES (3)");
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT INTO " + string2 + " VALUES (?)");
            preparedStatement.setInt(1, 17);
            preparedStatement.addBatch();
            preparedStatement.setInt(1, 13);
            preparedStatement.addBatch();
            preparedStatement.setInt(1, 12);
            preparedStatement.addBatch();
            preparedStatement.setInt(1, 3);
            preparedStatement.addBatch();
            preparedStatement.setInt(1, 14);
            preparedStatement.addBatch();
            preparedStatement.executeBatch();
            this.connection.commit();
        }
        catch (BatchUpdateException batchUpdateException) {
            int[] nArray = batchUpdateException.getUpdateCounts();
            this.log.addDifference(string, "PreparedStatement.executeBatch - check update count", new Integer(3), new Integer(nArray.length));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        BatchException batchException = new BatchException(stringArray);
        try {
            batchException.runInner();
        }
        finally {
            batchException.connection.close();
        }
        if (batchException.log.hasErrors()) {
            System.exit(5);
        }
    }
}

