/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.jdbcext;

import com.sap.dbtech.jdbcext.JDBCRowSetSapDB;
import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;

public class SimpleRowset
extends Test
implements RowSetListener {
    private static final String help = "help for SimpleRowset";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public SimpleRowset(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public SimpleRowset(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        int n;
        String string;
        String string2 = string = "SimpleRowset";
        this.dropTable(string2);
        this.stmt.execute("CREATE TABLE " + string2 + "   (a    Char (1) ASCII," + "    b     Char (1) BYTE," + "    c Varchar (1) ASCII," + "    d  Varchar (1) BYTE," + "    e          Integer," + "    f      Smallint," + "    g        Float (5)," + "    h        Fixed (5)," + "    i      Boolean," + "    j         Date," + "    k         Time," + "    l    Timestamp," + "    m    Long ASCII," + "    n     Long BYTE)");
        PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT INTO " + string2 + " VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        for (int i = 1; i <= 9; ++i) {
            preparedStatement.setString(1, String.valueOf(i));
            preparedStatement.setByte(2, new Byte(String.valueOf(i)));
            preparedStatement.setString(3, String.valueOf(i));
            preparedStatement.setByte(4, new Byte(String.valueOf(i)));
            preparedStatement.setString(5, String.valueOf(i));
            preparedStatement.setString(6, String.valueOf(i));
            preparedStatement.setString(7, String.valueOf(i));
            preparedStatement.setString(8, String.valueOf(i));
            preparedStatement.setBoolean(9, true);
            preparedStatement.setDate(10, new Date(i));
            preparedStatement.setTime(11, new Time(i));
            preparedStatement.setTimestamp(12, new Timestamp(i));
            preparedStatement.setString(13, String.valueOf(i));
            preparedStatement.setByte(14, new Byte(String.valueOf(i)));
            preparedStatement.addBatch();
        }
        preparedStatement.executeBatch();
        this.connection.commit();
        JDBCRowSetSapDB jDBCRowSetSapDB = new JDBCRowSetSapDB();
        jDBCRowSetSapDB.setUsername(this.getUsername());
        jDBCRowSetSapDB.setPassword(this.getPasswd());
        jDBCRowSetSapDB.setUrl("jdbc:sapdb:///" + this.getDBName());
        jDBCRowSetSapDB.setCommand("SELECT * from " + string2);
        jDBCRowSetSapDB.execute();
        ResultSetMetaData resultSetMetaData = jDBCRowSetSapDB.getMetaData();
        int n2 = 1;
        while (jDBCRowSetSapDB.next()) {
            for (n = 1; n <= resultSetMetaData.getColumnCount(); ++n) {
                if (resultSetMetaData.getColumnType(n) == -4 || resultSetMetaData.getColumnType(n) == -2 || resultSetMetaData.getColumnType(n) == -3) {
                    this.log.addDifference(string, "Check RowSet BINARY " + resultSetMetaData.getColumnName(n), new Byte(String.valueOf(n2)), new Byte(jDBCRowSetSapDB.getByte(n)));
                    continue;
                }
                if (resultSetMetaData.getColumnType(n) == 91) {
                    this.log.addDifference(string, "Check RowSet DATE " + resultSetMetaData.getColumnName(n), new Date(n2).toString(), jDBCRowSetSapDB.getString(n));
                    continue;
                }
                if (resultSetMetaData.getColumnType(n) == 92) {
                    this.log.addDifference(string, "Check RowSet TIME " + resultSetMetaData.getColumnName(n), new Time(n2), jDBCRowSetSapDB.getTime(n));
                    continue;
                }
                if (resultSetMetaData.getColumnType(n) == 93) {
                    this.log.addDifference(string, "Check RowSet TIMESTAMP " + resultSetMetaData.getColumnName(n), new Timestamp(n2), jDBCRowSetSapDB.getTimestamp(n));
                    continue;
                }
                if (resultSetMetaData.getColumnType(n) == -7) {
                    this.log.addDifference(string, "Check RowSet BOOLEAN " + resultSetMetaData.getColumnName(n), Boolean.TRUE, new Boolean(jDBCRowSetSapDB.getBoolean(n)));
                    continue;
                }
                this.log.addDifference(string, "Check RowSet STRING " + resultSetMetaData.getColumnName(n), String.valueOf(n2), jDBCRowSetSapDB.getString(n));
            }
            ++n2;
        }
        n2 = 1;
        jDBCRowSetSapDB.setCommand("SELECT * from " + string2 + " WHERE a=? and b=? and c=? " + " and d=? and e=? and f=? and g=? and h=? and i=? and j=? and k=? and l=?");
        jDBCRowSetSapDB.setString(1, String.valueOf(n2));
        jDBCRowSetSapDB.setByte(2, (byte)new Byte(String.valueOf(n2)));
        jDBCRowSetSapDB.setString(3, String.valueOf(n2));
        jDBCRowSetSapDB.setByte(4, (byte)new Byte(String.valueOf(n2)));
        jDBCRowSetSapDB.setString(5, String.valueOf(n2));
        jDBCRowSetSapDB.setString(6, String.valueOf(n2));
        jDBCRowSetSapDB.setString(7, String.valueOf(n2));
        jDBCRowSetSapDB.setString(8, String.valueOf(n2));
        jDBCRowSetSapDB.setBoolean(9, true);
        jDBCRowSetSapDB.setDate(10, new Date(n2));
        jDBCRowSetSapDB.setTime(11, new Time(n2));
        jDBCRowSetSapDB.setTimestamp(12, new Timestamp(n2));
        jDBCRowSetSapDB.execute();
        resultSetMetaData = jDBCRowSetSapDB.getMetaData();
        n = 1;
        while (jDBCRowSetSapDB.next()) {
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                if (resultSetMetaData.getColumnType(i) == -4 || resultSetMetaData.getColumnType(i) == -2 || resultSetMetaData.getColumnType(i) == -3) {
                    this.log.addDifference(string, "Check RowSet BINARY " + resultSetMetaData.getColumnName(i), new Byte(String.valueOf(n)), new Byte(jDBCRowSetSapDB.getByte(i)));
                    continue;
                }
                if (resultSetMetaData.getColumnType(i) == 91) {
                    this.log.addDifference(string, "Check RowSet DATE " + resultSetMetaData.getColumnName(i), new Date(n).toString(), jDBCRowSetSapDB.getString(i));
                    continue;
                }
                if (resultSetMetaData.getColumnType(i) == 92) {
                    this.log.addDifference(string, "Check RowSet TIME " + resultSetMetaData.getColumnName(i), new Time(n), jDBCRowSetSapDB.getTime(i));
                    continue;
                }
                if (resultSetMetaData.getColumnType(i) == 93) {
                    this.log.addDifference(string, "Check RowSet TIMESTAMP " + resultSetMetaData.getColumnName(i), new Timestamp(n), jDBCRowSetSapDB.getTimestamp(i));
                    continue;
                }
                if (resultSetMetaData.getColumnType(i) == -7) {
                    this.log.addDifference(string, "Check RowSet BOOLEAN " + resultSetMetaData.getColumnName(i), Boolean.TRUE, new Boolean(jDBCRowSetSapDB.getBoolean(i)));
                    continue;
                }
                this.log.addDifference(string, "Check RowSet STRING " + resultSetMetaData.getColumnName(i), String.valueOf(n), jDBCRowSetSapDB.getString(i));
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        SimpleRowset simpleRowset = new SimpleRowset(stringArray);
        try {
            simpleRowset.runInner();
        }
        finally {
            simpleRowset.connection.close();
        }
        if (simpleRowset.log.hasErrors()) {
            System.exit(5);
        }
    }

    public void rowSetChanged(RowSetEvent rowSetEvent) {
        System.out.println("rowSetChanged");
    }

    public void rowChanged(RowSetEvent rowSetEvent) {
        System.out.println("rowChanged");
    }

    public void cursorMoved(RowSetEvent rowSetEvent) {
        System.out.println("cursorMoved");
    }
}

