/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.ecperf;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DoublePerformance
extends Test {
    private static final String help = "help for DoublePerformance";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public DoublePerformance(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public DoublePerformance(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        int n = 10000;
        String string = "DoublePerformance";
        this.dropTable("DoublePerformance");
        this.stmt.execute("CREATE TABLE DoublePerformance (  o_id\t\tinteger key ,o_discount\t        float(38) ,o_total\t\tfixed(9,2) ,o_discount2\t        fixed(4,2) ,o_total2\t\tfixed(9,2) )");
        PreparedStatement preparedStatement = this.connection.prepareStatement("Insert into DoublePerformance values (?,?,?,?,?)");
        long l = System.currentTimeMillis();
        for (int i = 1; i <= n; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setLong(2, Long.MAX_VALUE);
            preparedStatement.setDouble(3, 1234567.89);
            preparedStatement.setFloat(4, 12.34f);
            preparedStatement.setFloat(5, 1234567.9f);
            preparedStatement.addBatch();
        }
        preparedStatement.executeBatch();
        System.out.println("INSERT of " + n + " rows needs " + (System.currentTimeMillis() - l) + " milli sec.");
        ResultSet resultSet = this.stmt.executeQuery("Select * from DoublePerformance");
        l = System.currentTimeMillis();
        while (resultSet.next()) {
            int n2 = resultSet.getInt(1);
            double d = resultSet.getDouble(2);
            double d2 = resultSet.getDouble(3);
            float f = resultSet.getFloat(4);
            float f2 = resultSet.getFloat(5);
        }
        System.out.println("SELECT of " + n + " rows needs " + (System.currentTimeMillis() - l) + " milli sec.");
        resultSet.close();
        ResultSet resultSet2 = this.stmt.executeQuery("Select * from DoublePerformance");
        while (resultSet2.next()) {
            this.log.addDifference(string, "Check result", new Double(9.223372036854776E18), new Double(resultSet2.getDouble(2)));
            this.log.addDifference(string, "Check result", new Double(1234567.89), new Double(resultSet2.getDouble(3)));
            this.log.addDifference(string, "Check result", new Float(12.34f), new Float(resultSet2.getFloat(4)));
            this.log.addDifference(string, "Check result", new Float(1234567.9f), new Float(resultSet2.getFloat(5)));
        }
        resultSet2.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        DoublePerformance doublePerformance = new DoublePerformance(stringArray);
        try {
            doublePerformance.runInner();
        }
        finally {
            doublePerformance.connection.close();
        }
        if (doublePerformance.log.hasErrors()) {
            System.exit(5);
        }
    }
}

