/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.benchmark;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Info;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class UnicodePackets
extends Test {
    private static final String help = "help for UnicodePackets";
    private static final OptionDesc[] optdesc = new OptionDesc[0];
    String tableName = "";

    public UnicodePackets(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public UnicodePackets(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "UnicodePackets";
        this.tableName = this.getUnicodeIdentifier(string);
        this.dropTable(this.tableName);
        this.stmt.execute("CREATE TABLE " + this.tableName + " (a varchar(100), b int primary key, c boolean)");
        int n = 5000;
        this.log.addInfo(new Info(string, "UnicodeDB: " + this.environment.hasFeature("UnicodeDB") + " Unicode Connection: " + this.environment.hasFeature("UnicodeConnection")));
        long l = this.testInserts(n);
        this.log.addInfo(new Info(string, "INSERTS: " + n + " TIME: " + l));
        l = this.testSelects(n);
        this.log.addInfo(new Info(string, "SELECTS: " + n + " TIME: " + l));
    }

    private long testInserts(int n) throws SQLException {
        String string = this.makeRandomString(100);
        long l = System.currentTimeMillis();
        for (int i = 1; i <= n; ++i) {
            PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT INTO " + this.tableName + " VALUES (?,?,?)");
            preparedStatement.setString(1, string);
            preparedStatement.setInt(1, i);
            preparedStatement.setBoolean(1, true);
            preparedStatement.close();
        }
        long l2 = System.currentTimeMillis();
        return l2 - l;
    }

    private long testSelects(int n) throws SQLException {
        Statement statement = this.connection.createStatement();
        long l = System.currentTimeMillis();
        for (int i = 1; i <= n; ++i) {
            statement.execute("SELECT * FROM " + this.tableName);
        }
        long l2 = System.currentTimeMillis();
        statement.close();
        return l2 - l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        UnicodePackets unicodePackets = new UnicodePackets(stringArray);
        try {
            unicodePackets.runInner();
        }
        finally {
            unicodePackets.connection.close();
        }
        if (unicodePackets.log.hasErrors()) {
            System.exit(5);
        }
    }
}

