/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.sapdb.lctest.LiveCacheConstants;
import com.sap.sapdb.lctest.LiveCacheMaster;
import com.sap.sapdb.lctest.TestActor;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import java.sql.SQLException;
import java.util.Random;

abstract class SQLActor
extends TestActor
implements LiveCacheConstants {
    public static final int WRITER = 1;
    public static final int NOT_STARTED = 0;
    public static final int W_LOCK = 1;
    public static final int W_COMMIT = 2;
    public static final int W_ROLLBACK = 3;
    public static final int W_CREATE = 4;
    public static final int W_DROP = 5;
    public static final int W_CHANGE = 6;
    protected int mAction = 0;
    protected static int mCycleNumber = 0;
    private static Random mRandomGenerator = new Random();
    private static long mRandomSeed = -1L;

    public SQLActor() {
    }

    public SQLActor(Runnable target) {
        super(target);
    }

    public SQLActor(Runnable target, String name) {
        super(target, name);
    }

    public SQLActor(String name) {
        super(name);
    }

    public SQLActor(ThreadGroup group, Runnable target) {
        super(group, target);
    }

    public SQLActor(ThreadGroup group, Runnable target, String name) {
        super(group, target, name);
    }

    public SQLActor(ThreadGroup group, String name) {
        super(group, name);
    }

    protected void callDBProcedure(String ProcedureName) throws SQLException {
        this.mStatement.execute("CALL " + ProcedureName);
    }

    protected void cleanup() {
        try {
            this.mStatement.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.mConnection.rollback();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.mConnection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getAction() {
        return this.mAction;
    }

    public abstract int getActorType();

    public int getCycleNumber() {
        return mCycleNumber;
    }

    public static Random getRandomGenerator() {
        return mRandomGenerator;
    }

    protected abstract int nextAction();

    public static float randomFloat(float MinValue, float MaxValue) {
        return (float)((double)mRandomGenerator.nextFloat() * (double)(MaxValue - MinValue)) + MinValue;
    }

    public static int randomInteger(int MinValue, int MaxValue) {
        return (int)((double)mRandomGenerator.nextFloat() * (double)(MaxValue - MinValue + 1)) + MinValue;
    }

    public static void setCycleNumber(int newCycleNumber) {
        mCycleNumber = newCycleNumber;
    }

    public static void setRandomSeed(int pNewSeed) {
        mRandomSeed = pNewSeed;
        mRandomGenerator.setSeed(pNewSeed);
    }

    public int createInitialTable(String pTableName, int pNoOfEntries) {
        int checksum = 0;
        int lLength = 10000;
        try {
            int i;
            byte[] bytearr = new byte[lLength];
            for (i = 0; i < bytearr.length; ++i) {
                bytearr[i] = 120;
            }
            this.mStatement.executeUpdate("Create table " + pTableName + " (k0 int, k1 char(10), f0 char(20), f1 int, f3 int, f4 LONG BYTE, primary key(k0, k1))");
            this.mStatement.executeUpdate("Create index ind_" + pTableName + " on " + pTableName + " (k1)");
            TestPreparedStatement mPreparedStatement = new TestPreparedStatement(null, this.mConnection, "Insert " + pTableName + " values (?,?,?,?,?,?)");
            for (i = 0; i < pNoOfEntries; ++i) {
                mPreparedStatement.setInt(1, i);
                mPreparedStatement.setString(2, "Key" + i);
                mPreparedStatement.setString(3, "Test" + i);
                mPreparedStatement.setInt(4, i);
                mPreparedStatement.setInt(5, 1);
                mPreparedStatement.setBytes(6, bytearr);
                mPreparedStatement.executeUpdate();
                checksum += i;
            }
            mPreparedStatement.close();
            LiveCacheMaster.printTrace(this.mTitle + ":  Successfully CREATEd new table " + pTableName + " with " + pNoOfEntries + " records");
        }
        catch (Exception e) {
            LiveCacheMaster.printTrace(this.mTitle + ": Traceinfo (test will keep running) ** ERROR in createInitialTable ** Raising exception " + e.getMessage());
            this.setStatus(-2, "SQLException: " + e.getMessage());
        }
        return checksum;
    }

    public boolean dropTable(String pTableName) {
        try {
            this.mStatement.executeUpdate("Drop index ind_" + pTableName + " on " + pTableName);
            this.mStatement.executeUpdate("Drop table " + pTableName);
            LiveCacheMaster.printTrace(this.mTitle + ":  Successfully dropped table " + pTableName);
        }
        catch (Exception e) {
            LiveCacheMaster.printTrace(this.mTitle + ": Traceinfo for dropTable (test will keep running): " + e.getMessage());
            this.setStatus(-2, "SQLException: " + e.getMessage());
        }
        return true;
    }

    public int insertIntoTable(String pTableName, int pChecksum, int pNoOfCurrentRecords, int pNoOfInserts) {
        int checksum = 0;
        try {
            this.mPreparedStatement = new TestPreparedStatement(null, this.mConnection, "Insert " + pTableName + " values (?,?,?,?,?)");
            for (int i = pNoOfCurrentRecords; i < pNoOfInserts + pNoOfCurrentRecords; ++i) {
                this.mPreparedStatement.setInt(1, i);
                this.mPreparedStatement.setString(2, "Key" + i);
                this.mPreparedStatement.setString(3, "Test" + i);
                this.mPreparedStatement.setInt(4, i);
                this.mPreparedStatement.setInt(5, i);
                this.mPreparedStatement.executeUpdate();
                checksum += i;
            }
            checksum += pChecksum;
            this.mPreparedStatement.close();
            LiveCacheMaster.printTrace(this.mTitle + ": Successfully inserted " + pNoOfInserts + " records into " + pTableName);
        }
        catch (Exception e) {
            LiveCacheMaster.printTrace(this.mTitle + ": Traceinfo for insertIntoTable (test will keep running): " + e.getMessage());
            this.setStatus(-2, "SQLException: " + e.getMessage());
        }
        return checksum;
    }

    public int updateTable(String pTableName, int pChecksum, int pNoOfCurrentEntries, int pNoOfUpdates) {
        int checksum = 0;
        boolean result = false;
        boolean j = false;
        int updValues = 0;
        int currEntries = 0;
        try {
            this.mPreparedStatement = new TestPreparedStatement(null, this.mConnection, "Update " + pTableName + " (f0) values (?) where k0 = ?");
            currEntries = pNoOfCurrentEntries - 1;
            for (updValues = pNoOfUpdates; updValues != 0; --updValues) {
                this.mPreparedStatement.setString(1, "UpdTest" + currEntries);
                this.mPreparedStatement.setInt(2, currEntries);
                this.mPreparedStatement.executeUpdate();
                --currEntries;
            }
            this.mPreparedStatement.close();
            LiveCacheMaster.printTrace(this.mTitle + ": Successfully updated " + pNoOfUpdates + " in table " + pTableName);
        }
        catch (Exception e) {
            LiveCacheMaster.printTrace(this.mTitle + ": Traceinfo for updateTable (test will keep running): " + e.getMessage());
            this.setStatus(-2, "SQLException: " + e.getMessage());
        }
        checksum = pChecksum;
        return checksum;
    }

    public int deleteFromTable(String pTableName, int pChecksum, int pNoOfCurrentEntries, int pNoOfDeletes) {
        boolean checksum = false;
        int delValues = 0;
        int currEntries = 0;
        try {
            this.mPreparedStatement = new TestPreparedStatement(null, this.mConnection, "delete from " + pTableName + " where k0 = ?");
            currEntries = pNoOfCurrentEntries - 1;
            for (delValues = pNoOfDeletes; delValues != 0; --delValues) {
                this.mPreparedStatement.setInt(1, currEntries);
                this.mPreparedStatement.executeUpdate();
                pChecksum -= currEntries;
                --currEntries;
            }
            this.mPreparedStatement.close();
            LiveCacheMaster.printTrace(this.mTitle + ":  Successfully DELETEd " + pNoOfDeletes + " records from table " + pTableName);
        }
        catch (Exception e) {
            LiveCacheMaster.printTrace(this.mTitle + ": Traceinfo for deleteTable (test will keep running): " + e.getMessage());
            this.setStatus(-2, "SQLException: " + e.getMessage());
        }
        return pChecksum;
    }
}

