/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.dbtech.jdbc.exceptions.DatabaseException;
import com.sap.dbtech.powertoys.DBM;
import com.sap.sapdb.lctest.DBProcedure;
import com.sap.sapdb.lctest.LiveCacheConstants;
import com.sap.sapdb.lctest.Oid;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class PrimaryTest
extends TestCase
implements LiveCacheConstants {
    protected static final String sUser = "UPRIMARY";
    protected static final String sPassword = "UPRIMARY";
    protected static final int mNumberOfConnections = 3;
    protected static final int USER1 = 1;
    protected static final int USER2 = 2;
    protected static final int USER3 = 3;
    protected static final int NO_ERROR = 0;
    protected static final int DEFAULT_TIMEOUT = 10;
    protected static final int IGNORE_ALL_ERRORS = -999;
    private int mStatementCounter = 0;
    private static Connection[] mConnections;
    private static TestStatement[] mStatements;
    private int mNextKey = 0;
    private int mNextValue = 0;
    private int mNTErrorCode;
    private String mNTErrorText;
    private String mNTInfoString;
    private String mNTCallString;
    private String mNTResultString;
    private DBM mDBMan = null;
    protected boolean mTrace = true;

    private void checkResultCode(String InfoString, String CallString, int pExpectedResultCode) throws TestCaseException {
        if (pExpectedResultCode != 0 && pExpectedResultCode != -999) {
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'E', (String)("***** ERROR ****** " + CallString + " --> expecting result code " + pExpectedResultCode));
            throw new TestCaseException(CallString + " --> expecting result code " + pExpectedResultCode);
        }
    }

    private void checkResultCode(String InfoString, String CallString, int pExpectedResultCode, SQLException e) throws TestCaseException {
        if (pExpectedResultCode == -999) {
            return;
        }
        if (e.getErrorCode() != pExpectedResultCode) {
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'E', (String)("***** ERROR ****** " + CallString + " --> " + e.getMessage() + "\nExpecting Error: " + pExpectedResultCode + "\nReceived Error : " + e.getErrorCode()));
            throw new TestCaseException(CallString + " --> " + e.getMessage());
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " - Expected error: " + e.getMessage() + " --> OK"));
    }

    public static void cleanUp() throws TestCaseException {
        int i;
        if (mStatements == null || mConnections == null) {
            return;
        }
        try {
            for (i = 0; i < 3; ++i) {
                if (mConnections[i] == null) continue;
                mConnections[i].commit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            PrimaryTest.addGlobalMessage((String)"cleanup", (char)'E', (String)("Error during commiting all opened connections: " + e.getMessage()));
            throw new TestCaseException("Error during connection commiting all opened connections: " + e.getMessage());
        }
        try {
            if (mStatements[0] != null) {
                mStatements[0].execute("CALL DROP_CURRENT_SCHEMA('testteam')");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            PrimaryTest.addGlobalMessage((String)"cleanup", (char)'E', (String)("Error while dropping schema: " + e.getMessage()));
            throw new TestCaseException("Error while dropping schema: " + e.getMessage());
        }
        try {
            for (i = 0; i < 3; ++i) {
                if (mStatements[i] != null) {
                    mStatements[i].close();
                }
                if (mConnections[i] != null) {
                    mConnections[i].commit();
                }
                mConnections[i].close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            PrimaryTest.addGlobalMessage((String)"cleanup", (char)'E', (String)("Error during connection closure: " + e.getMessage()));
            throw new TestCaseException("Error during connection closure: " + e.getMessage());
        }
    }

    private static boolean createConnections() {
        try {
            mConnections = new Connection[3];
            mStatements = new TestStatement[3];
            for (int i = 0; i < 3; ++i) {
                PrimaryTest.mConnections[i] = PrimaryTest.getDatabase().connect("UPRIMARY", "UPRIMARY");
                mConnections[i].setAutoCommit(false);
                PrimaryTest.mStatements[i] = new TestStatement(null, mConnections[i]);
                mStatements[i].execute("CALL SET_CURRENT_SCHEMA('testteam')");
                mConnections[i].commit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            PrimaryTest.addGlobalMessage((String)"createConnections", (char)'E', (String)("Error during connection creation: " + e.getMessage()));
            return false;
        }
        return true;
    }

    private static void createDBProcedures() throws TestCaseException {
        Connection con = null;
        TestStatement stmt = null;
        try {
            con = PrimaryTest.getDatabase().connect("UPRIMARY", "UPRIMARY");
            stmt = new TestStatement(null, con);
            int ExecMode = 1;
            try {
                if (TestDriver.compareRelease((String)((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion(), (String)">=", (String)"7.4.4")) {
                    DBProcedure.createPackageWithFile(stmt, "checkpt", "dbpinstall");
                    DBProcedure.createPackageWithFile(stmt, "consistent", "consistent");
                    DBProcedure.createPackageWithFile(stmt, "ttlcbasics", "ttlcbasics");
                    DBProcedure.createPackageWithFile(stmt, "lctest", "lctest");
                } else {
                    DBProcedure.createPackage(stmt, "checkpt", "liveCache.dbpInstall.V72");
                    DBProcedure.createPackage(stmt, "consistent", "liveCache.consistent.TEST");
                    DBProcedure.createPackage(stmt, "lctest", "livecache.lctest.TEST");
                    try {
                        DBProcedure.createPackage(stmt, "ttlcbasics", "liveCache.ttlcbasics.TT");
                    }
                    catch (TestCaseException tce) {}
                }
            }
            catch (TestDatabaseException e) {
                throw new TestDatabaseException((Exception)((Object)e), "Could not retrieve kernel version for creation of packages ");
            }
            DBProcedure.create(stmt, "LIST_INIT", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_EXIT", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_READ", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_CREATE", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_UPDATE", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_INSERT", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_DELETE", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_REMOVE", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_LOCK", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_CONSISTENT", "consistent", ExecMode);
            DBProcedure.create(stmt, "OPEN_CONSIST_VIEW", "consistent");
            DBProcedure.create(stmt, "CLOSE_CONSIST_VIEW", "consistent");
            DBProcedure.create(stmt, "CREATE_CONSIST_VIEW", "consistent");
            DBProcedure.create(stmt, "DROP_CONSIST_VIEW", "consistent");
            DBProcedure.create(stmt, "CREATE_OBJECT", "consistent");
            DBProcedure.create(stmt, "DELETE_OBJECT", "consistent");
            DBProcedure.create(stmt, "GET_OBJECT", "consistent");
            DBProcedure.create(stmt, "UPDATE_OBJECT", "consistent");
            DBProcedure.create(stmt, "GET_OBJECT_VALUE", "consistent");
            DBProcedure.create(stmt, "GET_OID", "consistent");
            DBProcedure.create(stmt, "CHECK_SUBTRANS", "consistent");
            DBProcedure.create(stmt, "DELETE_ALL_OBJECTS", "consistent");
            DBProcedure.create(stmt, "CREATE_CURRENT_SCHEMA", "consistent", ExecMode);
            DBProcedure.create(stmt, "SET_CURRENT_SCHEMA", "consistent", ExecMode);
            DBProcedure.create(stmt, "DROP_CURRENT_SCHEMA", "consistent", ExecMode);
            DBProcedure.create(stmt, "CLASS_REGISTER", "consistent", ExecMode);
            try {
                DBProcedure.create(stmt, "CREATE_CONTAINER", "ttlcbasics");
                DBProcedure.create(stmt, "CREATE_MYVAROBJ", "ttlcbasics");
                DBProcedure.create(stmt, "READ_MYVAROBJ", "ttlcbasics");
                DBProcedure.create(stmt, "UPDATE_MYVAROBJ", "ttlcbasics");
            }
            catch (Exception ex) {
                System.out.println("Error: " + ex.getMessage());
            }
            try {
                DBProcedure.create(stmt, "PR_CREATE_VERSION1", "ttlcbasics");
                DBProcedure.create(stmt, "PR_CREATE_VERSION2", "ttlcbasics");
                DBProcedure.create(stmt, "PR_OPEN_VERSION", "ttlcbasics");
                DBProcedure.create(stmt, "PR_CLOSE_VERSION", "ttlcbasics");
                DBProcedure.create(stmt, "PR_GET_VERSION_INFO", "ttlcbasics");
                DBProcedure.create(stmt, "PR_CURRENT_VERSION_ID", "ttlcbasics");
                DBProcedure.create(stmt, "PR_EXISTS_VERSION", "ttlcbasics");
                DBProcedure.create(stmt, "PR_DROP_VERSION", "ttlcbasics");
                DBProcedure.create(stmt, "PR_FORCE_DROP_VERSION", "ttlcbasics");
                DBProcedure.create(stmt, "PR_SET_CURR_VERSION_DESC", "ttlcbasics");
                DBProcedure.create(stmt, "PR_RELEASE", "ttlcbasics");
                DBProcedure.create(stmt, "PR_CREATE_MYOBJ", "ttlcbasics");
                DBProcedure.create(stmt, "PR_SET_TIMEOUT", "ttlcbasics");
                DBProcedure.create(stmt, "PR_GET_TIMEOUT", "ttlcbasics");
                DBProcedure.create(stmt, "PR_LOCK", "ttlcbasics");
                DBProcedure.create(stmt, "PR_IS_LOCKED", "ttlcbasics");
                DBProcedure.create(stmt, "PR_RELEASE2", "ttlcbasics");
                DBProcedure.create(stmt, "PR_DELETE", "ttlcbasics");
                DBProcedure.create(stmt, "PR_STARTSUBTRANS", "ttlcbasics");
                DBProcedure.create(stmt, "PR_GET_CURRENT_SUBTRANSLEVEL", "ttlcbasics");
                DBProcedure.create(stmt, "PR_COMMIT_SUBTRANS", "ttlcbasics");
                DBProcedure.create(stmt, "PR_ROLLBACK_SUBTRANS", "ttlcbasics");
                DBProcedure.create(stmt, "PR_DBP_GET_DBROOT_SAP_PATH", "ttlcbasics");
                DBProcedure.create(stmt, "PR_DBP_GET_WORKING_DIRECTORY", "ttlcbasics");
                DBProcedure.create(stmt, "PR_READ_ONLY", "ttlcbasics");
                DBProcedure.create(stmt, "PR_RENAME_VERSION", "ttlcbasics");
            }
            catch (Exception e) {
                System.out.println("Error: " + e.getMessage());
            }
            try {
                DBProcedure.create(stmt, "PR_OPEN_MESSAGEFILE", "ttlcbasics");
                DBProcedure.create(stmt, "PR_CLOSE_MESSAGEFILE", "ttlcbasics");
                DBProcedure.create(stmt, "PR_SYNC_MESSAGEFILE", "ttlcbasics");
                DBProcedure.create(stmt, "PR_DROP_MESSAGEFILE", "ttlcbasics");
                DBProcedure.create(stmt, "PR_WRITE_MESSAGEFILE", "ttlcbasics");
                DBProcedure.create(stmt, "PR_EXIST_MESSAGEFILE", "ttlcbasics");
                DBProcedure.create(stmt, "PR_MAX_CRITICAL_SECTIONS", "ttlcbasics");
                DBProcedure.create(stmt, "PR_ENTER_CRITICAL_SECTION", "ttlcbasics");
                DBProcedure.create(stmt, "PR_LEAVE_CRITICAL_SECTION", "ttlcbasics");
            }
            catch (Exception e) {
                System.out.println("Error: " + e.getMessage());
            }
            try {
                DBProcedure.create(stmt, "CREATE_MYOBJ", "ttlcbasics");
                DBProcedure.create(stmt, "UPDATE_MYOBJ", "ttlcbasics");
                DBProcedure.create(stmt, "READ_MYOBJ", "ttlcbasics");
                DBProcedure.create(stmt, "DROP_MYOBJ", "ttlcbasics");
                DBProcedure.create(stmt, "RELEASE_MYOBJ", "ttlcbasics");
                DBProcedure.create(stmt, "RELEASE_MYOBJ_MULTIPLE", "ttlcbasics");
            }
            catch (Exception e) {
                System.out.println("Error: " + e.getMessage());
            }
            try {
                if (TestDriver.compareRelease((String)((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion(), (String)">=", (String)"7.6.0")) {
                    DBProcedure.create(stmt, "INT8_PARAMETER_TEST", "lctest");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (TestDriver.compareRelease((String)((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion(), (String)">=", (String)"7.5.0")) {
                    DBProcedure.create(stmt, "THROW_EXCEPTION", "ttlcbasics");
                    DBProcedure.create(stmt, "THROW_BASE_EXCEPTION", "ttlcbasics");
                }
            }
            catch (Exception e) {
                System.out.println("Error: " + e.getMessage());
            }
            try {
                DBProcedure.create(stmt, "FORCE_AND_WAIT_FOR_CHECKPOINT", "checkpt", 1, "NOWAIT");
            }
            catch (Exception e) {
                // empty catch block
            }
            stmt.enableExceptions(false);
            stmt.execute("CALL DROP_CURRENT_SCHEMA('testteam')");
            stmt.enableExceptions(true);
            stmt.execute("CALL CREATE_CURRENT_SCHEMA('testteam')");
            stmt.execute("CALL CLASS_REGISTER");
            stmt.enableExceptions(false);
            stmt.execute("CALL DELETE_ALL_OBJECTS(0)");
            stmt.enableExceptions(true);
            con.commit();
        }
        catch (Exception e) {
            PrimaryTest.addGlobalMessage((String)"DPProc registration", (char)'E', (String)("SQL Error while registering DBProcedures: " + e.getMessage()));
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            PrimaryTest.addGlobalMessage((String)"DPProc registration", (char)'T', (String)("Exception stack trace: \n" + sw.toString()));
            throw new TestCaseException("PrimaryTest.createDBProcedures() failed");
        }
        finally {
            try {
                stmt.close();
                con.close();
            }
            catch (Exception e) {}
        }
    }

    public String executeDBMCmd(String pCmd) {
        String logon = "";
        String mHost = "";
        String mName = "";
        try {
            mHost = PrimaryTest.getDatabase().getHost();
            mName = PrimaryTest.getDatabase().getName();
            int mPort = PrimaryTest.getDatabase().getPort();
            if (this.mDBMan == null) {
                this.mDBMan = DBM.dbDBM((String)(mHost + ":" + mPort), (String)mName);
                logon = "USER_LOGON DBM,DBM";
                this.mDBMan.cmd(logon);
            }
            return this.mDBMan.cmd(pCmd);
        }
        catch (Exception e) {
            System.out.println("Could not execute: " + pCmd + "\ngot: " + e.getLocalizedMessage());
            return "error";
        }
    }

    protected Connection getConnection(int UserId) throws TestCaseException {
        if (UserId < 1 || UserId > 3) {
            throw new TestCaseException(" UserId " + UserId + " is out of range[1," + 3 + "]");
        }
        return mConnections[UserId - 1];
    }

    private String getInfoString(String pMethodName, int pCounter, int pUser) {
        return "<" + pMethodName + "(), Statement " + pCounter + ", User " + pUser + ">";
    }

    public synchronized int getNextKey() {
        return this.mNextKey++;
    }

    public synchronized int getNextValue() {
        return this.mNextValue++;
    }

    public String getNTCallString() {
        return this.mNTCallString;
    }

    public int getNTErrorCode() {
        return this.mNTErrorCode;
    }

    public String getNTErrorText() {
        return this.mNTErrorText;
    }

    public String getNTInfoString() {
        return this.mNTInfoString;
    }

    public String getNTResultString() {
        return this.mNTResultString;
    }

    protected TestStatement getStatement(int UserId) throws TestCaseException {
        if (UserId < 1 || UserId > 3) {
            throw new TestCaseException(" UserId " + UserId + " is out of range[1," + 3 + "]");
        }
        return mStatements[UserId - 1];
    }

    protected boolean prInt8ParamterTest(int pUserId, long pInputValue1, int pInputValue2, long pExpectedOutPutValue) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String ResultString = "";
        String InfoString = this.getInfoString("prInt8ParamterTest", this.mStatementCounter, pUserId);
        long ResultValue = 0L;
        try {
            Connection con = this.getConnection(pUserId);
            ResultString = CallString = "Call of INT8_PARAMETER_TEST( LONG=" + pInputValue1 + ", INT=" + pInputValue2 + ", LONG = ? )";
            CallableStatement stmt = con.prepareCall("CALL INT8_PARAMETER_TEST( ?, ?, ?)");
            stmt.setLong(1, pInputValue1);
            stmt.setInt(2, pInputValue2);
            stmt.registerOutParameter(3, 2);
            stmt.execute();
            ResultValue = stmt.getLong(3);
            ResultString = CallString + " returned: Value=" + ResultValue + "";
            if (pExpectedOutPutValue != ResultValue) {
                throw new TestCaseException(ResultString + " --> \n expecting Value= " + pExpectedOutPutValue + " \n getting Value  = " + ResultValue);
            }
        }
        catch (SQLException e) {
            throw new TestCaseException(ResultString + " --> \n expecting Value: " + pExpectedOutPutValue + " \n getting: " + e.getLocalizedMessage());
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(ResultString + " --> OK"));
        return true;
    }

    protected boolean prCheckObject(int pUserId, Oid pOid, int pExpectedKey, int pExpectedValue) throws TestCaseException {
        return this.prCheckObject(pUserId, pOid, pExpectedKey, pExpectedValue, 0);
    }

    protected boolean prCheckObject(int pUserId, Oid pOid, int pExpectedKey, int pExpectedValue, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        int ResultKey = 0;
        int ResultValue = 0;
        String CallString = "";
        String ResultString = "";
        String InfoString = this.getInfoString("prCheckObject", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            ResultString = CallString = "Call of GET_OBJECT ( OID=" + pOid.toString() + ", Counter=" + this.mStatementCounter + " )";
            CallableStatement stmt = con.prepareCall("CALL GET_OBJECT ( ?, " + this.mStatementCounter + ", ?, ?)");
            stmt.setBytes(1, pOid.getOmsOid());
            stmt.registerOutParameter(2, 4);
            stmt.registerOutParameter(3, 4);
            stmt.execute();
            ResultKey = stmt.getInt(2);
            ResultValue = stmt.getInt(3);
            ResultString = CallString + "returned: ( Key=" + ResultKey + ", Value=" + ResultValue + " )";
            if (pExpectedKey != ResultKey || pExpectedValue != ResultValue) {
                PrimaryTest.addGlobalMessage((String)InfoString, (char)'E', (String)("***** ERROR ****** " + ResultString + " --> expecting ( Key=" + pExpectedKey + ", Value=" + pExpectedValue + " )"));
                throw new TestCaseException(ResultString + " --> expecting ( Key=" + pExpectedKey + ", Value=" + pExpectedValue + " )");
            }
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return true;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(ResultString + " --> OK"));
        return true;
    }

    public int prCheckObjectGetErrorCode(int pUserId, Oid pOid, int pExpectedKey, int pExpectedValue, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        int ResultKey = 0;
        int ResultValue = 0;
        this.mNTCallString = "";
        this.mNTResultString = "";
        this.mNTInfoString = this.getInfoString("prCheckObject", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            this.mNTResultString = this.mNTCallString = "Call of GET_OBJECT ( OID=" + pOid.toString() + ", Counter=" + this.mStatementCounter + " )";
            CallableStatement stmt = con.prepareCall("CALL GET_OBJECT ( ?, " + this.mStatementCounter + ", ?, ?)");
            stmt.setBytes(1, pOid.getOmsOid());
            stmt.registerOutParameter(2, 4);
            stmt.registerOutParameter(3, 4);
            stmt.execute();
            ResultKey = stmt.getInt(2);
            ResultValue = stmt.getInt(3);
            this.mNTResultString = this.mNTCallString + "returned: ( Key=" + ResultKey + ", Value=" + ResultValue + " )";
            if (pExpectedKey != ResultKey || pExpectedValue != ResultValue) {
                PrimaryTest.addGlobalMessage((String)this.mNTInfoString, (char)'E', (String)("***** ERROR ****** " + this.mNTResultString + " --> expecting ( Key=" + pExpectedKey + ", Value=" + pExpectedValue + " )"));
                return 0;
            }
        }
        catch (SQLException e) {
            this.mNTErrorCode = e.getErrorCode();
            this.mNTErrorText = e.getMessage();
            if (pExpectedResultCode == this.mNTErrorCode) {
                PrimaryTest.addGlobalMessage((String)this.mNTInfoString, (char)'I', (String)(this.mNTCallString + " - Expected error: " + e.getMessage() + " --> OK"));
            }
            return this.mNTErrorCode;
        }
        PrimaryTest.addGlobalMessage((String)this.mNTInfoString, (char)'I', (String)(this.mNTResultString + " --> OK"));
        return pExpectedResultCode;
    }

    protected void prCheckSubtrans(int pUserId, int pKey) throws TestCaseException {
        this.prCheckSubtrans(pUserId, pKey, 10, 0);
    }

    protected void prCheckSubtrans(int pUserId, int pKey, int pRequestTimeout, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prCheckSubtrans", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "CALL CHECK_SUBTRANS ( Key=" + pKey + ", Counter=" + this.mStatementCounter + ", Timeout=" + pRequestTimeout + ")";
            CallableStatement stmt = con.prepareCall("CALL CHECK_SUBTRANS (" + pKey + ", " + this.mStatementCounter + ", " + pRequestTimeout + ")");
            stmt.execute();
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected boolean prCheckValue(int pUserId, int pKey, int pExpectedValue) throws TestCaseException {
        return this.prCheckValue(pUserId, pKey, pExpectedValue, 0);
    }

    protected boolean prCheckValue(int pUserId, int pKey, int pExpectedValue, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        int ResultValue = 0;
        String CallString = "";
        String ResultString = "";
        String InfoString = this.getInfoString("prCheckValue", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of GET_OBJECT_VALUE ( Key=" + pKey + ", Counter=" + this.mStatementCounter + " )";
            CallableStatement stmt = con.prepareCall("CALL GET_OBJECT_VALUE ( " + pKey + ", " + this.mStatementCounter + ", ?)");
            stmt.registerOutParameter(1, 4);
            stmt.execute();
            ResultValue = stmt.getInt(1);
            ResultString = CallString + " returned: ( Value=" + ResultValue + " )";
            if (ResultValue != pExpectedValue) {
                PrimaryTest.addGlobalMessage((String)InfoString, (char)'E', (String)("***** ERROR ****** " + ResultString + " --> expecting value " + pExpectedValue));
                throw new TestCaseException(ResultString + " --> expecting value " + pExpectedValue);
            }
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode, e);
            return true;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(ResultString + " --> OK"));
        return true;
    }

    protected void prCloseConsistentView(int pUserId, String pViewName) throws TestCaseException {
        this.prCloseConsistentView(pUserId, pViewName, 0);
    }

    protected void prCloseConsistentView(int pUserId, String pViewName, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prCloseConsistentView", this.mStatementCounter, pUserId);
        try {
            TestStatement stmt = this.getStatement(pUserId);
            CallString = "Call of CLOSE_CONSIST_VIEW ( View=" + pViewName + ", Counter=" + this.mStatementCounter + " )";
            stmt.execute("CALL CLOSE_CONSIST_VIEW ('" + pViewName + "', " + this.mStatementCounter + ")");
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected void prCommit(int pUserId) throws TestCaseException {
        ++this.mStatementCounter;
        String InfoString = this.getInfoString("prCommit", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            con.commit();
            if (this.mTrace) {
                PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)"Commit --> OK");
            }
        }
        catch (Exception e) {
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'E', (String)("***** ERROR ****** Could not commit: " + e.getMessage()));
            throw new TestCaseException("Error in Primary test");
        }
    }

    protected void prCreateConsistentView(int pUserId, String pViewName) throws TestCaseException {
        this.prCreateConsistentView(pUserId, pViewName, 0);
    }

    protected void prCreateConsistentView(int pUserId, String pViewName, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prCreateConsistentView", this.mStatementCounter, pUserId);
        try {
            TestStatement stmt = this.getStatement(pUserId);
            CallString = "Call of CREATE_CONSIST_VIEW ( View=" + pViewName + ", Counter=" + this.mStatementCounter + " )";
            stmt.execute("CALL CREATE_CONSIST_VIEW ('" + pViewName + "', " + this.mStatementCounter + ")");
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected void prCreateVersion(int pUserId, String pVersionName, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prCreateVersion", this.mStatementCounter, pUserId);
        try {
            TestStatement stmt = this.getStatement(pUserId);
            CallString = "Call of PR_CREATE_VERSION1 (Version=" + pVersionName + ", Counter=" + this.mStatementCounter + ")";
            stmt.execute("CALL PR_CREATE_VERSION1 ('" + pVersionName + "', " + this.mStatementCounter + ")");
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected void prCreateVersion(int pUserId, String pVersionName, String pDesc, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prCreateVersion", this.mStatementCounter, pUserId);
        try {
            TestStatement stmt = this.getStatement(pUserId);
            CallString = "Call of PR_CREATE_VERSION2 (Version=" + pVersionName + ", Description=" + pDesc + ", Counter=" + this.mStatementCounter + ")";
            stmt.execute("CALL PR_CREATE_VERSION2 ('" + pVersionName + "', '" + pDesc + "', " + this.mStatementCounter + ")");
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected void prOpenVersion(int pUserId, String pVersionName, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prOpenVersion", this.mStatementCounter, pUserId);
        try {
            TestStatement stmt = this.getStatement(pUserId);
            CallString = "Call of PR_OPEN_VERSION (Version=" + pVersionName + ", Counter=" + this.mStatementCounter + ")";
            stmt.execute("CALL PR_OPEN_VERSION ('" + pVersionName + "', " + this.mStatementCounter + ")");
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected void prCloseVersion(int pUserId, String pVersionName, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prCloseVersion", this.mStatementCounter, pUserId);
        try {
            TestStatement stmt = this.getStatement(pUserId);
            CallString = "Call of PR_CLOSE_VERSION (Version=" + pVersionName + ", Counter=" + this.mStatementCounter + ")";
            stmt.execute("CALL PR_CLOSE_VERSION ('" + pVersionName + "', " + this.mStatementCounter + ")");
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected void prRenameVersion(int pUserId, String pOldVersionName, String pNewVersionName, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prRenameVersion", this.mStatementCounter, pUserId);
        try {
            TestStatement stmt = this.getStatement(pUserId);
            CallString = "Call of PR_RENAME_VERSION (OldVersion=" + pOldVersionName + ", NewVersion=" + pNewVersionName + ", Counter=" + this.mStatementCounter + ")";
            stmt.execute("CALL PR_RENAME_VERSION ('" + pOldVersionName + "', '" + pNewVersionName + "'," + this.mStatementCounter + ")");
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected String prGetVersionInfo(int pUserId, String pVersionName, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prGetVersionInfo", this.mStatementCounter, pUserId);
        boolean success = false;
        String desc = null;
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of PR_GET_VERSION_INFO (Version=" + pVersionName + ", Counter=" + this.mStatementCounter + ")";
            CallableStatement stmt = con.prepareCall("CALL PR_GET_VERSION_INFO('" + pVersionName + "', ?, ?, " + this.mStatementCounter + ")");
            stmt.registerOutParameter(1, 4);
            stmt.registerOutParameter(2, 1);
            stmt.execute();
            success = stmt.getInt(1) != 0;
            desc = stmt.getString(2);
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return null;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
        if (success) {
            return desc.trim();
        }
        return null;
    }

    protected String prCurrentVersionId(int pUserId, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prCurrentVersionId", this.mStatementCounter, pUserId);
        String versionId = null;
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of PR_CURRENT_VERSION_ID (Counter=" + this.mStatementCounter + ")";
            CallableStatement stmt = con.prepareCall("CALL PR_CURRENT_VERSION_ID(?, " + this.mStatementCounter + ")");
            stmt.registerOutParameter(1, 1);
            stmt.execute();
            versionId = stmt.getString(1);
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return null;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
        return versionId.trim();
    }

    protected boolean prExistsVersion(int pUserId, String pVersionName, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prExistsVersion", this.mStatementCounter, pUserId);
        boolean success = false;
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of PR_EXISTS_VERSION (Version=" + pVersionName + ", Counter=" + this.mStatementCounter + ")";
            CallableStatement stmt = con.prepareCall("CALL PR_EXISTS_VERSION('" + pVersionName + "', ?, " + this.mStatementCounter + ")");
            stmt.registerOutParameter(1, 4);
            stmt.execute();
            success = stmt.getInt(1) != 0;
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return false;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
        return success;
    }

    protected void prDropVersion(int pUserId, String pVersionName, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prDropVersion", this.mStatementCounter, pUserId);
        try {
            TestStatement stmt = this.getStatement(pUserId);
            CallString = "Call of PR_DROP_VERSION (Version=" + pVersionName + ", Counter=" + this.mStatementCounter + ")";
            stmt.execute("CALL PR_DROP_VERSION ('" + pVersionName + "', " + this.mStatementCounter + ")");
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected void prForceDropVersion(int pUserId, String pVersionName, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prForceDropVersion", this.mStatementCounter, pUserId);
        try {
            TestStatement stmt = this.getStatement(pUserId);
            CallString = "Call of PR_FORCE_DROP_VERSION (Version=" + pVersionName + ", Counter=" + this.mStatementCounter + ")";
            stmt.execute("CALL PR_FORCE_DROP_VERSION ('" + pVersionName + "', " + this.mStatementCounter + ")");
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected void prSetCurrVersionDesc(int pUserId, String pDesc, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prSetCurrVersionDesc", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of PR_SET_CURR_VERSION_DESC (Description=" + pDesc + ", Counter=" + this.mStatementCounter + ")";
            CallableStatement stmt = con.prepareCall("CALL PR_SET_CURR_VERSION_DESC(?, " + this.mStatementCounter + ")");
            if (pDesc == null) {
                pDesc = "";
            }
            stmt.setString(1, pDesc);
            stmt.execute();
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected int prStartSubtrans(int pUserId, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prStartSubtrans", this.mStatementCounter, pUserId);
        int success = -1;
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of PR_STARTSUBTRANS (Counter=" + this.mStatementCounter + ")";
            CallableStatement stmt = con.prepareCall("CALL PR_STARTSUBTRANS(?, " + this.mStatementCounter + ")");
            stmt.registerOutParameter(1, 4);
            stmt.execute();
            success = stmt.getInt(1);
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return -1;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
        return success;
    }

    protected int prCurrentSubtransLevel(int pUserId, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prCurrentSubtransLevel", this.mStatementCounter, pUserId);
        int subtransLev = -1;
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of PR_GET_CURRENT_SUBTRANSLEVEL (Counter=" + this.mStatementCounter + ")";
            CallableStatement stmt = con.prepareCall("CALL PR_GET_CURRENT_SUBTRANSLEVEL(?, " + this.mStatementCounter + ")");
            stmt.registerOutParameter(1, 4);
            stmt.execute();
            subtransLev = stmt.getInt(1);
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return -1;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
        return subtransLev;
    }

    protected void prCommitSubtrans(int pUserId, int pSubtransLev, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prCommitSubtrans", this.mStatementCounter, pUserId);
        try {
            TestStatement stmt = this.getStatement(pUserId);
            CallString = "Call of PR_COMMIT_SUBTRANS ( SubtransLevel=" + pSubtransLev + ", Counter=" + this.mStatementCounter + " )";
            stmt.execute("CALL PR_COMMIT_SUBTRANS (" + pSubtransLev + ", " + this.mStatementCounter + ")");
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected void prRollbackSubtrans(int pUserId, int pSubtransLev, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prRollbackSubtrans", this.mStatementCounter, pUserId);
        try {
            TestStatement stmt = this.getStatement(pUserId);
            CallString = "Call of PR_ROLLBACK_SUBTRANS ( SubtransLevel=" + pSubtransLev + ", Counter=" + this.mStatementCounter + " )";
            stmt.execute("CALL PR_ROLLBACK_SUBTRANS (" + pSubtransLev + ", " + this.mStatementCounter + ")");
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected void prReadOnly(int pUserId, boolean pReadOnly, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prReadOnly", this.mStatementCounter, pUserId);
        try {
            TestStatement stmt = this.getStatement(pUserId);
            CallString = "Call of PR_READ_ONLY (ReadOnly=" + pReadOnly + ", Counter=" + this.mStatementCounter + ")";
            stmt.execute("CALL PR_READ_ONLY (" + pReadOnly + ", " + this.mStatementCounter + ")");
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected void prCreateContainer(int pUserId, int pClass, String pSchemaName, int pContainerNo, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prCreateContainer", this.mStatementCounter, pUserId);
        try {
            TestStatement stmt = this.getStatement(pUserId);
            CallString = "Call of CREATE_CONTAINER (Class=" + pClass + ", Schema=" + pSchemaName + ", Container=" + pContainerNo + ", Counter=" + this.mStatementCounter + ")";
            stmt.execute("CALL CREATE_CONTAINER (" + pClass + ", '" + pSchemaName + "', " + pContainerNo + ")");
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        if (this.mTrace) {
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
        }
    }

    protected Oid prCreateMyvarobj(int pUserId, String schemaName, int containerNo, int length, int pExpectedResultCode) throws TestCaseException {
        Oid oid;
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prCreateMyvarobj", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of CREATE_MYVAROBJ (Schema=" + schemaName + ", Container=" + containerNo + ", Length=" + length + ", Counter=" + this.mStatementCounter + ")";
            CallableStatement stmt = con.prepareCall("CALL CREATE_MYVAROBJ('" + schemaName + "', " + containerNo + ", ?, " + length + ")");
            stmt.registerOutParameter(1, -2);
            stmt.execute();
            oid = new Oid(stmt.getBytes(1));
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return null;
        }
        if (this.mTrace) {
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
        }
        return oid;
    }

    protected void prReadMyvarobj(int pUserId, String schemaName, int containerNo, Oid oid, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prReadMyvarobj", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of READ_MYVAROBJ (Schema=" + schemaName + ", Container=" + containerNo + ", OID=" + oid.getPno() + "," + oid.getPagePos() + "," + oid.getClassId() + ", Counter=" + this.mStatementCounter + ")";
            CallableStatement stmt = con.prepareCall("CALL READ_MYVAROBJ('" + schemaName + "', " + containerNo + ", ?, ?, ?)");
            stmt.setBytes(1, oid.getOmsOid());
            stmt.registerOutParameter(2, 4);
            stmt.registerOutParameter(3, 4);
            stmt.execute();
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        if (this.mTrace) {
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
        }
    }

    protected int[] prReadMyvarobj(int pUserId, String schemaName, int containerNo, Oid oid, int pExpectedResultCode, boolean pReturnSomething) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "" + pReturnSomething;
        String InfoString = this.getInfoString("prReadMyvarobj", this.mStatementCounter, pUserId);
        int[] resultLengthChecksum = new int[2];
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of READ_MYVAROBJ (Schema=" + schemaName + ", Container=" + containerNo + ", OID=" + oid.getPno() + "," + oid.getPagePos() + "," + oid.getClassId() + ", Counter=" + this.mStatementCounter + ")";
            CallableStatement stmt = con.prepareCall("CALL READ_MYVAROBJ('" + schemaName + "', " + containerNo + ", ?, ?, ?)");
            stmt.setBytes(1, oid.getOmsOid());
            stmt.registerOutParameter(2, 4);
            stmt.registerOutParameter(3, 4);
            stmt.execute();
            resultLengthChecksum[0] = stmt.getInt(2);
            resultLengthChecksum[1] = stmt.getInt(3);
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return null;
        }
        if (this.mTrace) {
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
        }
        return resultLengthChecksum;
    }

    protected void prUpdateMyvarobj(int pUserId, String schemaName, int containerNo, Oid oid, int length, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prUpdateMyvarobj", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of UPDATE_MYVAROBJ (Schema=" + schemaName + ", Container=" + containerNo + ", OID= " + oid.getPno() + "," + oid.getPagePos() + "," + oid.getClassId() + ", Length=" + length + ", Counter=" + this.mStatementCounter + ")";
            CallableStatement stmt = con.prepareCall("CALL UPDATE_MYVAROBJ('" + schemaName + "', " + containerNo + ", ?, " + length + ")");
            stmt.setBytes(1, oid.getOmsOid());
            stmt.execute();
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        if (this.mTrace) {
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
        }
    }

    protected void prRelease(int pUserId, Oid oid, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prRelease", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of PR_RELEASE (OID= " + oid.getPno() + "," + oid.getPagePos() + "," + oid.getClassId() + ", Counter=" + this.mStatementCounter + ")";
            CallableStatement stmt = con.prepareCall("CALL PR_RELEASE(?, " + this.mStatementCounter + ")");
            stmt.setBytes(1, oid.getOmsOid());
            stmt.execute();
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected Oid prCreateMyobj(int pUserId, String schemaName, int containerNo, int value, int pExpectedResultCode) throws TestCaseException {
        Oid oid;
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prCreateMyobj", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of PR_CREATE_MYOBJ (Schema=" + schemaName + ", Container=" + containerNo + ", Value=" + value + ", Counter=" + this.mStatementCounter + ")";
            CallableStatement stmt = con.prepareCall("CALL PR_CREATE_MYOBJ('" + schemaName + "', " + containerNo + ", " + value + ", ?, " + this.mStatementCounter + ")");
            stmt.registerOutParameter(1, -2);
            stmt.execute();
            oid = new Oid(stmt.getBytes(1));
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return null;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
        return oid;
    }

    protected void prSetTimeout(int pUserId, int pTime, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prSetTimeOut", this.mStatementCounter, pUserId);
        try {
            TestStatement stmt = this.getStatement(pUserId);
            CallString = "Call of PR_SET_TIMEOUT (Time=" + pTime + ", Counter=" + this.mStatementCounter + ")";
            stmt.execute("CALL PR_SET_TIMEOUT (" + pTime + ", " + this.mStatementCounter + ")");
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected int prGetTimeout(int pUserId, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prGetTimeout", this.mStatementCounter, pUserId);
        int time = 0;
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of PR_GET_TIMEOUT (Counter=" + this.mStatementCounter + ")";
            CallableStatement stmt = con.prepareCall("CALL PR_GET_TIMEOUT(?, " + this.mStatementCounter + ")");
            stmt.registerOutParameter(1, 4);
            stmt.execute();
            time = stmt.getInt(1);
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return -1;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
        return time;
    }

    protected void prLock(int pUserId, Oid oid, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prLock", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of PR_LOCK (OID= " + oid.getPno() + "," + oid.getPagePos() + "," + oid.getClassId() + ", Counter=" + this.mStatementCounter + ")";
            CallableStatement stmt = con.prepareCall("CALL PR_LOCK(?, " + this.mStatementCounter + ")");
            stmt.setBytes(1, oid.getOmsOid());
            stmt.execute();
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected boolean prIsLocked(int pUserId, Oid oid, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prIsLocked", this.mStatementCounter, pUserId);
        boolean isLocked = false;
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of PR_IS_LOCKED (OID= " + oid.getPno() + "," + oid.getPagePos() + "," + oid.getClassId() + ", Counter=" + this.mStatementCounter + ")";
            CallableStatement stmt = con.prepareCall("CALL PR_IS_LOCKED(?, ?, " + this.mStatementCounter + ")");
            stmt.setBytes(1, oid.getOmsOid());
            stmt.registerOutParameter(2, 4);
            stmt.execute();
            isLocked = stmt.getInt(2) != 0;
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return false;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
        return isLocked;
    }

    protected void prRelease2(int pUserId, Oid oid, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prRelease2", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of PR_RELEASE2 (OID= " + oid.getPno() + "," + oid.getPagePos() + "," + oid.getClassId() + ", Counter=" + this.mStatementCounter + ")";
            CallableStatement stmt = con.prepareCall("CALL PR_RELEASE2(?, " + this.mStatementCounter + ")");
            stmt.setBytes(1, oid.getOmsOid());
            stmt.execute();
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected void prDelete(int pUserId, Oid oid, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prDelete", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of PR_DELETE (OID= " + oid.getPno() + "," + oid.getPagePos() + "," + oid.getClassId() + ", Counter=" + this.mStatementCounter + ")";
            CallableStatement stmt = con.prepareCall("CALL PR_DELETE(?, " + this.mStatementCounter + ")");
            stmt.setBytes(1, oid.getOmsOid());
            stmt.execute();
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected String prDbpGetDbrootSapPath(int pUserId, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prDbpGetDbrootSapPath", this.mStatementCounter, pUserId);
        String path = null;
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of PR_DBP_GET_DBROOT_SAP_PATH (Counter=" + this.mStatementCounter + ")";
            CallableStatement stmt = con.prepareCall("CALL PR_DBP_GET_DBROOT_SAP_PATH(?, " + this.mStatementCounter + ")");
            stmt.registerOutParameter(1, 1);
            stmt.execute();
            path = stmt.getString(1);
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return null;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
        return path.trim();
    }

    protected String prDbpGetWorkingDirectory(int pUserId, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prDbpGetWorkingDirectory", this.mStatementCounter, pUserId);
        String path = null;
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of PR_DBP_GET_WORKING_DIRECTORY (Counter=" + this.mStatementCounter + ")";
            CallableStatement stmt = con.prepareCall("CALL PR_DBP_GET_WORKING_DIRECTORY(?, " + this.mStatementCounter + ")");
            stmt.registerOutParameter(1, 1);
            stmt.execute();
            path = stmt.getString(1);
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return null;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
        return path.trim();
    }

    protected void prCreateObject(int pUserId, int pKey, int pValue) throws TestCaseException {
        this.prCreateObject(pUserId, pKey, pValue, 10, 0);
    }

    protected void prCreateObject(int pUserId, int pKey, int pValue, int pRequestTimeout, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prCreateObject", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallableStatement stmt = con.prepareCall("CALL CREATE_OBJECT (" + pKey + ", " + pValue + ", " + pRequestTimeout + ", " + this.mStatementCounter + ")");
            CallString = "Call of CREATE_OBJECT ( Key=" + pKey + ", Value=" + pValue + ", Timeout=" + pRequestTimeout + ", Counter=" + this.mStatementCounter + " )";
            stmt.execute();
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        if (this.mTrace) {
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
        }
    }

    protected boolean prCreateObjects(int pUserId, int pNumberOfObjects) throws TestCaseException {
        for (int i = 0; i < pNumberOfObjects; ++i) {
            this.prCreateObject(pUserId, this.mNextKey++, this.mNextValue++);
        }
        return true;
    }

    protected void prDeleteAllObjects(int pUserId) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String ResultString = "";
        String InfoString = this.getInfoString("prDeleteAllObjects", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "CALL DELETE_ALL_OBJECTS ( Counter=" + this.mStatementCounter + " )";
            CallableStatement stmt = con.prepareCall("CALL DELETE_ALL_OBJECTS (" + this.mStatementCounter + ")");
            stmt.execute();
            ResultString = CallString;
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, 0, e);
            return;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(ResultString + " --> OK"));
    }

    protected void prDeleteObject(int pUserId, int pKey) throws TestCaseException {
        this.prDeleteObject(pUserId, pKey, 10, 0);
    }

    protected void prDeleteObject(int pUserId, int pKey, int pRequestTimeout, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String ResultString = "";
        String InfoString = this.getInfoString("prDeleteObject", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "CALL DELETE_OBJECT ( Key=" + pKey + ", Counter=" + this.mStatementCounter + ", Timeout=" + pRequestTimeout + " )";
            CallableStatement stmt = con.prepareCall("CALL DELETE_OBJECT (" + pKey + ", " + this.mStatementCounter + ", " + pRequestTimeout + ")");
            stmt.execute();
            ResultString = CallString;
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode, e);
            return;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(ResultString + " --> OK"));
    }

    protected void prDropConsistentView(int pUserId, String pViewName) throws TestCaseException {
        this.prDropConsistentView(pUserId, pViewName, 0);
    }

    protected void prDropConsistentView(int pUserId, String pViewName, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prDropConsistentView", this.mStatementCounter, pUserId);
        try {
            TestStatement stmt = this.getStatement(pUserId);
            CallString = "Call of DROP_CONSIST_VIEW ( View=" + pViewName + ", Counter=" + this.mStatementCounter + " )";
            stmt.execute("CALL DROP_CONSIST_VIEW ('" + pViewName + "', " + this.mStatementCounter + ")");
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    public static long getTimeout() {
        return 900000L;
    }

    public static void prepare() throws TestCaseException {
        Connection lDefConnection = null;
        TestStatement lDefTstmt = null;
        try {
            block16: {
                TestCase.setInfoMessageFilter((boolean)false);
                try {
                    lDefConnection = PrimaryTest.getDatabase().connect(PrimaryTest.getDatabase().getDBAUser(), PrimaryTest.getDatabase().getDBAPassword());
                }
                catch (Exception e) {
                    PrimaryTest.addGlobalMessage((String)"Login failure", (char)'E', (String)("DBAUser: " + PrimaryTest.getDatabase().getDBAUser() + ", Password: " + PrimaryTest.getDatabase().getDBAPassword()));
                    throw e;
                }
                lDefTstmt = new TestStatement(null, lDefConnection);
                lDefTstmt.enableExceptions(false);
                try {
                    if (((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion().startsWith("7.2")) {
                        lDefTstmt.executeUpdate("enable write transaction");
                    }
                }
                catch (TestDatabaseException e) {
                    throw new TestDatabaseException((Exception)((Object)e), "Could not retrieve kernel version");
                }
                lDefTstmt.executeUpdate("drop user UPRIMARY");
                lDefTstmt.enableExceptions(true);
                try {
                    lDefTstmt.executeUpdate("Create user UPRIMARY password UPRIMARY dba not exclusive");
                }
                catch (DatabaseException e) {
                    if (e.getErrorCode() == -6006) break block16;
                    PrimaryTest.addGlobalMessage((String)"Init failure", (char)'E', (String)"Creation of user : UPRIMARY not possible");
                    throw e;
                }
            }
            PrimaryTest.readParameters();
            PrimaryTest.createDBProcedures();
            PrimaryTest.createConnections();
        }
        catch (Exception e) {
            throw (TestCaseException)((Object)e);
        }
        finally {
            try {
                lDefTstmt.close();
                lDefConnection.close();
            }
            catch (Exception e) {}
        }
    }

    protected void prForceAndWaitForCheckpoint(int pUserId) throws TestCaseException {
        this.prForceAndWaitForCheckpoint(pUserId, 0);
    }

    protected void prForceAndWaitForCheckpoint(int pUserId, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String InfoString = this.getInfoString("prForceAndWaitForCheckpoint", this.mStatementCounter, pUserId);
        String CallString = "";
        String ResultString = "";
        try {
            TestStatement stmt = this.getStatement(pUserId);
            CallString = "CALL FORCE_AND_WAIT_FOR_CHECKPOINT()";
            stmt.execute("CALL FORCE_AND_WAIT_FOR_CHECKPOINT");
            ResultString = CallString;
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode, e);
            return;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(ResultString + " --> OK"));
    }

    protected int prGetKey(int pUserId, Oid pOid) throws TestCaseException {
        return this.prGetKey(pUserId, pOid, 0);
    }

    protected int prGetKey(int pUserId, Oid pOid, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        int ResultKey = 0;
        int ResultValue = 0;
        String CallString = "";
        String ResultString = "";
        String InfoString = this.getInfoString("prGetKey", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of GET_OBJECT ( OID=" + pOid.toString() + ", Counter=" + this.mStatementCounter + " )";
            CallableStatement stmt = con.prepareCall("CALL GET_OBJECT ( ?, " + this.mStatementCounter + ", ?, ?)");
            stmt.setBytes(1, pOid.getOmsOid());
            stmt.registerOutParameter(2, 4);
            stmt.registerOutParameter(3, 4);
            stmt.execute();
            ResultKey = stmt.getInt(2);
            ResultValue = stmt.getInt(3);
            ResultString = CallString + "returned: ( Key=" + ResultKey + ", Value=" + ResultValue + " )";
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode, e);
            return -1;
        }
        if (this.mTrace) {
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(ResultString + " --> OK"));
        }
        return ResultKey;
    }

    protected Oid prGetOid(int pUserId, int pKey) throws TestCaseException {
        return this.prGetOid(pUserId, pKey, 0);
    }

    protected Oid prGetOid(int pUserId, int pKey, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String ResultString = "";
        String InfoString = this.getInfoString("prGetOid", this.mStatementCounter, pUserId);
        Oid pOid = new Oid();
        try {
            Connection con = this.getConnection(pUserId);
            CallableStatement stmt = con.prepareCall("CALL GET_OID (" + pKey + ", " + this.mStatementCounter + ", ?)");
            CallString = "Call of GET_OID ( Key=" + pKey + ", Counter=" + this.mStatementCounter + " )";
            stmt.registerOutParameter(1, -2);
            stmt.execute();
            pOid.setOmsOid(stmt.getBytes(1));
            ResultString = CallString + "returned: ( OID=" + pOid.toString() + " )";
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode, e);
            return null;
        }
        if (this.mTrace) {
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(ResultString + " --> OK"));
        }
        return pOid;
    }

    protected int prGetValue(int pUserId, int pKey) throws TestCaseException {
        return this.prGetValue(pUserId, pKey);
    }

    protected int prGetValue(int pUserId, int pKey, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        int ResultValue = 0;
        String CallString = "";
        String ResultString = "";
        String InfoString = this.getInfoString("prGetValue", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of GET_OBJECT_VALUE ( Key=" + pKey + ", Counter=" + this.mStatementCounter + " )";
            CallableStatement stmt = con.prepareCall("CALL GET_OBJECT_VALUE ( " + pKey + ", " + this.mStatementCounter + ", ?)");
            stmt.registerOutParameter(1, 4);
            stmt.execute();
            ResultValue = stmt.getInt(1);
            ResultString = CallString + "returned: ( Value=" + ResultValue + " )";
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode, e);
            return -1;
        }
        if (this.mTrace) {
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(ResultString + " --> OK"));
        }
        return ResultValue;
    }

    protected int prGetValue(int pUserId, Oid pOid) throws TestCaseException {
        return this.prGetValue(pUserId, pOid, 0);
    }

    protected int prGetValue(int pUserId, Oid pOid, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        int ResultKey = 0;
        int ResultValue = 0;
        String CallString = "";
        String ResultString = "";
        String InfoString = this.getInfoString("prGetValue", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of GET_OBJECT ( OID=" + pOid.toString() + ", Counter=" + this.mStatementCounter + " )";
            CallableStatement stmt = con.prepareCall("CALL GET_OBJECT ( ?, " + this.mStatementCounter + ", ?, ?)");
            stmt.setBytes(1, pOid.getOmsOid());
            stmt.registerOutParameter(2, 4);
            stmt.registerOutParameter(3, 4);
            stmt.execute();
            ResultKey = stmt.getInt(2);
            ResultValue = stmt.getInt(3);
            ResultString = CallString + "returned: ( Key=" + ResultKey + ", Value=" + ResultValue + " )";
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode, e);
            return -1;
        }
        if (this.mTrace) {
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(ResultString + " --> OK"));
        }
        return ResultValue;
    }

    protected void printTestError(PrimaryTest pCallerClass) {
    }

    protected void printTestHeader(PrimaryTest pCallerClass) {
    }

    protected void printTestTrailer(PrimaryTest pCallerClass) {
    }

    protected boolean prObjectExists(int pUserId, int pKey) throws TestCaseException {
        return this.prObjectExists(pUserId, pKey, 0);
    }

    protected boolean prObjectExists(int pUserId, int pKey, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        int ResultValue = 0;
        String CallString = "";
        String ResultString = "";
        String InfoString = this.getInfoString("prObjectExists", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of GET_OBJECT_VALUE ( Key=" + pKey + ", Counter=" + this.mStatementCounter + " )";
            CallableStatement stmt = con.prepareCall("CALL GET_OBJECT_VALUE ( " + pKey + ", " + this.mStatementCounter + ", ?)");
            stmt.registerOutParameter(1, 4);
            stmt.execute();
            ResultValue = stmt.getInt(1);
            ResultString = CallString;
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode, e);
            return false;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(ResultString + " --> OK (value: " + ResultValue + ")"));
        return true;
    }

    protected void prOpenConsistentView(int pUserId, String pViewName) throws TestCaseException {
        this.prOpenConsistentView(pUserId, pViewName, 0);
    }

    protected void prOpenConsistentView(int pUserId, String pViewName, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prOpenConsistentView", this.mStatementCounter, pUserId);
        try {
            TestStatement stmt = this.getStatement(pUserId);
            CallString = "Call of OPEN_CONSIST_VIEW ( View=" + pViewName + ", Counter=" + this.mStatementCounter + " )";
            stmt.execute("CALL OPEN_CONSIST_VIEW ('" + pViewName + "', " + this.mStatementCounter + ")");
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected void prReconnect(int pUserId) throws TestCaseException {
        String InfoString = this.getInfoString("prReconnect", this.mStatementCounter++, pUserId);
        try {
            if (pUserId < 1 || pUserId > 3) {
                throw new TestCaseException("Illegal user number: " + pUserId);
            }
            mConnections[--pUserId].close();
            mStatements[pUserId].close();
            PrimaryTest.mConnections[pUserId] = PrimaryTest.getDatabase().connect("UPRIMARY", "UPRIMARY");
            mConnections[pUserId].setAutoCommit(false);
            PrimaryTest.mStatements[pUserId] = new TestStatement(null, mConnections[pUserId]);
            mStatements[pUserId].execute("CALL SET_CURRENT_SCHEMA('testteam')");
            mStatements[pUserId].execute("CALL CLASS_REGISTER");
            mConnections[pUserId].commit();
        }
        catch (Exception e) {
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'E', (String)("***** ERROR ****** Reconnect for user " + pUserId + " failed: " + e.getMessage()));
            throw new TestCaseException("Error in Primary test");
        }
    }

    protected void prRollback(int pUserId) throws TestCaseException {
        ++this.mStatementCounter;
        String InfoString = this.getInfoString("prRollback", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            con.rollback();
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)"Rollback --> OK");
        }
        catch (Exception e) {
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'E', (String)("Could not rollback: " + e.getMessage()));
            throw new TestCaseException("Error in Primary test");
        }
    }

    protected void prUpdateObject(int pUserId, int pKey, int pNewValue) throws TestCaseException {
        this.prUpdateObject(pUserId, pKey, pNewValue, 10, 0);
    }

    protected void prUpdateObject(int pUserId, int pKey, int pNewValue, int pRequestTimeout, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String ResultString = "";
        String InfoString = this.getInfoString("prUpdateObject", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallableStatement stmt = con.prepareCall("CALL UPDATE_OBJECT (" + pKey + ", " + pNewValue + ", " + this.mStatementCounter + ", " + pRequestTimeout + ")");
            CallString = "CALL UPDATE_OBJECT ( Key=" + pKey + ", Value=" + pNewValue + ", Counter=" + this.mStatementCounter + ", Timeout=" + pRequestTimeout + " )";
            stmt.execute();
            ResultString = CallString;
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode, e);
            return;
        }
        if (this.mTrace) {
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(ResultString + " --> OK"));
        }
    }

    private static void readParameters() throws TestCaseException {
    }

    public void run() {
    }

    void setNTCallString(String newNTCallString) {
        this.mNTCallString = newNTCallString;
    }

    void setNTErrorCode(int newNTErrorCode) {
        this.mNTErrorCode = newNTErrorCode;
    }

    void setNTErrorText(String newNTErrorText) {
        this.mNTErrorText = newNTErrorText;
    }

    void setNTInfoString(String newNTInfoString) {
        this.mNTInfoString = newNTInfoString;
    }

    void setNTResultString(String newNTResultString) {
        this.mNTResultString = newNTResultString;
    }

    protected int prOpenMessagefile(int pUserId, String pFileName, int pSize, boolean pDoAppend) throws TestCaseException {
        int result = -1;
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prOpenMessagefile", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of PR_OPEN_MESSAGEFILE ( File=" + pFileName + ", Size=" + pSize + ", DoAppend=" + pDoAppend + ", Counter=" + this.mStatementCounter + " )";
            CallableStatement stmt = con.prepareCall("CALL PR_OPEN_MESSAGEFILE ('" + pFileName + "', " + pSize + ", ?, ?, " + this.mStatementCounter + ")");
            stmt.setBoolean(1, pDoAppend);
            stmt.registerOutParameter(2, 4);
            stmt.execute();
            result = stmt.getInt(2);
        }
        catch (SQLException e) {
            System.out.println("exc: " + e.getLocalizedMessage() + " for: " + CallString);
            e.printStackTrace();
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'E', (String)(CallString + " --> " + e.getLocalizedMessage()));
            return -1;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
        return result;
    }

    protected void prCloseMessagefile(int pUserId, int pFileHandle) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prCloseMessagefile", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of PR_CLOSE_MESSAGEFILE ( FileHandle=" + pFileHandle + ", Counter=" + this.mStatementCounter + " )";
            CallableStatement stmt = con.prepareCall("CALL PR_CLOSE_MESSAGEFILE ('" + pFileHandle + "', " + this.mStatementCounter + ")");
            stmt.execute();
        }
        catch (SQLException e) {
            System.out.println("exc: " + e.getLocalizedMessage() + " for: " + CallString);
            e.printStackTrace();
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'E', (String)(CallString + " --> " + e.getLocalizedMessage()));
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected void prSyncMessagefile(int pUserId, String pFileName) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prSyncMessagefile", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of PR_SYNC_MESSAGEFILE ( FileName=" + pFileName + ", Counter=" + this.mStatementCounter + " )";
            CallableStatement stmt = con.prepareCall("CALL PR_SYNC_MESSAGEFILE ('" + pFileName + "', " + this.mStatementCounter + ")");
            stmt.execute();
        }
        catch (SQLException e) {
            System.out.println("exc: " + e.getLocalizedMessage() + " for: " + CallString);
            e.printStackTrace();
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'E', (String)(CallString + " --> " + e.getLocalizedMessage()));
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected void prDropMessagefile(int pUserId, String pFileName) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prDropMessagefile", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of PR_DROP_MESSAGEFILE ( FileName=" + pFileName + ", Counter=" + this.mStatementCounter + " )";
            CallableStatement stmt = con.prepareCall("CALL PR_DROP_MESSAGEFILE ('" + pFileName + "', " + this.mStatementCounter + ")");
            stmt.execute();
        }
        catch (SQLException e) {
            System.out.println("exc: " + e.getLocalizedMessage() + " for: " + CallString);
            e.printStackTrace();
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'E', (String)(CallString + " --> " + e.getLocalizedMessage()));
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected void prWriteMessagefile(int pUserId, int pFileHandle, String pString, int pNumber) throws TestCaseException {
        if (this.mTrace) {
            ++this.mStatementCounter;
        }
        String CallString = "";
        String InfoString = this.getInfoString("prWriteMessagefile", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of PR_WRITE_MESSAGEFILE ( FileHandle=" + pFileHandle + " text = '" + pString + "', number = '" + pNumber + "', Counter=" + this.mStatementCounter + " )";
            CallableStatement stmt = con.prepareCall("CALL PR_WRITE_MESSAGEFILE (" + pFileHandle + ", ?, " + pNumber + ", " + this.mStatementCounter + ")");
            stmt.setString(1, pString);
            stmt.execute();
        }
        catch (SQLException e) {
            System.out.println("exc: " + e.getLocalizedMessage() + " for: " + CallString);
            e.printStackTrace();
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'E', (String)(CallString + " --> " + e.getLocalizedMessage()));
        }
        if (this.mTrace) {
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
        }
    }

    protected void prExistsMessagefile(int pUserId, String pFileName, boolean pExpectedValueForDoesExist, boolean pExpectedValueForIsDirectory) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prExistsMessagefile", this.mStatementCounter, pUserId);
        boolean hasAnError = false;
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of PR_EXIST_MESSAGEFILE ( FileName=" + pFileName + " expected value for 'doesExist' = " + pExpectedValueForDoesExist + ",  expected value for 'isDirectory' = " + pExpectedValueForIsDirectory;
            CallableStatement stmt = con.prepareCall("CALL PR_EXIST_MESSAGEFILE ('" + pFileName + "', ?, ?, " + this.mStatementCounter + ")");
            stmt.registerOutParameter(1, 16);
            stmt.registerOutParameter(2, 16);
            stmt.execute();
            boolean getForDoesExist = stmt.getBoolean(1);
            boolean getForIsDirectory = stmt.getBoolean(2);
            if (getForDoesExist != pExpectedValueForDoesExist) {
                hasAnError = true;
                PrimaryTest.addGlobalMessage((String)InfoString, (char)'E', (String)(CallString + " --> got for doesExist: " + getForDoesExist));
            }
            if (getForIsDirectory != pExpectedValueForIsDirectory) {
                hasAnError = true;
                PrimaryTest.addGlobalMessage((String)InfoString, (char)'E', (String)(CallString + " --> got for isDirectory: " + getForIsDirectory));
            }
        }
        catch (SQLException e) {
            System.out.println("exc: " + e.getLocalizedMessage() + " for: " + CallString);
            e.printStackTrace();
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'E', (String)(CallString + " --> " + e.getLocalizedMessage()));
        }
        if (!hasAnError) {
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
        }
    }

    protected void prMaxCriticalSections(int pUserId, int pNoOfRegions, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String ResultString = "";
        String InfoString = this.getInfoString("prMaxCriticalSections", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of PR_MAX_CRITICAL_SECTIONS( MaxNumberOfRegions=" + pNoOfRegions + " ) ";
            CallableStatement stmt = con.prepareCall("CALL PR_MAX_CRITICAL_SECTIONS (" + pNoOfRegions + ", " + this.mStatementCounter + ")");
            stmt.execute();
            ResultString = CallString;
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode, e);
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
            return;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected void prEnterCriticalSection(int pUserId, int pExpectedResultCode) throws TestCaseException, SQLException {
        ++this.mStatementCounter;
        String CallString = "";
        String ResultString = "";
        String InfoString = this.getInfoString("prEnterCriticalSection", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of PR_ENTER_CRITICAL_SECTION( ) ";
            CallableStatement stmt = con.prepareCall("CALL PR_ENTER_CRITICAL_SECTION (" + this.mStatementCounter + ")");
            stmt.execute();
            ResultString = CallString;
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode, e);
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
            return;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected void prLeaveCriticalSection(int pUserId, int pExpectedResultCode) throws TestCaseException, SQLException {
        ++this.mStatementCounter;
        String CallString = "";
        String ResultString = "";
        String InfoString = this.getInfoString("prLeaveCriticalSection", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of PR_LEAVE_CRITICAL_SECTION( ) ";
            CallableStatement stmt = con.prepareCall("CALL PR_LEAVE_CRITICAL_SECTION (" + this.mStatementCounter + ")");
            stmt.execute();
            ResultString = CallString;
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode, e);
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
            return;
        }
        PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected Oid prCreateMyObj(int pUserId, int objSize, String schemaName, int containerNo, int pExpectedResultCode) throws TestCaseException {
        Oid oid;
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prCreateMyObj", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of CREATE_MYOBJ (OjcectSize=" + objSize + ", Schema=" + schemaName + ", Container=" + containerNo + ", Counter=" + this.mStatementCounter + ")";
            CallableStatement stmt = con.prepareCall("CALL CREATE_MYOBJ(" + objSize + ",'" + schemaName + "', " + containerNo + ", ?)");
            stmt.registerOutParameter(1, -2);
            stmt.execute();
            oid = new Oid(stmt.getBytes(1));
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return null;
        }
        if (this.mTrace) {
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
        }
        return oid;
    }

    protected void prReadMyObj(int pUserId, int objSize, Oid oid, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prReadMyObj", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of READ_MYOBJ (OjcectSize=" + objSize + ", OID=" + oid.getPno() + "," + oid.getPagePos() + "," + oid.getClassId() + ", Counter=" + this.mStatementCounter + ")";
            CallableStatement stmt = con.prepareCall("CALL READ_MYOBJ(" + objSize + ", ?)");
            stmt.setBytes(1, oid.getOmsOid());
            stmt.execute();
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        if (this.mTrace) {
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
        }
    }

    protected void prUpdateMyObj(int pUserId, int objSize, Oid oid, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prUpdateMyObj", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of UPDATE_MYOBJ (OjcectSize=" + objSize + ", OID= " + oid.getPno() + "," + oid.getPagePos() + "," + oid.getClassId() + ", Counter=" + this.mStatementCounter + ")";
            CallableStatement stmt = con.prepareCall("CALL UPDATE_MYOBJ(" + objSize + ", ?)");
            stmt.setBytes(1, oid.getOmsOid());
            stmt.execute();
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        if (this.mTrace) {
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
        }
    }

    protected void prDropMyObj(int pUserId, int objSize, Oid oid, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prDropMyObj", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of DROP_MYOBJ (OjcectSize=" + objSize + ", OID= " + oid.getPno() + ", Counter=" + this.mStatementCounter + ")";
            CallableStatement stmt = con.prepareCall("CALL DROP_MYOBJ(" + objSize + ", ?)");
            stmt.setBytes(1, oid.getOmsOid());
            stmt.execute();
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        if (this.mTrace) {
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
        }
    }

    protected void prReleaseMyObj(int pUserId, int objSize, Oid oid, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prReleaseMyObj", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of RELEASE_MYOBJ (OjcectSize=" + objSize + ", OID= " + oid.getPno() + ", Counter=" + this.mStatementCounter + ")";
            CallableStatement stmt = con.prepareCall("CALL RELEASE_MYOBJ(" + objSize + ", ?)");
            stmt.setBytes(1, oid.getOmsOid());
            stmt.execute();
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        if (this.mTrace) {
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
        }
    }

    protected void prReleaseMyObjMultiple(int pUserId, int objSize, int objCount, Oid oid, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prReleaseMyObjMultiple", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of RELEASE_MYOBJ_MULTIPLE (OjcectSize=" + objSize + ",OjcectCount=" + objCount + ", OID= " + oid.getPno() + ", Counter=" + this.mStatementCounter + ")";
            CallableStatement stmt = con.prepareCall("CALL RELEASE_MYOBJ_MULTIPLE(" + objSize + ", " + objCount + ", ?)");
            stmt.setBytes(1, oid.getOmsOid());
            stmt.execute();
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        if (this.mTrace) {
            PrimaryTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
        }
    }

    protected int prGetObjRevisionNumber(int pUserId, Oid pOID) throws TestCaseException {
        if (pOID == null || pUserId < 0 || pUserId > 3) {
            throw new TestCaseException("At least one wrong parameter in: prGetObjRevisionNumber(" + pUserId + ", " + pOID + ")");
        }
        int result = -1;
        return result;
    }
}

