/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.sapdb.lctest.Oid;
import com.sap.sapdb.lctest.PrimaryTest;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class PrimaryRevisionCounter
extends PrimaryTest {
    static final int NO_CHECK = 1;
    static final int CHECK_EQUAL = 2;
    static final int CHECK_NOT_EQUAL = 3;

    public static void cleanUp() throws TestCaseException {
        PrimaryTest.cleanUp();
    }

    public static void prepare() throws TestCaseException {
        PrimaryTest.prepare();
    }

    public void run() {
        int revisionCntForUser1 = 0;
        int revisionCntForUser2 = 0;
        Oid oid = null;
        try {
            oid = this.prCreateMyobj(1, "testteam", 1, 48, 0);
            revisionCntForUser1 = this.getAndCheck(1, revisionCntForUser1, oid, 1, 1);
            this.prCommit(1);
            this.getAndCheck(1, revisionCntForUser1, oid, 2, 2);
            this.prUpdateMyObj(1, 24, oid, 0);
            this.getAndCheck(1, revisionCntForUser1, oid, 2, 3);
            revisionCntForUser2 = revisionCntForUser1;
            this.getAndCheck(2, revisionCntForUser2, oid, 2, 4);
            this.prCommit(1);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public int getAndCheck(int pUser, int revisionCnt, Oid oid, int checkMode, int location) throws TestCaseException {
        int newCnt = this.prGetObjRevisionNumber(pUser, oid);
        if (checkMode == 2 && newCnt != revisionCnt) {
            throw new TestCaseException("Old (" + revisionCnt + ") and new (" + newCnt + ") Revision Counter are different for object with oid " + oid.toString() + " at location " + location);
        }
        if (checkMode == 3 && newCnt == revisionCnt) {
            throw new TestCaseException("Old and new Revision Counter are equal for object with oid " + oid.toString() + " at location " + location);
        }
        return newCnt;
    }
}

