/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.dbtech.jdbc.exceptions.DatabaseException;
import com.sap.dbtech.powertoys.DBM;
import com.sap.sapdb.lctest.DBProcedure;
import com.sap.sapdb.lctest.LiveCacheConstants;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public abstract class LCRecoverTest
extends TestCase
implements LiveCacheConstants {
    protected static final String sUser = "ULCREC";
    protected static final String sPassword = "ULCREC";
    protected static final int mNumberOfConnections = 3;
    protected static final int USER1 = 1;
    protected static final int USER2 = 2;
    protected static final int USER3 = 3;
    protected static final int NO_ERROR = 0;
    protected static final int DEFAULT_TIMEOUT = 10;
    protected static final int IGNORE_ALL_ERRORS = -999;
    private int mStatementCounter = 0;
    private static Connection[] mConnections;
    private static TestStatement[] mStatements;
    private int mNextKey = 0;
    private int mNextValue = 0;
    private Vector mValues = new Vector();
    private Vector mKeys = new Vector();
    private DBM mDBM;
    private DBM mDBMan = null;

    private void checkResultCode(String InfoString, String CallString, int pExpectedResultCode) throws TestCaseException {
        if (pExpectedResultCode != 0 && pExpectedResultCode != -999) {
            LCRecoverTest.addGlobalMessage((String)InfoString, (char)'E', (String)("***** ERROR ****** " + CallString + " --> expecting result code " + pExpectedResultCode));
            throw new TestCaseException(CallString + " --> expecting result code " + pExpectedResultCode);
        }
    }

    private void checkResultCode(String InfoString, String CallString, int pExpectedResultCode, SQLException e) throws TestCaseException {
        if (pExpectedResultCode == -999) {
            return;
        }
        if (e.getErrorCode() != pExpectedResultCode) {
            LCRecoverTest.addGlobalMessage((String)InfoString, (char)'E', (String)("***** ERROR ****** " + CallString + " --> " + e.getMessage()));
            throw new TestCaseException(CallString + " --> " + e.getMessage());
        }
        LCRecoverTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " - Expected error: " + e.getMessage() + " --> OK"));
    }

    public static void cleanUp() throws TestCaseException {
        if (mStatements == null || mConnections == null) {
            return;
        }
        try {
            if (mStatements[0] != null) {
                mConnections[0].commit();
            }
            mStatements[0].execute("CALL DROP_CURRENT_SCHEMA('testteam')");
            mConnections[0].commit();
        }
        catch (Exception e) {
            LCRecoverTest.addGlobalMessage((String)"CleanUp", (char)'E', (String)("Error while dropping schema: " + e.getMessage()));
            throw new TestCaseException("Error while dropping schema: " + e.getMessage());
        }
        try {
            if (mStatements[0] != null) {
                mStatements[0].close();
            }
            if (mConnections[0] != null) {
                mConnections[0].commit();
                mConnections[0].close();
            }
        }
        catch (Exception e) {
            LCRecoverTest.addGlobalMessage((String)"cleanup", (char)'E', (String)("Error during connection closure: " + e.getMessage()));
            throw new TestCaseException("Error during connection closure: " + e.getMessage());
        }
    }

    private static boolean createConnections() {
        try {
            mConnections = new Connection[3];
            mStatements = new TestStatement[3];
            for (int i = 0; i < 3; ++i) {
                LCRecoverTest.mConnections[i] = LCRecoverTest.getDatabase().connect("ULCREC", "ULCREC");
                mConnections[i].setAutoCommit(false);
                LCRecoverTest.mStatements[i] = new TestStatement(null, mConnections[i]);
            }
        }
        catch (Exception e) {
            LCRecoverTest.addGlobalMessage((String)"createConnections", (char)'E', (String)("Error during connection creation: " + e.getMessage()));
            return false;
        }
        return true;
    }

    private static void createDBProcedures() throws TestCaseException {
        Connection con = null;
        TestStatement stmt = null;
        int ExecMode = 1;
        try {
            con = LCRecoverTest.getDatabase().connect("ULCREC", "ULCREC");
            stmt = new TestStatement(null, con);
            try {
                if (TestDriver.compareRelease((String)((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion(), (String)">=", (String)"7.4.4")) {
                    DBProcedure.createPackageWithFile(stmt, "consistent", "consistent");
                } else {
                    DBProcedure.createPackage(stmt, "consistent", "liveCache.consistent.TEST");
                }
            }
            catch (TestDatabaseException e) {
                throw new TestDatabaseException((Exception)((Object)e), "Could not retrieve kernel version for creation of package 'consistent'");
            }
            DBProcedure.create(stmt, "CREATE_SCHEMA", "consistent");
            DBProcedure.create(stmt, "CREATE_KEYED_CONTAINER", "consistent");
            DBProcedure.create(stmt, "CREATE_VAROBJECTS", "consistent");
            DBProcedure.create(stmt, "CREATE_CONTAINER", "consistent");
            DBProcedure.create(stmt, "CREATE_OBJECTS", "consistent");
            DBProcedure.create(stmt, "CREATE_KEYED_OBJECT", "consistent");
            DBProcedure.create(stmt, "SUM_ALL_KEYED_OBJECTS", "consistent");
            DBProcedure.create(stmt, "READ_KEYED_OBJECT", "consistent");
            DBProcedure.create(stmt, "UPD_KEYED_OBJECT", "consistent");
            DBProcedure.create(stmt, "DEL_ALL_OBJECTS", "consistent");
            DBProcedure.create(stmt, "DEL_KEYED_OBJECT", "consistent");
            DBProcedure.create(stmt, "DROP_VERSION", "consistent");
            DBProcedure.create(stmt, "DROP_SCHEMA", "consistent");
            DBProcedure.create(stmt, "CREATE_CURRENT_SCHEMA", "consistent", ExecMode);
            DBProcedure.create(stmt, "SET_CURRENT_SCHEMA", "consistent", ExecMode);
            DBProcedure.create(stmt, "DROP_CURRENT_SCHEMA", "consistent", ExecMode);
            DBProcedure.create(stmt, "CLASS_REGISTER", "consistent", ExecMode);
            stmt.enableExceptions(false);
            stmt.execute("CALL DROP_CURRENT_SCHEMA('testteam')");
            stmt.enableExceptions(true);
            stmt.execute("CALL CREATE_CURRENT_SCHEMA('testteam')");
            stmt.execute("CALL CLASS_REGISTER");
            con.commit();
        }
        catch (Exception e) {
            LCRecoverTest.addGlobalMessage((String)"DPProc registration", (char)'E', (String)("SQL Error while registering DBProcedures: " + e.getMessage()));
            throw new TestCaseException("LCRecoverTest.createDBProcedures() failed");
        }
        finally {
            try {
                stmt.close();
                con.close();
            }
            catch (Exception e) {}
        }
    }

    public String executeDBMCmd(String pCmd) {
        String logon = "";
        String mHost = "";
        String mName = "";
        try {
            mHost = LCRecoverTest.getDatabase().getHost();
            mName = LCRecoverTest.getDatabase().getName();
            int mPort = LCRecoverTest.getDatabase().getPort();
            if (this.mDBMan == null) {
                this.mDBMan = DBM.dbDBM((String)(mHost + ":" + mPort), (String)mName);
                logon = "USER_LOGON DBM,DBM";
                this.mDBMan.cmd(logon);
            }
            return this.mDBMan.cmd(pCmd);
        }
        catch (Exception e) {
            System.out.println("Could not execute: " + pCmd);
            return "error";
        }
    }

    protected Connection getConnection(int UserId) throws TestCaseException {
        if (UserId < 1 || UserId > 3) {
            throw new TestCaseException(" UserId " + UserId + " is out of range[1," + 3 + "]");
        }
        return mConnections[UserId - 1];
    }

    private String getInfoString(String pMethodName, int pCounter, int pUser) {
        return "<" + pMethodName + "(), Statement " + pCounter + ", User " + pUser + ">";
    }

    public int getNextKey() {
        return this.mNextKey++;
    }

    public int getNextValue() {
        return this.mNextValue++;
    }

    protected TestStatement getStatement(int UserId) throws TestCaseException {
        if (UserId < 1 || UserId > 3) {
            throw new TestCaseException(" UserId " + UserId + " is out of range[1," + 3 + "]");
        }
        return mStatements[UserId - 1];
    }

    protected boolean prCheckValue(int pUserId, int pKey, int pExpectedValue) throws TestCaseException {
        return this.prCheckValue(pUserId, pKey, pExpectedValue, 0);
    }

    protected boolean prCheckValue(int pUserId, int pKey, int pExpectedValue, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        boolean ResultKey = false;
        int ResultValue = 0;
        String CallString = "";
        String ResultString = "";
        String InfoString = this.getInfoString("prCheckValue", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of GET_OBJECT_VALUE ( Key=" + pKey + ", Counter=" + this.mStatementCounter + " )";
            CallableStatement stmt = con.prepareCall("CALL GET_OBJECT_VALUE ( " + pKey + ", " + this.mStatementCounter + ", ?)");
            stmt.registerOutParameter(1, 4);
            stmt.execute();
            ResultValue = stmt.getInt(1);
            ResultString = CallString + " returned: ( Value=" + ResultValue + " )";
            if (ResultValue != pExpectedValue) {
                LCRecoverTest.addGlobalMessage((String)InfoString, (char)'E', (String)("***** ERROR ****** " + ResultString + " --> expecting value " + pExpectedValue));
                throw new TestCaseException(ResultString + " --> expecting value " + pExpectedValue);
            }
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode, e);
            return true;
        }
        LCRecoverTest.addGlobalMessage((String)InfoString, (char)'I', (String)(ResultString + " --> OK"));
        return true;
    }

    protected void prCommit(int pUserId) throws TestCaseException {
        ++this.mStatementCounter;
        String InfoString = this.getInfoString("prCommit", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            con.commit();
            LCRecoverTest.addGlobalMessage((String)InfoString, (char)'I', (String)"Commit --> OK");
        }
        catch (Exception e) {
            LCRecoverTest.addGlobalMessage((String)InfoString, (char)'E', (String)("***** ERROR ****** Could not commit: " + e.getMessage()));
            throw new TestCaseException("Error in LCRecoverTest");
        }
    }

    protected void prCreateKeyedContainer(int pUserId, String pSchemaName, int pContainerNumber) throws TestCaseException {
        this.prCreateKeyedContainer(pUserId, pSchemaName, pContainerNumber, 10, 0);
    }

    protected void prCreateKeyedContainer(int pUserId, String pSchemaName, int pContainerNumber, int pRequestTimeout, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prCreateKeyedContainer", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallableStatement stmt = con.prepareCall("CALL CREATE_KEYED_CONTAINER ('" + pSchemaName + "', " + pContainerNumber + ")");
            CallString = "Call of CREATE_KEYED_CONTAINER ('" + pSchemaName + "', " + pContainerNumber + ")";
            stmt.execute();
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        LCRecoverTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected void prCreateKeyedObject(int pUserId, int pKey, int pValue, int pRequestTimeout, int pExpectedResultCode, String pSchemaName, int pContainerNumber) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prCreateKeyedObject", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallableStatement stmt = con.prepareCall("CALL CREATE_KEYED_OBJECT (" + pKey + ", " + pValue + ", '" + pSchemaName + "', " + pContainerNumber + ")");
            CallString = "Call of CREATE_KEYED_OBJECT ( Key=" + pKey + ", Value=" + pValue + ", pSchemaName = '" + pSchemaName + "', pContainerNumber=" + pContainerNumber + " )";
            stmt.execute();
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
    }

    protected void prCreateKeyedObject(int pUserId, String pSchemaName, int pKey, int pValue) throws TestCaseException {
        this.prCreateKeyedObject(pUserId, pKey, pValue, 10, 0, pSchemaName, 1);
    }

    protected boolean prCreateKeyedObjects(int pUserId, String pSchemaName, int pNumberOfKeyedObjects) throws TestCaseException {
        this.mNextKey = 0;
        this.mNextValue = 0;
        for (int i = 0; i < pNumberOfKeyedObjects; ++i) {
            this.prCreateKeyedObject(pUserId, pSchemaName, this.mNextKey++, this.mNextValue++);
        }
        return true;
    }

    protected void prCreateObject(int pUserId, int pKey, int pValue) throws TestCaseException {
        this.prCreateObject(pUserId, pKey, pValue, 10, 0);
    }

    protected void prCreateObject(int pUserId, int pKey, int pValue, int pRequestTimeout, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prCreateObject", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallableStatement stmt = con.prepareCall("CALL CREATE_OBJECT (" + pKey + ", " + pValue + ", " + pRequestTimeout + ", " + this.mStatementCounter + ")");
            CallString = "Call of CREATE_OBJECT ( Key=" + pKey + ", Value=" + pValue + ", Timeout=" + pRequestTimeout + ", Counter=" + this.mStatementCounter + " )";
            stmt.execute();
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        LCRecoverTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected void prCreateObject(int pUserId, int pKey, int pValue, String pSchemaName, int pRequestTimeout, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prCreateObject", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallableStatement stmt = con.prepareCall("CALL CREATE_OBJECT (" + pKey + ", " + pValue + ", " + pRequestTimeout + ", " + this.mStatementCounter + ")");
            CallString = "Call of CREATE_OBJECT ( Key=" + pKey + ", Value=" + pValue + ", Timeout=" + pRequestTimeout + ", Counter=" + this.mStatementCounter + " )";
            stmt.execute();
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
    }

    protected boolean prCreateObjects(int pUserId, int pNumberOfObjects) throws TestCaseException {
        for (int i = 0; i < pNumberOfObjects; ++i) {
            this.prCreateObject(pUserId, this.mNextKey++, this.mNextValue++);
        }
        return true;
    }

    protected void prCreateSchema(int pUserId, String pSchemaName) throws TestCaseException {
        this.prCreateSchema(pUserId, pSchemaName, 10, 0);
    }

    protected void prCreateSchema(int pUserId, String pSchemaName, int pRequestTimeout, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prCreateSchema", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallableStatement stmt = con.prepareCall("CALL CREATE_SCHEMA ('" + pSchemaName + "')");
            CallString = "Call of CREATE_SCHEMA ('" + pSchemaName + "')";
            stmt.execute();
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        LCRecoverTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected void prDeleteAllObjects(int pUserId) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String ResultString = "";
        String InfoString = this.getInfoString("prDeleteAllObjects", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "CALL DELETE_ALL_OBJECTS ( Counter=" + this.mStatementCounter + " )";
            CallableStatement stmt = con.prepareCall("CALL DELETE_ALL_OBJECTS (" + this.mStatementCounter + ")");
            stmt.execute();
            ResultString = CallString;
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, 0, e);
            return;
        }
        LCRecoverTest.addGlobalMessage((String)InfoString, (char)'I', (String)(ResultString + " --> OK"));
    }

    protected void prDeleteKeyedObject(int pUserId, int pKey, int pValue, int pRequestTimeout, int pExpectedResultCode, String pSchemaName, int pContainerNumber) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prDeleteKeyedObject", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallableStatement stmt = con.prepareCall("CALL DEL_KEYED_OBJECT (" + pKey + ", '" + pSchemaName + "', " + pContainerNumber + ")");
            CallString = "Call of DEL_KEYED_OBJECT ( Key=" + pKey + ", pSchemaName = '" + pSchemaName + "', pContainerNumber = " + pContainerNumber + " )";
            stmt.execute();
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
    }

    protected void prDeleteKeyedObject(int pUserId, String pSchemaName, int pContainerNumber, int pKey, int pValue) throws TestCaseException {
        this.prDeleteKeyedObject(pUserId, pKey, pValue, 10, 0, pSchemaName, pContainerNumber);
    }

    protected boolean prDeleteKeyedObjects(int pUserId, String pSchemaName, int pContainerNumber, int pNumberOfKeyedObjects) throws TestCaseException {
        this.mNextKey = 0;
        this.mNextValue = 0;
        for (int i = 0; i < pNumberOfKeyedObjects; ++i) {
            this.prDeleteKeyedObject(pUserId, pSchemaName, pContainerNumber, this.mNextKey++, this.mNextValue++);
        }
        return true;
    }

    protected void prDeleteObject(int pUserId, int pKey) throws TestCaseException {
        this.prDeleteObject(pUserId, pKey, 10, 0);
    }

    protected void prDeleteObject(int pUserId, int pKey, int pRequestTimeout, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String ResultString = "";
        String InfoString = this.getInfoString("prDeleteObject", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "CALL DELETE_OBJECT ( Key=" + pKey + ", Counter=" + this.mStatementCounter + ", Timeout=" + pRequestTimeout + " )";
            CallableStatement stmt = con.prepareCall("CALL DELETE_OBJECT (" + pKey + ", " + this.mStatementCounter + ", " + pRequestTimeout + ")");
            stmt.execute();
            ResultString = CallString;
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode, e);
            return;
        }
        LCRecoverTest.addGlobalMessage((String)InfoString, (char)'I', (String)(ResultString + " --> OK"));
    }

    protected void prDropSchema(int pUserId, String pSchemaName) throws TestCaseException {
        this.prDropSchema(pUserId, pSchemaName, 0);
    }

    protected void prDropSchema(int pUserId, String pSchemaName, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prDropSchema", this.mStatementCounter, pUserId);
        Connection con = null;
        TestStatement stmt = null;
        try {
            con = this.getConnection(pUserId);
            stmt = new TestStatement(null, con);
            stmt = this.getStatement(pUserId);
            CallString = "Call of DROP_SCHEMA ('" + pSchemaName + "')";
            stmt.enableExceptions(false);
            stmt.execute("CALL DROP_SCHEMA ('" + pSchemaName + "')");
            stmt.enableExceptions(true);
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        LCRecoverTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    public static void prepare() throws TestCaseException {
        Connection lDefConnection = null;
        TestStatement lDefTstmt = null;
        try {
            block16: {
                TestCase.setInfoMessageFilter((boolean)false);
                try {
                    lDefConnection = LCRecoverTest.getDatabase().connect(LCRecoverTest.getDatabase().getDBAUser(), LCRecoverTest.getDatabase().getDBAPassword());
                }
                catch (Exception e) {
                    LCRecoverTest.addGlobalMessage((String)"Login failure", (char)'E', (String)("DBAUser: " + LCRecoverTest.getDatabase().getDBAUser() + ", Password: " + LCRecoverTest.getDatabase().getDBAPassword()));
                    throw e;
                }
                lDefTstmt = new TestStatement(null, lDefConnection);
                lDefTstmt.enableExceptions(false);
                try {
                    if (((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion().startsWith("7.2")) {
                        lDefTstmt.executeUpdate("enable write transaction");
                    }
                }
                catch (TestDatabaseException e) {
                    throw new TestDatabaseException((Exception)((Object)e), "Could not retrieve kernel version");
                }
                lDefTstmt.executeUpdate("drop user ULCREC");
                lDefTstmt.enableExceptions(true);
                try {
                    lDefTstmt.executeUpdate("Create user ULCREC password ULCREC dba not exclusive");
                }
                catch (DatabaseException e) {
                    if (e.getErrorCode() == -6006) break block16;
                    LCRecoverTest.addGlobalMessage((String)"Init failure", (char)'E', (String)"Creation of user : ULCREC not possible");
                    throw e;
                }
            }
            LCRecoverTest.readParameters();
            LCRecoverTest.createDBProcedures();
            LCRecoverTest.createConnections();
        }
        catch (Exception e) {
            throw (TestCaseException)e;
        }
        finally {
            try {
                lDefTstmt.close();
                lDefConnection.close();
            }
            catch (Exception e) {}
        }
    }

    protected void prReconnect(int pUserId) throws TestCaseException {
        String InfoString = this.getInfoString("prReconnect", this.mStatementCounter++, pUserId);
        try {
            if (pUserId < 1 || pUserId > 3) {
                throw new TestCaseException("Illegal user number: " + pUserId);
            }
            LCRecoverTest.mConnections[--pUserId] = LCRecoverTest.getDatabase().connect("ULCREC", "ULCREC");
            mConnections[pUserId].setAutoCommit(false);
            LCRecoverTest.mStatements[pUserId] = new TestStatement(null, mConnections[pUserId]);
        }
        catch (Exception e) {
            LCRecoverTest.addGlobalMessage((String)InfoString, (char)'E', (String)("***** ERROR ****** Reconnect for user " + pUserId + " failed: " + e.getMessage()));
            throw new TestCaseException("Error in LCRecoverTest");
        }
    }

    protected void prRollback(int pUserId) throws TestCaseException {
        ++this.mStatementCounter;
        String InfoString = this.getInfoString("prRollback", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            con.rollback();
            LCRecoverTest.addGlobalMessage((String)InfoString, (char)'I', (String)"Rollback --> OK");
        }
        catch (Exception e) {
            LCRecoverTest.addGlobalMessage((String)InfoString, (char)'E', (String)("Could not rollback: " + e.getMessage()));
            throw new TestCaseException("Error in Primary test");
        }
    }

    protected boolean prSumAllKeyedObjects(int pUserId, String pSchemaName, int pContainerNumber, int pExpectedValue, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        boolean ResultKey = false;
        int ResultValue1 = 0;
        int ResultValue2 = 0;
        String CallString = "";
        String ResultString = "";
        String InfoString = this.getInfoString("prSumAllKeyedObjects", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of SUM_ALL_KEYED_OBJECTS ( pSchemaName = '" + pSchemaName + "', pContainerNumber = " + pContainerNumber + "NumberOfKeyedObjecs = ?, SumOfKeyedObjects = ?)";
            CallableStatement stmt = con.prepareCall("CALL SUM_ALL_KEYED_OBJECTS ( '" + pSchemaName + "', " + pContainerNumber + ", ?, ?)");
            stmt.registerOutParameter(1, 4);
            stmt.registerOutParameter(2, 4);
            stmt.execute();
            ResultValue1 = stmt.getInt(1);
            ResultValue2 = stmt.getInt(2);
            ResultString = CallString + " returned: ( SumOfKeyedObjects = " + ResultValue2 + " )";
            if (ResultValue2 != pExpectedValue) {
                LCRecoverTest.addGlobalMessage((String)InfoString, (char)'E', (String)("***** ERROR ****** " + ResultString + " --> expecting value " + pExpectedValue));
                throw new TestCaseException(ResultString + " --> expecting value " + pExpectedValue);
            }
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode, e);
            return true;
        }
        LCRecoverTest.addGlobalMessage((String)InfoString, (char)'I', (String)(ResultString + " --> OK"));
        return true;
    }

    protected void prUpdateKeyedObject(int pUserId, int pKey, int pNewValue, int pRequestTimeout, int pExpectedResultCode, String pSchemaName, int pContainerNumber) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String ResultString = "";
        String InfoString = this.getInfoString("prUpdateObject", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallableStatement stmt = con.prepareCall("CALL UPD_KEYED_OBJECT (" + pKey + ", '" + pSchemaName + "', " + pContainerNumber + ", " + pNewValue + ")");
            CallString = "CALL UPD_KEYED_OBJECT ( Key=" + pKey + ", pSchemaName = '" + pSchemaName + "', pContainerNumber = " + pContainerNumber + ", pNewValue = " + pNewValue + " )";
            stmt.execute();
            ResultString = CallString;
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode, e);
            return;
        }
    }

    protected void prUpdateKeyedObject(int pUserId, String pSchemaName, int pContainerNumber, int pKey, int pNewValue) throws TestCaseException {
        this.prUpdateKeyedObject(pUserId, pKey, pNewValue, 10, 0, pSchemaName, pContainerNumber);
    }

    protected void prUpdateKeyedObjects(int pUserId, String pSchemaName, int pContainerNumber, int pNumberOfKeyedObjects, int pValue) throws TestCaseException {
        this.mNextValue = 20;
        this.mNextKey = 0;
        for (int i = 0; i < pNumberOfKeyedObjects; ++i) {
            this.prUpdateKeyedObject(pUserId, pSchemaName, pContainerNumber, this.mNextKey++, pValue);
        }
    }

    private static void readParameters() throws TestCaseException {
    }

    public void run() {
    }
}

