/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.dbtech.powertoys.DBM;
import com.sap.sapdb.lctest.LiveCacheConstants;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.StringTokenizer;

public class BackupRestoreLogUntil1
extends TestCase
implements LiveCacheConstants {
    private static final String sVersion = "1.3";
    private Connection mConnection = null;
    private TestStatement stmt = null;
    private static int mTraceLevel;
    private static int mWorkOnDatabase;
    private int expectedLogSaves = 0;
    private String[] LogSaves;
    private DBM mDBMan = null;
    final SimpleDateFormat mTimeStampFormat = new SimpleDateFormat("yyyyMMdd HHmmss");
    final SimpleDateFormat mTimeFormat = new SimpleDateFormat("dd.MM.yyyy 'at' HH:mm:ss");
    int defaultValue = 10;
    private String sString = null;
    private int i = 0;
    private int j = 0;
    private int dummyj = 0;
    private boolean indexExists = false;
    private Random r = new Random();
    private int rand = 0;
    private String[] logTimeStamp = new String[this.defaultValue];
    private String[] checkValues = new String[this.defaultValue];
    private String mKernelMode = "FAST";

    public static String getTestClassId() {
        return "BackupRestoreLogUntil1";
    }

    public static String getMinimumRelease() {
        return "7.4.1.*";
    }

    public static void prepare() throws TestCaseException {
        BackupRestoreLogUntil1.readAndPrintParameters();
    }

    private static void printInfo(int Level2, String pComponent, String pInfoText) {
        if (Level2 <= mTraceLevel) {
            System.out.println(pComponent + " --> " + pInfoText);
        }
        if (Level2 < 7) {
            BackupRestoreLogUntil1.addGlobalMessage((String)pComponent, (char)'I', (String)pInfoText);
        } else if (mTraceLevel >= 9) {
            BackupRestoreLogUntil1.addGlobalMessage((String)pComponent, (char)'I', (String)pInfoText);
        }
    }

    protected static void readAndPrintParameters() throws TestCaseException {
        mTraceLevel = BackupRestoreLogUntil1.getParameterInt((String)"TraceLevel", (int)2);
        mWorkOnDatabase = BackupRestoreLogUntil1.getParameterInt((String)"WorkOnDatabase", (int)500);
        BackupRestoreLogUntil1.printInfo(1, "\n" + BackupRestoreLogUntil1.getTestClassId(), "Starting BackupRestoreLogUntil1 Test - Version: 1.3\n");
        BackupRestoreLogUntil1.printInfo(2, BackupRestoreLogUntil1.getTestClassId(), "Parameter: TraceLevel        = " + mTraceLevel);
        BackupRestoreLogUntil1.printInfo(2, BackupRestoreLogUntil1.getTestClassId(), "Parameter: WorkonDatabase    = " + mWorkOnDatabase + " cycles");
    }

    public String executeDBMCmd(String pCmd) throws TestDatabaseException {
        String logon = "";
        String mHost = "";
        String mName = "";
        BackupRestoreLogUntil1.printInfo(5, BackupRestoreLogUntil1.getTestClassId(), "executeDBMCmd: " + pCmd);
        try {
            mHost = BackupRestoreLogUntil1.getDatabase().getHost();
            mName = BackupRestoreLogUntil1.getDatabase().getName();
            int mPort = BackupRestoreLogUntil1.getDatabase().getPort();
            if (this.mDBMan == null) {
                this.mDBMan = DBM.dbDBM((String)(mHost + ":" + mPort), (String)mName);
                logon = "USER_LOGON DBM,DBM";
                this.mDBMan.cmd(logon);
            }
            return this.mDBMan.cmd(pCmd);
        }
        catch (Exception e) {
            System.out.println("Could not execute: " + pCmd);
            System.out.println("Exception: " + e.getMessage() + "\n" + e.getClass());
            throw new TestDatabaseException(e, " DBM command: " + pCmd + ", logon String: " + logon);
        }
    }

    private void recoverData() throws TestCaseException, SQLException, TestDatabaseException {
        this.executeDBMCmd("util_connect");
        this.executeDBMCmd("recover_start LCRecoverTest401dat DATA");
        this.executeDBMCmd("util_release");
    }

    private void checkBackUpState() throws SQLException, TestDatabaseException {
        String[] szLines = new String[200];
        int nCurrent = 0;
        String[] tempArray = new String[100];
        int tempArrayInt = 0;
        this.executeDBMCmd("util_execute clear log");
        String szBuffer = this.executeDBMCmd("backup_history_list -c KEY -m -r LAST");
        BackupRestoreLogUntil1.printInfo(4, BackupRestoreLogUntil1.getTestClassId(), "DBM command: 'backup_history_list -c KEY -m -r LAST' returns:\n" + szBuffer);
        String dummy = "";
        StringTokenizer stBuffer = new StringTokenizer(szBuffer);
        while (stBuffer.hasMoreTokens()) {
            dummy = stBuffer.nextToken("\n");
            if (!dummy.startsWith("M:") || dummy.indexOf("YES") == -1) continue;
            StringTokenizer singleLine = new StringTokenizer(dummy);
            int lastElementOfSingleLine = singleLine.countTokens();
            while (singleLine.hasMoreTokens()) {
                tempArray[tempArrayInt++] = singleLine.nextToken("|");
            }
            szLines[nCurrent++] = tempArray[lastElementOfSingleLine].trim();
            tempArray = new String[100];
            tempArrayInt = 0;
        }
        this.LogSaves = szLines;
        for (int z = 0; z < 200; ++z) {
            if (this.LogSaves[z] == null) continue;
            BackupRestoreLogUntil1.printInfo(4, BackupRestoreLogUntil1.getTestClassId(), "LogSaves[" + z + "] = " + this.LogSaves[z]);
        }
        if (this.LogSaves[0] == null) {
            this.addMessage(BackupRestoreLogUntil1.getTestClassId(), 'E', "Can not read the last log saves by using the statement \"backup_history_list -c KEY -m -r LAST\"");
            this.addMessage(BackupRestoreLogUntil1.getTestClassId(), 'I', "get:\n" + szBuffer);
            throw new TestDatabaseException("Can not read the last log saves.");
        }
    }

    private void recoverUntilLog(int mCounter) throws TestCaseException, SQLException, TestDatabaseException {
        String rcode = "";
        this.executeDBMCmd("util_connect");
        String firstLogSaveNumber = this.LogSaves[0].substring(this.LogSaves[0].indexOf(".") + 1, this.LogSaves[0].length());
        rcode = this.executeDBMCmd("recover_start LCRecoverTest401log LOG " + firstLogSaveNumber + " UNTIL " + this.logTimeStamp[mCounter]);
        if (rcode.indexOf("-8020") > 0) {
            for (int lo = 1; lo < this.expectedLogSaves; ++lo) {
                rcode = this.executeDBMCmd("recover_replace LCRecoverTest401log " + this.LogSaves[lo]);
                BackupRestoreLogUntil1.printInfo(5, BackupRestoreLogUntil1.getTestClassId(), "log = " + lo + " rcode = " + rcode);
                if (rcode.indexOf("-8020") == -1) break;
            }
        }
        this.executeDBMCmd("util_release");
    }

    private void restartDatabaseCold() throws TestCaseException, SQLException, TestDatabaseException {
        BackupRestoreLogUntil1.printInfo(2, BackupRestoreLogUntil1.getTestClassId(), "Restart");
        this.executeDBMCmd("db_offline");
        this.executeDBMCmd("db_cold -" + this.mKernelMode);
        this.executeDBMCmd("util_execute clear log");
        this.executeDBMCmd("util_connect");
        if (!TestDriver.compareRelease((String)((TestDatabaseSap)BackupRestoreLogUntil1.getDatabase()).getKernelVersion(), (String)">=", (String)"7.6.0")) {
            this.executeDBMCmd("util_execute diagnose vtrace check 'log' on");
            this.executeDBMCmd("util_execute diagnose vtrace topic 'log' on");
        }
        this.executeDBMCmd("util_release");
    }

    private void startUp() throws TestCaseException, SQLException, TestDatabaseException {
        this.mConnection = BackupRestoreLogUntil1.getDatabase().connect(BackupRestoreLogUntil1.getUser(), BackupRestoreLogUntil1.getPassword());
        this.stmt = new TestStatement((TestCase)this, this.mConnection);
        TestDatabaseSap sapdb = (TestDatabaseSap)BackupRestoreLogUntil1.getDatabase();
        this.mKernelMode = sapdb.getKernelMode();
        this.executeDBMCmd("autosave_off");
        this.executeDBMCmd("util_connect");
        if (!TestDriver.compareRelease((String)((TestDatabaseSap)BackupRestoreLogUntil1.getDatabase()).getKernelVersion(), (String)">=", (String)"7.6.0")) {
            this.executeDBMCmd("util_execute diagnose vtrace check 'log' on");
            this.executeDBMCmd("util_execute diagnose vtrace topic 'log' on");
        }
        this.executeDBMCmd("util_release");
        this.createTable();
        this.stmt.close();
    }

    private void checkTable(String mTabName, int mCounter) throws SQLException, TestDatabaseException {
        ResultSet rs = null;
        Connection mCheckConnection = BackupRestoreLogUntil1.getDatabase().connect(BackupRestoreLogUntil1.getUser(), BackupRestoreLogUntil1.getPassword());
        this.stmt = new TestStatement((TestCase)this, mCheckConnection);
        int row_counter = 0;
        String dummy = "";
        this.sString = "Select count(*) from " + mTabName;
        rs = this.stmt.executeQuery(this.sString);
        rs.next();
        dummy = dummy + "Result of \"" + this.sString + "\" -> ";
        row_counter = rs.getInt(1);
        dummy = dummy + row_counter + "\n";
        this.sString = "Select * from " + mTabName + " WHERE PRIMKEY > " + (row_counter - 10);
        rs = this.stmt.executeQuery(this.sString);
        dummy = dummy + "Result of \"" + this.sString + "\"\n";
        dummy = dummy + "PrimKey \t Name \t\t PersNr\t Adresse\n";
        while (rs.next()) {
            dummy = dummy + " " + rs.getInt(1) + " ";
            dummy = dummy + "\t\t " + rs.getString(2) + " ";
            dummy = dummy + "\t  " + rs.getInt(3) + " ";
            dummy = dummy + "\t  " + rs.getString(4) + "\n";
        }
        this.sString = "Select SUM(PRIMKEY) from " + mTabName;
        rs = this.stmt.executeQuery(this.sString);
        rs.next();
        dummy = dummy + "Result of \"" + this.sString + "\" -> ";
        dummy = dummy + rs.getInt(1) + "\n";
        if (this.checkValues[mCounter].compareTo(dummy) != 0) {
            BackupRestoreLogUntil1.printInfo(2, BackupRestoreLogUntil1.getTestClassId(), "***** ERROR ****** \nwrong table content --> expecting:\n" + this.checkValues[mCounter] + "\ngetting:\n" + dummy);
            BackupRestoreLogUntil1.addGlobalMessage((String)BackupRestoreLogUntil1.getTestClassId(), (char)'E', (String)("***** ERROR ****** \nwrong table content --> expecting:\n" + this.checkValues[mCounter] + "\ngetting:\n" + dummy));
        } else {
            BackupRestoreLogUntil1.printInfo(2, BackupRestoreLogUntil1.getTestClassId(), "check database... ok.");
        }
        this.stmt.close();
        mCheckConnection.commit();
        mCheckConnection.close();
    }

    private void generateTimeStamp(int mCounter) throws TestCaseException, SQLException {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        long mTimeMS = System.currentTimeMillis();
        String mTime = this.mTimeStampFormat.format(new Date(mTimeMS));
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        this.logTimeStamp[mCounter] = mTime;
        BackupRestoreLogUntil1.printInfo(4, BackupRestoreLogUntil1.getTestClassId(), "Time: " + this.mTimeFormat.format(new Date(mTimeMS)) + " -> TimeStamp No. " + mCounter + ": " + mTime);
    }

    private void createTable() throws TestCaseException, SQLException {
        this.sString = "DROP INDEX TT_DUMMY_LOG_IND1";
        BackupRestoreLogUntil1.printInfo(5, BackupRestoreLogUntil1.getTestClassId(), this.sString);
        this.stmt.executeUpdateIgnoreErrors(this.sString);
        this.sString = "DROP TABLE TT_DUMMY_LOG";
        BackupRestoreLogUntil1.printInfo(5, BackupRestoreLogUntil1.getTestClassId(), this.sString);
        this.stmt.executeUpdateIgnoreErrors(this.sString);
        this.sString = "CREATE TABLE TT_DUMMY_LOG(PRIMKEY INTEGER PRIMARY KEY, NAME CHAR(30), PERSNR INTEGER, ADRESSE VARCHAR(200) )";
        BackupRestoreLogUntil1.printInfo(5, BackupRestoreLogUntil1.getTestClassId(), this.sString);
        this.stmt.executeUpdate(this.sString);
        this.mConnection.commit();
    }

    private void createTableAndFill(String mTabName, int mCounter) throws TestCaseException, SQLException, TestDatabaseException {
        this.stmt = new TestStatement((TestCase)this, this.mConnection);
        this.sString = "DROP TABLE " + mTabName;
        this.stmt.executeUpdateIgnoreErrors(this.sString);
        this.sString = "CREATE TABLE " + mTabName + " (PRIMKEY INTEGER PRIMARY KEY, NAME CHAR(30), PERSNR INTEGER, ADRESSE VARCHAR(200) )";
        BackupRestoreLogUntil1.printInfo(5, BackupRestoreLogUntil1.getTestClassId(), this.sString);
        this.stmt.executeUpdate(this.sString);
        this.j = 0;
        this.i = 1;
        while (this.i <= mWorkOnDatabase) {
            this.rand = Math.abs(this.r.nextInt() % 100) + 1;
            if (this.rand < 50) {
                ++this.j;
                this.sString = "INSERT INTO " + mTabName + " VALUES(" + this.j + ", 'name " + this.j + "', " + this.j * 2 + " , 'adresse " + this.j + "')";
                BackupRestoreLogUntil1.printInfo(7, BackupRestoreLogUntil1.getTestClassId(), this.sString);
                this.stmt.execute(this.sString);
            }
            if (this.rand >= 50 && this.rand < 90 && this.j > 3) {
                int newRand = Math.abs(this.r.nextInt() % this.j) + 1;
                this.sString = "UPDATE " + mTabName + " SET PERSNR = " + this.j * newRand + " WHERE PRIMKEY = " + newRand;
                BackupRestoreLogUntil1.printInfo(7, BackupRestoreLogUntil1.getTestClassId(), this.sString);
                this.stmt.execute(this.sString);
            }
            if (this.rand >= 90 && this.rand < 100 && this.j > 50) {
                this.sString = "DELETE FROM " + mTabName + " WHERE PRIMKEY = " + this.j;
                BackupRestoreLogUntil1.printInfo(7, BackupRestoreLogUntil1.getTestClassId(), this.sString);
                this.stmt.execute(this.sString);
                --this.j;
            }
            if (this.i % 100 == 0) {
                this.mConnection.commit();
            }
            ++this.i;
        }
        this.mConnection.commit();
        ResultSet rs = null;
        this.stmt = new TestStatement((TestCase)this, this.mConnection);
        this.checkValues[mCounter] = "";
        this.sString = "Select count(*) from " + mTabName;
        rs = this.stmt.executeQuery(this.sString);
        rs.next();
        int n = mCounter;
        this.checkValues[n] = this.checkValues[n] + "Result of \"" + this.sString + "\" -> ";
        int row_counts = rs.getInt(1);
        int n2 = mCounter;
        this.checkValues[n2] = this.checkValues[n2] + row_counts + "\n";
        this.sString = "Select * from " + mTabName + " WHERE PRIMKEY > " + (row_counts - 10);
        rs = this.stmt.executeQuery(this.sString);
        int n3 = mCounter;
        this.checkValues[n3] = this.checkValues[n3] + "Result of \"" + this.sString + "\"\n";
        int n4 = mCounter;
        this.checkValues[n4] = this.checkValues[n4] + "PrimKey \t Name \t\t PersNr\t Adresse\n";
        while (rs.next()) {
            int n5 = mCounter;
            this.checkValues[n5] = this.checkValues[n5] + " " + rs.getInt(1) + " ";
            int n6 = mCounter;
            this.checkValues[n6] = this.checkValues[n6] + "\t\t " + rs.getString(2) + " ";
            int n7 = mCounter;
            this.checkValues[n7] = this.checkValues[n7] + "\t  " + rs.getInt(3) + " ";
            int n8 = mCounter;
            this.checkValues[n8] = this.checkValues[n8] + "\t  " + rs.getString(4) + "\n";
        }
        this.sString = "Select SUM(PRIMKEY) from " + mTabName;
        rs = this.stmt.executeQuery(this.sString);
        rs.next();
        int n9 = mCounter;
        this.checkValues[n9] = this.checkValues[n9] + "Result of \"" + this.sString + "\" -> ";
        int n10 = mCounter;
        this.checkValues[n10] = this.checkValues[n10] + rs.getInt(1) + "\n";
        this.mConnection.commit();
        this.stmt.close();
    }

    private void deleteTable(String mTabName) throws TestCaseException, SQLException {
        this.stmt = new TestStatement((TestCase)this, this.mConnection);
        this.sString = "DROP TABLE " + mTabName;
        BackupRestoreLogUntil1.printInfo(5, BackupRestoreLogUntil1.getTestClassId(), this.sString);
        this.stmt.executeUpdateIgnoreErrors(this.sString);
        this.mConnection.commit();
        this.stmt.close();
    }

    private void createBackUpMedium() throws TestCaseException, SQLException, TestDatabaseException {
        this.executeDBMCmd("util_connect");
        this.executeDBMCmd("backup_media_put LCRecoverTest401log LCRecoverTest401log FILE LOG");
        this.executeDBMCmd("backup_media_put LCRecoverTest401dat LCRecoverTest401dat FILE DATA 0 8 YES NO ");
        this.executeDBMCmd("util_release");
    }

    private void backUpData() throws TestCaseException, SQLException, TestDatabaseException {
        this.setStatus("createBackup");
        BackupRestoreLogUntil1.printInfo(2, BackupRestoreLogUntil1.getTestClassId(), "Backup_save DATA");
        this.executeDBMCmd("util_connect");
        this.executeDBMCmd("backup_save LCRecoverTest401dat DATA");
        this.executeDBMCmd("util_release");
    }

    private void backUpLogWarm() throws TestCaseException, SQLException, TestDatabaseException {
        this.setStatus("createBackup");
        BackupRestoreLogUntil1.printInfo(2, BackupRestoreLogUntil1.getTestClassId(), "Backup_save LOG");
        this.executeDBMCmd("util_connect");
        this.executeDBMCmd("backup_save LCRecoverTest401log LOG");
        this.executeDBMCmd("util_release");
        ++this.expectedLogSaves;
    }

    private void backUpLogCold() throws TestCaseException, SQLException, TestDatabaseException {
        this.executeDBMCmd("db_cold -" + this.mKernelMode);
        this.setStatus("createBackup");
        BackupRestoreLogUntil1.printInfo(2, BackupRestoreLogUntil1.getTestClassId(), "Backup_save LOG");
        this.executeDBMCmd("util_connect");
        this.executeDBMCmd("backup_save LCRecoverTest401log LOG");
        this.executeDBMCmd("util_release");
        ++this.expectedLogSaves;
    }

    private void produceDummyLog() throws TestCaseException, SQLException, TestDatabaseException {
        Connection mLogConnection = BackupRestoreLogUntil1.getDatabase().connect(BackupRestoreLogUntil1.getUser(), BackupRestoreLogUntil1.getPassword());
        this.stmt = new TestStatement((TestCase)this, mLogConnection);
        if (mWorkOnDatabase <= 0) {
            return;
        }
        BackupRestoreLogUntil1.printInfo(4, BackupRestoreLogUntil1.getTestClassId(), "Working with data in the database to produce dummy log ...");
        this.i = 1;
        while (this.i <= mWorkOnDatabase) {
            this.rand = Math.abs(this.r.nextInt() % 100) + 1;
            if (this.rand < 50) {
                ++this.dummyj;
                this.sString = "INSERT INTO TT_DUMMY_LOG VALUES(" + this.dummyj + ", 'name " + this.dummyj + "', " + this.dummyj * 2 + " , 'adresse " + this.dummyj + "')";
                BackupRestoreLogUntil1.printInfo(8, BackupRestoreLogUntil1.getTestClassId(), this.sString);
                this.stmt.execute(this.sString);
            }
            if (this.rand >= 50 && this.rand < 90 && this.dummyj > 3) {
                int newRand = Math.abs(this.r.nextInt() % this.dummyj) + 1;
                this.sString = "UPDATE TT_DUMMY_LOG SET PERSNR = " + this.dummyj * newRand + " WHERE PRIMKEY = " + newRand;
                BackupRestoreLogUntil1.printInfo(8, BackupRestoreLogUntil1.getTestClassId(), this.sString);
                this.stmt.execute(this.sString);
                String newAdress = "";
                for (int z = 1; z < Math.abs(this.r.nextInt() % 200) + 1; ++z) {
                    newAdress = newAdress + "" + (Math.abs(this.r.nextInt() % 9) + 1);
                }
                this.sString = "UPDATE TT_DUMMY_LOG SET ADRESSE = 'adresse " + newAdress + "' WHERE PRIMKEY = " + newRand;
                BackupRestoreLogUntil1.printInfo(8, BackupRestoreLogUntil1.getTestClassId(), this.sString);
                this.stmt.execute(this.sString);
            }
            if (this.rand >= 90 && this.rand < 100 && this.dummyj > 50) {
                this.sString = "DELETE FROM TT_DUMMY_LOG WHERE PRIMKEY = " + this.dummyj;
                BackupRestoreLogUntil1.printInfo(8, BackupRestoreLogUntil1.getTestClassId(), this.sString);
                this.stmt.execute(this.sString);
                --this.dummyj;
            }
            if (this.rand >= 100) {
                if (this.indexExists) {
                    this.sString = "DROP INDEX TT_DUMMY_LOG_IND1";
                    this.stmt.execute(this.sString);
                    this.indexExists = false;
                }
                this.sString = "CREATE INDEX TT_DUMMY_LOG_IND1 ON TT_DUMMY_LOG (NAME)";
                this.stmt.execute(this.sString);
                mLogConnection.commit();
                this.indexExists = true;
            }
            if (this.i % 100 == 0) {
                mLogConnection.commit();
            }
            ++this.i;
        }
        mLogConnection.commit();
        this.stmt.close();
        mLogConnection.close();
    }

    public void run() {
        try {
            this.setStatus("startUp");
            this.startUp();
            this.setStatus("createBackUpMedium");
            this.createBackUpMedium();
            this.setStatus("BackUp DATA");
            this.backUpData();
            this.setStatus("Work on Database");
            this.createTableAndFill("TT_TAB1", 1);
            this.produceDummyLog();
            this.setStatus("BackUp Log warm");
            this.backUpLogWarm();
            this.generateTimeStamp(1);
            this.deleteTable("TT_TAB1");
            this.createTableAndFill("TT_TAB2", 2);
            this.produceDummyLog();
            this.createTableAndFill("TT_TAB3", 3);
            this.produceDummyLog();
            this.setStatus("BackUp Log warm");
            this.backUpLogWarm();
            this.generateTimeStamp(3);
            this.deleteTable("TT_TAB3");
            this.deleteTable("TT_TAB2");
            this.setStatus("BackUp Log cold");
            this.produceDummyLog();
            this.backUpLogCold();
            this.executeDBMCmd("db_warm -" + this.mKernelMode);
            this.createTableAndFill("TT_TAB4", 4);
            this.produceDummyLog();
            this.generateTimeStamp(4);
            this.deleteTable("TT_TAB4");
            this.setStatus("BackUp Log cold");
            this.backUpLogCold();
            this.checkBackUpState();
            this.setStatus("Restart Database");
            this.restartDatabaseCold();
            this.setStatus("Recover Data");
            this.recoverData();
            this.setStatus("Recover LOG");
            this.recoverUntilLog(1);
            this.setStatus("Check State");
            this.checkTable("TT_TAB1", 1);
            this.setStatus("Restart Database");
            this.restartDatabaseCold();
            this.setStatus("Recover Data");
            this.recoverData();
            this.setStatus("Recover LOG");
            this.recoverUntilLog(3);
            this.setStatus("Check State");
            this.checkTable("TT_TAB2", 2);
            this.checkTable("TT_TAB3", 3);
            this.setStatus("Restart Database");
            this.restartDatabaseCold();
            this.setStatus("Recover Data");
            this.recoverData();
            this.setStatus("Recover LOG");
            this.recoverUntilLog(4);
            this.setStatus("Check State");
            this.checkTable("TT_TAB4", 4);
            this.setStatus("BackUp DATA");
            this.backUpData();
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
            System.out.println("Exception LocalizedMessage: " + e.getLocalizedMessage());
            System.out.println("Exception class: " + e.getClass());
            BackupRestoreLogUntil1.addGlobalMessage((String)BackupRestoreLogUntil1.getTestClassId(), (char)'E', (String)("Exception: " + e.getMessage()));
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            BackupRestoreLogUntil1.addGlobalMessage((String)BackupRestoreLogUntil1.getTestClassId(), (char)'T', (String)("Trace: " + sw.toString()));
        }
    }

    public static void cleanUp() throws TestCaseException {
    }

    static {
        mWorkOnDatabase = 0;
    }
}

