/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.performancetest;

import com.sap.dbtech.powertoys.DBM;
import com.sap.sapdb.benchmark.common.DBDescription;
import com.sap.sapdb.benchmark.common.ServerNode;
import com.sap.sapdb.benchmark.common.StorableObject;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestStatementMonitor;
import com.sap.sapdb.testframe.driver.TestStatementMonitorException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.utilities.Execute;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Properties;
import java.util.Random;

public class VarcharBlobPerformance
extends TestCase {
    public static final String VERSION = "0.0";
    private static final int MAXNOSTATEMENTS = 5000;
    private static final int MAXSTMT_GROUPS = 500;
    private static final int MAX_NUMBER_ROWS = 100;
    private static int mNumberOfRows;
    private static int mNumberOfRecords;
    private static int mStartKey;
    public static int mTraceLevel;
    private static boolean mTraceOn;
    private static String mHostName;
    private static int mTestNumber;
    private TestStatementMonitor mMonitor = null;
    private Connection mExclusiveConnection = null;
    private Statement mExclusiveStatement = null;
    private int mStatementTaskId = 0;
    private Connection mPrepExclusiveConnection = null;
    private PreparedStatement mPrepExclusiveStatement = null;
    private int mPrepStatementTaskId = 0;
    private Connection mMeasureConnection = null;
    private TestStatement mMeasureStatement = null;
    private Connection mMainConnection = null;
    private TestStatement mMainStatement = null;
    private long mRememberRuntime;
    private Random mRandomGenerator = new Random();
    private static final String mExUser = "PERFORMANCEUSER";
    private static final String mExPassword = "PERFORMANCEUSER";
    private DBM mDBMan = null;
    private Properties mDefResult;
    private Properties mOneResultRecord;
    private Properties[] mResults = new Properties[5000];
    private int mTestRunId = 0;
    private int mStatementCounter = 0;
    private String mStmtDescription = "";
    private static TestDatabaseSap mTestDB;
    private static DBDescription mDbdescription;
    private static ServerNode mServernode;
    private static String mKernelVersion;

    static {
        mTestNumber = 0;
        mTestDB = null;
        mDbdescription = null;
        mServernode = null;
    }

    public static void prepare() throws TestCaseException {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block13: {
            sql = "";
            rs = null;
            rsDBMcmd = "";
            try {
                try {
                    VarcharBlobPerformance.mTraceLevel = TestCase.getParameterInt((String)"TraceLevel", (int)2);
                    VarcharBlobPerformance.mTraceOn = TestCase.getParameterBoolean((String)"TraceOn", (boolean)false);
                    VarcharBlobPerformance.printInfo(1, "StatementRuntimes", "*************************************************");
                    VarcharBlobPerformance.printInfo(1, "StatementRuntimes", "   VarcharBlobPerformance - Version: 0.0");
                    VarcharBlobPerformance.printInfo(1, "StatementRuntimes", "*************************************************");
                    VarcharBlobPerformance.printInfo(2, "StatementRuntimes", "TraceLevel    = " + VarcharBlobPerformance.mTraceLevel);
                    VarcharBlobPerformance.printInfo(2, "StatementRuntimes", "TraceOn       = " + VarcharBlobPerformance.mTraceOn + "\n");
                    this.setStatus("Creating DB users and connections");
                    this.startUp();
                    this.setStatus("Creating tables");
                    this.createTables();
                    if (VarcharBlobPerformance.mTraceOn) {
                        this.executeDBMCmd("util_connect");
                        this.executeDBMCmd("util_execute diagnose vtrace default on");
                        this.executeDBMCmd("util_execute diagnose vtrace object on");
                        this.executeDBMCmd("util_execute diagnose check pages on");
                        this.executeDBMCmd("util_execute diagnose vtrace time on");
                        this.executeDBMCmd("util_release");
                    }
                    VarcharBlobPerformance.mNumberOfRecords = 100;
                    VarcharBlobPerformance.mStartKey = 1;
                    this.mStmtDescription = "VARCHAR_8K: INSERT " + VarcharBlobPerformance.mNumberOfRecords + " single 8K records         ";
                    this.insertMultipleRecords("MYVARCHARTAB_8K", "HUGE", VarcharBlobPerformance.mNumberOfRecords, VarcharBlobPerformance.mStartKey, 201);
                    this.mStmtDescription = "BLOB_8K   : INSERT " + VarcharBlobPerformance.mNumberOfRecords + " single 8K records         ";
                    this.insertMultipleRecords("MYLONGTAB_8K", "HUGE", VarcharBlobPerformance.mNumberOfRecords, VarcharBlobPerformance.mStartKey, 202);
                    this.mStmtDescription = "VARCHAR_8K: INSERT " + VarcharBlobPerformance.mNumberOfRecords + " single 4K records         ";
                    this.insertMultipleRecords("MYVARCHARTAB_8K", "LARGE", VarcharBlobPerformance.mNumberOfRecords, VarcharBlobPerformance.mStartKey += VarcharBlobPerformance.mNumberOfRecords, 203);
                    this.mStmtDescription = "BLOB_8K   : INSERT " + VarcharBlobPerformance.mNumberOfRecords + " single 4K records         ";
                    this.insertMultipleRecords("MYLONGTAB_8K", "LARGE", VarcharBlobPerformance.mNumberOfRecords, VarcharBlobPerformance.mStartKey, 204);
                    this.mStmtDescription = "VARCHAR_8K: INSERT " + VarcharBlobPerformance.mNumberOfRecords + " single 2K records         ";
                    this.insertMultipleRecords("MYVARCHARTAB_8K", "MEDIUM", VarcharBlobPerformance.mNumberOfRecords, VarcharBlobPerformance.mStartKey += VarcharBlobPerformance.mNumberOfRecords, 205);
                    this.mStmtDescription = "BLOB_8K   : INSERT " + VarcharBlobPerformance.mNumberOfRecords + " single 2K records         ";
                    this.insertMultipleRecords("MYLONGTAB_8K", "MEDIUM", VarcharBlobPerformance.mNumberOfRecords, VarcharBlobPerformance.mStartKey, 206);
                    this.mStmtDescription = "VARCHAR_8K: INSERT " + VarcharBlobPerformance.mNumberOfRecords + " single 500B records         ";
                    this.insertMultipleRecords("MYVARCHARTAB_8K", "SMALL", VarcharBlobPerformance.mNumberOfRecords, VarcharBlobPerformance.mStartKey += VarcharBlobPerformance.mNumberOfRecords, 207);
                    this.mStmtDescription = "BLOB_8K   : INSERT " + VarcharBlobPerformance.mNumberOfRecords + " single 500B records         ";
                    this.insertMultipleRecords("MYLONGTAB_8K", "SMALL", VarcharBlobPerformance.mNumberOfRecords, VarcharBlobPerformance.mStartKey, 208);
                    this.mStmtDescription = "VARCHAR_8K: INSERT " + VarcharBlobPerformance.mNumberOfRecords + " single 100B records         ";
                    this.insertMultipleRecords("MYVARCHARTAB_8K", "TINY", VarcharBlobPerformance.mNumberOfRecords, VarcharBlobPerformance.mStartKey += VarcharBlobPerformance.mNumberOfRecords, 209);
                    this.mStmtDescription = "BLOB_8K   : INSERT " + VarcharBlobPerformance.mNumberOfRecords + " single 100B records         ";
                    this.insertMultipleRecords("MYLONGTAB_8K", "TINY", VarcharBlobPerformance.mNumberOfRecords, VarcharBlobPerformance.mStartKey, 210);
                    VarcharBlobPerformance.mNumberOfRecords = 100;
                    VarcharBlobPerformance.mStartKey = 501;
                    this.mStmtDescription = "VARCHAR_8K: INSERT " + VarcharBlobPerformance.mNumberOfRecords + " single 8K records         ";
                    this.insertMultipleRecords("MYVARCHARTAB_8K", "HUGE", VarcharBlobPerformance.mNumberOfRecords, VarcharBlobPerformance.mStartKey, 201);
                    this.mStmtDescription = "BLOB_8K   : INSERT " + VarcharBlobPerformance.mNumberOfRecords + " single 8K records         ";
                    this.insertMultipleRecords("MYLONGTAB_8K", "HUGE", VarcharBlobPerformance.mNumberOfRecords, VarcharBlobPerformance.mStartKey, 202);
                    this.mStmtDescription = "VARCHAR_8K: INSERT " + VarcharBlobPerformance.mNumberOfRecords + " single 4K records         ";
                    this.insertMultipleRecords("MYVARCHARTAB_8K", "LARGE", VarcharBlobPerformance.mNumberOfRecords, VarcharBlobPerformance.mStartKey += VarcharBlobPerformance.mNumberOfRecords, 203);
                    this.mStmtDescription = "BLOB_8K   : INSERT " + VarcharBlobPerformance.mNumberOfRecords + " single 4K records         ";
                    this.insertMultipleRecords("MYLONGTAB_8K", "LARGE", VarcharBlobPerformance.mNumberOfRecords, VarcharBlobPerformance.mStartKey, 204);
                    this.mStmtDescription = "VARCHAR_8K: INSERT " + VarcharBlobPerformance.mNumberOfRecords + " single 2K records         ";
                    this.insertMultipleRecords("MYVARCHARTAB_8K", "MEDIUM", VarcharBlobPerformance.mNumberOfRecords, VarcharBlobPerformance.mStartKey += VarcharBlobPerformance.mNumberOfRecords, 205);
                    this.mStmtDescription = "BLOB_8K   : INSERT " + VarcharBlobPerformance.mNumberOfRecords + " single 2K records         ";
                    this.insertMultipleRecords("MYLONGTAB_8K", "MEDIUM", VarcharBlobPerformance.mNumberOfRecords, VarcharBlobPerformance.mStartKey, 206);
                    this.mStmtDescription = "VARCHAR_8K: INSERT " + VarcharBlobPerformance.mNumberOfRecords + " single 500B records         ";
                    this.insertMultipleRecords("MYVARCHARTAB_8K", "SMALL", VarcharBlobPerformance.mNumberOfRecords, VarcharBlobPerformance.mStartKey += VarcharBlobPerformance.mNumberOfRecords, 207);
                    this.mStmtDescription = "BLOB_8K   : INSERT " + VarcharBlobPerformance.mNumberOfRecords + " single 500B records         ";
                    this.insertMultipleRecords("MYLONGTAB_8K", "SMALL", VarcharBlobPerformance.mNumberOfRecords, VarcharBlobPerformance.mStartKey, 208);
                    this.mStmtDescription = "VARCHAR_8K: INSERT " + VarcharBlobPerformance.mNumberOfRecords + " single 100B records         ";
                    this.insertMultipleRecords("MYVARCHARTAB_8K", "TINY", VarcharBlobPerformance.mNumberOfRecords, VarcharBlobPerformance.mStartKey += VarcharBlobPerformance.mNumberOfRecords, 209);
                    this.mStmtDescription = "BLOB_8K   : INSERT " + VarcharBlobPerformance.mNumberOfRecords + " single 100B records         ";
                    this.insertMultipleRecords("MYLONGTAB_8K", "TINY", VarcharBlobPerformance.mNumberOfRecords, VarcharBlobPerformance.mStartKey, 210);
                    VarcharBlobPerformance.mNumberOfRecords = 100;
                    VarcharBlobPerformance.mStartKey = 1;
                    mEndKey = 100;
                    this.mStmtDescription = "VARCHAR_8K: SELECT " + VarcharBlobPerformance.mNumberOfRecords + " 8K records         ";
                    this.selMultipleRecords(1L, 100L, "MYVARCHARTAB_8K", "KEY1", "V", 231);
                    this.selMultipleRecords(501L, 600L, "MYVARCHARTAB_8K", "KEY1", "V", 231);
                    this.mStmtDescription = "BLOB_8K   : SELECT " + VarcharBlobPerformance.mNumberOfRecords + " 8K records         ";
                    this.selMultipleRecords(1L, 100L, "MYLONGTAB_8K", "KEY1", "B", 232);
                    this.selMultipleRecords(501L, 600L, "MYLONGTAB_8K", "KEY1", "B", 232);
                    this.mStmtDescription = "VARCHAR_8K: SELECT " + VarcharBlobPerformance.mNumberOfRecords + " 4K records         ";
                    this.selMultipleRecords(101L, 200L, "MYVARCHARTAB_8K", "KEY1", "V", 233);
                    this.selMultipleRecords(601L, 700L, "MYVARCHARTAB_8K", "KEY1", "V", 233);
                    this.mStmtDescription = "BLOB_8K   : SELECT " + VarcharBlobPerformance.mNumberOfRecords + " 4K records         ";
                    this.selMultipleRecords(101L, 200L, "MYLONGTAB_8K", "KEY1", "B", 234);
                    this.selMultipleRecords(601L, 700L, "MYLONGTAB_8K", "KEY1", "B", 234);
                    this.mStmtDescription = "VARCHAR_8K: SELECT " + VarcharBlobPerformance.mNumberOfRecords + " 2K records         ";
                    this.selMultipleRecords(201L, 300L, "MYVARCHARTAB_8K", "KEY1", "V", 235);
                    this.selMultipleRecords(701L, 800L, "MYVARCHARTAB_8K", "KEY1", "V", 235);
                    this.mStmtDescription = "BLOB_8K   : SELECT " + VarcharBlobPerformance.mNumberOfRecords + " 2K records         ";
                    this.selMultipleRecords(201L, 300L, "MYLONGTAB_8K", "KEY1", "B", 236);
                    this.selMultipleRecords(701L, 800L, "MYLONGTAB_8K", "KEY1", "B", 236);
                    this.mStmtDescription = "VARCHAR_8K: SELECT " + VarcharBlobPerformance.mNumberOfRecords + " 500B records         ";
                    this.selMultipleRecords(301L, 400L, "MYVARCHARTAB_8K", "KEY1", "V", 237);
                    this.selMultipleRecords(801L, 900L, "MYVARCHARTAB_8K", "KEY1", "V", 237);
                    this.mStmtDescription = "BLOB_8K   : SELECT " + VarcharBlobPerformance.mNumberOfRecords + " 500B records         ";
                    this.selMultipleRecords(301L, 400L, "MYLONGTAB_8K", "KEY1", "B", 238);
                    this.selMultipleRecords(801L, 900L, "MYLONGTAB_8K", "KEY1", "B", 238);
                    this.mStmtDescription = "VARCHAR_8K: SELECT " + VarcharBlobPerformance.mNumberOfRecords + " 100B records         ";
                    this.selMultipleRecords(401L, 500L, "MYVARCHARTAB_8K", "KEY1", "V", 239);
                    this.selMultipleRecords(901L, 1000L, "MYVARCHARTAB_8K", "KEY1", "V", 239);
                    this.mStmtDescription = "BLOB_8K   : SELECT " + VarcharBlobPerformance.mNumberOfRecords + " 100B records         ";
                    this.selMultipleRecords(401L, 500L, "MYLONGTAB_8K", "KEY1", "B", 240);
                    this.selMultipleRecords(901L, 1000L, "MYLONGTAB_8K", "KEY1", "B", 240);
                    this.writeResultsToProtocol();
                    TestCase.addGlobalMessage((String)"run()", (char)'I', (String)"End of measurements! ");
                }
                catch (Exception e) {
                    TestCase.addGlobalMessage((String)"Method run", (char)'E', (String)("Exception: " + e.getClass() + e.getMessage()));
                    System.out.println("Method run Exception: " + e.getClass() + e.getMessage());
                }
            }
            catch (Throwable var6_6) {
                var5_7 = null;
                try {
                    this.mMainStatement.close();
                    this.mExclusiveStatement.close();
                    this.mMeasureStatement.close();
                    this.mPrepExclusiveStatement.close();
                    StorableObject.closeConnection();
                }
                catch (Exception var7_9) {
                    // empty catch block
                }
                try {
                    this.mMainConnection.commit();
                    this.mMainConnection.close();
                    this.mExclusiveConnection.commit();
                    this.mExclusiveConnection.close();
                    this.mMeasureConnection.commit();
                    this.mMeasureConnection.close();
                    this.mPrepExclusiveConnection.commit();
                    this.mPrepExclusiveConnection.close();
                    StorableObject.closeConnection();
                    throw var6_6;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw var6_6;
            }
            {
                var5_8 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 1968->2006)] { 
lbl143:
            // 1 sources

            this.mMainStatement.close();
            this.mExclusiveStatement.close();
            this.mMeasureStatement.close();
            this.mPrepExclusiveStatement.close();
            StorableObject.closeConnection();
            break block13;
lbl149:
            // 1 sources

            catch (Exception var7_10) {
                // empty catch block
            }
        }
        try {}
        catch (Exception e) {
            return;
        }
        this.mMainConnection.commit();
        this.mMainConnection.close();
        this.mExclusiveConnection.commit();
        this.mExclusiveConnection.close();
        this.mMeasureConnection.commit();
        this.mMeasureConnection.close();
        this.mPrepExclusiveConnection.commit();
        this.mPrepExclusiveConnection.close();
        StorableObject.closeConnection();
    }

    public static void cleanUp() throws TestCaseException {
        System.out.println("End of measurement");
    }

    public static String getTestClassId() {
        return "VarcharBlobPerformance";
    }

    private void createTables() {
        try {
            this.mMainStatement.executeUpdate("CREATE TABLE MYVARCHARTAB_8K (KEY1 FIXED (12),  COL1 VARCHAR(8000), PRIMARY KEY (KEY1))");
            this.mMainStatement.executeUpdate("CREATE TABLE MYLONGTAB_8K (KEY1 FIXED (12),  COL1 LONG BYTE, PRIMARY KEY (KEY1))");
            this.mMainStatement.executeUpdate("CREATE TABLE RESULTS (QUERY_NO FIXED (4),  STMT_CNT FIXED(4), STMT_DESCRIPTION VARCHAR(100),  METHOD_NAME VARCHAR(32),  DATE_TIME TIMESTAMP DEFAULT TIMESTAMP, RUN_TIME FIXED (20),  CPU_TIME FIXED (20), READIO FIXED(7), WRITEIO FIXED(7), RESULTCNT FIXED(20), VALUES_OK BOOLEAN DEFAULT FALSE)");
            VarcharBlobPerformance.printInfo(2, "createTables()", "Creating benchmark tables");
        }
        catch (SQLException se) {
            TestCase.addGlobalMessage((String)"createTables()", (char)'E', (String)("SQLException: " + se.getClass() + se.getMessage()));
        }
    }

    private void selMultipleRecords(long pBeginRange, long pEndRange, String pTable, String pField, String pType, int pQueryNo) {
        String lSqlString = "";
        int lCPUTime = 0;
        int lResCount = 0;
        ResultSet rs = null;
        try {
            lSqlString = "SELECT * FROM   " + pTable + " WHERE " + pTable + "." + pField + " BETWEEN " + pBeginRange + " AND " + pEndRange;
            this.mExclusiveStatement = this.mExclusiveConnection.createStatement();
            this.executeDBMCmd("db_cons time enable");
            this.executeDBMCmd("db_cons reset t_cnt");
            long lStart = System.currentTimeMillis();
            rs = this.mExclusiveStatement.executeQuery(lSqlString);
            while (rs.next()) {
                long lKey1 = rs.getLong("KEY1");
                if (pType.equals("V")) {
                    String string = rs.getString("COL1");
                }
                if (pType.equals("B")) {
                    byte[] byArray = rs.getBytes("COL1");
                }
                ++lResCount;
            }
            this.mExclusiveConnection.commit();
            long lEnd = System.currentTimeMillis();
            long lRuntime = lEnd - lStart;
            this.mMonitor.fill(this.mStatementTaskId, lRuntime);
            lCPUTime = this.mMonitor.getCPUTime() / 1000;
            this.storeResultsInJava("selMultipleRec", pQueryNo, this.mMonitor.getNOWRuntime(), lCPUTime, this.mMonitor.getReadIO(), this.mMonitor.getWriteIO(), lSqlString, lResCount, this.mPrepStatementTaskId, this.mStmtDescription);
            this.executeDBMCmd("db_cons time disable");
            this.mMonitor.clearXCONSResults();
            this.mPrepExclusiveStatement.close();
            VarcharBlobPerformance.printInfo(2, "selMultipleRec()", String.valueOf(this.mStmtDescription) + "Runtime: " + lRuntime + " ms");
        }
        catch (Exception e) {
            TestCase.addGlobalMessage((String)"selMultipleRecords()", (char)'E', (String)("ERROR during FETCH: " + e.getClass() + e.getMessage()));
            System.out.println("StatementRuntimes: selMultipleRecords() -- ERROR during FETCH: " + e.getClass() + e.getMessage());
            e.printStackTrace();
        }
    }

    private String paddTo(String str, int len) {
        int l = str.length();
        if (l < len) {
            char[] ca = new char[len - l];
            Arrays.fill(ca, ' ');
            return String.valueOf(str) + new String(ca);
        }
        if (l == len) {
            return str;
        }
        return str.substring(0, len);
    }

    private void writeResultsToProtocol() {
        String lColumn = "";
        String lValue = "";
        long lQueryNo = 0L;
        long lStmtCnt = 0L;
        long lResultCnt = 0L;
        long lAvgRuntime = 0L;
        long lAvgCPUTime = 0L;
        long lAvgReadIO = 0L;
        long lAvgWriteIO = 0L;
        String lStmtDesc = "";
        int lExecutionCount = 0;
        StringBuffer lOutString = new StringBuffer();
        try {
            lOutString.append("----------------------------------------------------------- \n");
            lOutString.append("RESULT SUMMAY: \n");
            lOutString.append("------------------------------------------------------------------------------------------------- \n");
            lOutString.append("query    statement description                       runtime (ms) cputime (ms) # execs  # records \n");
            lOutString.append("------------------------------------------------------------------------------------------------- \n");
            int j = 0;
            while (j <= 500) {
                ResultSet rs = this.mMainStatement.executeQuery("SELECT * FROM RESULTS WHERE QUERY_NO = " + j);
                while (rs.next()) {
                    lQueryNo = rs.getLong("QUERY_NO");
                    lStmtDesc = rs.getString("STMT_DESCRIPTION");
                    lAvgRuntime += rs.getLong("RUN_TIME");
                    lAvgCPUTime += rs.getLong("CPU_TIME");
                    lAvgReadIO += rs.getLong("READIO");
                    lAvgWriteIO += rs.getLong("WRITEIO");
                    lResultCnt = rs.getLong("RESULTCNT");
                    ++lExecutionCount;
                }
                if (lExecutionCount != 0) {
                    lAvgReadIO /= (long)lExecutionCount;
                    lAvgWriteIO /= (long)lExecutionCount;
                    lOutString.append(String.valueOf(this.paddToRightJustified(String.valueOf(lQueryNo), 3)) + "   " + this.paddTo(lStmtDesc, 45) + this.paddToRightJustified(String.valueOf(lAvgRuntime /= (long)lExecutionCount), 12) + this.paddToRightJustified(String.valueOf(lAvgCPUTime /= (long)lExecutionCount), 13) + this.paddToRightJustified(String.valueOf(lExecutionCount), 9) + this.paddToRightJustified(String.valueOf(lResultCnt), 8) + "\n");
                }
                lExecutionCount = 0;
                lAvgRuntime = 0L;
                lAvgCPUTime = 0L;
                lAvgReadIO = 0L;
                lAvgWriteIO = 0L;
                lResultCnt = 0L;
                ++j;
            }
            VarcharBlobPerformance.printInfo(2, "RESULT SUMMARY: ", lOutString.toString());
        }
        catch (Exception e) {
            TestCase.addGlobalMessage((String)"writeResultsToProtocol()", (char)'E', (String)("ERROR: " + e.getClass() + e.getMessage()));
            System.out.println("writeResultsToProtocol() -- ERROR: " + e.getClass() + e.getMessage());
        }
    }

    private void insertMultipleRecords(String pTable, String pSize, int pNumberOfRecords, int pStartKey, int pQueryNo) {
        String lSqlString = "";
        int lLength = 0;
        String lIn = "";
        String lShort = "";
        int lResCount = 0;
        int lCPUTime = 0;
        try {
            String lTestCase;
            if (pSize.equals("HUGE")) {
                lTestCase = "insSize8K";
                lLength = 8000;
                lShort = "8K";
            } else if (pSize.equals("LARGE")) {
                lTestCase = "insSize4K";
                lLength = 4000;
                lShort = "4K";
            } else if (pSize.equals("MEDIUM")) {
                lTestCase = "insSize2K";
                lLength = 2000;
                lShort = "2K";
            } else if (pSize.equals("SMALL")) {
                lTestCase = "insSize500B";
                lLength = 500;
                lShort = "500B";
            } else if (pSize.equals("TINY")) {
                lTestCase = "insSize100B";
                lLength = 100;
                lShort = "100B";
            }
            lResCount = 0;
            byte[] bytearr = new byte[lLength];
            int i = 0;
            while (i < bytearr.length) {
                bytearr[i] = 120;
                ++i;
            }
            lSqlString = "INSERT INTO " + pTable + " VALUES (?, ?)";
            this.mPrepExclusiveStatement = this.mPrepExclusiveConnection.prepareStatement(lSqlString);
            this.executeDBMCmd("db_cons time enable");
            this.executeDBMCmd("db_cons reset t_cnt");
            long lStart = System.currentTimeMillis();
            long end = pNumberOfRecords + pStartKey;
            long lTitle = pStartKey;
            while (lTitle < end) {
                this.mPrepExclusiveStatement.setLong(1, lTitle);
                this.mPrepExclusiveStatement.setBytes(2, bytearr);
                this.mPrepExclusiveStatement.executeUpdate();
                ++lResCount;
                ++lTitle;
            }
            this.mPrepExclusiveConnection.commit();
            long lEnd = System.currentTimeMillis();
            long lRuntime = lEnd - lStart;
            this.mMonitor.fill(this.mPrepStatementTaskId, lRuntime);
            lCPUTime = this.mMonitor.getCPUTime() / 1000;
            this.storeResultsInJava("insertMultipleRecords", pQueryNo, this.mMonitor.getNOWRuntime(), lCPUTime, this.mMonitor.getReadIO(), this.mMonitor.getWriteIO(), lSqlString, lResCount, this.mPrepStatementTaskId, this.mStmtDescription);
            this.executeDBMCmd("db_cons time disable");
            this.mMonitor.clearXCONSResults();
            this.mPrepExclusiveStatement.close();
            VarcharBlobPerformance.printInfo(2, "insertMultipleRecords()", String.valueOf(this.mStmtDescription) + "Runtime: " + lRuntime + " ms");
        }
        catch (Exception e) {
            TestCase.addGlobalMessage((String)"insertMultipleRecords()", (char)'E', (String)("ERROR during INSERT: " + e.getClass() + e.getMessage()));
            System.out.println("insertMultipleRecords() -- ERROR during INSERT: " + e.getClass() + e.getMessage());
        }
    }

    public String executeDBMCmd(String pCmd) {
        String logon = "";
        String mHost = "";
        String mName = "";
        try {
            mHost = TestCase.getDatabase().getHost();
            mName = TestCase.getDatabase().getName();
            int mPort = TestCase.getDatabase().getPort();
            if (this.mDBMan == null) {
                this.mDBMan = DBM.dbDBM((String)(String.valueOf(mHost) + ":" + mPort), (String)mName);
                logon = "USER_LOGON DBM,DBM";
                this.mDBMan.cmd(logon);
            }
            return this.mDBMan.cmd(pCmd);
        }
        catch (Exception e) {
            TestCase.addGlobalMessage((String)"executeDBMCmd()", (char)'W', (String)("Problem with command '" + pCmd + "' --> Exception: " + e.getMessage() + "\n" + e.getClass()));
            return "error";
        }
    }

    public String getHostname() {
        StringBuffer ProcessOutput = new StringBuffer();
        Execute SystemProcess = null;
        ProcessOutput.setLength(0);
        String currentCmd = "uname -n";
        SystemProcess = new Execute(currentCmd, null, ProcessOutput);
        SystemProcess.exec();
        if (SystemProcess.getExitValue() == 0 && ProcessOutput.length() != 0) {
            String hostName = ProcessOutput.toString().trim().toLowerCase();
            return hostName;
        }
        ProcessOutput.setLength(0);
        currentCmd = "hostname";
        SystemProcess = new Execute(currentCmd, null, ProcessOutput);
        SystemProcess.exec();
        if (SystemProcess.getExitValue() == 0 && ProcessOutput.length() != 0) {
            String hostName = ProcessOutput.toString().trim().toLowerCase();
            return hostName;
        }
        return "unknown";
    }

    private void startUp() {
        try {
            mHostName = TestCase.mTestDriverOptions.getProperty("DBHost");
            this.mMainConnection = TestCase.getDatabase().connect(TestCase.getUser(), TestCase.getPassword());
            this.mMainStatement = new TestStatement(null, this.mMainConnection);
            this.mMainStatement.enableExceptions(false);
            this.mMainStatement.executeUpdate("Drop user PERFORMANCEUSER");
            this.mMainStatement.executeUpdateIgnoreErrors("Drop table myvarchartab_8K");
            this.mMainStatement.executeUpdateIgnoreErrors("Drop table mylongtab_8K");
            this.mMainStatement.enableExceptions(true);
            this.mMainStatement.executeUpdate("Create user PERFORMANCEUSER password PERFORMANCEUSER dba not exclusive");
            this.mMainStatement.close();
            this.mMainConnection.close();
            this.mMainConnection = TestCase.getDatabase().connect("PERFORMANCEUSER", "PERFORMANCEUSER");
            this.mMainStatement = new TestStatement(null, this.mMainConnection);
            this.mExclusiveConnection = TestCase.getDatabase().connect("PERFORMANCEUSER", "PERFORMANCEUSER");
            this.mExclusiveConnection.setAutoCommit(false);
            this.mExclusiveStatement = this.mExclusiveConnection.createStatement();
            this.mPrepExclusiveConnection = TestCase.getDatabase().connect("PERFORMANCEUSER", "PERFORMANCEUSER");
            this.mPrepExclusiveConnection.setAutoCommit(false);
            this.mPrepExclusiveStatement = this.mPrepExclusiveConnection.prepareStatement("select process from dba.transactions, connectparameters where transactions.session = connectparameters.session");
            ResultSet rs = this.mPrepExclusiveStatement.executeQuery();
            if (rs.next()) {
                this.mPrepStatementTaskId = rs.getInt(1);
                VarcharBlobPerformance.printInfo(2, "StatementRuntimes", "startUp()            : Prepared statements to be measured use task ID: " + this.mPrepStatementTaskId);
            } else {
                TestCase.addGlobalMessage((String)"startUp()", (char)'E', (String)"Cannot determine TASK ID for prepared statements!");
            }
            this.mPrepExclusiveStatement.close();
            this.mMeasureConnection = TestCase.getDatabase().connect("PERFORMANCEUSER", "PERFORMANCEUSER");
            this.mMeasureStatement = new TestStatement(null, this.mMeasureConnection);
            this.mMonitor = new TestStatementMonitor(this.mMeasureConnection, TestCase.getDatabase().getHost(), TestCase.getDatabase().getName(), TestCase.getDatabase().getPort());
            rs = this.mExclusiveStatement.executeQuery("select process from transactions, connectparameters where transactions.session = connectparameters.session");
            if (rs.next()) {
                this.mStatementTaskId = rs.getInt(1);
            }
            VarcharBlobPerformance.printInfo(2, "StatementRuntimes", "startUp()            : Statements to be measured use task ID: " + this.mStatementTaskId);
            this.mOneResultRecord = new Properties();
        }
        catch (TestDatabaseException tde) {
            TestCase.addGlobalMessage((String)"startUp()", (char)'E', (String)("startUp() method failed with TestDatabaseException: " + ((Object)((Object)tde)).getClass() + tde.getMessage()));
        }
        catch (SQLException se) {
            TestCase.addGlobalMessage((String)"startUp()", (char)'E', (String)("startUp() method failed with SQLException: " + se.getClass() + se.getMessage()));
        }
        catch (TestStatementMonitorException tsme) {
            TestCase.addGlobalMessage((String)"startUp()", (char)'E', (String)("startUp() method failed with TestStatementMonitorException: " + ((Object)((Object)tsme)).getClass() + tsme.getMessage()));
        }
        catch (Exception e) {
            TestCase.addGlobalMessage((String)"startUp()", (char)'E', (String)("startUp() method failed with Exception: " + e.getClass() + e.getMessage()));
        }
    }

    private void storeResultsInJava(String pTestCase, int pTestNumber, long pRuntime, int pCPUTime, int pReadIO, int pWriteIO, String pSQLString, int pNumberOfRows, int pTaskId, String pStmtDesc) {
        try {
            ++this.mStatementCounter;
            this.mOneResultRecord.setProperty("testrun_id", String.valueOf(this.mTestRunId));
            this.mOneResultRecord.setProperty("query_no", String.valueOf(pTestNumber));
            this.mOneResultRecord.setProperty("stmt_cnt", String.valueOf(this.mStatementCounter));
            this.mOneResultRecord.setProperty("stmt_description", "'" + pStmtDesc + "'");
            this.mOneResultRecord.setProperty("method_name", "'" + pTestCase + "'");
            this.mOneResultRecord.setProperty("run_time", String.valueOf(pRuntime));
            this.mOneResultRecord.setProperty("cpu_time", String.valueOf(pCPUTime));
            this.mOneResultRecord.setProperty("readio", String.valueOf(pReadIO));
            this.mOneResultRecord.setProperty("writeio", String.valueOf(pWriteIO));
            this.mOneResultRecord.setProperty("statement", "'" + pSQLString + "'");
            this.mOneResultRecord.setProperty("resultcnt", String.valueOf(pNumberOfRows));
            this.mOneResultRecord.setProperty("taskid", String.valueOf(pTaskId));
            this.mResults[this.mStatementCounter] = (Properties)this.mOneResultRecord.clone();
            String lSqlString = "insert RESULTS set query_no = " + pTestNumber + ", stmt_cnt = " + this.mStatementCounter + ", stmt_description = '" + pStmtDesc + "', method_name = '" + pTestCase + "', RUN_TIME = " + pRuntime + ", CPU_TIME = " + pCPUTime + ", READIO = " + pReadIO + ", WRITEIO = " + pWriteIO + ", RESULTCNT = " + pNumberOfRows + ", VALUES_OK = TRUE";
            TestPreparedStatement myPrepStatement = new TestPreparedStatement(null, this.mMeasureConnection, lSqlString);
            myPrepStatement.execute();
        }
        catch (Exception e) {
            System.out.println("storeResultsInJava(): " + e.getClass() + e.getMessage());
            TestCase.addGlobalMessage((String)"storeResultsInJava()", (char)'E', (String)("Exception: " + e.getClass() + e.getMessage()));
        }
    }

    public static void printInfo(int Level2, String pComponent, String pInfoText) {
        if (Level2 <= mTraceLevel) {
            System.out.println(String.valueOf(pComponent) + " --> " + pInfoText);
        }
        if (Level2 < 7) {
            TestCase.addGlobalMessage((String)pComponent, (char)'I', (String)pInfoText);
        } else if (mTraceLevel >= 9) {
            TestCase.addGlobalMessage((String)pComponent, (char)'I', (String)pInfoText);
        }
    }

    private String paddToRightJustified(String str, int len) {
        int l = str.length();
        if (l < len) {
            char[] ca = new char[len - l];
            Arrays.fill(ca, ' ');
            return String.valueOf(new String(ca)) + str;
        }
        if (l == len) {
            return str;
        }
        return str.substring(0, len);
    }
}

