/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import java.util.Hashtable;

public class EncodingMap {
    protected static final Hashtable fIANA2JavaMap = new Hashtable();
    protected static final Hashtable fJava2IANAMap = new Hashtable();

    public static void putIANA2JavaMapping(String ianaEncoding, String javaEncoding) {
        fIANA2JavaMap.put(ianaEncoding, javaEncoding);
    }

    public static String getIANA2JavaMapping(String ianaEncoding) {
        return (String)fIANA2JavaMap.get(ianaEncoding);
    }

    public static String removeIANA2JavaMapping(String ianaEncoding) {
        return (String)fIANA2JavaMap.remove(ianaEncoding);
    }

    public static void putJava2IANAMapping(String javaEncoding, String ianaEncoding) {
        fJava2IANAMap.put(javaEncoding, ianaEncoding);
    }

    public static String getJava2IANAMapping(String javaEncoding) {
        return (String)fJava2IANAMap.get(javaEncoding);
    }

    public static String removeJava2IANAMapping(String javaEncoding) {
        return (String)fJava2IANAMap.remove(javaEncoding);
    }

    static {
        fIANA2JavaMap.put("BIG5", "Big5");
        fIANA2JavaMap.put("EBCDIC-CP-US", "CP037");
        fIANA2JavaMap.put("EBCDIC-CP-CA", "CP037");
        fIANA2JavaMap.put("EBCDIC-CP-NL", "CP037");
        fIANA2JavaMap.put("EBCDIC-CP-DK", "CP277");
        fIANA2JavaMap.put("EBCDIC-CP-NO", "CP277");
        fIANA2JavaMap.put("EBCDIC-CP-FI", "CP278");
        fIANA2JavaMap.put("EBCDIC-CP-SE", "CP278");
        fIANA2JavaMap.put("EBCDIC-CP-IT", "CP280");
        fIANA2JavaMap.put("EBCDIC-CP-ES", "CP284");
        fIANA2JavaMap.put("EBCDIC-CP-GB", "CP285");
        fIANA2JavaMap.put("EBCDIC-CP-FR", "CP297");
        fIANA2JavaMap.put("EBCDIC-CP-AR1", "CP420");
        fIANA2JavaMap.put("EBCDIC-CP-HE", "CP424");
        fIANA2JavaMap.put("EBCDIC-CP-CH", "CP500");
        fIANA2JavaMap.put("EBCDIC-CP-ROECE", "CP870");
        fIANA2JavaMap.put("EBCDIC-CP-YU", "CP870");
        fIANA2JavaMap.put("EBCDIC-CP-IS", "CP871");
        fIANA2JavaMap.put("EBCDIC-CP-AR2", "CP918");
        fIANA2JavaMap.put("EUC-JP", "EUCJIS");
        fIANA2JavaMap.put("EUC-KR", "KSC5601");
        fIANA2JavaMap.put("GB2312", "GB2312");
        fIANA2JavaMap.put("ISO-2022-JP", "JIS");
        fIANA2JavaMap.put("ISO-2022-KR", "ISO2022KR");
        fIANA2JavaMap.put("ISO-8859-1", "8859_1");
        fIANA2JavaMap.put("ISO-8859-2", "8859_2");
        fIANA2JavaMap.put("ISO-8859-3", "8859_3");
        fIANA2JavaMap.put("ISO-8859-4", "8859_4");
        fIANA2JavaMap.put("ISO-8859-5", "8859_5");
        fIANA2JavaMap.put("ISO-8859-6", "8859_6");
        fIANA2JavaMap.put("ISO-8859-7", "8859_7");
        fIANA2JavaMap.put("ISO-8859-8", "8859_8");
        fIANA2JavaMap.put("ISO-8859-9", "8859_9");
        fIANA2JavaMap.put("KOI8-R", "KOI8_R");
        fIANA2JavaMap.put("US-ASCII", "8859_1");
        fIANA2JavaMap.put("UTF-8", "UTF8");
        fIANA2JavaMap.put("UTF-16", "Unicode");
        fJava2IANAMap.put("8859_1", "ISO-8859-1");
        fJava2IANAMap.put("8859_2", "ISO-8859-2");
        fJava2IANAMap.put("8859_3", "ISO-8859-3");
        fJava2IANAMap.put("8859_4", "ISO-8859-4");
        fJava2IANAMap.put("8859_5", "ISO-8859-5");
        fJava2IANAMap.put("8859_6", "ISO-8859-6");
        fJava2IANAMap.put("8859_7", "ISO-8859-7");
        fJava2IANAMap.put("8859_8", "ISO-8859-8");
        fJava2IANAMap.put("8859_9", "ISO-8859-9");
        fJava2IANAMap.put("BIG5", "Big5");
        fJava2IANAMap.put("CP037", "EBCDIC-CP-US");
        fJava2IANAMap.put("CP037", "EBCDIC-CP-CA");
        fJava2IANAMap.put("CP037", "EBCDIC-CP-NL");
        fJava2IANAMap.put("CP277", "EBCDIC-CP-DK");
        fJava2IANAMap.put("CP277", "EBCDIC-CP-NO");
        fJava2IANAMap.put("CP278", "EBCDIC-CP-FI");
        fJava2IANAMap.put("CP278", "EBCDIC-CP-SE");
        fJava2IANAMap.put("CP280", "EBCDIC-CP-IT");
        fJava2IANAMap.put("CP284", "EBCDIC-CP-ES");
        fJava2IANAMap.put("CP285", "EBCDIC-CP-GB");
        fJava2IANAMap.put("CP297", "EBCDIC-CP-FR");
        fJava2IANAMap.put("CP420", "EBCDIC-CP-AR1");
        fJava2IANAMap.put("CP424", "EBCDIC-CP-HE");
        fJava2IANAMap.put("CP500", "EBCDIC-CP-CH");
        fJava2IANAMap.put("CP870", "EBCDIC-CP-ROECE");
        fJava2IANAMap.put("CP870", "EBCDIC-CP-YU");
        fJava2IANAMap.put("CP871", "EBCDIC-CP-IS");
        fJava2IANAMap.put("CP918", "EBCDIC-CP-AR2");
        fJava2IANAMap.put("EUCJIS", "EUC-JP");
        fJava2IANAMap.put("GB2312", "GB2312");
        fJava2IANAMap.put("ISO2022KR", "ISO-2022-KR");
        fJava2IANAMap.put("JIS", "ISO-2022-JP");
        fJava2IANAMap.put("KOI8_R", "KOI8-R");
        fJava2IANAMap.put("KSC5601", "EUC-KR");
        fJava2IANAMap.put("SJIS", "Shift_JIS");
        fJava2IANAMap.put("UTF8", "UTF-8");
        fJava2IANAMap.put("Unicode", "UTF-16");
    }
}

