/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.Hashtable;
import org.apache.xerces.impl.dv.xs.AnySimpleType;
import org.apache.xerces.impl.dv.xs.AnyURIDatatypeValidator;
import org.apache.xerces.impl.dv.xs.Base64BinaryDatatypeValidator;
import org.apache.xerces.impl.dv.xs.BooleanDatatypeValidator;
import org.apache.xerces.impl.dv.xs.DatatypeValidator;
import org.apache.xerces.impl.dv.xs.DateDatatypeValidator;
import org.apache.xerces.impl.dv.xs.DateTimeDatatypeValidator;
import org.apache.xerces.impl.dv.xs.DayDatatypeValidator;
import org.apache.xerces.impl.dv.xs.DecimalDatatypeValidator;
import org.apache.xerces.impl.dv.xs.DoubleDatatypeValidator;
import org.apache.xerces.impl.dv.xs.DurationDatatypeValidator;
import org.apache.xerces.impl.dv.xs.EntityDatatypeValidator;
import org.apache.xerces.impl.dv.xs.FloatDatatypeValidator;
import org.apache.xerces.impl.dv.xs.HexBinaryDatatypeValidator;
import org.apache.xerces.impl.dv.xs.IDDatatypeValidator;
import org.apache.xerces.impl.dv.xs.IDREFDatatypeValidator;
import org.apache.xerces.impl.dv.xs.ListDatatypeValidator;
import org.apache.xerces.impl.dv.xs.MonthDatatypeValidator;
import org.apache.xerces.impl.dv.xs.MonthDayDatatypeValidator;
import org.apache.xerces.impl.dv.xs.NOTATIONDatatypeValidator;
import org.apache.xerces.impl.dv.xs.QNameDatatypeValidator;
import org.apache.xerces.impl.dv.xs.StringDatatypeValidator;
import org.apache.xerces.impl.dv.xs.TimeDatatypeValidator;
import org.apache.xerces.impl.dv.xs.YearDatatypeValidator;
import org.apache.xerces.impl.dv.xs.YearMonthDatatypeValidator;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSAttributeDecl;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSGroupDecl;
import org.apache.xerces.impl.xs.XSNotationDecl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.util.SymbolHash;
import org.apache.xerces.util.SymbolTable;

public class SchemaGrammar {
    private SymbolTable fSymbolTable;
    public String fTargetNamespace;
    SymbolHash fGlobalAttrDecls;
    SymbolHash fGlobalAttrGrpDecls;
    SymbolHash fGlobalElemDecls;
    SymbolHash fGlobalGroupDecls;
    SymbolHash fGlobalNotationDecls;
    SymbolHash fGlobalTypeDecls;
    SymbolHash fGlobalIDConstraintDecls;
    private static final int BASICSET_COUNT = 29;
    private static final int FULLSET_COUNT = 46;
    private static final int INITIAL_SIZE = 16;
    private int fCTCount = 0;
    private XSComplexTypeDecl[] fComplexTypeDecls = new XSComplexTypeDecl[16];
    public static final XSComplexTypeDecl fAnyType = new XSComplexTypeDecl();
    public static final DatatypeValidator fAnySimpleType = new AnySimpleType();
    public static final SchemaGrammar SG_SchemaNS;
    public static final SchemaGrammar SG_SchemaBasicSet;

    public SchemaGrammar(SymbolTable symbolTable, String targetNamespace) {
        this.fSymbolTable = symbolTable;
        this.fTargetNamespace = targetNamespace;
        this.fGlobalAttrDecls = new SymbolHash();
        this.fGlobalAttrGrpDecls = new SymbolHash();
        this.fGlobalElemDecls = new SymbolHash();
        this.fGlobalGroupDecls = new SymbolHash();
        this.fGlobalNotationDecls = new SymbolHash();
        this.fGlobalTypeDecls = new SymbolHash();
        this.fGlobalIDConstraintDecls = new SymbolHash();
    }

    private final void addGlobalTypeDecl(String name, XSTypeDecl decl) {
        this.fGlobalTypeDecls.put(name, (Object)decl);
    }

    protected SchemaGrammar(SymbolTable symbolTable, boolean fullSet) {
        this.fSymbolTable = symbolTable;
        this.fTargetNamespace = SchemaSymbols.URI_SCHEMAFORSCHEMA;
        this.fGlobalAttrDecls = new SymbolHash(1);
        this.fGlobalAttrGrpDecls = new SymbolHash(1);
        this.fGlobalElemDecls = new SymbolHash(1);
        this.fGlobalGroupDecls = new SymbolHash(1);
        this.fGlobalNotationDecls = new SymbolHash(1);
        this.fGlobalIDConstraintDecls = new SymbolHash(1);
        this.fGlobalTypeDecls = new SymbolHash((fullSet ? 46 : 29) * 2);
        this.addGlobalTypeDecl("anyType", fAnyType);
        this.addGlobalTypeDecl("anySimpleType", fAnySimpleType);
        StringDatatypeValidator stringDV = new StringDatatypeValidator(fAnySimpleType, null, false, null);
        this.addGlobalTypeDecl("string", stringDV);
        this.addGlobalTypeDecl("boolean", new BooleanDatatypeValidator(fAnySimpleType, null, false, null));
        DecimalDatatypeValidator decimalDV = new DecimalDatatypeValidator(fAnySimpleType, null, false, null);
        this.addGlobalTypeDecl("decimal", decimalDV);
        this.addGlobalTypeDecl("anyURI", new AnyURIDatatypeValidator(fAnySimpleType, null, false, null));
        this.addGlobalTypeDecl("base64Binary", new Base64BinaryDatatypeValidator(fAnySimpleType, null, false, null));
        this.addGlobalTypeDecl("duration", new DurationDatatypeValidator(fAnySimpleType, null, false, null));
        this.addGlobalTypeDecl("dateTime", new DateTimeDatatypeValidator(fAnySimpleType, null, false, null));
        this.addGlobalTypeDecl("time", new TimeDatatypeValidator(fAnySimpleType, null, false, null));
        this.addGlobalTypeDecl("date", new DateDatatypeValidator(fAnySimpleType, null, false, null));
        this.addGlobalTypeDecl("gYearMonth", new YearMonthDatatypeValidator(fAnySimpleType, null, false, null));
        this.addGlobalTypeDecl("gYear", new YearDatatypeValidator(fAnySimpleType, null, false, null));
        this.addGlobalTypeDecl("gMonthDay", new MonthDayDatatypeValidator(fAnySimpleType, null, false, null));
        this.addGlobalTypeDecl("gDay", new DayDatatypeValidator(fAnySimpleType, null, false, null));
        this.addGlobalTypeDecl("gMonth", new MonthDatatypeValidator(fAnySimpleType, null, false, null));
        Hashtable<String, String> facets = new Hashtable<String, String>(2);
        facets.put(SchemaSymbols.ELT_FRACTIONDIGITS, "0");
        DecimalDatatypeValidator integerDV = new DecimalDatatypeValidator(decimalDV, facets, false, null);
        this.addGlobalTypeDecl("integer", integerDV);
        facets.clear();
        facets.put(SchemaSymbols.ELT_MAXINCLUSIVE, "0");
        DecimalDatatypeValidator nonPositiveDV = new DecimalDatatypeValidator(integerDV, facets, false, null);
        this.addGlobalTypeDecl("nonPositiveInteger", nonPositiveDV);
        facets.clear();
        facets.put(SchemaSymbols.ELT_MAXINCLUSIVE, "-1");
        this.addGlobalTypeDecl("negativeInteger", new DecimalDatatypeValidator(nonPositiveDV, facets, false, null));
        facets.clear();
        facets.put(SchemaSymbols.ELT_MAXINCLUSIVE, "9223372036854775807");
        facets.put(SchemaSymbols.ELT_MININCLUSIVE, "-9223372036854775808");
        DecimalDatatypeValidator longDV = new DecimalDatatypeValidator(integerDV, facets, false, null);
        this.addGlobalTypeDecl("long", longDV);
        facets.clear();
        facets.put(SchemaSymbols.ELT_MAXINCLUSIVE, "2147483647");
        facets.put(SchemaSymbols.ELT_MININCLUSIVE, "-2147483648");
        DecimalDatatypeValidator intDV = new DecimalDatatypeValidator(longDV, facets, false, null);
        this.addGlobalTypeDecl("int", intDV);
        facets.clear();
        facets.put(SchemaSymbols.ELT_MAXINCLUSIVE, "32767");
        facets.put(SchemaSymbols.ELT_MININCLUSIVE, "-32768");
        DecimalDatatypeValidator shortDV = new DecimalDatatypeValidator(intDV, facets, false, null);
        this.addGlobalTypeDecl("short", shortDV);
        facets.clear();
        facets.put(SchemaSymbols.ELT_MAXINCLUSIVE, "127");
        facets.put(SchemaSymbols.ELT_MININCLUSIVE, "-128");
        this.addGlobalTypeDecl("byte", new DecimalDatatypeValidator(shortDV, facets, false, null));
        facets.clear();
        facets.put(SchemaSymbols.ELT_MININCLUSIVE, "0");
        DecimalDatatypeValidator nonNegativeDV = new DecimalDatatypeValidator(integerDV, facets, false, null);
        this.addGlobalTypeDecl("nonNegativeInteger", nonNegativeDV);
        facets.clear();
        facets.put(SchemaSymbols.ELT_MAXINCLUSIVE, "18446744073709551615");
        DecimalDatatypeValidator unsignedLongDV = new DecimalDatatypeValidator(nonNegativeDV, facets, false, null);
        this.addGlobalTypeDecl("unsignedLong", unsignedLongDV);
        facets.clear();
        facets.put(SchemaSymbols.ELT_MAXINCLUSIVE, "4294967295");
        DecimalDatatypeValidator unsignedIntDV = new DecimalDatatypeValidator(unsignedLongDV, facets, false, null);
        this.addGlobalTypeDecl("unsignedInt", unsignedIntDV);
        facets.clear();
        facets.put(SchemaSymbols.ELT_MAXINCLUSIVE, "65535");
        DecimalDatatypeValidator unsignedShortDV = new DecimalDatatypeValidator(unsignedIntDV, facets, false, null);
        this.addGlobalTypeDecl("unsignedShort", unsignedShortDV);
        facets.clear();
        facets.put(SchemaSymbols.ELT_MAXINCLUSIVE, "255");
        this.addGlobalTypeDecl("unsignedByte", new DecimalDatatypeValidator(unsignedShortDV, facets, false, null));
        facets.clear();
        facets.put(SchemaSymbols.ELT_MININCLUSIVE, "1");
        this.addGlobalTypeDecl("positiveInteger", new DecimalDatatypeValidator(nonNegativeDV, facets, false, null));
        if (!fullSet) {
            return;
        }
        this.addGlobalTypeDecl("float", new FloatDatatypeValidator(fAnySimpleType, null, false, null));
        this.addGlobalTypeDecl("double", new DoubleDatatypeValidator(fAnySimpleType, null, false, null));
        this.addGlobalTypeDecl("hexBinary", new HexBinaryDatatypeValidator(fAnySimpleType, null, false, null));
        this.addGlobalTypeDecl("NOTATION", new NOTATIONDatatypeValidator(fAnySimpleType, null, false, null));
        facets.clear();
        facets.put(SchemaSymbols.ELT_WHITESPACE, "replace");
        StringDatatypeValidator normalizedDV = new StringDatatypeValidator(stringDV, facets, false, null);
        this.addGlobalTypeDecl("normalizedString", normalizedDV);
        facets.clear();
        facets.put(SchemaSymbols.ELT_WHITESPACE, "collapse");
        StringDatatypeValidator tokenDV = new StringDatatypeValidator(normalizedDV, facets, false, null);
        this.addGlobalTypeDecl("token", tokenDV);
        facets.clear();
        facets.put(SchemaSymbols.ELT_WHITESPACE, "collapse");
        facets.put(SchemaSymbols.ELT_PATTERN, "([a-zA-Z]{2}|[iI]-[a-zA-Z]+|[xX]-[a-zA-Z]+)(-[a-zA-Z]+)*");
        this.addGlobalTypeDecl("language", new StringDatatypeValidator(tokenDV, facets, false, null));
        facets.clear();
        facets.put(SchemaSymbols.ELT_WHITESPACE, "collapse");
        facets.put("specialToken", "Name");
        StringDatatypeValidator nameDV = new StringDatatypeValidator(tokenDV, facets, false, null);
        this.addGlobalTypeDecl("Name", nameDV);
        facets.clear();
        facets.put(SchemaSymbols.ELT_WHITESPACE, "collapse");
        facets.put("specialToken", "NCName");
        StringDatatypeValidator ncnameDV = new StringDatatypeValidator(nameDV, facets, false, null);
        this.addGlobalTypeDecl("NCName", ncnameDV);
        QNameDatatypeValidator qnameDV = new QNameDatatypeValidator(fAnySimpleType, null, false, null);
        QNameDatatypeValidator.setNCNameValidator(ncnameDV);
        this.addGlobalTypeDecl("QName", qnameDV);
        this.addGlobalTypeDecl("ID", new IDDatatypeValidator(ncnameDV, null, false, null));
        IDREFDatatypeValidator idrefDV = new IDREFDatatypeValidator(ncnameDV, null, false, null);
        this.addGlobalTypeDecl("IDREF", idrefDV);
        this.addGlobalTypeDecl("IDREFS", new ListDatatypeValidator(idrefDV, null, true, null));
        EntityDatatypeValidator entityDV = new EntityDatatypeValidator(ncnameDV, null, false, null);
        this.addGlobalTypeDecl("ENTITY", entityDV);
        this.addGlobalTypeDecl("ENTITIES", new ListDatatypeValidator(entityDV, null, true, null));
        facets.clear();
        facets.put(SchemaSymbols.ELT_WHITESPACE, "collapse");
        facets.put("specialToken", "NMTOKEN");
        StringDatatypeValidator nmtokenDV = new StringDatatypeValidator(tokenDV, facets, false, null);
        this.addGlobalTypeDecl("NMTOKEN", nmtokenDV);
        this.addGlobalTypeDecl("NMTOKENS", new ListDatatypeValidator(nmtokenDV, null, true, null));
    }

    public final String getTargetNamespace() {
        return this.fTargetNamespace;
    }

    public final void addGlobalAttributeDecl(XSAttributeDecl decl) {
        this.fGlobalAttrDecls.put(decl.fName, (Object)decl);
    }

    public final void addGlobalAttributeGroupDecl(XSAttributeGroupDecl decl) {
        this.fGlobalAttrGrpDecls.put(decl.fName, (Object)decl);
    }

    public final void addGlobalElementDecl(XSElementDecl decl) {
        this.fGlobalElemDecls.put(decl.fName, (Object)decl);
    }

    public final void addGlobalGroupDecl(XSGroupDecl decl) {
        this.fGlobalGroupDecls.put(decl.fName, (Object)decl);
    }

    public final void addGlobalNotationDecl(XSNotationDecl decl) {
        this.fGlobalNotationDecls.put(decl.fName, (Object)decl);
    }

    public final void addGlobalTypeDecl(XSTypeDecl decl) {
        this.fGlobalTypeDecls.put(decl.getXSTypeName(), (Object)decl);
    }

    public final void addIDConstraintDecl(XSElementDecl elmDecl, IdentityConstraint decl) {
        elmDecl.addIDConstaint(decl);
        this.fGlobalIDConstraintDecls.put(decl.getIdentityConstraintName(), (Object)decl);
    }

    public final XSAttributeDecl getGlobalAttributeDecl(String declName) {
        return (XSAttributeDecl)this.fGlobalAttrDecls.get(declName);
    }

    public final XSAttributeGroupDecl getGlobalAttributeGroupDecl(String declName) {
        return (XSAttributeGroupDecl)this.fGlobalAttrGrpDecls.get(declName);
    }

    public final XSElementDecl getGlobalElementDecl(String declName) {
        return (XSElementDecl)this.fGlobalElemDecls.get(declName);
    }

    public final XSGroupDecl getGlobalGroupDecl(String declName) {
        return (XSGroupDecl)this.fGlobalGroupDecls.get(declName);
    }

    public final XSNotationDecl getNotationDecl(String declName) {
        return (XSNotationDecl)this.fGlobalNotationDecls.get(declName);
    }

    public final XSTypeDecl getGlobalTypeDecl(String declName) {
        return (XSTypeDecl)this.fGlobalTypeDecls.get(declName);
    }

    public final IdentityConstraint getIDConstraintDecl(String declName) {
        return (IdentityConstraint)this.fGlobalIDConstraintDecls.get(declName);
    }

    final void addComplexTypeDecl(XSComplexTypeDecl decl) {
        if (this.fCTCount == this.fComplexTypeDecls.length) {
            this.fComplexTypeDecls = SchemaGrammar.resize(this.fComplexTypeDecls, this.fCTCount * 2);
        }
        this.fComplexTypeDecls[this.fCTCount++] = decl;
    }

    final XSComplexTypeDecl[] getAllComplexTypeDecls() {
        if (this.fCTCount < this.fComplexTypeDecls.length) {
            this.fComplexTypeDecls = SchemaGrammar.resize(this.fComplexTypeDecls, this.fCTCount);
        }
        return this.fComplexTypeDecls;
    }

    static final XSComplexTypeDecl[] resize(XSComplexTypeDecl[] oldArray, int newSize) {
        XSComplexTypeDecl[] newArray = new XSComplexTypeDecl[newSize];
        System.arraycopy(oldArray, 0, newArray, 0, Math.min(oldArray.length, newSize));
        return newArray;
    }

    static {
        SchemaGrammar.fAnyType.fName = "anyType";
        SchemaGrammar.fAnyType.fTargetNamespace = SchemaSymbols.URI_SCHEMAFORSCHEMA;
        SchemaGrammar.fAnyType.fBaseType = fAnyType;
        SchemaGrammar.fAnyType.fDerivedBy = (short)2;
        SchemaGrammar.fAnyType.fContentType = (short)2;
        XSWildcardDecl wildcard = new XSWildcardDecl();
        XSParticleDecl particle = new XSParticleDecl();
        particle.fMinOccurs = 0;
        particle.fMaxOccurs = -1;
        particle.fType = (short)2;
        particle.fValue = wildcard;
        SchemaGrammar.fAnyType.fParticle = particle;
        SchemaGrammar.fAnyType.fAttrGrp.fAttributeWC = wildcard;
        AnySimpleType astype = (AnySimpleType)fAnySimpleType;
        astype.fLocalName = "anySimpleType";
        SG_SchemaNS = new SchemaGrammar(null, true);
        SG_SchemaBasicSet = new SchemaGrammar(null, false);
    }
}

