/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.puttests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;

public class TestPut015
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestPut015.createWebDAVSchema();
        TestPut015.addGlobalMessage((String)("prepare test " + TestPut015.getTestClassId()), (char)'I', (String)"********************************\n* PUT a file with chunked data *\n********************************");
        host = new String(TestPut015.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestPut015.getPort();
        baseUrl = TestPut015.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestPut015.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestPut015.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestPut015.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestPut015.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestPut015.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestPut015.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on WDV_PORT " + WDV_PORT);
        }
        urlStr = "/TestPut015.txt";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPut015.addGlobalMessage((String)"1. DELETE the resource /TestPut015.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestPut015.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public void run() {
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        int i = 0;
        Vector<String> chunkedContent = new Vector<String>();
        while (i < content.length()) {
            if (i == content.length() || i + 10 >= content.length()) {
                chunkedContent.add(content.substring(i, content.length()));
            } else {
                chunkedContent.add(content.substring(i, i + 10));
            }
            i += 10;
        }
        String chunkedBody = "";
        Iterator iter = chunkedContent.iterator();
        while (iter.hasNext()) {
            String chunkElement = (String)iter.next();
            chunkedBody = String.valueOf(chunkedBody) + Integer.toHexString(chunkElement.length()) + new Character('\r').toString() + new Character('\n').toString() + chunkElement + new Character('\r').toString() + new Character('\n').toString();
        }
        chunkedBody = String.valueOf(chunkedBody) + "0" + new Character('\r').toString() + new Character('\n').toString() + new Character('\r').toString() + new Character('\n').toString();
        try {
            resource.PUT_chunked(chunkedBody, contentType, locktoken);
        }
        catch (WDVTestJ_WdvException e) {
            TestPut015.addGlobalMessage((String)"2. PUT the resource with chunked body", (char)'E', (String)("A WebDAV exception '" + e.getMessage() + " " + e.getStatusCode() + "' occured due to a request with the following body:\n" + chunkedBody));
        }
        catch (IOException e) {
            this.handleExceptions(e);
        }
        try {
            urlStr = "/TestPut015.txt";
            resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
            String contentR = new String(resource.GET());
            long contentLengthR = resource.getResponseHeaders().contentLength();
            if (contentLengthR != contentLength) {
                TestPut015.addGlobalMessage((String)"3. compare the expected and the received content data", (char)'W', (String)("Recieved content length (" + contentLengthR + ") not equal to expected content length (" + contentLength + ")\n" + "Please refer to this PTS-message: http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1129800"));
            } else if (content.compareTo(contentR) != 0) {
                TestPut015.addGlobalMessage((String)"3. compare the expected and the received content data", (char)'W', (String)("Recieved content not equal to expected content.\nExpected content:\n" + content + "\n" + "Recieved content:\n" + contentR + "\n" + "Please refer to this PTS-message: http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1129800"));
            } else {
                TestPut015.addGlobalMessage((String)"3. compare the expected and the received content data", (char)'I', (String)"Recieved content equals expected content\nTest was successful.");
            }
            String contentTypeR = resource.getResponseHeaders().contentType();
            if (contentTypeR.compareTo(contentType) != 0) {
                TestPut015.addGlobalMessage((String)"3. compare the expected and the received content data", (char)'E', (String)("Recieved content type (" + contentTypeR + ") not equal to expected content type (" + contentType + ")"));
            } else {
                TestPut015.addGlobalMessage((String)"3. compare the expected and the received content data", (char)'I', (String)"Recieved content type equals expected content type\nTest was successful.");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            TestPut015.addGlobalMessage((String)"3. compare the expected and the received content data", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + "\n" + "Expected result: 200 OK"));
        }
        catch (Exception exc) {
            TestPut015.handleGlobalExceptions((Exception)exc);
        }
    }

    public static void cleanUp() {
        if (resource.exists()) {
            TestPut015.doDelete(resource, locktoken, String.valueOf(host) + " : " + WDV_PORT + baseUrl + urlStr);
        }
    }
}

