/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.proppatchtests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

public class TestProppatch020
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static Document xmlDocument = null;

    public static void prepare() throws TestCaseException {
        TestProppatch020.createWebDAVSchema();
        TestProppatch020.addGlobalMessage((String)("prepare test " + TestProppatch020.getTestClassId()), (char)'I', (String)"do a PROPPATCH with a not well-formed request body due to a malformed property value");
        host = new String(TestProppatch020.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestProppatch020.getPort();
        baseUrl = TestProppatch020.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestProppatch020.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestProppatch020.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestProppatch020.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestProppatch020.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestProppatch020.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestProppatch020.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestProppatch020.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestProppatch020.addGlobalMessage((String)"1. DELETE the resource /TestProppatch020.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestProppatch020.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestProppatch020.doPut(resource, content, contentType, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        block6: {
            TestProppatch020.addGlobalMessage((String)"3. preparing the PROPPATCH", (char)'I', (String)"building the XML-body");
            String namespace = "Z";
            String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
            body = String.valueOf(body) + "\n<D:propertyupdate xmlns:D=\"DAV:\"";
            body = String.valueOf(body) + "\nxmlns:" + namespace + "=\"http://www.some.place.com\">";
            body = String.valueOf(body) + "\n<D:set>";
            body = String.valueOf(body) + "\n <D:prop>";
            body = String.valueOf(body) + "\n  <" + namespace + ":testprop><</" + namespace + ":testprop>";
            body = String.valueOf(body) + "\n </D:prop>";
            body = String.valueOf(body) + "\n</D:set>";
            body = String.valueOf(body) + "\n</D:propertyupdate>";
            try {
                xmlDocument = resource.PROPPATCH(body, null);
                TestProppatch020.addGlobalMessage((String)"4. do the PRPOPPATCH on the resource /TestProppatch020.txt at baseUrl", (char)'I', (String)"Successful!");
                if (resource.getStatus().getStatusCode() != 207) break block6;
                TestProppatch020.addGlobalMessage((String)"4.1 get the status code of the patched property", (char)'I', (String)"try to get the status code");
                String status = null;
                status = xmlDocument.getElementsByTagName("D:status").item(0).getFirstChild().getNodeValue();
                if (status.equalsIgnoreCase("HTTP/1.1 200 OK")) {
                    TestProppatch020.addGlobalMessage((String)"4.1 get the status code of the patched property", (char)'I', (String)"The status of the resource is 'HTTP/1.1 200 OK'. Test was succesful!");
                    break block6;
                }
                TestProppatch020.addGlobalMessage((String)"4.1 get the status code of the patched property", (char)'E', (String)("The status of the resource is '" + status + "'. Test failed due to some WebDAV feature."));
                return;
            }
            catch (WDVTestJ_WdvException exc) {
                if (exc.getStatusCode() != 400) {
                    TestProppatch020.addGlobalMessage((String)"4. do the PRPOPPATCH on the resource /TestProppatch020.txt at baseUrl", (char)'E', (String)("status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                    TestProppatch020.addGlobalMessage((String)"4. do the PRPOPPATCH on the resource /TestProppatch020.txt at baseUrl", (char)'I', (String)"Test failed due to some WebDAV feature");
                    return;
                }
            }
            catch (SAXParseException exc) {
                TestProppatch020.addGlobalMessage((String)"4. do the PRPOPPATCH on the resource /TestProppatch020.txt at baseUrl", (char)'E', (String)("parser says: " + exc.getMessage()));
                TestProppatch020.addGlobalMessage((String)"4. do the PRPOPPATCH on the resource /TestProppatch020.txt at baseUrl", (char)'I', (String)("request body: " + body));
                return;
            }
            catch (Exception exc) {
                TestProppatch020.addGlobalMessage((String)"4. do the PRPOPPATCH on the resource /TestProppatch020.txt at baseUrl", (char)'E', (String)("Java exception: " + exc));
                TestProppatch020.addGlobalMessage((String)"4. do the PRPOPPATCH on the resource /TestProppatch020.txt at baseUrl", (char)'I', (String)"Test failed due to some Java feature");
                return;
            }
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestProppatch020.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestProppatch020.addGlobalMessage((String)"5. DELETE the resource /TestProppatch020.txt at baseUrl", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        TestProppatch020.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

