/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.proppatchtests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class TestProppatch016
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static Document xmlDocument = null;
    static Node newproperty_node = null;

    public static void prepare() throws TestCaseException {
        TestProppatch016.createWebDAVSchema();
        TestProppatch016.addGlobalMessage((String)("prepare test " + TestProppatch016.getTestClassId()), (char)'I', (String)"set a userdefined property with a property-value of more than 450 signs");
        host = new String(TestProppatch016.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestProppatch016.getPort();
        baseUrl = TestProppatch016.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestProppatch016.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestProppatch016.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestProppatch016.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestProppatch016.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestProppatch016.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestProppatch016.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestProppatch016.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestProppatch016.addGlobalMessage((String)"1. DELETE the resource /TestProppatch016.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestProppatch016.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestProppatch016.doPut(resource, content, contentType, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        String propValue = new String();
        int i = 0;
        while (i <= 50) {
            propValue = String.valueOf(propValue) + "the property's value consists of more than 450 signs\n";
            ++i;
        }
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
        body = String.valueOf(body) + "\n<D:propertyupdate xmlns:D=\"DAV:\"";
        body = String.valueOf(body) + "\nxmlns:Z=\"http://www.some.place.com\">";
        body = String.valueOf(body) + "\n<D:set>";
        body = String.valueOf(body) + "\n <D:prop>";
        body = String.valueOf(body) + "\n  <Z:newproperty>" + propValue + "</Z:newproperty>";
        body = String.valueOf(body) + "\n </D:prop>";
        body = String.valueOf(body) + "\n</D:set>";
        body = String.valueOf(body) + "\n</D:propertyupdate>";
        try {
            xmlDocument = resource.PROPPATCH(body, null);
        }
        catch (WDVTestJ_WdvException exc) {
            TestProppatch016.addGlobalMessage((String)"PROPPATCH 'newproperty'", (char)'E', (String)("status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
            TestProppatch016.addGlobalMessage((String)"PROPPATCH 'newproperty'", (char)'I', (String)"test failed due to some WebDAV feature");
        }
        catch (SAXParseException exc) {
            TestProppatch016.addGlobalMessage((String)"PROPPATCH 'newproperty'", (char)'E', (String)("parser says: " + exc.getMessage()));
            TestProppatch016.addGlobalMessage((String)"PROPPATCH 'newproperty'", (char)'I', (String)("request body: " + body));
        }
        catch (Exception exc) {
            TestProppatch016.addGlobalMessage((String)"PROPPATCH 'newproperty'", (char)'E', (String)("Java exception: " + exc));
            exc.printStackTrace();
            TestProppatch016.addGlobalMessage((String)"PROPPATCH 'newproperty'", (char)'I', (String)"Test failed due to some Java feature");
        }
        if (resource.getStatus().getStatusCode() != 207) {
            TestProppatch016.addGlobalMessage((String)"PROPPATCH 'newproperty'", (char)'E', (String)("status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
            TestProppatch016.addGlobalMessage((String)"PROPPATCH 'newproperty'", (char)'I', (String)"expected result: 207 Multi-Status");
            return;
        }
        try {
            NodeList nl = xmlDocument.getElementsByTagName("newproperty");
            newproperty_node = nl.item(0);
        }
        catch (NullPointerException exc) {
            TestProppatch016.addGlobalMessage((String)"4. check if the property status of 'newproperty' is \"HTTP/1.1 409 Conflict\"", (char)'E', (String)"the 'newproperty'-element for the resource could not be retrieved");
        }
        String status = null;
        status = xmlDocument.getElementsByTagName("D:status").item(0).getFirstChild().getNodeValue();
        if (!status.equalsIgnoreCase("HTTP/1.1 409 Conflict")) {
            TestProppatch016.addGlobalMessage((String)"4. check if the property status of 'newproperty' is \"HTTP/1.1 409 Conflict\"", (char)'E', (String)("Test failed due to some WebDAV features (status was: " + status + ")"));
            return;
        }
        TestProppatch016.addGlobalMessage((String)"4. check if the property status of 'newproperty' is \"HTTP/1.1 409 Conflict\"", (char)'I', (String)"successful");
        Document xmlbody = null;
        newproperty_node = null;
        String propfind_body = new String("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
        propfind_body = String.valueOf(propfind_body) + "<D:propfind xmlns:D=\"DAV:\">\n";
        propfind_body = String.valueOf(propfind_body) + "<D:prop>\n";
        propfind_body = String.valueOf(propfind_body) + "<D:newproperty/>\n";
        propfind_body = String.valueOf(propfind_body) + "</D:prop>\n";
        propfind_body = String.valueOf(propfind_body) + "</D:propfind>\n";
        try {
            xmlbody = resource.PROPFIND(propfind_body);
            if (resource.getStatus().getStatusCode() != 207) {
                TestProppatch016.addGlobalMessage((String)"5. check if the property's status after a PROPFIND is  HTTP/1.1 404 Not Found", (char)'E', (String)("'PROPFIND' resulted in " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                TestProppatch016.addGlobalMessage((String)"5. check if the property's status after a PROPFIND is  HTTP/1.1 404 Not Found", (char)'I', (String)"expected response: 207 Multi-Status, Skipping Test...");
                return;
            }
            TestProppatch016.addGlobalMessage((String)"5. check if the property's status after a PROPFIND is  HTTP/1.1 404 Not Found", (char)'I', (String)("'PROPFIND' resulted in " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
        }
        catch (WDVTestJ_WdvException exc) {
            TestProppatch016.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestProppatch016.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some WebDAV feature");
            return;
        }
        catch (Exception exc) {
            TestProppatch016.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Java exception: " + exc));
            exc.printStackTrace();
            TestProppatch016.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)" Test failed due to some Java feature");
            return;
        }
        try {
            NodeList nl = xmlbody.getElementsByTagName("s1:newproperty");
            newproperty_node = nl.item(0);
        }
        catch (NullPointerException exc) {
            TestProppatch016.addGlobalMessage((String)"retrieving the 's1:newproperty'-element", (char)'E', (String)"the 'newproperty'-element for the resource could not be retrieved");
        }
        String propfind_status = null;
        propfind_status = xmlbody.getElementsByTagName("D:status").item(0).getFirstChild().getNodeValue();
        if (propfind_status.equalsIgnoreCase("HTTP/1.1 404 Not Found")) {
            TestProppatch016.addGlobalMessage((String)"5. check if the property's status after a PROPFIND is  HTTP/1.1 404 Not Found", (char)'I', (String)"Test was successful!");
            return;
        }
        TestProppatch016.addGlobalMessage((String)"5. check if the property's status after a PROPFIND is  HTTP/1.1 404 Not Found", (char)'E', (String)("received property status: " + propfind_status));
        TestProppatch016.addGlobalMessage((String)"5. check if the property's status after a PROPFIND is  HTTP/1.1 404 Not Found", (char)'I', (String)"Test failed.");
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestProppatch016.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestProppatch016.addGlobalMessage((String)"6. DELETE the resource /TestProppatch016.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestProppatch016.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

