/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.proppatchtests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class TestProppatch011
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static Document xmlDocument = null;
    static Node getcontenttype_node = null;

    public static void prepare() throws TestCaseException {
        TestProppatch011.createWebDAVSchema();
        TestProppatch011.addGlobalMessage((String)("prepare test " + TestProppatch011.getTestClassId()), (char)'I', (String)"patch the write-enabled live property 'getcontenttype' with a value whose syntax is incorrect, old posted value = received value");
        host = new String(TestProppatch011.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestProppatch011.getPort();
        baseUrl = TestProppatch011.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestProppatch011.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestProppatch011.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestProppatch011.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestProppatch011.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestProppatch011.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestProppatch011.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestProppatch011.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestProppatch011.addGlobalMessage((String)"1. DELETE the resource /TestProppatch011.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestProppatch011.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestProppatch011.doPut(resource, content, contentType, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
        body = String.valueOf(body) + "\n<D:propertyupdate xmlns:D=\"DAV:\"";
        body = String.valueOf(body) + "\nxmlns:Z=\"DAV:\">";
        body = String.valueOf(body) + "\n<D:set>";
        body = String.valueOf(body) + "\n<D:prop>";
        body = String.valueOf(body) + "\n<Z:getcontenttype>Eins, Zwei, Drei...der Server ist inzwei...</Z:getcontenttype>";
        body = String.valueOf(body) + "\n</D:prop>";
        body = String.valueOf(body) + "\n</D:set>";
        body = String.valueOf(body) + "\n</D:propertyupdate>";
        try {
            xmlDocument = resource.PROPPATCH(body, null);
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 400) {
                TestProppatch011.addGlobalMessage((String)"PROPPATCH (set) the write-enabled live prop 'getcontenttype'", (char)'I', (String)"Test successful");
            } else {
                TestProppatch011.addGlobalMessage((String)"PROPPATCH (set) the write-enabled live prop 'getcontenttype'", (char)'E', (String)("status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                TestProppatch011.addGlobalMessage((String)"PROPPATCH (set) the write-enabled live prop 'getcontenttype'", (char)'I', (String)"expected result: 400 Bad Request");
            }
        }
        catch (SAXParseException exc) {
            TestProppatch011.addGlobalMessage((String)"PROPPATCH (set) the write-enabled live prop 'getcontenttype'", (char)'E', (String)("parser says: " + exc.getMessage()));
            TestProppatch011.addGlobalMessage((String)"PROPPATCH (set) the write-enabled live prop 'getcontenttype'", (char)'I', (String)("request body: " + body));
        }
        catch (Exception exc) {
            TestProppatch011.addGlobalMessage((String)"PROPPATCH (set) the write-enabled live prop 'getcontenttype'", (char)'E', (String)("Java exception: " + exc));
            exc.printStackTrace();
            TestProppatch011.addGlobalMessage((String)"PROPPATCH (set) the write-enabled live prop 'getcontenttype'", (char)'I', (String)"Test failed due to some Java feature");
        }
        if (resource.getStatus().getStatusCode() == 207) {
            try {
                NodeList nl = xmlDocument.getElementsByTagName("getcontenttype");
                getcontenttype_node = nl.item(0);
            }
            catch (NullPointerException exc) {
                TestProppatch011.addGlobalMessage((String)"5. check if the property status of 'getcontenttype' is \"HTTP/1.1 409\"", (char)'E', (String)"the 'getcontenttype'-element for the resource could not be retrieved");
            }
            String status = null;
            status = xmlDocument.getElementsByTagName("D:status").item(0).getFirstChild().getNodeValue();
            if (status.startsWith("HTTP/1.1 409")) {
                TestProppatch011.addGlobalMessage((String)"5. check if the property status of 'getcontenttype' is \"HTTP/1.1 409\"", (char)'I', (String)"test succeeded!");
            } else {
                TestProppatch011.addGlobalMessage((String)"5. check if the property status of 'getcontenttype' is \"HTTP/1.1 409\"", (char)'E', (String)"test failed due to some WebDAV feature");
                TestProppatch011.addGlobalMessage((String)"5. check if the property status of 'getcontenttype' is \"HTTP/1.1 409\"", (char)'I', (String)("Status: " + status));
            }
            String contentTypeR = TestProppatch011.doPropfindByTagName(resource, "getcontenttype", String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
            if (contentType.equalsIgnoreCase(contentTypeR)) {
                TestProppatch011.addGlobalMessage((String)"6. check if the content type was not overwritten", (char)'I', (String)"test was successfull");
            } else {
                TestProppatch011.addGlobalMessage((String)"6. check if the content type was not overwritten", (char)'E', (String)"test was not successfull");
                TestProppatch011.addGlobalMessage((String)"6. check if the content type was not overwritten", (char)'I', (String)("posted: " + contentType + ", received: " + contentTypeR));
            }
        } else {
            TestProppatch011.addGlobalMessage((String)"PROPPATCH (set) the write-enabled live prop 'getcontenttype'", (char)'E', (String)("status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
            TestProppatch011.addGlobalMessage((String)"PROPPATCH (set) the write-enabled live prop 'getcontenttype'", (char)'I', (String)"expected result: 207 Multi-Status");
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestProppatch011.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestProppatch011.addGlobalMessage((String)"7. clean up and DELETE the resource /TestProppatch011.txt at baseUrl", (char)'E', (String)"clean up failed due to some Java feature.");
        }
        TestProppatch011.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

