/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.propfindtests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class TestPropfind011
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static Document xmlDocument = null;
    static Node locktype_node = null;
    static String locktype_Str = null;
    static String locktype_StrR = null;
    static String[] lockProps = new String[]{"locktype", "lockscope", "depth", "owner", "timeout", "locktoken", "activelock"};

    public static void prepare() throws TestCaseException {
        TestPropfind011.createWebDAVSchema();
        TestPropfind011.addGlobalMessage((String)("prepare test " + TestPropfind011.getTestClassId()), (char)'I', (String)"*************************************************************************\n* create a resource and check whether the properties 'locktype',        *\n* 'lockscope', 'depth', 'owner', 'timeout', 'locktoken' and 'activelock'*\n* supplied by PROPFIND have the status '404 Not Found'                  *\n*************************************************************************");
        host = new String(TestPropfind011.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestPropfind011.getPort();
        baseUrl = TestPropfind011.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestPropfind011.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestPropfind011.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestPropfind011.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestPropfind011.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestPropfind011.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestPropfind011.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestPropfind011.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPropfind011.addGlobalMessage((String)"1. DELETE the resource /TestPropfind011.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        if (resource.exists()) {
            locktoken = TestPropfind011.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
            TestPropfind011.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestPropfind011.doPut(resource, content, contentType, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        locktoken = TestPropfind011.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        TestPropfind011.doLock(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public void run() {
        int i = 0;
        while (i < lockProps.length) {
            String body = new String("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
            body = String.valueOf(body) + "<D:propfind xmlns:D=\"DAV:\">";
            body = String.valueOf(body) + "<D:prop>";
            body = String.valueOf(body) + "<D:" + lockProps[i] + "/>";
            body = String.valueOf(body) + "</D:prop>";
            body = String.valueOf(body) + "</D:propfind>";
            try {
                xmlDocument = resource.PROPFIND(body);
                TestPropfind011.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"property status is going to be compared to expected data");
            }
            catch (WDVTestJ_WdvException exc) {
                TestPropfind011.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
                TestPropfind011.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some WebDAV feature");
                return;
            }
            catch (Exception exc) {
                TestPropfind011.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Java exception: " + exc));
                TestPropfind011.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Preparations failed due to some Java feature");
                return;
            }
            String status = new String();
            status = xmlDocument.getElementsByTagName("D:status").item(0).getFirstChild().getNodeValue();
            if (status.equalsIgnoreCase("HTTP/1.1 404 Not Found")) {
                TestPropfind011.addGlobalMessage((String)("The HTTP status of '" + lockProps[i] + "' is '" + status + "'"), (char)'I', (String)"test succesful");
            } else {
                TestPropfind011.addGlobalMessage((String)("The HTTP status of '" + lockProps[i] + "' is '" + status + "'"), (char)'W', (String)"test failed, see PTS message: http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1126820");
            }
            if (resource.getStatus().getStatusCode() != 207) {
                TestPropfind011.addGlobalMessage((String)"checking the received status code", (char)'E', (String)("WebDAV code: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                TestPropfind011.addGlobalMessage((String)"checking the received status code", (char)'I', (String)"207 Multistatus expected");
            }
            ++i;
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestPropfind011.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPropfind011.addGlobalMessage((String)"4. clean up and DELETE the resource /TestPropfind011.txt at baseUrl", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        locktoken = TestPropfind011.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        TestPropfind011.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

