/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.movetests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.net.URL;
import java.sql.SQLException;

public class TestMove003
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestMove003.createWebDAVSchema();
        TestMove003.addGlobalMessage((String)("prepare test " + TestMove003.getTestClassId()), (char)'I', (String)"***********************************************************************\n* Move a collection (no sub-folders) to a directory with sub-folders. *\n***********************************************************************");
        host = new String(TestMove003.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestMove003.getPort();
        baseUrl = TestMove003.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestMove003.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestMove003.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestMove003.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestMove003.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestMove003.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestMove003.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = "/TestMove003";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove003.addGlobalMessage((String)"1. DELETE folder /testMove003 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature");
        }
        TestMove003.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + "/" + baseUrl + urlStr);
        urlStr = "/temp003";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove003.addGlobalMessage((String)"1. DELETE folder /temp003 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature");
        }
        TestMove003.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + "/" + baseUrl + urlStr);
        urlStr = "/TestMove003";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove003.addGlobalMessage((String)"1. MkCol for folder /testMove003 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature");
        }
        if (!TestMove003.doMkCol(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr = String.valueOf(urlStr) + "/sub1");
        if (resource == null) {
            TestMove003.addGlobalMessage((String)"3. MkCol to create folder /TestMove003/sub1 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature");
        }
        TestMove003.doMkCol(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + "/" + baseUrl + urlStr);
        urlStr = String.valueOf(urlStr) + "/sub2";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove003.addGlobalMessage((String)"4. MkCol to create folder /TestMove003/sub1/sub2 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature");
        }
        TestMove003.doMkCol(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + "/" + baseUrl + urlStr);
        urlStr = "/temp003";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove003.addGlobalMessage((String)"5. MkCol to create folder /temp003 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature");
        }
        TestMove003.doMkCol(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + "/" + baseUrl + urlStr);
        urlStr = String.valueOf(urlStr) + "/TestMove003";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove003.addGlobalMessage((String)"6. MkCol to create folder /temp003/TestMove003 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature");
        }
        TestMove003.doMkCol(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + "/" + baseUrl + urlStr);
    }

    public void run() {
        try {
            String dest_Url = new URL("http", host, WDV_PORT, baseUrl).toString();
            String overwrite = var_overwrite;
            String body = null;
            locktoken = null;
            TestMove003.doMove(resource, dest_Url, overwrite, body, locktoken, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        urlStr = "/TestMove003/sub1/sub2";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove003.addGlobalMessage((String)"8. check for sub-directory", (char)'E', (String)"Test failed due to some Java feature");
        }
        TestMove003.doGetContent(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = "/TestMove003";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove003.addGlobalMessage((String)"9. cleaning up /temp003", (char)'E', (String)"Clean Up failed due to some Java feature");
        }
        TestMove003.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = "/temp003";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove003.addGlobalMessage((String)"9. cleaning up /temp003", (char)'E', (String)"Clean Up failed due to some Java feature");
        }
        TestMove003.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + "/" + baseUrl + urlStr);
    }
}

