/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.locktests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestLock012
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestLock012.createWebDAVSchema();
        TestLock012.addGlobalMessage((String)("prepare test " + TestLock012.getTestClassId()), (char)'I', (String)"************************************************************\n* create a null resource and do a DELETE on it (must fail) *\n************************************************************");
        host = new String(TestLock012.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestLock012.getPort();
        baseUrl = TestLock012.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestLock012.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestLock012.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestLock012.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestLock012.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestLock012.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestLock012.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestLock012.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock012.addGlobalMessage((String)"1. DELETE resource /TestLock012.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (resource.exists() && (locktoken = TestLock012.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) != null) {
            TestLock012.doUnlock(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        }
        if (resource.exists() && !TestLock012.doDelete(resource, locktoken = TestLock012.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr), String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n";
        body = String.valueOf(body) + "<D:lockinfo xmlns:D=\"DAV:\">\n";
        body = String.valueOf(body) + "<D:locktype>\n";
        body = String.valueOf(body) + "<D:write/>\n";
        body = String.valueOf(body) + "</D:locktype>\n";
        body = String.valueOf(body) + "<D:lockscope>\n";
        body = String.valueOf(body) + "<D:exclusive/>\n";
        body = String.valueOf(body) + "</D:lockscope>\n";
        body = String.valueOf(body) + "<D:owner>D041249</D:owner>\n";
        body = String.valueOf(body) + "</D:lockinfo>\n";
        try {
            resource.LOCK(body, null);
            if (resource.getStatus().getStatusCode() == 200) {
                TestLock012.addGlobalMessage((String)"3. LOCK the null-resource /TestLock012.txt", (char)'I', (String)"LOCK was successful!");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            TestLock012.addGlobalMessage((String)"3. LOCK the null-resource /TestLock012.txt", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestLock012.addGlobalMessage((String)"3. LOCK the null-resource /TestLock012.txt", (char)'I', (String)"Test failed due to some WebDAV feature. Expected: 200 OK");
            return;
        }
        catch (Exception exc) {
            TestLock012.addGlobalMessage((String)"3. LOCK the null-resource /TestLock012.txt", (char)'E', (String)("Java exception: " + exc.getMessage()));
            TestLock012.addGlobalMessage((String)"3. LOCK the null-resource /TestLock012.txt", (char)'I', (String)"Test failed due to some Java feature.");
            return;
        }
        try {
            locktoken = TestLock012.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
            resource.DELETE(locktoken);
            if (resource.getStatus().getStatusCode() != 405) {
                TestLock012.addGlobalMessage((String)"4. try to DELETE the null-resource", (char)'W', (String)("WebDAV says: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                TestLock012.addGlobalMessage((String)"4. try to DELETE the null-resource", (char)'I', (String)"Test failed due to some WebDAV feature. Expected: 405 Method Not Allowed.PTS messages : \nhttp://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1127814\nhttp://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1124239");
                return;
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 405) {
                TestLock012.addGlobalMessage((String)"4. try to DELETE the null-resource", (char)'I', (String)(String.valueOf(exc.getStatusCode()) + " " + exc.getMessage() + " Test was successful!"));
            } else {
                TestLock012.addGlobalMessage((String)"4. try to DELETE the null-resource", (char)'W', (String)("WebDAV says: " + exc.getStatusCode() + " " + exc.getMessage()));
                TestLock012.addGlobalMessage((String)"4. try to DELETE the null-resource", (char)'I', (String)"Test failed due to some WebDAV feature. PTS messages : \nhttp://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1127814\nhttp://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1124239");
            }
        }
        catch (Exception exc) {
            TestLock012.addGlobalMessage((String)"4. try to DELETE the null-resource", (char)'E', (String)("Java exception: " + exc));
            TestLock012.addGlobalMessage((String)"4. try to DELETE the null-resource", (char)'I', (String)"Test failed due to some Java feature.");
            return;
        }
    }

    public static void cleanUp() throws TestCaseException {
        if (resource.exists() && (locktoken = TestLock012.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) != null) {
            TestLock012.doUnlock(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }
}

