/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.gettests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestGet010
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = "";
    static String contentType = null;
    static String expectedContent = "";
    static String locktoken = null;
    static String contentRange = null;
    static Byte firstByte = null;
    static Byte lastByte = null;

    public static void prepare() throws TestCaseException {
        TestGet010.createWebDAVSchema();
        TestGet010.addGlobalMessage((String)("prepare test " + TestGet010.getTestClassId()), (char)'I', (String)"**********************************************************************************************************\n* get on an existing file and try to receive a byte range whose start byte is less than '0' (Status 416) *\n**********************************************************************************************************");
        host = new String(TestGet010.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestGet010.getPort();
        baseUrl = TestGet010.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestGet010.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestGet010.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestGet010.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestGet010.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestGet010.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestGet010.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = "/TestGet010.txt";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestGet010.addGlobalMessage((String)"1. DELETE /TestGet010.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestGet010.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt! ";
        contentType = "text/plain";
        if (!TestGet010.doPut(resource, content, contentType, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        contentRange = "bytes=-2-10";
        try {
            resource.GET(contentRange);
            if (resource.getStatus().getStatusCode() != 416) {
                TestGet010.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'E', (String)("The HTTP status in the response DOES NOT equal the expected one\nexpected: 'HTTP/1.1 416 Requested range not satisfiable'\nreceived: '" + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "'"));
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 416) {
                TestGet010.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'I', (String)("The server replied: '" + exc.getStatusCode() + " " + exc.getLocalizedMessage() + "'\n" + "Test was successful!"));
            } else {
                TestGet010.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'E', (String)("WebDAV replied: " + exc.getStatusCode() + " " + exc.getMessage()));
                TestGet010.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'I', (String)"Test failed due to some WebDAV feature. '416 Requested range not satisfiable' was expected.");
            }
        }
        catch (Exception exc) {
            TestGet010.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'E', (String)("Java exception: " + exc.getMessage()));
            TestGet010.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'I', (String)"Test failed due to some Java feature.");
        }
        String lastModified = new String();
        lastModified = resource.getResponseHeaders().lastModified();
        if (lastModified == null) {
            TestGet010.addGlobalMessage((String)"Checking, whether the 'Last-Modified' - header is not existing.", (char)'I', (String)"The 'Last-Modified' - header is not set as expected");
        } else if (!TestGet010.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("T")) {
            TestGet010.addGlobalMessage((String)"Checking, whether the 'Last-Modified' - header is not existing.", (char)'W', (String)("The 'Last-Modified' - header IS set: 'Last-Modified': " + lastModified + "\nTest failed!\n" + "See PTS message: http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1128950"));
        } else {
            TestGet010.addGlobalMessage((String)"Checking, whether the 'Last-Modified' - header is not existing.", (char)'E', (String)("The 'Last-Modified' - header IS set: 'Last-Modified': " + lastModified + "\nTest failed!"));
        }
        if (TestGet010.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("F")) {
            String expectedContentType = "text/html";
            String receivedContentType = "";
            receivedContentType = resource.getResponseHeaders().contentType();
            if (receivedContentType.equalsIgnoreCase(expectedContentType)) {
                TestGet010.addGlobalMessage((String)"Check, whether the Content-Type of the response is 'text/html'.", (char)'I', (String)("The received 'Content-Type' ('" + receivedContentType + "') equals " + "the expected 'Content-Type' ('" + expectedContentType + "')\n" + "Test was successful!"));
            } else {
                TestGet010.addGlobalMessage((String)"Check, whether the Content-Type of the response is 'text/html'.", (char)'E', (String)("The received 'Content-Type' ('" + receivedContentType + "') DOES NOT equal " + "the expected 'Content-Type' ('" + expectedContentType + "')\n" + "Test failed!" + "See PTS message: http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1128950"));
            }
        }
    }

    public static void cleanUp() throws TestCaseException {
        TestGet010.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

