/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.destructivetests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;

public class TestDestructive002
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    int iterations = 10000;
    Vector iterated_name_vector;

    public static void prepare() throws TestCaseException {
        TestDestructive002.createWebDAVSchema();
        TestDestructive002.addGlobalMessage((String)("prepare test " + TestDestructive002.getTestClassId()), (char)'I', (String)"write many resources to a folder and move them into their own folders afterwards(which have to be created then)");
        host = new String(TestDestructive002.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestDestructive002.getPort();
        baseUrl = TestDestructive002.getParameterString((String)"baseUrl", (String)"/webdav");
        baseUrl = TestDestructive002.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestDestructive002.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestDestructive002.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestDestructive002.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestDestructive002.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestDestructive002.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = "/TestDestructive002";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestDestructive002.addGlobalMessage((String)"1. DELETE folder /TestDestructive002 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestDestructive002.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        if (!TestDestructive002.doMkCol(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        String iterated_name;
        int test_iterations = 0;
        while (test_iterations <= this.iterations) {
            urlStr = new String("/TestDestructive002/TestDestructive002_" + test_iterations + ".txt");
            resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
            if (resource == null) {
                TestDestructive002.addGlobalMessage((String)("3. PUT /TestDestructive002/TestDestructive002" + test_iterations + ".txt"), (char)'E', (String)"Preparations failed due to some Java feature.");
            }
            content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
            contentType = "text/plain";
            contentLength = content.length();
            TestDestructive002.doPut(resource, content, contentType, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
            this.iterated_name_vector.add(new String("/TestDestructive002_" + test_iterations));
            ++test_iterations;
        }
        Enumeration e = this.iterated_name_vector.elements();
        while (e.hasMoreElements()) {
            iterated_name = (String)e.nextElement();
            urlStr = "/TestDestructive002/" + iterated_name;
            resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
            if (resource == null) {
                TestDestructive002.addGlobalMessage((String)"4. do a move for each file and move it into its own folder (which has to be created)", (char)'E', (String)"Test failed due to some Java feature.");
            }
            TestDestructive002.doMkCol(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
            urlStr = "/TestDestructive002/" + iterated_name + ".txt";
            resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
            if (resource == null) {
                TestDestructive002.addGlobalMessage((String)"Move resource to new folder", (char)'E', (String)"Test failed due to some Java feature.");
            }
            try {
                String dest_URL = new URL("http", host, WDV_PORT, String.valueOf(baseUrl) + "/TestDestructive002/" + iterated_name + "/" + iterated_name + ".txt").toString();
                String body = null;
                TestDestructive002.doMove(resource, dest_URL, var_overwrite, body, locktoken, TestDestructive002.getTestClassId());
            }
            catch (MalformedURLException exc) {
                TestDestructive002.addGlobalMessage((String)"Move resource to new folder", (char)'E', (String)("MalFormedURLException" + exc));
            }
        }
        e = this.iterated_name_vector.elements();
        while (e.hasMoreElements()) {
            iterated_name = (String)e.nextElement();
            urlStr = "/TestDestructive002/" + iterated_name + "/" + iterated_name + ".txt";
            TestDestructive002.compareContent(resource, content, contentType, contentLength, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = "/TestDestructive002";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestDestructive002.addGlobalMessage((String)"6. clean up and DELETE folder /TestDestructive002 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestDestructive002.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

