/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.deletetests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestDelete005
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String fileUrlStr = null;
    static String collectionUrlStr = null;
    static WDVTestJ_WebDAVCore fileResource = null;
    static WDVTestJ_WebDAVCore collectionResource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestDelete005.createWebDAVSchema();
        if (TestDelete005.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("T")) {
            throw new TestCaseException("Deleted Items Folder not yet implemented");
        }
        TestDelete005.addGlobalMessage((String)("prepare test " + TestDelete005.getTestClassId()), (char)'I', (String)"delete a file and a collection with the use of the folder 'Deleted Files'");
        host = new String(TestDelete005.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestDelete005.getPort();
        baseUrl = TestDelete005.getParameterString((String)"baseUrl", (String)"/webdav");
        start_server = TestDelete005.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestDelete005.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestDelete005.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestDelete005.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestDelete005.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        fileUrlStr = "/TestDelete005.txt";
        fileResource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, fileUrlStr);
        if (fileResource == null) {
            TestDelete005.addGlobalMessage((String)"1. DELETE the file /TestDelete005.txt", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestDelete005.doDelete(fileResource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + fileUrlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        collectionUrlStr = "/TestDelete005";
        collectionResource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, collectionUrlStr);
        if (collectionResource == null) {
            TestDelete005.addGlobalMessage((String)"2. DELETE the collection /TestDelete005", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestDelete005.doDelete(collectionResource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + collectionUrlStr);
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestDelete005.doPut(fileResource, content, contentType, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + fileUrlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        TestDelete005.doMkCol(collectionResource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + collectionUrlStr);
    }

    public void run() {
        try {
            fileResource.DELETE(locktoken, "T");
            if (fileResource.getStatus().getStatusCode() == 204) {
                TestDelete005.addGlobalMessage((String)"5. call the DELETE method to move /TestDelete005.txt to 'Deleted Items'", (char)'I', (String)"succesful");
            } else {
                TestDelete005.addGlobalMessage((String)"5. call the DELETE method to move /TestDelete005.txt to 'Deleted Items'", (char)'E', (String)("WebDAV response: " + fileResource.getStatus().getStatusCode() + " " + fileResource.getStatus().getStatusMessage() + " Expected result: 204 Not Found"));
                TestDelete005.addGlobalMessage((String)"5. call the DELETE method to move /TestDelete005.txt to 'Deleted Items'", (char)'I', (String)"Test failed due to some WebDAV feature.");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            TestDelete005.addGlobalMessage((String)"5. call the DELETE method to move /TestDelete005.txt to 'Deleted Items'", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + " Expected result: 204 Not Found"));
            TestDelete005.addGlobalMessage((String)"5. call the DELETE method to move /TestDelete005.txt to 'Deleted Items'", (char)'I', (String)"Test failed due to some WebDAV feature");
        }
        catch (Exception exc) {
            TestDelete005.addGlobalMessage((String)"5. call the DELETE method to move /TestDelete005.txt to 'Deleted Items'", (char)'E', (String)("Java exception: " + exc));
            TestDelete005.addGlobalMessage((String)"5. call the DELETE method to move /TestDelete005.txt to 'Deleted Items'", (char)'I', (String)"Test failed due to some Java feature");
        }
        try {
            collectionResource.DELETE(locktoken, "T");
            if (collectionResource.getStatus().getStatusCode() == 204) {
                TestDelete005.addGlobalMessage((String)"6. call the DELETE method to move /TestDelete005 to 'Deleted Items'", (char)'I', (String)"succesful");
            } else {
                TestDelete005.addGlobalMessage((String)"6. call the DELETE method to move /TestDelete005 to 'Deleted Items'", (char)'E', (String)("WebDAV exception: " + collectionResource.getStatus().getStatusCode() + " " + collectionResource.getStatus().getStatusMessage() + " Expected result: 204 No Content"));
                TestDelete005.addGlobalMessage((String)"6. call the DELETE method to move /TestDelete005 to 'Deleted Items'", (char)'I', (String)"Test failed due to some WebDAV feature.");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            TestDelete005.addGlobalMessage((String)"6. call the DELETE method to move /TestDelete005 to 'Deleted Items'", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + " Expected result: 204 No Content"));
            TestDelete005.addGlobalMessage((String)"6. call the DELETE method to move /TestDelete005 to 'Deleted Items'", (char)'I', (String)"Test failed due to some WebDAV feature");
        }
        catch (Exception exc) {
            TestDelete005.addGlobalMessage((String)"6. call the DELETE method to move /TestDelete005 to 'Deleted Items'", (char)'E', (String)("Java exception: " + exc));
            TestDelete005.addGlobalMessage((String)"6. call the DELETE method to move /TestDelete005 to 'Deleted Items'", (char)'I', (String)"Test failed due to some Java feature");
        }
        try {
            fileResource.HEAD(null);
            if (fileResource.getStatus().getStatusCode() != 404) {
                TestDelete005.addGlobalMessage((String)"7. test whether /TestDelete005.txt was deleted", (char)'E', (String)("WebDAV exception: " + fileResource.getStatus().getStatusCode() + " " + fileResource.getStatus().getStatusMessage() + " Expected result: 404 Not Found"));
                TestDelete005.addGlobalMessage((String)"7. test whether /TestDelete005.txt was deleted", (char)'I', (String)"Test failed due to some WebDAV feature");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 404) {
                TestDelete005.addGlobalMessage((String)"7. test whether /TestDelete005.txt was deleted", (char)'I', (String)"Test was successful!");
            } else {
                TestDelete005.addGlobalMessage((String)"7. test whether /TestDelete005.txt was deleted", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + " Expected result: 404 Not Found"));
                TestDelete005.addGlobalMessage((String)"7. test whether /TestDelete005.txt was deleted", (char)'I', (String)"Test failed due to some WebDAV feature");
            }
        }
        catch (Exception exc) {
            TestDelete005.addGlobalMessage((String)"7. test whether /TestDelete005.txt was deleted", (char)'E', (String)("Java exception: " + exc));
            TestDelete005.addGlobalMessage((String)"7. test whether /TestDelete005.txt was deleted", (char)'I', (String)"Test failed due to some Java feature");
        }
        try {
            collectionResource.HEAD(null);
            if (collectionResource.getStatus().getStatusCode() != 404) {
                TestDelete005.addGlobalMessage((String)"8. test whether /TestDelete005 was deleted", (char)'E', (String)("WebDAV exception: " + collectionResource.getStatus().getStatusCode() + " " + collectionResource.getStatus().getStatusMessage() + " Expected result: 404 Not Found"));
                TestDelete005.addGlobalMessage((String)"8. test whether /TestDelete005 was deleted", (char)'I', (String)"Test failed due to some WebDAV feature");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 404) {
                TestDelete005.addGlobalMessage((String)"8. test whether /TestDelete005 was deleted", (char)'I', (String)"Test was successful!");
            } else {
                TestDelete005.addGlobalMessage((String)"8. test whether /TestDelete005 was deleted", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + " Expected result: 404 Not Found"));
                TestDelete005.addGlobalMessage((String)"8. test whether /TestDelete005 was deleted", (char)'I', (String)"Test failed due to some WebDAV feature");
            }
        }
        catch (Exception exc) {
            TestDelete005.addGlobalMessage((String)"8. test whether /TestDelete005 was deleted", (char)'E', (String)("Java exception: " + exc));
            TestDelete005.addGlobalMessage((String)"8. test whether /TestDelete005 was deleted", (char)'I', (String)"Test failed due to some Java feature");
        }
        if ((fileResource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, fileUrlStr = "/Deleted%20Items/TestDelete005.txt")) == null) {
            TestDelete005.addGlobalMessage((String)"9. test whether /TestDelete005.txt was moved to 'Deleted Items' correctly", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        try {
            fileResource.HEAD(null);
            if (fileResource.getStatus().getStatusCode() == 200) {
                TestDelete005.addGlobalMessage((String)"9. test whether /TestDelete005 was moved to 'Deleted Items' correctly", (char)'I', (String)"Test was successful!");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            TestDelete005.addGlobalMessage((String)"9. test whether /TestDelete005.txt was moved to 'Deleted Items' correctly", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + " Expected result: 200 OK"));
            TestDelete005.addGlobalMessage((String)"9. test whether /TestDelete005.txt was moved to 'Deleted Items' correctly", (char)'I', (String)"Test failed due to some WebDAV feature");
        }
        catch (Exception exc) {
            TestDelete005.addGlobalMessage((String)"9. test whether /TestDelete005.txt was moved to 'Deleted Items' correctly", (char)'E', (String)("Java exception: " + exc));
            TestDelete005.addGlobalMessage((String)"9. test whether /TestDelete005.txt was moved to 'Deleted Items' correctly", (char)'I', (String)"Test failed due to some Java feature");
        }
        collectionUrlStr = "/Deleted%20Items/TestDelete005";
        collectionResource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, fileUrlStr);
        if (collectionResource == null) {
            TestDelete005.addGlobalMessage((String)"10. test whether /TestDelete005 was moved to 'Deleted Items' correctly", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        try {
            collectionResource.HEAD(null);
            if (collectionResource.getStatus().getStatusCode() == 200) {
                TestDelete005.addGlobalMessage((String)"10. test whether TestDelete005 was moved to 'Deleted Items' correctly", (char)'I', (String)"Test was successful!");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            TestDelete005.addGlobalMessage((String)"10. test whether TestDelete005 was moved to 'Deleted Items' correctly", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + " Expected result: 200 OK"));
            TestDelete005.addGlobalMessage((String)"10. test whether TestDelete005 was moved to 'Deleted Items' correctly", (char)'I', (String)"Test failed due to some WebDAV feature");
        }
        catch (Exception exc) {
            TestDelete005.addGlobalMessage((String)"10. test whether TestDelete005 was moved to 'Deleted Items' correctly", (char)'E', (String)("Java exception: " + exc));
            TestDelete005.addGlobalMessage((String)"10. test whether TestDelete005 was moved to 'Deleted Items' correctly", (char)'I', (String)"Test failed due to some Java feature");
        }
    }

    public static void cleanUp() throws TestCaseException {
        fileUrlStr = "/TestDelete005";
        fileResource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, fileUrlStr);
        if (fileResource == null) {
            TestDelete005.addGlobalMessage((String)"11. DELETE the file /TestDelete005", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        TestDelete005.doDelete(fileResource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + fileUrlStr);
        collectionUrlStr = "/TestDelete005";
        collectionResource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, collectionUrlStr);
        if (collectionResource == null) {
            TestDelete005.addGlobalMessage((String)"12. DELETE the collection /TestDelete005", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        TestDelete005.doDelete(collectionResource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + collectionUrlStr);
    }
}

