/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.copytests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;

public class TestCopy007
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static String depth = null;

    public static void prepare() throws TestCaseException {
        TestCopy007.createWebDAVSchema();
        TestCopy007.addGlobalMessage((String)("prepare test " + TestCopy007.getTestClassId()), (char)'I', (String)"************************************************************************************************\n* check if the server copies all resources recursivly when doing a COPY without a depth header *\n************************************************************************************************");
        host = new String(TestCopy007.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestCopy007.getPort();
        baseUrl = TestCopy007.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestCopy007.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestCopy007.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestCopy007.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestCopy007.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestCopy007.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestCopy007.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestCopy007");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy007.addGlobalMessage((String)"1. DELETE /tempCopy007 and /TestCopy007 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestCopy007.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/tempCopy007");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy007.addGlobalMessage((String)"1. DELETE /tempCopy007 and /TestCopy007 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy007.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestCopy007");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy007.addGlobalMessage((String)"2. create the folder /TestCopy007 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy007.doMkCol(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/tempCopy007");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy007.addGlobalMessage((String)"2. create the folder /tempCopy007 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy007.doMkCol(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/tempCopy007/folder007_a");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy007.addGlobalMessage((String)"3. create sub-folder /folder007_a at /tempCopy007", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy007.doMkCol(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/tempCopy007/folder007_a/folder007_b");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy007.addGlobalMessage((String)"3. create sub-folder /folder007_b at /tempCopy007/folder007_a", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy007.doMkCol(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/tempCopy007/res007_a.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy007.addGlobalMessage((String)"4. create resource /res007_a.txt at /tempCopy007", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestCopy007.doPut(resource, content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt", contentType = "text/plain", locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/tempCopy007/folder007_a/res007_b.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy007.addGlobalMessage((String)"4. create resource /res007_b.txt at /tempCopy007/folder007_a", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy007.doPut(resource, content, contentType, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public void run() {
        urlStr = new String("/tempCopy007");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy007.addGlobalMessage((String)"5. COPY the collection /tempCopy007 to /TestCopy007 without a depth header", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        String dest_Url = null;
        Object body = null;
        try {
            dest_Url = new URL("http", host, WDV_PORT, String.valueOf(baseUrl) + "/TestCopy007/tempCopy007").toString();
            body = null;
            locktoken = null;
        }
        catch (MalformedURLException exc) {
            TestCopy007.addGlobalMessage((String)"5. COPY the collection /temp007 to /TestCopy007 without a depth header", (char)'E', (String)"Test failed due to some Java-URL feature");
        }
        try {
            resource.COPY(dest_Url, var_overwrite, body, locktoken, depth);
            TestCopy007.addGlobalMessage((String)("COPY TO http://" + dest_Url + " without a depth header"), (char)'I', (String)("WebDAV returned: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
            if (resource.getStatus().getStatusCode() != 201) {
                TestCopy007.addGlobalMessage((String)("COPY TO http://" + dest_Url + " without a depth header"), (char)'E', (String)("WebDAV returned: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                TestCopy007.addGlobalMessage((String)"Test failed due to some WebDAV feature", (char)'I', (String)"Expected result: '201 Created'");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            TestCopy007.addGlobalMessage((String)("COPY TO http://" + dest_Url + " without a depth header"), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestCopy007.addGlobalMessage((String)"Test failed due to some WebDAV feature", (char)'I', (String)"Expected result: 412 Precondition Failed");
        }
        catch (Exception exc) {
            TestCopy007.addGlobalMessage((String)("COPY TO http://" + dest_Url + " without a depth header"), (char)'E', (String)("Java exception: " + exc));
            exc.printStackTrace();
            TestCopy007.addGlobalMessage((String)"Test failed due to some Java feature", (char)'I', (String)("Skipping test " + TestCopy007.getTestClassId()));
        }
        if ((resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr = new String("/TestCopy007/tempCopy007/res007_a.txt"))) == null) {
            TestCopy007.addGlobalMessage((String)"6. check, if the collection /TestCopy007 includes /tempCopy007/res007_a.txt", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        try {
            resource.HEAD(null);
            if (resource.getStatus().getStatusCode() != 200) {
                TestCopy007.addGlobalMessage((String)"6. check, if the collection /TestCopy007 includes /tempCopy007/res007_a.txt", (char)'E', (String)("WebDAV returned: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                TestCopy007.addGlobalMessage((String)"Test failed due to some WebDAV feature", (char)'I', (String)"Expected result: '200 OK'");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            TestCopy007.addGlobalMessage((String)"6. check, if the collection /TestCopy007 includes /tempCopy007/res007_a.txt", (char)'E', (String)("WebDAV returned: " + exc.getStatusCode() + " " + exc.getMessage()));
        }
        catch (Exception exc) {
            this.handleExceptions(exc);
        }
        if ((resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr = new String("/TestCopy007/tempCopy007/folder007_a/res007_b.txt"))) == null) {
            TestCopy007.addGlobalMessage((String)"6. check, if the collection /TestCopy007 includes /tempCopy007/folder007_a/res007_b.txt", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        try {
            resource.HEAD(null);
            if (resource.getStatus().getStatusCode() != 200) {
                TestCopy007.addGlobalMessage((String)"6. check, if the collection /TestCopy007 includes /tempCopy007/folder007_a/res007_b.txt", (char)'E', (String)("WebDAV returned: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                TestCopy007.addGlobalMessage((String)"Test failed due to some WebDAV feature", (char)'I', (String)"Expected result: '200 OK'");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            TestCopy007.addGlobalMessage((String)"6. check, if the collection /TestCopy007 includes /tempCopy007/folder007_a/res007_b.txt", (char)'E', (String)("WebDAV returned: " + exc.getStatusCode() + " " + exc.getMessage()));
        }
        catch (Exception exc) {
            this.handleExceptions(exc);
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestCopy007");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy007.addGlobalMessage((String)"8. clean up and DELETE /tempCopy007 as well as /TestCopy007", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        TestCopy007.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/tempCopy007");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy007.addGlobalMessage((String)"8. clean up and DELETE /tempCopy007 as well as /TestCopy007", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        TestCopy007.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

