/*!******************************************************************************

  @file         hsp49.h

  ------------------------------------------------------------------------------

  @author       

  @brief        Patterns

\if EMIT_LICENCE  


    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



\endif

********************************************************************************/

#ifndef HSP49_H
#define HSP49_H


/*===========================================================================*
 *     RefType: Both                                                         *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\xcc\xcb\x2d\x8a\xe3\xb0\xd5\x38\x91\x35\x7a\x1c\x69\xce\xd7\x98'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal void s49build_pattern (
    void                  *  pat_buffer,
    pasbool                              is_ascii,
    tsp00_Int4                           start,
    tsp00_Int4                           stop,
    char                                 escape_char,
    pasbool                              escape,
    pasbool                              string,
    tsp00_SqlMode_Param                  sqlmode,
    pasbool               VAR_VALUE_REF  ok);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s49uni_build_pattern (
    void                  *  pat_buffer,
    tsp00_Int4                           start,
    tsp00_Int4                           stop,
    char*                                escape_char,
    pasbool                              escape,
    tsp00_SqlMode_Param                  sqlmode,
    pasbool               VAR_VALUE_REF  ok);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool s49onecmatch (
    void                  *  pat,
    tsp00_Int4                           s_pos,
    char                                 comp_ch,
    tsp00_Int4            VAR_VALUE_REF  pat_incr);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool s49patmatch (
    void                  *  val,
    tsp00_Int4                           val_offset,
    tsp00_Int4                           val_len,
    void                  *  pat,
    tsp00_Int4                           pat_offset,
    tsp00_Int4                           pat_len,
    char                                 pat_defbyte);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool s49upatmatch (
    void                  *  val,
    tsp00_Int4                           val_offset,
    tsp00_Int4                           val_len,
    void                  *  pat,
    tsp00_Int4                           pat_offset,
    tsp00_Int4                           pat_len);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s49xtdbuild_pattern (
    void                  *  pat_buffer,
    pasbool                              is_ascii,
    tsp00_Int4                           start,
    tsp00_Int4                           stop,
    char                                 escape_char,
    char                                 pad_char,
    pasbool                              escape,
    pasbool                              string,
    tsp00_SqlMode_Param                  sqlmode,
    pasbool               VAR_VALUE_REF  ok);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

