
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
"""A DOM implementation that offers traversal and ranges on top of
minidom, using the 4DOM traversal implementation."""

import minidom, string

class DOMImplementation(minidom.DOMImplementation):
    def hasFeature(self, feature, version):
        if version not in ("1.0", "2.0"):
            return 0
        feature = string.lower(feature)
        if feature in ['traversal','range']:
            return 1
        return minidom.DOMImplementation.hasFeature(self, feature, version)

    def _createDocument(self):
        return Document()

class Document(minidom.Document):
    implementation = DOMImplementation()
    def createNodeIterator(self, root, whatToShow, filter, entityReferenceExpansion):
        from xml.dom import NodeIterator
        nodi = NodeIterator.NodeIterator(root, whatToShow, filter, entityReferenceExpansion)
        return nodi

    def createTreeWalker(self, root, whatToShow, filter, entityReferenceExpansion):
        from TreeWalker import TreeWalker
        return TreeWalker(root, whatToShow, filter, entityReferenceExpansion)

    def createRange(self):
        import Range
        return Range.Range(self)

def getDOMImplementation():
    return Document.implementation
