########################################################################
#
# File Name:            __init__.py
#
# Documentation:        http://docs.4suite.org/4DOM/ext/reader/__init__.py.html
#
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

"""
The 4DOM reader module has routines for deserializing XML and HTML to DOM
WWW: http://4suite.org/4DOM         e-mail: support@4suite.org

Copyright (c) 2000 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

import string, urllib, urlparse, cStringIO, os
from xml.dom.ext import ReleaseNode

try:
    import codecs
    from types import UnicodeType
    encoder = codecs.lookup("utf-8")[0] # encode,decode,reader,writer
    def StrStream(st):
        if type(st) is UnicodeType:
            st = encoder(st)[0]
        return cStringIO.StringIO(st)
except ImportError:
    StrStream = lambda x: cStringIO.StringIO(x)

import string, urlparse, urllib, os


class BaseUriResolver:
    def resolve(self, uri, base=''):
        #scheme, netloc, path, params, query, fragment
        scheme = urlparse.urlparse(uri)[0]
        if scheme in ['', 'http', 'ftp', 'file', 'gopher']:
            uri = urlparse.urljoin(base, uri)
        if os.access(uri, os.F_OK):
            #Hack because urllib breaks on Windows paths
            stream = open(uri)
        else:
            stream = urllib.urlopen(uri)
        return stream

BASIC_RESOLVER = BaseUriResolver()

class Reader:
    def clone(self):
        """Used to create a new copy of this instance"""
        if hasattr(self,'__getinitargs__'):
            return apply(self.__class__,self.__getinitargs__())
        else:
            return self.__class__()

    def fromStream(self, stream, ownerDoc=None):
        """Create a DOM from a stream"""
        raise "NOT OVERIDDEN"

    def fromString(self, str, ownerDoc=None):
        """Create a DOM from a string"""
        stream = StrStream(str)
        try:
            return self.fromStream(stream, ownerDoc)
        finally:
            stream.close()

    def fromUri(self, uri, ownerDoc=None):
        stream = BASIC_RESOLVER.resolve(uri)
        try:
            return self.fromStream(stream, ownerDoc)
        finally:
            stream.close()

    def releaseNode(self, node):
        "Free a DOM tree"
        node and ReleaseNode(node)
