
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
import string
import Printer
from xml.dom import XHTML_NAMESPACE
from xml.dom.html import HTML_FORBIDDEN_END

class HtmlDocType:
    name = 'HTML'
    publicId = "-//W3C//DTD HTML 4.0//EN"
    systemId = "http://www.w3.org/TR/REC-html40/strict.dtd"
    entities = notations = []

class HtmlAttr:
    def __init__(self, node):
        self.namespaceURI = None
        self.name = string.upper(node.localName or node.nodeName)
        self.value = node.value
        return

class HtmlElement:
    def __init__(self, node):
        self.tagName = string.upper(node.localName or node.nodeName)
        self.childNodes = node.childNodes
        self.attributes = node.attributes
        return

class XHtml2HtmlPrintVisitor(Printer.PrintVisitor):
    def __init__(self, stream, encoding, indent='', plainElements=None):
        Printer.PrintVisitor.__init__(self,stream,encoding,indent,plainElements)
        self._html = 1
        return

    def visitDocument(self, doc):
        self.visitDocumentType(HtmlDocType)
        self.visitNodeList(doc.childNodes, exclude=doc.doctype)
        return

    def visitAttr(self, node):
        if node.namespaceURI and node.namespaceURI != XHTML_NAMESPACE:
            return
        Printer.PrintVisitor.visitAttr(self,HtmlAttr(node))

    def visitElement(self, node):
        if node.namespaceURI and node.namespaceURI != XHTML_NAMESPACE:
            return
        htmlElement = HtmlElement(node)
        if htmlElement.tagName == 'XHTML':
            htmlElement.tagName = 'HTML'
        Printer.PrintVisitor.visitElement(self,htmlElement)
