########################################################################
#
# File Name:            NodeList.py
#
# Documentation:        http://docs.4suite.com/4DOM/NodeList.py.html
#
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

"""
WWW: http://4suite.com/4DOM         e-mail: support@4suite.com

Copyright (c) 2000 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.com/COPYRIGHT  for license and copyright information
"""

import UserList

from xml.dom import NoModificationAllowedErr

class NodeList(UserList.UserList):
    def __init__(self, list=None):
        UserList.UserList.__init__(self, list)
        return

    ### Attribute Access Methods ###

    def __getattr__(self, name):
        if name == 'length':
            return len(self)
        #Pass-through
        return getattr(NodeList, name)

    def __setattr__(self, name, value):
        if name == 'length':
            raise NoModificationAllowedErr()
        #Pass-through
        self.__dict__[name] = value

    ### Attribute Methods ###

    def _get_length(self):
        return len(self)

    ### Methods ###

    def item(self, index):
        if 0 <= index < len(self):
            return self[int(index)]
        return None

    #Not defined in the standard
    def contains(self, node):
        return node in self

    def __repr__(self):
        st = "<NodeList at %x: [" % id(self)
        if len(self):
            for i in self[:-1]:
                st = st + repr(i) + ', '
            st = st + repr(self[-1])
        st = st + ']>'
        return st
