########################################################################
#
# File Name:            DOMImplementation.py
#
# Documentation:        http://docs.4suite.com/4DOM/DOMImplementation.py.html
#
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

"""
WWW: http://4suite.com/4DOM         e-mail: support@4suite.com

Copyright (c) 2000 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.com/COPYRIGHT  for license and copyright information
"""

import string

FEATURES_MAP = {'CORE':2.0,
                'XML':2.0,
                'TRAVERSAL':2.0,
                'EVENTS':2.0,
                'MUTATIONEVENTS':2.0,
                }

try:
    import Range
except:
    pass
else:
    FEATURES_MAP['RANGE'] = 2.0

class DOMImplementation:

    def __init__(self):
        pass

    def hasFeature(self, feature, version=''):
        featureVersion = FEATURES_MAP.get(string.upper(feature))
        if featureVersion:
            if version and float(version) != featureVersion:
                return 0
            return 1
        return 0

    def createDocumentType(self, qualifiedName, publicId, systemId):
        import DocumentType
        dt = DocumentType.DocumentType(qualifiedName,
                                       self._4dom_createNamedNodeMap(),
                                       self._4dom_createNamedNodeMap(),
                                       publicId,
                                       systemId)
        return dt

    def createDocument(self, namespaceURI, qualifiedName, doctype):
        import Document
        doc = Document.Document(doctype)
        if qualifiedName:
            el = doc.createElementNS(namespaceURI, qualifiedName)
            doc.appendChild(el)
        return doc

    def _4dom_createNodeList(self, list=None):
        import NodeList
        return NodeList.NodeList(list)

    def _4dom_createNamedNodeMap(self, owner=None):
        import NamedNodeMap
        return NamedNodeMap.NamedNodeMap(owner)

implementation = DOMImplementation()
getDOMImplementation = DOMImplementation
