/*!******************************************************************************

  @file         hkb52.h

  ------------------------------------------------------------------------------

  @author       UweH

  @brief        KB_show_lock

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2001-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

\endif

********************************************************************************/

#ifndef HKB52_H
#define HKB52_H


/*===========================================================================*
 *     RefType: Both                                                         *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\x89\x38\xa4\x17\xd9\xd9\x4d\x87\xb6\x52\xc0\xba\x2c\x34\x86\x41'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "ggg00.h"
#include "gkb05.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal void k52acc_objcoll_entry (
    tkb05_ObjCollGlob     VAR_VALUE_REF  ObjCollGlob,
    tgg00_TransIndex                     EntryIndex,
    tkb05_ObjCollEntryPtr  VAR_VALUE_REF  ObjCollEntryPtr);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52acc_objreq_entry (
    tkb05_ObjCollGlob     VAR_VALUE_REF  ObjCollGlob,
    tgg00_TransIndex                     TransIndex,
    tkb05_ObjReqEntryPtr  VAR_VALUE_REF  ObjReqEntryPtr);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52acc_trans_entry (
    tgg00_TransIndex                     TransIndex,
    tkb05_TransEntryPtr   VAR_VALUE_REF  TransEntryPtr);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52begexcl_lockstate (
    tsp00_TaskId                         TaskId,
    tkb05_LockStateGlobPtr  VAR_VALUE_REF  LockStateGlobPtr);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52begexcl_objcoll (
    tsp00_TaskId                         TaskId,
    tkb05_ObjCollGlobPtr  VAR_VALUE_REF  ObjCollGlobPtr);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52begexcl_region (
    tsp00_TaskId                         TaskId,
    tkb05_RegionNo                       Region,
    tkb05_RegionGlobPtr   VAR_VALUE_REF  RegionGlobPtr);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52begexcl_supply_pool (
    tsp00_TaskId                         TaskId,
    tkb05_SupplyPoolGlobPtr  VAR_VALUE_REF  SupplyPoolGlobPtr);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52endexcl_lockstate (
    tsp00_TaskId                         TaskId,
    tkb05_LockStateGlobPtr  VAR_VALUE_REF  LockStateGlobPtr);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52endexcl_objcoll (
    tsp00_TaskId                         TaskId,
    tkb05_ObjCollGlobPtr  VAR_VALUE_REF  ObjCollGlobPtr);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52endexcl_region (
    tsp00_TaskId                         TaskId,
    tkb05_RegionGlobPtr   VAR_VALUE_REF  RegionGlobPtr);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52endexcl_supply_pool (
    tsp00_TaskId                         TaskId,
    tkb05_SupplyPoolGlobPtr  VAR_VALUE_REF  SupplyPoolGlobPtr);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52flush_consist_view (
    tkb05_ConsistView     VAR_VALUE_REF  ConsistView);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52flush_hash_open_trans (
    tkb05_HashOpenTrans   VAR_VALUE_REF  HashOpenTrans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52flush_objreq_entry (
    tkb05_ObjReqEntry     VAR_VALUE_REF  ObjReqEntry);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52flush_row_lock (
    tkb05_RowLock         VAR_VALUE_REF  RowLock);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52flush_row_trans (
    tkb05_RowTrans        VAR_VALUE_REF  RowTrans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52flush_tab_lock (
    tkb05_TabLock         VAR_VALUE_REF  TabLock);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52flush_tab_trans (
    tkb05_TabTrans        VAR_VALUE_REF  TabTrans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52flush_trans_entry (
    tkb05_TransEntry      VAR_VALUE_REF  TransEntry);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52flush_trans_glob (
    tkb05_TransGlob       VAR_VALUE_REF  TransGlob);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52flush_trans_waiting (
    pasbool               VAR_VALUE_REF  TransWaiting);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool k52GetCollisionEntry (
    tsp00_TaskId                         taskid,
    tgg00_TransIndex      VAR_VALUE_REF  entryNumber,
    tgg00_TransIndex      VAR_VALUE_REF  colEntryIndex,
    tgg00_TransIndex      VAR_VALUE_REF  reqEntryIndex,
    tgg00_ObjFileNo       VAR_VALUE_REF  fileno,
    tgg92_KernelOid&                     oid,
    tgg91_TransNo         VAR_VALUE_REF  transno,
    tsp00_TaskId          VAR_VALUE_REF  taskidOfTrans,
    pasbool               VAR_VALUE_REF  isHolder);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52show_lock (
    tgg00_MessBlock       VAR_VALUE_REF  m);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int4 k52used_items_of_region (
    tkb05_RegionGlob      VAR_VALUE_REF  RegionGlob);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int4 k52used_trans_of_region (
    tkb05_RegionGlob      VAR_VALUE_REF  RegionGlob);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52x_item_error (
    tsp00_C24             VAR_ARRAY_REF  msg,
    tkb05_ItemKind_Param                 ItemKind);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52x_loop_error (
    tsp00_C24             VAR_ARRAY_REF  msg,
    tsp00_Int4                           error_no);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#if defined (SAPDB_SLOW)

externPascal void k52xaddr_rowl (
    tgg00_Debug_Param                    debug,
    tsp00_Sname           VAR_ARRAY_REF  msg,
    tkb05_RowLockPtr                     RowLock);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52xaddr_rowl_check (
    tkb05_RegionGlob      VAR_VALUE_REF  RowRegionGlob,
    tkb05_RowLockPtr                     RowLock);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52xaddr_rowt (
    tgg00_Debug_Param                    debug,
    tsp00_Sname           VAR_ARRAY_REF  msg,
    tkb05_RowTransPtr                    RowTrans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52xaddr_rowt_check (
    tkb05_RegionGlob      VAR_VALUE_REF  TransRegionGlob,
    tkb05_RowTransPtr                    RowTrans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52xaddr_tabl (
    tgg00_Debug_Param                    debug,
    tsp00_Sname           VAR_ARRAY_REF  msg,
    tkb05_TabLockPtr                     TabLock);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52xaddr_tabl_check (
    tkb05_RegionGlob      VAR_VALUE_REF  TabRegionGlob,
    tkb05_TabLockPtr                     TabLock);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52xaddr_tabt (
    tgg00_Debug_Param                    debug,
    tsp00_Sname           VAR_ARRAY_REF  msg,
    tkb05_TabTransPtr                    TabTrans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52xaddr_tabt_check (
    tkb05_RegionGlob      VAR_VALUE_REF  TransRegionGlob,
    tkb05_TabTransPtr                    TabTrans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52xregion_supply_check (
    tkb05_RegionGlob      VAR_VALUE_REF  RegionGlob);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52xreq (
    tgg00_Debug_Param                    debug,
    tkb05_ReqPtr                         Req);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52xrow_lock (
    tgg00_Debug_Param                    debug,
    tkb05_RowLockPtr                     Row);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52xrow_region_check (
    tkb05_RegionGlob      VAR_VALUE_REF  RowRegionGlob);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52xrow_trans (
    tgg00_Debug_Param                    debug,
    tkb05_RowTransPtr                    Row);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52xtab_lock (
    tgg00_Debug_Param                    debug,
    tkb05_TabLockPtr                     Tab);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52xtab_region_check (
    tkb05_RegionGlob      VAR_VALUE_REF  TabRegionGlob);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52xtab_trans (
    tgg00_Debug_Param                    debug,
    tkb05_TabTransPtr                    Tab);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52xtrans (
    tgg00_Debug_Param                    debug,
    tkb05_TransEntryPtr                  TransEntry);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k52xwanted_lock (
    tgg00_Debug_Param                    debug,
    tkb05_WantedLock      VAR_VALUE_REF  WantedLock);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif


#endif

