/*!
  @file           heo68.h
  @author         JoergM
  @special area   inline_console
  @brief          Interface to provide x_cons functionality inside of kernel
  @see            example.html ...

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



\endif
*/



#ifndef HEO68_H
#define HEO68_H



/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"

/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

/* Cancel the given task */
externC void xcancel ( tsp00_TaskId pid );

/* Kill the given task */
externC void xkill   ( tsp00_TaskId pid );

/* NYI */
externC void xio ( tsp2_devname VAR_ARRAY_REF devspace,
                   tsp00_Int4   VAR_VALUE_REF size,
                   tsp00_Int4   VAR_VALUE_REF readcount,
                   tsp00_Int4   VAR_VALUE_REF writecount );

/* NYI */
externC void xstorage ( tsp00_Int4 VAR_VALUE_REF codesize,
                        tsp00_Int4 VAR_VALUE_REF datasize,
                        tsp00_Int4 VAR_VALUE_REF stacksize,
                        tsp00_Int4 VAR_VALUE_REF taskcount,
                        tsp00_Int4 VAR_VALUE_REF unused );

/* NYI */
externC void xprocess ( tsp00_TaskId                          pid,
                        tsp00_TaskId            VAR_VALUE_REF uid,
                        tsp2_process_type_Param VAR_VALUE_REF ptype,
                        tsp00_TaskState_Param   VAR_VALUE_REF pstate,
                        tsp00_Region            VAR_ARRAY_REF semaname,
                        tsp00_Int4              VAR_VALUE_REF timeout,
                        tsp00_Int4              VAR_VALUE_REF commandcount,
                        tsp00_Int4              VAR_VALUE_REF file_root,
                        tsp00_Int4              VAR_VALUE_REF file_record_cnt );

/* NYI */
externC void xversion ( tsp00_Version VAR_ARRAY_REF kernelversion,
                        tsp00_Version VAR_ARRAY_REF runtimeversion );

/* NYI */
externC void xregions ( tsp00_RegionId             sid,
                        tsp00_Region VAR_ARRAY_REF semaname,
                        tsp00_Int4   VAR_VALUE_REF semcalls,
                        tsp00_Int4   VAR_VALUE_REF collisions );

/* NYI */
externC void xstate ( tsp00_DatabaseState_Param VAR_VALUE_REF dbstate );

#endif  /* HEO68_H */
