/****************************************************************************

  module      : vbd490.cpp

  -------------------------------------------------------------------------

  author      : TorstenS
  responsible : TorstenS

  special area: FileDirectory
  description : Cache for syskey generation


  last changed: 2005-06-20  14:00
  see also    : 

  -------------------------------------------------------------------------

  copyright:    (c) 1999-2004 SAP AG



    ========== licence begin  GPL
    Copyright (c) 1999-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*****************************************************************************/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gbd190.h"
#include "hbd190.h"

#include "RunTime/MemoryManagement/RTEMem_Allocator.hpp"


/*===========================================================================*
 *  BEGIN OF CODE                                                            *
 *===========================================================================*/

bd190SystemKeyCache* bd190SystemKeyCache::m_Instance = 0;

/*---------------------------------------------------------------------------*/

bd190SystemKeyCache&
bd190SystemKeyCache::CreateInstance()
{
    if( 0 == m_Instance  )
    {
        m_Instance = new ( RTEMem_Allocator::Instance()) 
            bd190SystemKeyCache( RTEMem_Allocator::Instance());

        if( 0 == m_Instance )
        {
            RTE_Crash( SAPDBErr_Exception(__CONTEXT__,SAPDBERR_ASSERT_STATE_FAILED,
                                          "Could not create system key cache"));
        }
    }
    return *m_Instance;
}

/*---------------------------------------------------------------------------*/

bd190SystemKeyCache::bd190SystemKeyCache( SAPDBMem_IRawAllocator  &allocator )
        :
        m_Allocator( UTF8( "FileDirSystemKeyCache" ), allocator ),
        m_SpinLock( UTF8( "FileDirSystemKeyCache"), 1 ),
        m_pRwLock( 0 ),
        m_SysKeyCache( m_Allocator )
{
    m_pRwLock = RTESync_CreateRWRegion( 1, m_SpinLock, m_Allocator );

    if ( 0 == m_pRwLock )
        RTE_Crash( SAPDBErr_Exception(__CONTEXT__,SAPDBERR_ASSERT_STATE_FAILED,
                                      "Could not create system key cache resources"));
}

/*===========================================================================*
*  PASCAL INTERFACE                                                          *
*============================================================================*/

externC void
bd190CreateSysKeyCache()
{
    ROUTINE_DBG_MEO00 ("bd190CreateSysKeyCache");

    bd190SystemKeyCache::CreateInstance();
}

/*---------------------------------------------------------------------------*/

externC void
bd190InitSysKeyCache()
{
    ROUTINE_DBG_MEO00 ("bd190InitSysKeyCache");

    bd190SystemKeyCache::Instance().Initialize();
}

/*---------------------------------------------------------------------------*/

externC pasbool
bd190GetNewSysKeyForFile(
    const tsp00_PageNo  fileRoot,
    tgg00_Surrogate&    sysKey )
{
    ROUTINE_DBG_MEO00 ("bd190GetNewSysKeyForFile");

    return bd190SystemKeyCache::Instance().GetNewSysKeyForFile( fileRoot, sysKey );
}

/*---------------------------------------------------------------------------*/

externC pasbool
bd190AddAndGetNewSysKeyForFile(
    const tsp00_PageNo  fileRoot,
    tgg00_Surrogate&    sysKey )
{
    ROUTINE_DBG_MEO00 ("bd190AddAndGetNewSysKeyForFile");

    return bd190SystemKeyCache::Instance().AddAndGetNewSysKeyForFile( fileRoot, sysKey );
}

/*---------------------------------------------------------------------------*/

externC void
bd190DeleteSysKeyFile( const tsp00_PageNo   fileRoot )
{
    ROUTINE_DBG_MEO00 ("bd190DeleteSysKeyFile");

    bd190SystemKeyCache::Instance().DeleteSysKeyFile( fileRoot );
}

/*===========================================================================*
*  END OF CODE                                                              *
*===========================================================================*/
