/****************************************************************************

  module      : WDVDelete_CommonUtils.c

  -------------------------------------------------------------------------

  responsible : Daniel Kirmse

  special area:
  description :


  last changed: 2001-03-28  16:58
  see also    :

  -------------------------------------------------------------------------


    ========== licence begin  GPL
    Copyright (c) 2001-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*****************************************************************************/

	#include "SAPDB/WebDAV/DeleteService/WDVDelete_CommonUtils.h"
	#include "hwd21req.h"
	#include "SAPDBCommon/SAPDB_string.h"

	/*------------------------------------------------------------------------
		Function:	getWebDAVPrefix
	--------------------------------------------------------------------------*/
	void getWebDAVPrefix(sapdbwa_Handle		wa,
						 WDVD_Char *prefix)
	{
		WDVD_Char   temp[WDVD_MAX_URI_LEN+1];

		if (wa != NULL) {
			/* set server prefix */
			strncpy(temp,sapdbwa_GetServiceName(wa),WDVD_MAX_URI_LEN);
			temp[WDVD_MAX_URI_LEN] = '\0';
			sp77sprintf(prefix,WDVD_MAX_URI_LEN+1,"/%s",temp);
		} else {
			sp77sprintf(prefix,WDVD_MAX_URI_LEN+1,"/");
		}
	}

	/*------------------------------------------------------------------------
		Function:	getFirstHeaderLine
	--------------------------------------------------------------------------*/
	void getFirstHeaderLine(sapdbwa_Handle		wa,
		                    sapdbwa_HttpRequestP request,
		                    WDVD_PChar *host,
							WDVD_PChar *port,
							WDVD_PChar uri)
	{
		WDVD_Char	*newUri;
		WDVD_Char   prefix[WDVD_MAX_URI_LEN+1];

		if (host==NULL || port==NULL || wa==NULL || request==NULL || uri==NULL)
			return;

		*host = (char*)sapdbwa_GetHeader(request, "HTTP_HOST" );
		*port = (char*)sapdbwa_GetHeader(request, "HTTP_PORT" );
		/* *port = "85"; */
		newUri = (char*)sapdbwa_GetRequestURI(request);
		/* set server prefix */
		getWebDAVPrefix(wa,prefix);
		/* cut webdav service prefix */
		newUri  = newUri + strlen(prefix);
		/* unescape uri */
		strncpy(uri,newUri,WDVD_MAX_URI_LEN);
		uri[WDVD_MAX_URI_LEN] = '\0';
		wd21_UnescapeUrl(uri,strlen(uri));
		if (strcmp(uri,"")==0)
			strcpy(uri,"/");
	}

	/*------------------------------------------------------------------------
		Function:	getRequestUri
	--------------------------------------------------------------------------*/
	void getRequestUri(sapdbwa_Handle		wa,
					   sapdbwa_HttpRequestP request,
					   WDVD_PChar uri)
	{
		WDVD_Char	*newUri;
		WDVD_Char   prefix[WDVD_MAX_URI_LEN+1];

		if (wa==NULL || request==NULL || uri==NULL)
			return;

		newUri = (char*)sapdbwa_GetRequestURI(request);
		/* set server prefix */
		getWebDAVPrefix(wa,prefix);
		/* cut webdav service prefix */
		newUri  = newUri + strlen(prefix);
		/* unescape uri */
		strncpy(uri,newUri,WDVD_MAX_URI_LEN);
		uri[WDVD_MAX_URI_LEN] = '\0';
		wd21_UnescapeUrl(uri,strlen(uri));
		if (strcmp(uri,"")==0)
			strcpy(uri,"/");
	}

	/*------------------------------------------------------------------------
		Function:	getRequestUriFromString
	--------------------------------------------------------------------------*/
	void getRequestUriFromString(sapdbwa_Handle			wa,
								 sapdbwa_HttpRequestP	request,
								 WDVD_PChar				uri)
	{
		WDVD_Char	newUri[WDVD_MAX_URI_LEN+1];
		WDVD_Char   prefix[WDVD_MAX_URI_LEN+1];
		WDVD_Char	*pNewUri;
		WDVD_Char	*server=NULL;

		if (wa==NULL || request==NULL || uri==NULL)
			return;

		strncpy(newUri,uri,WDVD_MAX_URI_LEN);
		newUri[WDVD_MAX_URI_LEN] = '\0';
		/* set server prefix */
		buildServerString(request,&server);
		getWebDAVPrefix(wa,prefix);
		/* cut webdav service prefix */
		pNewUri  = newUri + strlen(server) + strlen(prefix);
		if (strcmp(pNewUri,"")==0)
			strcpy(uri,"/");
		else {
			strncpy(uri,pNewUri,WDVD_MAX_URI_LEN);
			uri[WDVD_MAX_URI_LEN] = '\0';
		}
		if (server)
			WDVDelete_Free((sapdbwa_UInt1*) server);
	}

	/*------------------------------------------------------------------------
		Function:	buildServerString
	--------------------------------------------------------------------------*/
	void buildServerString(sapdbwa_HttpRequestP request,
		                   WDVD_PChar *server)
	{
		WDVD_Char				*host = NULL;
		WDVD_Char				*port = NULL;
		WDVD_Char				*newServer;
		sapdbwa_Bool			allocatOK;
		sapdbwa_Int4			length;

		if (request==NULL || server==NULL)
			return;

		host = (char*)sapdbwa_GetHeader(request, "HTTP_HOST" );
		port = (char*)sapdbwa_GetHeader(request, "HTTP_PORT" );

		if (host==NULL) {
			WDVDelete_Allocat(sizeof(SAPDB_Char)*2,(sapdbwa_UInt1**) &newServer,&allocatOK);
			if (allocatOK) {
				sp77sprintf(newServer,2,"");
			}
		} else {
			if (port==NULL) {
				length = strlen("http://") + strlen(host) + 3;
				WDVDelete_Allocat(sizeof(SAPDB_Char)*length,(sapdbwa_UInt1**) &newServer,&allocatOK);
				if (allocatOK) {
					sp77sprintf(newServer,length,"%s%s","http://",host);
				}
			} else if (strcmp(port,"")==0) {
				length = strlen("http://") + strlen(host) + 3;
				WDVDelete_Allocat(sizeof(SAPDB_Char)*length,(sapdbwa_UInt1**) &newServer,&allocatOK);
				if (allocatOK) {
					sp77sprintf(newServer,length,"%s%s","http://",host);
				}
			} else {
				length = strlen("http://") + strlen(host) + strlen(port) + 3;
				WDVDelete_Allocat(sizeof(SAPDB_Char)*length,(sapdbwa_UInt1**) &newServer,&allocatOK);
				if (allocatOK) {
					sp77sprintf(newServer,length,"%s%s:%s","http://",host,port);
				}
			}
		}

		if (allocatOK)
			*server = newServer;
		else
			*server = NULL;
	}

	/*------------------------------------------------------------------------
		Function:	buildServerStringLong
	--------------------------------------------------------------------------*/
	void buildServerStringLong(sapdbwa_Handle		wa,
							   sapdbwa_HttpRequestP request,
							   WDVD_PChar *server)
	{
		WDVD_Char				*host = NULL;
		WDVD_Char				*port = NULL;
		WDVD_Char				*newServer;
		sapdbwa_Bool			allocatOK;
		sapdbwa_Int4			length;
		WDVD_Char				prefix[WDVD_MAX_URI_LEN+1];

		if (wa==NULL || request==NULL || server==NULL)
			return;

		host = (char*)sapdbwa_GetHeader(request, "HTTP_HOST" );
		port = (char*)sapdbwa_GetHeader(request, "HTTP_PORT" );
		/* set server prefix */
		getWebDAVPrefix(wa,prefix);

		if (host==NULL) {
			WDVDelete_Allocat(sizeof(SAPDB_Char)*2,(sapdbwa_UInt1**) &newServer,&allocatOK);
			if (allocatOK) {
				sp77sprintf(newServer,2,"");
			}
		} else {
			if (port==NULL) {
				length = strlen("http://") + strlen(host) + strlen(prefix) + 3;
				WDVDelete_Allocat(sizeof(SAPDB_Char)*length,(sapdbwa_UInt1**) &newServer,&allocatOK);
				if (allocatOK) {
					sp77sprintf(newServer,length,"%s%s%s","http://",host,prefix);
				}
			} else {
				length = strlen("http://") + strlen(host) + strlen(port) + strlen(prefix) + 3;
				WDVDelete_Allocat(sizeof(SAPDB_Char)*length,(sapdbwa_UInt1**) &newServer,&allocatOK);
				if (allocatOK) {
					sp77sprintf(newServer,length,"%s%s:%s%s","http://",host,port,prefix);
				}
			}
		}

		if (allocatOK)
			*server = newServer;
		else
			*server = NULL;
	}

	/*------------------------------------------------------------------------
		Function:	getDcHeader
	--------------------------------------------------------------------------*/
	WDVD_Bool getDeletedItemsHeader(sapdbwa_HttpRequestP request,
									WDVD_Bool *delitems)
	{
		WDVD_Char		*temp;

		if (request==NULL || delitems==NULL)
			return WDVD_False;

		temp = (char*)sapdbwa_GetHeader(request,"SAPDB_DeletedItems");
		if (temp != NULL) {
			if (strcmp(temp,"F")==0 || strcmp(temp,"f")==0)
				*delitems = WDVD_False;
			else if (strcmp(temp,"T")==0 || strcmp(temp,"t")==0)
				*delitems = WDVD_True;
			return WDVD_True;
		} else {
			*delitems = WDVD_False;
			return WDVD_False;
		}
	}

	/*------------------------------------------------------------------------
		Function:	createConnUserData
	--------------------------------------------------------------------------*/
	WDVD_Bool createConnUserData(WDVD_ConnUserData *userdata)
	{
		WDVD_Bool			ok = WDVD_False;
		WDVD_ConnUserData	newUserData = NULL;

		if ( !userdata ) {
			return WDVD_False;
		}

		WDVDelete_Allocat( sizeof(struct st_conn_user_data), (WDVD_UInt1**) &newUserData, &ok );
		if (ok == WDVD_True) {

			*userdata = newUserData;

			return WDVD_True;
		} else {
			*userdata = NULL;

			return WDVD_False;
		}

	}

	/*------------------------------------------------------------------------
		Function:	destroyConnUserData
	--------------------------------------------------------------------------*/
	WDVD_Bool destroyConnUserData(void *userdata)
	{
		if ( !userdata ) {
			return WDVD_False;
		}

		WDVCAPI_DestroyWDV(((WDVD_ConnUserData)userdata)->wdvHandle);

		WDVDelete_Free((WDVD_UInt1*)userdata);
		return WDVD_True;
	}

	WDVD_Bool getParameterValue(const WDVD_Char *pParamName,
				 	 		    sapdbwa_HttpRequestP req,
				 	 		    WDVD_Char *sValue)
	{
		sapdbwa_StringSeqP	__values;

		if (pParamName==NULL || req==NULL || sValue==NULL)
			return WDVD_False;

		__values = sapdbwa_CreateStringSeq();

		strcpy(sValue,"");
		if (sapdbwa_GetParameterValues(req, pParamName, __values) == sapdbwa_True) {
			if (sapdbwa_GetNumElem(__values) > 0) {
				strcpy(sValue,sapdbwa_GetStringByIndex(__values,0));
				return WDVD_True;
			}
		} else {
			return WDVD_False;
		}
		return WDVD_False;
	}

	const WDVD_Char* getParameterValueWithoutCopy(const WDVD_Char *pParamName,
				 	 					sapdbwa_HttpRequestP req)
	{
		sapdbwa_StringSeqP	__values;

		if (pParamName==NULL || req==NULL)
			return NULL;

		__values = sapdbwa_CreateStringSeq();

		if (sapdbwa_GetParameterValues(req, pParamName, __values) == sapdbwa_True) {
			if (sapdbwa_GetNumElem(__values) > 0) {
/*				strcpy(sValue,sapdbwa_GetStringByIndex(__values,0));*/
				return sapdbwa_GetStringByIndex(__values,0);
			}
		} else {
			return NULL;
		}
		return NULL;
	}


	WDVD_Bool checkAuthentication(sapdbwa_Handle		wa,
								  sapdbwa_HttpRequestP	req,
								  sapdbwa_HttpReplyP	rep,
								  SAPDB_Char			*isRequired,
								  SAPDB_Char			*user,
								  SAPDB_Char			*password)
	{
		const SAPDB_Char		*requestUser;
		const SAPDB_Char		*requestPassword;
		WDVD_Bool		authenticationOK;

		if (strcmp(isRequired,"1")==0) {
			/* authentication required -> check user and password */
			/* check the user and password delivered with the request */
			authenticationOK = sapdbwa_GetAuthorization(req, &requestUser, &requestPassword);
			if (authenticationOK == SAPDB_FALSE || (strcmp(user, requestUser)!=0) || (strcmp(password, requestPassword)!=0)) {
				/* wrong authentication was provided */
				sapdbwa_InitHeader(rep, 401, "text/html", NULL, NULL, NULL, NULL );
				sapdbwa_SetHeader ( rep, "WWW-Authenticate", "Basic realm=""SAP DB Web Server Administration""");
				sapdbwa_SendHeader( rep );
				return WDVD_False;
			} else {
				/* correct authentication was provided */
				return WDVD_True;
			}
		} else {
			/* no authentication required */
			return WDVD_True;
		}
		return WDVD_False;
	}
						  